/*-
 *   BSD LICENSE
 *
 *   Copyright(c) 2016 Intel Corporation. All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *	 * Redistributions of source code must retain the above copyright
 *	   notice, this list of conditions and the following disclaimer.
 *	 * Redistributions in binary form must reproduce the above copyright
 *	   notice, this list of conditions and the following disclaimer in
 *	   the documentation and/or other materials provided with the
 *	   distribution.
 *	 * Neither the name of Intel Corporation nor the names of its
 *	   contributors may be used to endorse or promote products derived
 *	   from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY ExPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, ExEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef TEST_CRYPTODEV_ZUC_HASH_TEST_VECTORS_H_
#define TEST_CRYPTODEV_ZUC_HASH_TEST_VECTORS_H_

struct zuc_hash_test_data {
	struct {
		uint8_t data[64];
		unsigned len;
	} key;

	struct {
		uint8_t data[64];
		unsigned len;
	} aad;

	struct {
		uint8_t data[2056];
		unsigned len; /* length must be in Bits */
	} plaintext;

	struct {
		unsigned len;
	} validAuthLenInBits;

	struct {
		unsigned len;
	} validAuthOffsetLenInBits;

	struct {
		uint8_t data[64];
		unsigned len;
	} digest;
};

struct zuc_hash_test_data zuc_hash_test_case_1 = {
	.key = {
		.data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		},
		.len = 16
	},
	.aad = {
		.data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
		},
		.len = 16
	},
	.plaintext = {
		.data = {0x00},
		.len = 8
	},
	.validAuthLenInBits = {
		.len = 1
	},
	.validAuthOffsetLenInBits = {
		.len = 128
	},
	.digest = {
		.data = {0xC8, 0xA9, 0x59, 0x5E},
		.len  = 4
	}
};

struct zuc_hash_test_data zuc_hash_test_case_2 = {
	.key = {
		.data = {
			0x47, 0x05, 0x41, 0x25, 0x56, 0x1E, 0xB2, 0xDD,
			0xA9, 0x40, 0x59, 0xDA, 0x05, 0x09, 0x78, 0x50
		},
		.len = 16
	},
	.aad = {
		.data = {
			0x56, 0x1E, 0xB2, 0xDD, 0xA0, 0x00, 0x00, 0x00,
			0x56, 0x1E, 0xB2, 0xDD, 0xA0, 0x00, 0x00, 0x00
		},
		.len = 16
	},
	.plaintext = {
		.data = {
			0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
			0x00, 0x00, 0x00, 0x00
		},
		.len = 96
	},
	.validAuthLenInBits = {
		.len = 90
	},
	.validAuthOffsetLenInBits = {
		.len = 128
	},
	.digest = {
		.data = {0x67, 0x19, 0xA0, 0x88},
		.len  = 4
	}
};

struct zuc_hash_test_data zuc_hash_test_case_3 = {
	.key = {
		.data = {
			0xC9, 0xE6, 0xCE, 0xC4, 0x60, 0x7C, 0x72, 0xDB,
			0x00, 0x0A, 0xEF, 0xA8, 0x83, 0x85, 0xAB, 0x0A
		},
		.len = 16
	},
	.aad = {
		.data = {
			0xA9, 0x40, 0x59, 0xDA, 0x50, 0x00, 0x00, 0x00,
			0x29, 0x40, 0x59, 0xDA, 0x50, 0x00, 0x80, 0x00
		},
		.len = 16
	},
	.plaintext = {
		.data = {
			0x98, 0x3B, 0x41, 0xD4, 0x7D, 0x78, 0x0C, 0x9E,
			0x1A, 0xD1, 0x1D, 0x7E, 0xB7, 0x03, 0x91, 0xB1,
			0xDE, 0x0B, 0x35, 0xDA, 0x2D, 0xC6, 0x2F, 0x83,
			0xE7, 0xB7, 0x8D, 0x63, 0x06, 0xCA, 0x0E, 0xA0,
			0x7E, 0x94, 0x1B, 0x7B, 0xE9, 0x13, 0x48, 0xF9,
			0xFC, 0xB1, 0x70, 0xE2, 0x21, 0x7F, 0xEC, 0xD9,
			0x7F, 0x9F, 0x68, 0xAD, 0xB1, 0x6E, 0x5D, 0x7D,
			0x21, 0xE5, 0x69, 0xD2, 0x80, 0xED, 0x77, 0x5C,
			0xEB, 0xDE, 0x3F, 0x40, 0x93, 0xC5, 0x38, 0x81,
			0x00
		},
		.len = 584
	},
	.validAuthLenInBits = {
		.len = 577
	},
	.validAuthOffsetLenInBits = {
		.len = 128
	},
	.digest = {
		.data = {0xFA, 0xE8, 0xFF, 0x0B},
		.len  = 4
	}
};

struct zuc_hash_test_data zuc_hash_test_case_4 = {
	.key = {
		.data = {
			0xC8, 0xA4, 0x82, 0x62, 0xD0, 0xC2, 0xE2, 0xBA,
			0xC4, 0xB9, 0x6E, 0xF7, 0x7E, 0x80, 0xCA, 0x59
		},
		.len = 16
	},
	.aad = {
		.data = {
			0x05, 0x09, 0x78, 0x50, 0x80, 0x00, 0x00, 0x00,
			0x85, 0x09, 0x78, 0x50, 0x80, 0x00, 0x80, 0x00
		},
		.len = 16
	},
	.plaintext = {
		.data = {
			0xB5, 0x46, 0x43, 0x0B, 0xF8, 0x7B, 0x4F, 0x1E,
			0xE8, 0x34, 0x70, 0x4C, 0xD6, 0x95, 0x1C, 0x36,
			0xE2, 0x6F, 0x10, 0x8C, 0xF7, 0x31, 0x78, 0x8F,
			0x48, 0xDC, 0x34, 0xF1, 0x67, 0x8C, 0x05, 0x22,
			0x1C, 0x8F, 0xA7, 0xFF, 0x2F, 0x39, 0xF4, 0x77,
			0xE7, 0xE4, 0x9E, 0xF6, 0x0A, 0x4E, 0xC2, 0xC3,
			0xDE, 0x24, 0x31, 0x2A, 0x96, 0xAA, 0x26, 0xE1,
			0xCF, 0xBA, 0x57, 0x56, 0x38, 0x38, 0xB2, 0x97,
			0xF4, 0x7E, 0x85, 0x10, 0xC7, 0x79, 0xFD, 0x66,
			0x54, 0xB1, 0x43, 0x38, 0x6F, 0xA6, 0x39, 0xD3,
			0x1E, 0xDB, 0xD6, 0xC0, 0x6E, 0x47, 0xD1, 0x59,
			0xD9, 0x43, 0x62, 0xF2, 0x6A, 0xEE, 0xED, 0xEE,
			0x0E, 0x4F, 0x49, 0xD9, 0xBF, 0x84, 0x12, 0x99,
			0x54, 0x15, 0xBF, 0xAD, 0x56, 0xEE, 0x82, 0xD1,
			0xCA, 0x74, 0x63, 0xAB, 0xF0, 0x85, 0xB0, 0x82,
			0xB0, 0x99, 0x04, 0xD6, 0xD9, 0x90, 0xD4, 0x3C,
			0xF2, 0xE0, 0x62, 0xF4, 0x08, 0x39, 0xD9, 0x32,
			0x48, 0xB1, 0xEB, 0x92, 0xCD, 0xFE, 0xD5, 0x30,
			0x0B, 0xC1, 0x48, 0x28, 0x04, 0x30, 0xB6, 0xD0,
			0xCA, 0xA0, 0x94, 0xB6, 0xEC, 0x89, 0x11, 0xAB,
			0x7D, 0xC3, 0x68, 0x24, 0xB8, 0x24, 0xDC, 0x0A,
			0xF6, 0x68, 0x2B, 0x09, 0x35, 0xFD, 0xE7, 0xB4,
			0x92, 0xA1, 0x4D, 0xC2, 0xF4, 0x36, 0x48, 0x03,
			0x8D, 0xA2, 0xCF, 0x79, 0x17, 0x0D, 0x2D, 0x50,
			0x13, 0x3F, 0xD4, 0x94, 0x16, 0xCB, 0x6E, 0x33,
			0xBE, 0xA9, 0x0B, 0x8B, 0xF4, 0x55, 0x9B, 0x03,
			0x73, 0x2A, 0x01, 0xEA, 0x29, 0x0E, 0x6D, 0x07,
			0x4F, 0x79, 0xBB, 0x83, 0xC1, 0x0E, 0x58, 0x00,
			0x15, 0xCC, 0x1A, 0x85, 0xB3, 0x6B, 0x55, 0x01,
			0x04, 0x6E, 0x9C, 0x4B, 0xDC, 0xAE, 0x51, 0x35,
			0x69, 0x0B, 0x86, 0x66, 0xBD, 0x54, 0xB7, 0xA7,
			0x03, 0xEA, 0x7B, 0x6F, 0x22, 0x0A, 0x54, 0x69,
			0xA5, 0x68, 0x02, 0x7E
		},
		.len = 2080
	},
	.validAuthLenInBits = {
		.len = 2079
	},
	.validAuthOffsetLenInBits = {
		.len = 128
	},
	.digest = {
		.data = {0x00, 0x4A, 0xC4, 0xD6},
		.len  = 4
	}
};

struct zuc_hash_test_data zuc_hash_test_case_5 = {
	.key = {
		.data = {
			0x6B, 0x8B, 0x08, 0xEE, 0x79, 0xE0, 0xB5, 0x98,
			0x2D, 0x6D, 0x12, 0x8E, 0xA9, 0xF2, 0x20, 0xCB
		},
		.len = 16
	},
	.aad = {
		.data = {
			0x56, 0x1E, 0xB2, 0xDD, 0xE0, 0x00, 0x00, 0x00,
			0x56, 0x1E, 0xB2, 0xDD, 0xE0, 0x00, 0x00, 0x00
		},
		.len = 16
	},
	.plaintext = {
		.data = {
			0x5B, 0xAD, 0x72, 0x47, 0x10, 0xBA, 0x1C, 0x56,
			0xD5, 0xA3, 0x15, 0xF8, 0xD4, 0x0F, 0x6E, 0x09,
			0x37, 0x80, 0xBE, 0x8E, 0x8D, 0xE0, 0x7B, 0x69,
			0x92, 0x43, 0x20, 0x18, 0xE0, 0x8E, 0xD9, 0x6A,
			0x57, 0x34, 0xAF, 0x8B, 0xAD, 0x8A, 0x57, 0x5D,
			0x3A, 0x1F, 0x16, 0x2F, 0x85, 0x04, 0x5C, 0xC7,
			0x70, 0x92, 0x55, 0x71, 0xD9, 0xF5, 0xB9, 0x4E,
			0x45, 0x4A, 0x77, 0xC1, 0x6E, 0x72, 0x93, 0x6B,
			0xF0, 0x16, 0xAE, 0x15, 0x74, 0x99, 0xF0, 0x54,
			0x3B, 0x5D, 0x52, 0xCA, 0xA6, 0xDB, 0xEA, 0xB6,
			0x97, 0xD2, 0xBB, 0x73, 0xE4, 0x1B, 0x80, 0x75,
			0xDC, 0xE7, 0x9B, 0x4B, 0x86, 0x04, 0x4F, 0x66,
			0x1D, 0x44, 0x85, 0xA5, 0x43, 0xDD, 0x78, 0x60,
			0x6E, 0x04, 0x19, 0xE8, 0x05, 0x98, 0x59, 0xD3,
			0xCB, 0x2B, 0x67, 0xCE, 0x09, 0x77, 0x60, 0x3F,
			0x81, 0xFF, 0x83, 0x9E, 0x33, 0x18, 0x59, 0x54,
			0x4C, 0xFB, 0xC8, 0xD0, 0x0F, 0xEF, 0x1A, 0x4C,
			0x85, 0x10, 0xFB, 0x54, 0x7D, 0x6B, 0x06, 0xC6,
			0x11, 0xEF, 0x44, 0xF1, 0xBC, 0xE1, 0x07, 0xCF,
			0xA4, 0x5A, 0x06, 0xAA, 0xB3, 0x60, 0x15, 0x2B,
			0x28, 0xDC, 0x1E, 0xBE, 0x6F, 0x7F, 0xE0, 0x9B,
			0x05, 0x16, 0xF9, 0xA5, 0xB0, 0x2A, 0x1B, 0xD8,
			0x4B, 0xB0, 0x18, 0x1E, 0x2E, 0x89, 0xE1, 0x9B,
			0xD8, 0x12, 0x59, 0x30, 0xD1, 0x78, 0x68, 0x2F,
			0x38, 0x62, 0xDC, 0x51, 0xB6, 0x36, 0xF0, 0x4E,
			0x72, 0x0C, 0x47, 0xC3, 0xCE, 0x51, 0xAD, 0x70,
			0xD9, 0x4B, 0x9B, 0x22, 0x55, 0xFB, 0xAE, 0x90,
			0x65, 0x49, 0xF4, 0x99, 0xF8, 0xC6, 0xD3, 0x99,
			0x47, 0xED, 0x5E, 0x5D, 0xF8, 0xE2, 0xDE, 0xF1,
			0x13, 0x25, 0x3E, 0x7B, 0x08, 0xD0, 0xA7, 0x6B,
			0x6B, 0xFC, 0x68, 0xC8, 0x12, 0xF3, 0x75, 0xC7,
			0x9B, 0x8F, 0xE5, 0xFD, 0x85, 0x97, 0x6A, 0xA6,
			0xD4, 0x6B, 0x4A, 0x23, 0x39, 0xD8, 0xAE, 0x51,
			0x47, 0xF6, 0x80, 0xFB, 0xE7, 0x0F, 0x97, 0x8B,
			0x38, 0xEF, 0xFD, 0x7B, 0x2F, 0x78, 0x66, 0xA2,
			0x25, 0x54, 0xE1, 0x93, 0xA9, 0x4E, 0x98, 0xA6,
			0x8B, 0x74, 0xBD, 0x25, 0xBB, 0x2B, 0x3F, 0x5F,
			0xB0, 0xA5, 0xFD, 0x59, 0x88, 0x7F, 0x9A, 0xB6,
			0x81, 0x59, 0xB7, 0x17, 0x8D, 0x5B, 0x7B, 0x67,
			0x7C, 0xB5, 0x46, 0xBF, 0x41, 0xEA, 0xDC, 0xA2,
			0x16, 0xFC, 0x10, 0x85, 0x01, 0x28, 0xF8, 0xBD,
			0xEF, 0x5C, 0x8D, 0x89, 0xF9, 0x6A, 0xFA, 0x4F,
			0xA8, 0xB5, 0x48, 0x85, 0x56, 0x5E, 0xD8, 0x38,
			0xA9, 0x50, 0xFE, 0xE5, 0xF1, 0xC3, 0xB0, 0xA4,
			0xF6, 0xFB, 0x71, 0xE5, 0x4D, 0xFD, 0x16, 0x9E,
			0x82, 0xCE, 0xCC, 0x72, 0x66, 0xC8, 0x50, 0xE6,
			0x7C, 0x5E, 0xF0, 0xBA, 0x96, 0x0F, 0x52, 0x14,
			0x06, 0x0E, 0x71, 0xEB, 0x17, 0x2A, 0x75, 0xFC,
			0x14, 0x86, 0x83, 0x5C, 0xBE, 0xA6, 0x53, 0x44,
			0x65, 0xB0, 0x55, 0xC9, 0x6A, 0x72, 0xE4, 0x10,
			0x52, 0x24, 0x18, 0x23, 0x25, 0xD8, 0x30, 0x41,
			0x4B, 0x40, 0x21, 0x4D, 0xAA, 0x80, 0x91, 0xD2,
			0xE0, 0xFB, 0x01, 0x0A, 0xE1, 0x5C, 0x6D, 0xE9,
			0x08, 0x50, 0x97, 0x3B, 0xDF, 0x1E, 0x42, 0x3B,
			0xE1, 0x48, 0xA2, 0x37, 0xB8, 0x7A, 0x0C, 0x9F,
			0x34, 0xD4, 0xB4, 0x76, 0x05, 0xB8, 0x03, 0xD7,
			0x43, 0xA8, 0x6A, 0x90, 0x39, 0x9A, 0x4A, 0xF3,
			0x96, 0xD3, 0xA1, 0x20, 0x0A, 0x62, 0xF3, 0xD9,
			0x50, 0x79, 0x62, 0xE8, 0xE5, 0xBE, 0xE6, 0xD3,
			0xDA, 0x2B, 0xB3, 0xF7, 0x23, 0x76, 0x64, 0xAC,
			0x7A, 0x29, 0x28, 0x23, 0x90, 0x0B, 0xC6, 0x35,
			0x03, 0xB2, 0x9E, 0x80, 0xD6, 0x3F, 0x60, 0x67,
			0xBF, 0x8E, 0x17, 0x16, 0xAC, 0x25, 0xBE, 0xBA,
			0x35, 0x0D, 0xEB, 0x62, 0xA9, 0x9F, 0xE0, 0x31,
			0x85, 0xEB, 0x4F, 0x69, 0x93, 0x7E, 0xCD, 0x38,
			0x79, 0x41, 0xFD, 0xA5, 0x44, 0xBA, 0x67, 0xDB,
			0x09, 0x11, 0x77, 0x49, 0x38, 0xB0, 0x18, 0x27,
			0xBC, 0xC6, 0x9C, 0x92, 0xB3, 0xF7, 0x72, 0xA9,
			0xD2, 0x85, 0x9E, 0xF0, 0x03, 0x39, 0x8B, 0x1F,
			0x6B, 0xBA, 0xD7, 0xB5, 0x74, 0xF7, 0x98, 0x9A,
			0x1D, 0x10, 0xB2, 0xDF, 0x79, 0x8E, 0x0D, 0xBF,
			0x30, 0xD6, 0x58, 0x74, 0x64, 0xD2, 0x48, 0x78,
			0xCD, 0x00, 0xC0, 0xEA, 0xEE, 0x8A, 0x1A, 0x0C,
			0xC7, 0x53, 0xA2, 0x79, 0x79, 0xE1, 0x1B, 0x41,
			0xDB, 0x1D, 0xE3, 0xD5, 0x03, 0x8A, 0xFA, 0xF4,
			0x9F, 0x5C, 0x68, 0x2C, 0x37, 0x48, 0xD8, 0xA3,
			0xA9, 0xEC, 0x54, 0xE6, 0xA3, 0x71, 0x27, 0x5F,
			0x16, 0x83, 0x51, 0x0F, 0x8E, 0x4F, 0x90, 0x93,
			0x8F, 0x9A, 0xB6, 0xE1, 0x34, 0xC2, 0xCF, 0xDF,
			0x48, 0x41, 0xCB, 0xA8, 0x8E, 0x0C, 0xFF, 0x2B,
			0x0B, 0xCC, 0x8E, 0x6A, 0xDC, 0xB7, 0x11, 0x09,
			0xB5, 0x19, 0x8F, 0xEC, 0xF1, 0xBB, 0x7E, 0x5C,
			0x53, 0x1A, 0xCA, 0x50, 0xA5, 0x6A, 0x8A, 0x3B,
			0x6D, 0xE5, 0x98, 0x62, 0xD4, 0x1F, 0xA1, 0x13,
			0xD9, 0xCD, 0x95, 0x78, 0x08, 0xF0, 0x85, 0x71,
			0xD9, 0xA4, 0xBB, 0x79, 0x2A, 0xF2, 0x71, 0xF6,
			0xCC, 0x6D, 0xBB, 0x8D, 0xC7, 0xEC, 0x36, 0xE3,
			0x6B, 0xE1, 0xED, 0x30, 0x81, 0x64, 0xC3, 0x1C,
			0x7C, 0x0A, 0xFC, 0x54, 0x1C
		},
		.len = 5672
	},
	.validAuthLenInBits = {
		.len = 5670
	},
	.validAuthOffsetLenInBits = {
		.len = 128
	},
	.digest = {
		.data = {0x0C, 0xA1, 0x27, 0x92},
		.len  = 4
	}
};

#endif /* TEST_CRYPTODEV_ZUC_HASH_TEST_VECTORS_H_ */
