/*
 * nullstream - iostream that does nothing
 *
 * Copyright (C) 2003,2004,2005,2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NULLSTREAM_H
#define NULLSTREAM_H

#include <iostream>

namespace wibble {

class nullbuf: public std::streambuf
{
protected:
	int	overflow(int c) { return c; }
	int	underflow() { return EOF; }
	int	sync() { return 0; }

public:
	nullbuf()
	{
		setp(0, 0);
		setg(0, 0, 0);
	}
};

class inullstream: public std::istream
{
public:
	inullstream() : std::istream(new nullbuf) {}
	~inullstream() { delete rdbuf(); }
};

class onullstream: public std::ostream
{
public:
  onullstream() : std::ostream(new nullbuf) {}
  ~onullstream() { delete rdbuf(); }
};

}

// vim:set ts=4 sw=4:
#endif
