// This file was generated by go generate; DO NOT EDIT

package currency

import "golang.org/x/text/internal/tag"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "28"

const (
	xxx = 282
	xts = 280
	usd = 249
	eur = 92
	jpy = 131
	gbp = 97
	chf = 60
	aud = 19
	nzd = 190
	cad = 57
	sek = 217
	nok = 188
	dkk = 80
	xag = 263
	xau = 264
	xpt = 277
	xpd = 275
	brl = 46
	cny = 66
	inr = 123
	rub = 208
	hkd = 112
	idr = 118
	krw = 139
	mxn = 176
	pln = 199
	sar = 211
	thb = 232
	try = 241
	twd = 243
	zar = 290
)

// currency holds an alphabetically sorted list of canonical 3-letter currency
// identifiers. Each identifier is followed by a byte of type currencyInfo,
// defined in gen_common.go.
// Size: 1196 bytes
var currency tag.Index = "" +
	"\x00\x00\x00\x00ADP\x09AED\x00AFA\x00AFN\x09ALK\x00ALL\x09AMD\x09ANG\x00" +
	"AOA\x00AOK\x00AON\x00AOR\x00ARA\x00ARL\x00ARM\x00ARP\x00ARS\x00ATS\x00AU" +
	"D\x00AWG\x00AZM\x00AZN\x00BAD\x00BAM\x00BAN\x00BBD\x00BDT\x00BEC\x00BEF" +
	"\x00BEL\x00BGL\x00BGM\x00BGN\x00BGO\x00BHD\x1bBIF\x09BMD\x00BND\x00BOB" +
	"\x00BOL\x00BOP\x00BOV\x00BRB\x00BRC\x00BRE\x00BRL\x00BRN\x00BRR\x00BRZ" +
	"\x00BSD\x00BTN\x00BUK\x00BWP\x00BYB\x00BYR\x09BZD\x00CAD(CDF\x00CHE\x00C" +
	"HF(CHW\x00CLE\x00CLF$CLP\x09CNX\x00CNY\x00COP\x09COU\x00CRC\x09CSD\x00CS" +
	"K\x00CUC\x00CUP\x00CVE\x00CYP\x00CZK\x08DDM\x00DEM\x00DJF\x09DKK\x00DOP" +
	"\x00DZD\x00ECS\x00ECV\x00EEK\x00EGP\x00ERN\x00ESA\x00ESB\x00ESP\x09ETB" +
	"\x00EUR\x00FIM\x00FJD\x00FKP\x00FRF\x00GBP\x00GEK\x00GEL\x00GHC\x00GHS" +
	"\x00GIP\x00GMD\x00GNF\x09GNS\x00GQE\x00GRD\x00GTQ\x00GWE\x00GWP\x00GYD" +
	"\x09HKD\x00HNL\x00HRD\x00HRK\x00HTG\x00HUF\x08IDR\x09IEP\x00ILP\x00ILR" +
	"\x00ILS\x00INR\x00IQD\x09IRR\x09ISJ\x00ISK\x09ITL\x09JMD\x00JOD\x1bJPY" +
	"\x09KES\x00KGS\x00KHR\x00KMF\x09KPW\x09KRH\x00KRO\x00KRW\x09KWD\x1bKYD" +
	"\x00KZT\x00LAK\x09LBP\x09LKR\x00LRD\x00LSL\x00LTL\x00LTT\x00LUC\x00LUF" +
	"\x09LUL\x00LVL\x00LVR\x00LYD\x1bMAD\x00MAF\x00MCF\x00MDC\x00MDL\x00MGA" +
	"\x09MGF\x09MKD\x00MKN\x00MLF\x00MMK\x09MNT\x09MOP\x00MRO\x09MTL\x00MTP" +
	"\x00MUR\x09MVP\x00MVR\x00MWK\x00MXN\x00MXP\x00MXV\x00MYR\x00MZE\x00MZM" +
	"\x00MZN\x00NAD\x00NGN\x00NIC\x00NIO\x00NLG\x00NOK\x00NPR\x00NZD\x00OMR" +
	"\x1bPAB\x00PEI\x00PEN\x00PES\x00PGK\x00PHP\x00PKR\x09PLN\x00PLZ\x00PTE" +
	"\x00PYG\x09QAR\x00RHD\x00ROL\x00RON\x00RSD\x09RUB\x00RUR\x00RWF\x09SAR" +
	"\x00SBD\x00SCR\x00SDD\x00SDG\x00SDP\x00SEK\x00SGD\x00SHP\x00SIT\x00SKK" +
	"\x00SLL\x09SOS\x09SRD\x00SRG\x00SSP\x00STD\x09SUR\x00SVC\x00SYP\x09SZL" +
	"\x00THB\x00TJR\x00TJS\x00TMM\x09TMT\x00TND\x1bTOP\x00TPE\x00TRL\x09TRY" +
	"\x00TTD\x00TWD\x08TZS\x09UAH\x00UAK\x00UGS\x00UGX\x09USD\x00USN\x00USS" +
	"\x00UYI\x09UYP\x00UYU\x00UZS\x09VEB\x00VEF\x00VND\x09VNN\x00VUV\x09WST" +
	"\x00XAF\x09XAG\x00XAU\x00XBA\x00XBB\x00XBC\x00XBD\x00XCD\x00XDR\x00XEU" +
	"\x00XFO\x00XFU\x00XOF\x09XPD\x00XPF\x09XPT\x00XRE\x00XSU\x00XTS\x00XUA" +
	"\x00XXX\x00YDD\x00YER\x09YUD\x00YUM\x00YUN\x00YUR\x00ZAL\x00ZAR\x00ZMK" +
	"\x09ZMW\x00ZRN\x00ZRZ\x00ZWD\x09ZWL\x00ZWR\x00\xff\xff\xff\xff"

const numCurrencies = 297

type toCurrency struct {
	region uint16
	code   uint16
}

// Size: 1044 bytes, 255 elements
var regionToCurrency = []toCurrency{
	{region: 0x4143, code: 0xdb},
	{region: 0x4144, code: 0x5c},
	{region: 0x4145, code: 0x2},
	{region: 0x4146, code: 0x4},
	{region: 0x4147, code: 0x10d},
	{region: 0x4149, code: 0x10d},
	{region: 0x414c, code: 0x6},
	{region: 0x414d, code: 0x7},
	{region: 0x414f, code: 0x9},
	{region: 0x4152, code: 0x11},
	{region: 0x4153, code: 0xf9},
	{region: 0x4154, code: 0x5c},
	{region: 0x4155, code: 0x13},
	{region: 0x4157, code: 0x14},
	{region: 0x4158, code: 0x5c},
	{region: 0x415a, code: 0x16},
	{region: 0x4241, code: 0x18},
	{region: 0x4242, code: 0x1a},
	{region: 0x4244, code: 0x1b},
	{region: 0x4245, code: 0x5c},
	{region: 0x4246, code: 0x112},
	{region: 0x4247, code: 0x21},
	{region: 0x4248, code: 0x23},
	{region: 0x4249, code: 0x24},
	{region: 0x424a, code: 0x112},
	{region: 0x424c, code: 0x5c},
	{region: 0x424d, code: 0x25},
	{region: 0x424e, code: 0x26},
	{region: 0x424f, code: 0x27},
	{region: 0x4251, code: 0xf9},
	{region: 0x4252, code: 0x2e},
	{region: 0x4253, code: 0x32},
	{region: 0x4254, code: 0x33},
	{region: 0x4256, code: 0xbc},
	{region: 0x4257, code: 0x35},
	{region: 0x4259, code: 0x37},
	{region: 0x425a, code: 0x38},
	{region: 0x4341, code: 0x39},
	{region: 0x4343, code: 0x13},
	{region: 0x4344, code: 0x3a},
	{region: 0x4346, code: 0x106},
	{region: 0x4347, code: 0x106},
	{region: 0x4348, code: 0x3c},
	{region: 0x4349, code: 0x112},
	{region: 0x434b, code: 0xbe},
	{region: 0x434c, code: 0x40},
	{region: 0x434d, code: 0x106},
	{region: 0x434e, code: 0x42},
	{region: 0x434f, code: 0x43},
	{region: 0x4352, code: 0x45},
	{region: 0x4355, code: 0x49},
	{region: 0x4356, code: 0x4a},
	{region: 0x4357, code: 0x8},
	{region: 0x4358, code: 0x13},
	{region: 0x4359, code: 0x5c},
	{region: 0x435a, code: 0x4c},
	{region: 0x4445, code: 0x5c},
	{region: 0x4447, code: 0xf9},
	{region: 0x444a, code: 0x4f},
	{region: 0x444b, code: 0x50},
	{region: 0x444d, code: 0x10d},
	{region: 0x444f, code: 0x51},
	{region: 0x445a, code: 0x52},
	{region: 0x4541, code: 0x5c},
	{region: 0x4543, code: 0xf9},
	{region: 0x4545, code: 0x5c},
	{region: 0x4547, code: 0x56},
	{region: 0x4548, code: 0x9c},
	{region: 0x4552, code: 0x57},
	{region: 0x4553, code: 0x5c},
	{region: 0x4554, code: 0x5b},
	{region: 0x4555, code: 0x5c},
	{region: 0x4649, code: 0x5c},
	{region: 0x464a, code: 0x5e},
	{region: 0x464b, code: 0x5f},
	{region: 0x464d, code: 0xf9},
	{region: 0x464f, code: 0x50},
	{region: 0x4652, code: 0x5c},
	{region: 0x4741, code: 0x106},
	{region: 0x4742, code: 0x61},
	{region: 0x4744, code: 0x10d},
	{region: 0x4745, code: 0x63},
	{region: 0x4746, code: 0x5c},
	{region: 0x4747, code: 0x61},
	{region: 0x4748, code: 0x65},
	{region: 0x4749, code: 0x66},
	{region: 0x474c, code: 0x50},
	{region: 0x474d, code: 0x67},
	{region: 0x474e, code: 0x68},
	{region: 0x4750, code: 0x5c},
	{region: 0x4751, code: 0x106},
	{region: 0x4752, code: 0x5c},
	{region: 0x4753, code: 0x61},
	{region: 0x4754, code: 0x6c},
	{region: 0x4755, code: 0xf9},
	{region: 0x4757, code: 0x112},
	{region: 0x4759, code: 0x6f},
	{region: 0x484b, code: 0x70},
	{region: 0x484d, code: 0x13},
	{region: 0x484e, code: 0x71},
	{region: 0x4852, code: 0x73},
	{region: 0x4854, code: 0x74},
	{region: 0x4855, code: 0x75},
	{region: 0x4943, code: 0x5c},
	{region: 0x4944, code: 0x76},
	{region: 0x4945, code: 0x5c},
	{region: 0x494c, code: 0x7a},
	{region: 0x494d, code: 0x61},
	{region: 0x494e, code: 0x7b},
	{region: 0x494f, code: 0xf9},
	{region: 0x4951, code: 0x7c},
	{region: 0x4952, code: 0x7d},
	{region: 0x4953, code: 0x7f},
	{region: 0x4954, code: 0x5c},
	{region: 0x4a45, code: 0x61},
	{region: 0x4a4d, code: 0x81},
	{region: 0x4a4f, code: 0x82},
	{region: 0x4a50, code: 0x83},
	{region: 0x4b45, code: 0x84},
	{region: 0x4b47, code: 0x85},
	{region: 0x4b48, code: 0x86},
	{region: 0x4b49, code: 0x13},
	{region: 0x4b4d, code: 0x87},
	{region: 0x4b4e, code: 0x10d},
	{region: 0x4b50, code: 0x88},
	{region: 0x4b52, code: 0x8b},
	{region: 0x4b57, code: 0x8c},
	{region: 0x4b59, code: 0x8d},
	{region: 0x4b5a, code: 0x8e},
	{region: 0x4c41, code: 0x8f},
	{region: 0x4c42, code: 0x90},
	{region: 0x4c43, code: 0x10d},
	{region: 0x4c49, code: 0x3c},
	{region: 0x4c4b, code: 0x91},
	{region: 0x4c52, code: 0x92},
	{region: 0x4c53, code: 0x122},
	{region: 0x4c54, code: 0x5c},
	{region: 0x4c55, code: 0x5c},
	{region: 0x4c56, code: 0x5c},
	{region: 0x4c59, code: 0x9b},
	{region: 0x4d41, code: 0x9c},
	{region: 0x4d43, code: 0x5c},
	{region: 0x4d44, code: 0xa0},
	{region: 0x4d45, code: 0x5c},
	{region: 0x4d46, code: 0x5c},
	{region: 0x4d47, code: 0xa1},
	{region: 0x4d48, code: 0xf9},
	{region: 0x4d4b, code: 0xa3},
	{region: 0x4d4c, code: 0x112},
	{region: 0x4d4d, code: 0xa6},
	{region: 0x4d4e, code: 0xa7},
	{region: 0x4d4f, code: 0xa8},
	{region: 0x4d50, code: 0xf9},
	{region: 0x4d51, code: 0x5c},
	{region: 0x4d52, code: 0xa9},
	{region: 0x4d53, code: 0x10d},
	{region: 0x4d54, code: 0x5c},
	{region: 0x4d55, code: 0xac},
	{region: 0x4d56, code: 0xae},
	{region: 0x4d57, code: 0xaf},
	{region: 0x4d58, code: 0xb0},
	{region: 0x4d59, code: 0xb3},
	{region: 0x4d5a, code: 0xb6},
	{region: 0x4e41, code: 0xb7},
	{region: 0x4e43, code: 0x114},
	{region: 0x4e45, code: 0x112},
	{region: 0x4e46, code: 0x13},
	{region: 0x4e47, code: 0xb8},
	{region: 0x4e49, code: 0xba},
	{region: 0x4e4c, code: 0x5c},
	{region: 0x4e4f, code: 0xbc},
	{region: 0x4e50, code: 0xbd},
	{region: 0x4e52, code: 0x13},
	{region: 0x4e55, code: 0xbe},
	{region: 0x4e5a, code: 0xbe},
	{region: 0x4f4d, code: 0xbf},
	{region: 0x5041, code: 0xc0},
	{region: 0x5045, code: 0xc2},
	{region: 0x5046, code: 0x114},
	{region: 0x5047, code: 0xc4},
	{region: 0x5048, code: 0xc5},
	{region: 0x504b, code: 0xc6},
	{region: 0x504c, code: 0xc7},
	{region: 0x504d, code: 0x5c},
	{region: 0x504e, code: 0xbe},
	{region: 0x5052, code: 0xf9},
	{region: 0x5053, code: 0x7a},
	{region: 0x5054, code: 0x5c},
	{region: 0x5057, code: 0xf9},
	{region: 0x5059, code: 0xca},
	{region: 0x5141, code: 0xcb},
	{region: 0x5245, code: 0x5c},
	{region: 0x524f, code: 0xce},
	{region: 0x5253, code: 0xcf},
	{region: 0x5255, code: 0xd0},
	{region: 0x5257, code: 0xd2},
	{region: 0x5341, code: 0xd3},
	{region: 0x5342, code: 0xd4},
	{region: 0x5343, code: 0xd5},
	{region: 0x5344, code: 0xd7},
	{region: 0x5345, code: 0xd9},
	{region: 0x5347, code: 0xda},
	{region: 0x5348, code: 0xdb},
	{region: 0x5349, code: 0x5c},
	{region: 0x534a, code: 0xbc},
	{region: 0x534b, code: 0x5c},
	{region: 0x534c, code: 0xde},
	{region: 0x534d, code: 0x5c},
	{region: 0x534e, code: 0x112},
	{region: 0x534f, code: 0xdf},
	{region: 0x5352, code: 0xe0},
	{region: 0x5353, code: 0xe2},
	{region: 0x5354, code: 0xe3},
	{region: 0x5356, code: 0xf9},
	{region: 0x5358, code: 0x8},
	{region: 0x5359, code: 0xe6},
	{region: 0x535a, code: 0xe7},
	{region: 0x5441, code: 0x61},
	{region: 0x5443, code: 0xf9},
	{region: 0x5444, code: 0x106},
	{region: 0x5446, code: 0x5c},
	{region: 0x5447, code: 0x112},
	{region: 0x5448, code: 0xe8},
	{region: 0x544a, code: 0xea},
	{region: 0x544b, code: 0xbe},
	{region: 0x544c, code: 0xf9},
	{region: 0x544d, code: 0xec},
	{region: 0x544e, code: 0xed},
	{region: 0x544f, code: 0xee},
	{region: 0x5452, code: 0xf1},
	{region: 0x5454, code: 0xf2},
	{region: 0x5456, code: 0x13},
	{region: 0x5457, code: 0xf3},
	{region: 0x545a, code: 0xf4},
	{region: 0x5541, code: 0xf5},
	{region: 0x5547, code: 0xf8},
	{region: 0x554d, code: 0xf9},
	{region: 0x5553, code: 0xf9},
	{region: 0x5559, code: 0xfe},
	{region: 0x555a, code: 0xff},
	{region: 0x5641, code: 0x5c},
	{region: 0x5643, code: 0x10d},
	{region: 0x5645, code: 0x101},
	{region: 0x5647, code: 0xf9},
	{region: 0x5649, code: 0xf9},
	{region: 0x564e, code: 0x102},
	{region: 0x5655, code: 0x104},
	{region: 0x5746, code: 0x114},
	{region: 0x5753, code: 0x105},
	{region: 0x584b, code: 0x5c},
	{region: 0x5945, code: 0x11c},
	{region: 0x5954, code: 0x5c},
	{region: 0x5a41, code: 0x122},
	{region: 0x5a4d, code: 0x124},
	{region: 0x5a57, code: 0xf9},
}

// symbols holds symbol data of the form <n> <str>, where n is the length of
// the symbol string str.
// Size: 1462 bytes
var symbols string = "" +
	"\x00\x02Kz\x01$\x02A$\x02KM\x03৳\x02Bs\x02R$\x01P\x03р.\x03CA$\x04CN¥" +
	"\x02¥\x03₡\x03Kč\x02kr\x03E£\x03₧\x03€\x02£\x02FG\x01Q\x03HK$\x01L\x02kn" +
	"\x02Ft\x02Rp\x03₪\x03₹\x04JP¥\x03៛\x02CF\x03₩\x03₸\x03₭\x03L£\x02Rs\x02L" +
	"t\x02Ls\x02Ar\x01K\x03₮\x03MX$\x02RM\x03₦\x02C$\x03NZ$\x03₱\x03zł\x03₲" +
	"\x03₽\x02RF\x02Db\x03฿\x02T$\x03₺\x03NT$\x03₴\x03US$\x03₫\x04FCFA\x03EC$" +
	"\x03CFA\x04CFPF\x01R\x02ZK\x05GH₵\x03AU$\x06ብር\x03***\x09د.إ.\u200f\x03A" +
	"R$\x03BB$\x09د.ب.\u200f\x03BM$\x03BN$\x03BS$\x03BZ$\x03CL$\x03CO$\x03CU$" +
	"\x03DO$\x09د.ج.\u200f\x09ج.م.\u200f\x03FJ$\x04UK£\x03GY$\x08ر.إن.\x09د.ع" +
	".\u200f\x06ر.إ.\x03JM$\x09د.أ.\u200f\x0cف.ج.ق.\u200f\x09د.ك.\u200f\x03KY" +
	"$\x09ل.ل.\u200f\x09د.ل.\u200f\x09د.م.\u200f\x09أ.م.\u200f\x09ر.ع.\u200f" +
	"\x06ر.ب.\x09ر.ق.\u200f\x09ر.س.\u200f\x03SB$\x09د.س.\u200f\x06ج.س.\x03SR$" +
	"\x09ج.ج.س.\x09ل.س.\u200f\x09د.ت.\u200f\x06ل.ت.\x03TT$\x03UY$\x09ر.ي." +
	"\u200f\x03Fdj\x03Nfk\x01S\x04GB£\x03TSh\x03₼\x03S£\x04Bds$\x03BD$\x02B$" +
	"\x04CUC$\x03$MN\x03RD$\x04FK£\x02G$\x04Íkr\x02J$\x03CI$\x02L$\x02N$\x07р" +
	"уб.\x03SI$\x02S$\x02$U\x05лв.\x06щ.д.\x02$A\x03$CA\x04£ E\x05£ RU\x04$ " +
	"HK\x03£L\x04$ ZN\x03$ T\x04$ SU\x04din.\x04КМ\x04Кч\x04зл\x07дин.\x04Тл" +
	"\x01F\x03USh\x04Kčs\x03ECU\x02TK\x03kr.\x03Ksh\x03öS\x03BGK\x03BGJ\x04Cu" +
	"b$\x02DM\x04Fl£\x04F.G.\x02FC\x04F.Rw\x03Nu.\x05KR₩\x05TH฿\x06Δρχ\x02Tk" +
	"\x02$b\x02Kr\x05ل.ل\x02Gs\x03CFP\x03FBu\x01D\x04MOP$\x02MK\x02SR\x02Le" +
	"\x04NAf.\x01E\x02VT\x03WS$\x03BsF\x02Af\x03Naf\x02$a\x04Afl.\x02Br\x02TL" +
	"\x03B/.\x03S/.\x03Gs.\x03Bs.\x02؋\x04¥CN\x03$HK\x08ریال\x03$MX\x03$NZ" +
	"\x03$EC\x02UM\x02mk\x03$AR\x03$AU\x02FB\x03$BM\x03$BN\x03$BS\x03$BZ\x03$" +
	"CL\x03$CO\x04£CY\x03£E\x03$FJ\x04£FK\x04£GB\x04£GI\x04£IE\x04£IL\x05₤IT" +
	"\x04£LB\x04£MT\x03$NA\x02$C\x03$RH\x02FR\x03$SB\x03$SG\x03$SR\x03$TT\x03" +
	"$US\x03$UY\x04FCFP\x02Kw\x05$\u00a0AU\x05$\u00a0HK\x05$\u00a0NZ\x05$" +
	"\u00a0SG\x05$\u00a0US\x02DA\x01G\x02LS\x02DT\x02$R\x04¥JP\x03$NT\x07રૂ." +
	"\x06ל״י\x03₨\x02֏\x03NKr\x03元\x03￥\x03\u200b\x04БД\x05КД$\x02LE\x02Kn" +
	"\x06сом\x02zl\x02rb\x03MTn\x06ден\x12ဒေါ်လာ\x12စီအာစီ\x0cनेरू\x02ر\x04Es" +
	"c.\x06\u200bPTE\x04XXXX\x06ТМТ\x03Dkr\x03Skr\x03Nkr\x07රු.\x0fසිෆ්එ\x03N" +
	"IS\x05Lekë\x03den\x05[BGN]\x05[BYR]\x06руб\x02r.\x03rub\x03BR$\x03Ekr" +
	"\x04EG£\x03Ikr\x03Rs.\x04AUD$\x04NZD$\x07крб.\x05soʻm\x06сўм\x03ILS\x03￦" +
	"\x02P.\x03Zł"

type curToIndex struct {
	cur uint16
	idx uint16
}

// Size: 1446 bytes, 711 elements
var normalLangIndex = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0014, 0x0014, 0x0014, 0x0017, 0x0018, 0x0018, 0x0018,
	0x0018, 0x0019, 0x0019, 0x001c, 0x001c, 0x0038, 0x0038, 0x0038,
	0x0038, 0x0039, 0x0039, 0x0039, 0x0039, 0x003a, 0x003a, 0x003a,
	0x003a, 0x003a, 0x003a, 0x003b, 0x003b, 0x003b, 0x003b, 0x003b,
	0x003b, 0x003b, 0x003b, 0x003b, 0x003c, 0x003e, 0x003e, 0x003e,
	0x003e, 0x003e, 0x003e, 0x003e, 0x003f, 0x003f, 0x0042, 0x0042,
	0x0044, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x0045, 0x004c,
	0x004c, 0x004d, 0x004d, 0x004e, 0x004e, 0x005f, 0x005f, 0x005f,
	// Entry 40 - 7F
	0x005f, 0x0061, 0x0061, 0x0061, 0x0062, 0x0062, 0x0063, 0x0071,
	0x0071, 0x0071, 0x0071, 0x0082, 0x0088, 0x0088, 0x0088, 0x0088,
	0x0091, 0x0091, 0x0091, 0x0092, 0x0092, 0x0093, 0x0093, 0x0094,
	0x0094, 0x0095, 0x0095, 0x0095, 0x0095, 0x0095, 0x009c, 0x009c,
	0x009d, 0x009d, 0x009f, 0x009f, 0x00a3, 0x00a3, 0x00a3, 0x00a4,
	0x00a4, 0x00ac, 0x00ac, 0x00ac, 0x00ad, 0x00ad, 0x00ae, 0x00af,
	0x00af, 0x00af, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4, 0x00b4,
	0x00ba, 0x00ba, 0x00bb, 0x00bb, 0x00be, 0x00be, 0x00be, 0x00c1,
	// Entry 80 - BF
	0x00c1, 0x00c1, 0x00c3, 0x00c5, 0x00c5, 0x00c6, 0x00c7, 0x00c7,
	0x00c7, 0x00dc, 0x00dd, 0x00dd, 0x00de, 0x00df, 0x00e0, 0x00e1,
	0x00e2, 0x00e3, 0x00e4, 0x00e4, 0x00e5, 0x00e5, 0x00e6, 0x00e6,
	0x00e6, 0x00e6, 0x00e7, 0x00e8, 0x00e9, 0x00e9, 0x00ea, 0x00ec,
	0x00ec, 0x00ec, 0x00ed, 0x00ed, 0x00ee, 0x00f0, 0x00f1, 0x00f1,
	0x00f2, 0x00f2, 0x00f2, 0x00f2, 0x00f2, 0x00f2, 0x00f2, 0x00f2,
	0x00f3, 0x00f4, 0x00f5, 0x00f6, 0x00f7, 0x00f8, 0x00f9, 0x00fa,
	0x00fb, 0x00fb, 0x00fc, 0x00fc, 0x00fd, 0x00fe, 0x00ff, 0x0100,
	// Entry C0 - FF
	0x0101, 0x0102, 0x0103, 0x0104, 0x0104, 0x0105, 0x0106, 0x0107,
	0x0108, 0x0109, 0x010a, 0x010b, 0x010b, 0x010b, 0x010c, 0x010d,
	0x010e, 0x010e, 0x010f, 0x0110, 0x0112, 0x0112, 0x0113, 0x0115,
	0x0116, 0x0117, 0x0117, 0x0118, 0x0119, 0x011a, 0x011b, 0x011c,
	0x011d, 0x011d, 0x011d, 0x011e, 0x011e, 0x011e, 0x011f, 0x0120,
	0x0121, 0x0122, 0x0122, 0x0122, 0x0122, 0x0134, 0x0134, 0x0139,
	0x013b, 0x013c, 0x013e, 0x0140, 0x0141, 0x0143, 0x0145, 0x0145,
	0x0146, 0x0146, 0x0147, 0x0148, 0x0149, 0x0149, 0x0152, 0x0153,
	// Entry 100 - 13F
	0x0154, 0x0155, 0x0156, 0x0157, 0x0158, 0x0159, 0x015b, 0x015d,
	0x015e, 0x0163, 0x0163, 0x0165, 0x0165, 0x0165, 0x0165, 0x0170,
	0x0170, 0x0170, 0x0170, 0x0170, 0x0171, 0x0172, 0x0172, 0x0183,
	0x0183, 0x0187, 0x0187, 0x0188, 0x0189, 0x0189, 0x01af, 0x01af,
	0x01af, 0x01b0, 0x01b0, 0x01b0, 0x01d0, 0x01d1, 0x01d1, 0x01d1,
	0x01d1, 0x01d1, 0x01d1, 0x01d2, 0x01d3, 0x01d3, 0x01d3, 0x01d3,
	0x01d4, 0x01d4, 0x01d4, 0x01d5, 0x01d6, 0x01d8, 0x01d8, 0x01d8,
	0x01d8, 0x01d9, 0x01d9, 0x01d9, 0x01da, 0x01db, 0x01db, 0x01db,
	// Entry 140 - 17F
	0x01db, 0x01db, 0x01db, 0x01dc, 0x01dd, 0x01dd, 0x01de, 0x01de,
	0x01de, 0x01df, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e0, 0x01e6,
	0x01e6, 0x01e9, 0x01e9, 0x01eb, 0x01eb, 0x01f5, 0x01f5, 0x01f8,
	0x01f8, 0x01f8, 0x01f8, 0x01f9, 0x01f9, 0x01fa, 0x01fa, 0x01fa,
	0x01fa, 0x01fb, 0x01fc, 0x01fc, 0x01fc, 0x01fd, 0x01fd, 0x0200,
	0x0200, 0x0202, 0x0202, 0x0214, 0x0215, 0x0215, 0x021a, 0x021a,
	0x022c, 0x022c, 0x022f, 0x022f, 0x0233, 0x0233, 0x0234, 0x0234,
	0x0235, 0x0235, 0x0241, 0x0241, 0x0248, 0x0248, 0x0248, 0x0248,
	// Entry 180 - 1BF
	0x024d, 0x024d, 0x024d, 0x024d, 0x024e, 0x024e, 0x0257, 0x0257,
	0x0258, 0x0258, 0x0259, 0x0259, 0x025a, 0x025a, 0x025d, 0x025d,
	0x025d, 0x025d, 0x025e, 0x025e, 0x0264, 0x0264, 0x0264, 0x0264,
	0x0265, 0x0265, 0x0266, 0x0266, 0x0269, 0x0269, 0x026b, 0x026b,
	0x026d, 0x026d, 0x026d, 0x026d, 0x026d, 0x026d, 0x026d, 0x026e,
	0x026e, 0x026e, 0x026e, 0x026e, 0x026e, 0x026e, 0x026e, 0x027d,
	0x027d, 0x027e, 0x027e, 0x0283, 0x0283, 0x0284, 0x0284, 0x0285,
	0x0285, 0x0286, 0x0287, 0x0287, 0x0287, 0x0287, 0x0289, 0x0289,
	// Entry 1C0 - 1FF
	0x0289, 0x0289, 0x0289, 0x029c, 0x029c, 0x029d, 0x029d, 0x029e,
	0x029e, 0x029f, 0x029f, 0x02a4, 0x02a4, 0x02a5, 0x02a5, 0x02a6,
	0x02a7, 0x02a7, 0x02a8, 0x02a8, 0x02a9, 0x02a9, 0x02aa, 0x02aa,
	0x02aa, 0x02aa, 0x02b6, 0x02b6, 0x02b9, 0x02b9, 0x02bc, 0x02bc,
	0x02be, 0x02be, 0x02c2, 0x02c3, 0x02c3, 0x02c4, 0x02c4, 0x02c4,
	0x02c4, 0x02c4, 0x02c7, 0x02c7, 0x02c8, 0x02c8, 0x02c9, 0x02c9,
	0x02db, 0x02db, 0x02db, 0x02db, 0x02db, 0x02dd, 0x02dd, 0x02dd,
	0x02e3, 0x02e4, 0x02e4, 0x02e5, 0x02e6, 0x02e6, 0x02e7, 0x02e8,
	// Entry 200 - 23F
	0x02e8, 0x02e8, 0x02e9, 0x02e9, 0x02e9, 0x02e9, 0x02eb, 0x02eb,
	0x02ec, 0x02ec, 0x02ed, 0x02ed, 0x02ee, 0x02ee, 0x02ee, 0x02ef,
	0x02ef, 0x02f0, 0x02f1, 0x02f2, 0x02f2, 0x02f2, 0x02f2, 0x0301,
	0x0301, 0x0301, 0x0301, 0x0302, 0x0302, 0x0305, 0x0306, 0x0306,
	0x0308, 0x0308, 0x0309, 0x030a, 0x030b, 0x030c, 0x030c, 0x030d,
	0x030f, 0x0311, 0x0311, 0x0311, 0x0311, 0x0312, 0x0312, 0x0323,
	0x0324, 0x0324, 0x0325, 0x0325, 0x032d, 0x032f, 0x0330, 0x0331,
	0x0332, 0x0332, 0x0332, 0x0333, 0x0333, 0x0334, 0x0334, 0x0335,
	// Entry 240 - 27F
	0x0335, 0x0336, 0x0336, 0x0337, 0x0337, 0x033b, 0x033b, 0x033b,
	0x033d, 0x033e, 0x033e, 0x033e, 0x033e, 0x033e, 0x033e, 0x033e,
	0x033e, 0x033e, 0x033e, 0x033e, 0x0341, 0x0341, 0x034f, 0x034f,
	0x0353, 0x0353, 0x0353, 0x0353, 0x0353, 0x0353, 0x0354, 0x0355,
	0x0356, 0x0357, 0x0357, 0x0359, 0x0359, 0x035a, 0x035a, 0x0362,
	0x0362, 0x0362, 0x0362, 0x0362, 0x0362, 0x036a, 0x036a, 0x036a,
	0x036a, 0x036a, 0x0381, 0x0381, 0x0381, 0x0381, 0x0384, 0x0385,
	0x0385, 0x0385, 0x0386, 0x0389, 0x0389, 0x038a, 0x038c, 0x038f,
	// Entry 280 - 2BF
	0x0391, 0x0391, 0x0392, 0x0393, 0x0393, 0x0395, 0x0395, 0x0396,
	0x0397, 0x0397, 0x0399, 0x0399, 0x039c, 0x039c, 0x03a1, 0x03a1,
	0x03a1, 0x03a1, 0x03a1, 0x03a1, 0x03a1, 0x03a3, 0x03a3, 0x03b6,
	0x03b6, 0x03b9, 0x03ba, 0x03ba, 0x03bb, 0x03bc, 0x03bc, 0x03be,
	0x03be, 0x03be, 0x03be, 0x03bf, 0x03c0, 0x03c0, 0x03c0, 0x03c0,
	0x03c2, 0x03c2, 0x03c2, 0x03c2, 0x03c3, 0x03c3, 0x03c5, 0x03c5,
	0x03c6, 0x03c6, 0x03c6, 0x03c6, 0x03c6, 0x03c6, 0x03c7, 0x03c7,
	0x03c7, 0x03c7, 0x03c7, 0x03cb, 0x03cb, 0x03cb, 0x03cc, 0x03ce,
	// Entry 2C0 - 2FF
	0x03d0, 0x03d4, 0x03d6, 0x03d7, 0x03d7, 0x03d9, 0x03d9,
}

// Size: 3964 bytes, 985 elements
var normalSymIndex = []curToIndex{
	{cur: 0x13, idx: 0x6},
	{cur: 0x2e, idx: 0x13},
	{cur: 0x39, idx: 0x1c},
	{cur: 0x42, idx: 0x20},
	{cur: 0x5c, idx: 0x3b},
	{cur: 0x61, idx: 0x3f},
	{cur: 0x70, idx: 0x47},
	{cur: 0x7a, idx: 0x56},
	{cur: 0x7b, idx: 0x5a},
	{cur: 0x83, idx: 0x5e},
	{cur: 0x8b, idx: 0x6a},
	{cur: 0xb0, idx: 0x8c},
	{cur: 0xbe, idx: 0x9a},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0x102, idx: 0xcb},
	{cur: 0x106, idx: 0xcf},
	{cur: 0x10d, idx: 0xd4},
	{cur: 0x112, idx: 0xd8},
	{cur: 0x114, idx: 0xdc},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x122, idx: 0xe1},
	{cur: 0xb7, idx: 0x4},
	{cur: 0x65, idx: 0xe6},
	{cur: 0x13, idx: 0xec},
	{cur: 0x5b, idx: 0xf0},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x0, idx: 0xf7},
	{cur: 0x2, idx: 0xfb},
	{cur: 0x13, idx: 0xec},
	{cur: 0x23, idx: 0x10d},
	{cur: 0x52, idx: 0x137},
	{cur: 0x56, idx: 0x141},
	{cur: 0x76, idx: 0x158},
	{cur: 0x7c, idx: 0x161},
	{cur: 0x7d, idx: 0x16b},
	{cur: 0x82, idx: 0x176},
	{cur: 0x87, idx: 0x180},
	{cur: 0x8c, idx: 0x18d},
	{cur: 0x90, idx: 0x19b},
	{cur: 0x9b, idx: 0x1a5},
	{cur: 0x9c, idx: 0x1af},
	{cur: 0xa9, idx: 0x1b9},
	{cur: 0xbf, idx: 0x1c3},
	{cur: 0xc6, idx: 0x1cd},
	{cur: 0xcb, idx: 0x1d4},
	{cur: 0xd3, idx: 0x1de},
	{cur: 0xd6, idx: 0x1ec},
	{cur: 0xd7, idx: 0x1f6},
	{cur: 0xe2, idx: 0x201},
	{cur: 0xe6, idx: 0x20b},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xed, idx: 0x215},
	{cur: 0xf1, idx: 0x21f},
	{cur: 0x11c, idx: 0x22e},
	{cur: 0x4f, idx: 0x238},
	{cur: 0x57, idx: 0x23c},
	{cur: 0xd7, idx: 0x0},
	{cur: 0xdf, idx: 0x240},
	{cur: 0x61, idx: 0x242},
	{cur: 0xe2, idx: 0x3f},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x16, idx: 0x24b},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x16, idx: 0x24b},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x37, idx: 0x18},
	{cur: 0x39, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xd0, idx: 0xaa},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x124, idx: 0x86},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x13, idx: 0x0},
	{cur: 0x21, idx: 0x298},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x29e},
	{cur: 0x102, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x1b, idx: 0xc},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x42, idx: 0x25},
	{cur: 0x42, idx: 0x20},
	{cur: 0x13, idx: 0x2a5},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x2a8},
	{cur: 0x42, idx: 0x0},
	{cur: 0x61, idx: 0x2b1},
	{cur: 0x70, idx: 0x2b7},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xbe, idx: 0x2c0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x2c9},
	{cur: 0x102, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x13, idx: 0x0},
	{cur: 0x18, idx: 0x9},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x73, idx: 0x4d},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xcf, idx: 0x2ce},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x114, idx: 0x0},
	{cur: 0x18, idx: 0x2d3},
	{cur: 0x4c, idx: 0x2d8},
	{cur: 0x83, idx: 0x25},
	{cur: 0xc7, idx: 0x2dd},
	{cur: 0xcf, idx: 0x2e2},
	{cur: 0xf1, idx: 0x2ea},
	{cur: 0x13, idx: 0xec},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x25},
	{cur: 0x5a, idx: 0x37},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x60, idx: 0x2ef},
	{cur: 0xd0, idx: 0xaa},
	{cur: 0xf8, idx: 0x2f1},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x13, idx: 0xec},
	{cur: 0x47, idx: 0x2f5},
	{cur: 0x4c, idx: 0x2c},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x10f, idx: 0x2fa},
	{cur: 0xd0, idx: 0xaa},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x13, idx: 0xec},
	{cur: 0x50, idx: 0x301},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x84, idx: 0x305},
	{cur: 0x12, idx: 0x309},
	{cur: 0x13, idx: 0xec},
	{cur: 0x20, idx: 0x30d},
	{cur: 0x22, idx: 0x311},
	{cur: 0x4e, idx: 0x31a},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x97, idx: 0x2ef},
	{cur: 0x13, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0xc7, idx: 0xa2},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x13, idx: 0xec},
	{cur: 0x33, idx: 0x32f},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x8b, idx: 0x333},
	{cur: 0xe8, idx: 0x339},
	{cur: 0x106, idx: 0x0},
	{cur: 0x84, idx: 0x305},
	{cur: 0x13, idx: 0xec},
	{cur: 0x65, idx: 0xe6},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x6b, idx: 0x33f},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x83, idx: 0x25},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x83, idx: 0x5e},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x13, idx: 0x4},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xd5, idx: 0x7a},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x106, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x112, idx: 0x0},
	{cur: 0x114, idx: 0x358},
	{cur: 0x1a, idx: 0x4},
	{cur: 0x24, idx: 0x35c},
	{cur: 0x25, idx: 0x4},
	{cur: 0x32, idx: 0x4},
	{cur: 0x35, idx: 0x16},
	{cur: 0x38, idx: 0x4},
	{cur: 0x39, idx: 0x4},
	{cur: 0x13, idx: 0x4},
	{cur: 0xbe, idx: 0x4},
	{cur: 0x13, idx: 0x4},
	{cur: 0x50, idx: 0x301},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x57, idx: 0x23c},
	{cur: 0x5e, idx: 0x4},
	{cur: 0x5f, idx: 0x3f},
	{cur: 0x61, idx: 0x242},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x65, idx: 0xe6},
	{cur: 0x61, idx: 0x242},
	{cur: 0x66, idx: 0x3f},
	{cur: 0x67, idx: 0x360},
	{cur: 0x6f, idx: 0x4},
	{cur: 0x81, idx: 0x4},
	{cur: 0x84, idx: 0x305},
	{cur: 0x13, idx: 0x4},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x8d, idx: 0x4},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x92, idx: 0x4},
	{cur: 0x122, idx: 0xe1},
	{cur: 0xa1, idx: 0x83},
	{cur: 0xa8, idx: 0x362},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x61, idx: 0x242},
	{cur: 0xac, idx: 0x7a},
	{cur: 0xaf, idx: 0x367},
	{cur: 0xb3, idx: 0x90},
	{cur: 0xb7, idx: 0x4},
	{cur: 0x13, idx: 0x4},
	{cur: 0xb8, idx: 0x93},
	{cur: 0x13, idx: 0x4},
	{cur: 0xbe, idx: 0x4},
	{cur: 0xbe, idx: 0x4},
	{cur: 0xc4, idx: 0x86},
	{cur: 0xc5, idx: 0x9e},
	{cur: 0xc6, idx: 0x7a},
	{cur: 0xbe, idx: 0x4},
	{cur: 0xd2, idx: 0xae},
	{cur: 0xd4, idx: 0x4},
	{cur: 0xd5, idx: 0x36a},
	{cur: 0xd9, idx: 0x30},
	{cur: 0xda, idx: 0x4},
	{cur: 0x61, idx: 0x242},
	{cur: 0xdb, idx: 0x3f},
	{cur: 0xde, idx: 0x36d},
	{cur: 0x61, idx: 0x242},
	{cur: 0xe2, idx: 0x3f},
	{cur: 0x8, idx: 0x370},
	{cur: 0xe7, idx: 0x375},
	{cur: 0xbe, idx: 0x4},
	{cur: 0xee, idx: 0xb8},
	{cur: 0xf2, idx: 0x4},
	{cur: 0x13, idx: 0x4},
	{cur: 0xf4, idx: 0x247},
	{cur: 0xf8, idx: 0x2f1},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x104, idx: 0x377},
	{cur: 0x105, idx: 0x37a},
	{cur: 0x122, idx: 0xe1},
	{cur: 0x124, idx: 0x86},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x5a, idx: 0x37},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x106, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x112, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x5c, idx: 0x0},
	{cur: 0xe8, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x11, idx: 0x4},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0x27, idx: 0x10},
	{cur: 0x40, idx: 0x4},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0x43, idx: 0x4},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0x45, idx: 0x28},
	{cur: 0x49, idx: 0x4},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0x51, idx: 0x268},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x106, idx: 0xcf},
	{cur: 0x6c, idx: 0x45},
	{cur: 0x71, idx: 0x4b},
	{cur: 0x4, idx: 0x382},
	{cur: 0x8, idx: 0x385},
	{cur: 0x9, idx: 0x1},
	{cur: 0x11, idx: 0x389},
	{cur: 0x13, idx: 0xec},
	{cur: 0x14, idx: 0x38c},
	{cur: 0x42, idx: 0x20},
	{cur: 0xb0, idx: 0x4},
	{cur: 0x114, idx: 0x0},
	{cur: 0xba, idx: 0x97},
	{cur: 0xc0, idx: 0x397},
	{cur: 0xc2, idx: 0x39b},
	{cur: 0xc5, idx: 0x9e},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xca, idx: 0x39f},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x83, idx: 0x25},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0xfe, idx: 0x4},
	{cur: 0x101, idx: 0x3a3},
	{cur: 0x13, idx: 0xec},
	{cur: 0x55, idx: 0x30},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x5a, idx: 0x37},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x4, idx: 0x3a7},
	{cur: 0x39, idx: 0x2a8},
	{cur: 0x42, idx: 0x3aa},
	{cur: 0x70, idx: 0x3af},
	{cur: 0x7d, idx: 0x3b3},
	{cur: 0x83, idx: 0x25},
	{cur: 0xb0, idx: 0x3bc},
	{cur: 0xbe, idx: 0x3c0},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x10d, idx: 0x3c4},
	{cur: 0x68, idx: 0x42},
	{cur: 0xa9, idx: 0x3c8},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x5d, idx: 0x3cb},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x102, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x114, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0xc5, idx: 0x9e},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x50, idx: 0x30},
	{cur: 0x50, idx: 0x301},
	{cur: 0x11, idx: 0x3ce},
	{cur: 0x13, idx: 0x3d2},
	{cur: 0x1d, idx: 0x3d6},
	{cur: 0x25, idx: 0x3d9},
	{cur: 0x26, idx: 0x3dd},
	{cur: 0x32, idx: 0x3e1},
	{cur: 0x38, idx: 0x3e5},
	{cur: 0x39, idx: 0x2a8},
	{cur: 0x40, idx: 0x3e9},
	{cur: 0x42, idx: 0x0},
	{cur: 0x43, idx: 0x3ed},
	{cur: 0x4b, idx: 0x3f1},
	{cur: 0x5e, idx: 0x3fa},
	{cur: 0x5f, idx: 0x3fe},
	{cur: 0x60, idx: 0x2ef},
	{cur: 0x61, idx: 0x403},
	{cur: 0x66, idx: 0x408},
	{cur: 0x70, idx: 0x0},
	{cur: 0x77, idx: 0x40d},
	{cur: 0x78, idx: 0x412},
	{cur: 0x80, idx: 0x417},
	{cur: 0x83, idx: 0x0},
	{cur: 0x90, idx: 0x41d},
	{cur: 0xab, idx: 0x422},
	{cur: 0xb0, idx: 0x3bc},
	{cur: 0xb7, idx: 0x427},
	{cur: 0xbe, idx: 0x3c0},
	{cur: 0xcc, idx: 0x42e},
	{cur: 0xd4, idx: 0x435},
	{cur: 0xda, idx: 0x439},
	{cur: 0xe0, idx: 0x43d},
	{cur: 0xf2, idx: 0x441},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x445},
	{cur: 0xfe, idx: 0x449},
	{cur: 0x105, idx: 0x37a},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x114, idx: 0x44d},
	{cur: 0x24, idx: 0x35c},
	{cur: 0x11, idx: 0x0},
	{cur: 0x13, idx: 0x455},
	{cur: 0x25, idx: 0x0},
	{cur: 0x26, idx: 0x0},
	{cur: 0x32, idx: 0x0},
	{cur: 0x38, idx: 0x0},
	{cur: 0x39, idx: 0x4},
	{cur: 0x40, idx: 0x0},
	{cur: 0x42, idx: 0x20},
	{cur: 0x43, idx: 0x0},
	{cur: 0x5e, idx: 0x0},
	{cur: 0x5f, idx: 0x0},
	{cur: 0x61, idx: 0x3f},
	{cur: 0x66, idx: 0x0},
	{cur: 0x70, idx: 0x45b},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0x8b, idx: 0x0},
	{cur: 0x90, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xb7, idx: 0x0},
	{cur: 0xbe, idx: 0x461},
	{cur: 0xd4, idx: 0x0},
	{cur: 0xda, idx: 0x467},
	{cur: 0xe0, idx: 0x0},
	{cur: 0xf2, idx: 0x0},
	{cur: 0xf9, idx: 0x46d},
	{cur: 0xfe, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x106, idx: 0x0},
	{cur: 0x112, idx: 0x0},
	{cur: 0x114, idx: 0x0},
	{cur: 0x3a, idx: 0x327},
	{cur: 0x4f, idx: 0x238},
	{cur: 0x52, idx: 0x473},
	{cur: 0x68, idx: 0x42},
	{cur: 0x74, idx: 0x476},
	{cur: 0x87, idx: 0x67},
	{cur: 0x60, idx: 0x0},
	{cur: 0x97, idx: 0x2ef},
	{cur: 0xa1, idx: 0x83},
	{cur: 0xa9, idx: 0x3c8},
	{cur: 0xac, idx: 0x7a},
	{cur: 0xd2, idx: 0xae},
	{cur: 0xd5, idx: 0x36a},
	{cur: 0xe6, idx: 0x478},
	{cur: 0xed, idx: 0x47b},
	{cur: 0x104, idx: 0x377},
	{cur: 0x13, idx: 0xec},
	{cur: 0x39, idx: 0x97},
	{cur: 0x5e, idx: 0x14b},
	{cur: 0xd4, idx: 0x28e},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x114, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x13, idx: 0x2a5},
	{cur: 0x2e, idx: 0x47e},
	{cur: 0x39, idx: 0x2a8},
	{cur: 0x5a, idx: 0x37},
	{cur: 0x70, idx: 0x3af},
	{cur: 0x83, idx: 0x481},
	{cur: 0xb0, idx: 0x3bc},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf3, idx: 0x486},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x12, idx: 0x309},
	{cur: 0x83, idx: 0x25},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x84, idx: 0x305},
	{cur: 0xb8, idx: 0x93},
	{cur: 0x65, idx: 0xe6},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x78, idx: 0x492},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x114, idx: 0x0},
	{cur: 0x18, idx: 0x9},
	{cur: 0x13, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0xc7, idx: 0xa2},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x75, idx: 0x50},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x7, idx: 0x49d},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x13, idx: 0xec},
	{cur: 0x76, idx: 0x53},
	{cur: 0x7b, idx: 0x7a},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xb8, idx: 0x93},
	{cur: 0x42, idx: 0x25},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf3, idx: 0x0},
	{cur: 0x13, idx: 0xec},
	{cur: 0x42, idx: 0x4a4},
	{cur: 0x83, idx: 0x4a8},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x13, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x52, idx: 0x473},
	{cur: 0x84, idx: 0x305},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x13, idx: 0xec},
	{cur: 0x4a, idx: 0x4ac},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x84, idx: 0x305},
	{cur: 0x25, idx: 0x4b0},
	{cur: 0x39, idx: 0x4b5},
	{cur: 0x8e, idx: 0x6e},
	{cur: 0xd0, idx: 0xaa},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x50, idx: 0x301},
	{cur: 0x84, idx: 0x305},
	{cur: 0x86, idx: 0x63},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x13, idx: 0xec},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x85, idx: 0x4c1},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x12, idx: 0x309},
	{cur: 0x13, idx: 0xec},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xf8, idx: 0x2f1},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x3a, idx: 0x327},
	{cur: 0x9, idx: 0x1},
	{cur: 0x8f, idx: 0x72},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x106, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x112, idx: 0x0},
	{cur: 0x114, idx: 0x0},
	{cur: 0x3a, idx: 0x327},
	{cur: 0x84, idx: 0x305},
	{cur: 0x84, idx: 0x305},
	{cur: 0x13, idx: 0xec},
	{cur: 0x83, idx: 0x25},
	{cur: 0x99, idx: 0x80},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x84, idx: 0x305},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x84, idx: 0x305},
	{cur: 0xac, idx: 0x7a},
	{cur: 0xa1, idx: 0x83},
	{cur: 0xb6, idx: 0x4ce},
	{cur: 0x13, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xa3, idx: 0x4d2},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xa7, idx: 0x88},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x39, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xb3, idx: 0x90},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x26, idx: 0x4},
	{cur: 0xda, idx: 0x4},
	{cur: 0x45, idx: 0x4ec},
	{cur: 0xa6, idx: 0x86},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xb7, idx: 0x4},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbc, idx: 0x30},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x106, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0x114, idx: 0x0},
	{cur: 0xbd, idx: 0x4ff},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x13, idx: 0xec},
	{cur: 0x39, idx: 0x97},
	{cur: 0x5e, idx: 0x14b},
	{cur: 0xd4, idx: 0x28e},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x114, idx: 0x0},
	{cur: 0x14, idx: 0x38c},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x8, idx: 0x370},
	{cur: 0xe0, idx: 0x4},
	{cur: 0x8, idx: 0x370},
	{cur: 0xbc, idx: 0x30},
	{cur: 0x61, idx: 0x242},
	{cur: 0xe2, idx: 0x3f},
	{cur: 0xf8, idx: 0x2f1},
	{cur: 0x5b, idx: 0x391},
	{cur: 0x84, idx: 0x305},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xd0, idx: 0xaa},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xc6, idx: 0x50c},
	{cur: 0x13, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xc7, idx: 0xa2},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x4, idx: 0x3a7},
	{cur: 0x13, idx: 0xec},
	{cur: 0xc9, idx: 0x50f},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x9, idx: 0x1},
	{cur: 0x4a, idx: 0x4ac},
	{cur: 0xc9, idx: 0x514},
	{cur: 0xa8, idx: 0x362},
	{cur: 0xb6, idx: 0x4ce},
	{cur: 0xc9, idx: 0x4ac},
	{cur: 0xe3, idx: 0xb1},
	{cur: 0xc2, idx: 0x39b},
	{cur: 0x27, idx: 0x10},
	{cur: 0xc2, idx: 0x0},
	{cur: 0xc2, idx: 0x0},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x24, idx: 0x35c},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0xa0, idx: 0x4b},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x0, idx: 0x51b},
	{cur: 0x83, idx: 0x25},
	{cur: 0xd0, idx: 0xaa},
	{cur: 0xd1, idx: 0x18},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xec, idx: 0x520},
	{cur: 0xf5, idx: 0xc3},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x37, idx: 0x18},
	{cur: 0xd1, idx: 0x0},
	{cur: 0x85, idx: 0x4c1},
	{cur: 0x8e, idx: 0x6e},
	{cur: 0xa0, idx: 0x4b},
	{cur: 0xd2, idx: 0xae},
	{cur: 0xf4, idx: 0x247},
	{cur: 0xd0, idx: 0xaa},
	{cur: 0x84, idx: 0x305},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x50, idx: 0x527},
	{cur: 0xbc, idx: 0x30},
	{cur: 0xd9, idx: 0x52b},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xbc, idx: 0x52f},
	{cur: 0xd9, idx: 0x30},
	{cur: 0xb6, idx: 0x4ce},
	{cur: 0x91, idx: 0x533},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x112, idx: 0x53b},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x54b},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xdf, idx: 0x240},
	{cur: 0x4f, idx: 0x238},
	{cur: 0x5b, idx: 0x391},
	{cur: 0x84, idx: 0x305},
	{cur: 0x6, idx: 0x54f},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xa3, idx: 0x555},
	{cur: 0x13, idx: 0x0},
	{cur: 0x18, idx: 0x2d3},
	{cur: 0x21, idx: 0x559},
	{cur: 0x37, idx: 0x55f},
	{cur: 0x83, idx: 0x25},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x13, idx: 0x0},
	{cur: 0x18, idx: 0x9},
	{cur: 0x21, idx: 0x559},
	{cur: 0x37, idx: 0x55f},
	{cur: 0x83, idx: 0x25},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x13, idx: 0x0},
	{cur: 0x1a, idx: 0x253},
	{cur: 0x25, idx: 0x117},
	{cur: 0x2e, idx: 0x573},
	{cur: 0x32, idx: 0x11f},
	{cur: 0x38, idx: 0x123},
	{cur: 0x42, idx: 0x0},
	{cur: 0x50, idx: 0x527},
	{cur: 0x51, idx: 0x268},
	{cur: 0x55, idx: 0x577},
	{cur: 0x56, idx: 0x57b},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x7f, idx: 0x580},
	{cur: 0x81, idx: 0x172},
	{cur: 0x83, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xbc, idx: 0x52f},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xd9, idx: 0x30},
	{cur: 0xf3, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x84, idx: 0x305},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x3a, idx: 0x327},
	{cur: 0xf8, idx: 0x2f1},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x91, idx: 0x584},
	{cur: 0xb3, idx: 0x90},
	{cur: 0xda, idx: 0x292},
	{cur: 0xb3, idx: 0x90},
	{cur: 0xda, idx: 0x4},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xf8, idx: 0x2f1},
	{cur: 0x84, idx: 0x305},
	{cur: 0x13, idx: 0xec},
	{cur: 0x83, idx: 0x25},
	{cur: 0x5b, idx: 0x391},
	{cur: 0x57, idx: 0x23c},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x13, idx: 0x588},
	{cur: 0xbe, idx: 0x58d},
	{cur: 0xee, idx: 0xb8},
	{cur: 0x13, idx: 0xec},
	{cur: 0x83, idx: 0x25},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf1, idx: 0xbb},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x42, idx: 0x4a8},
	{cur: 0xf9, idx: 0x4},
	{cur: 0x13, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x61, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x83, idx: 0x25},
	{cur: 0x8b, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf5, idx: 0xc3},
	{cur: 0xf6, idx: 0x592},
	{cur: 0xf9, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0x10d, idx: 0x0},
	{cur: 0xc6, idx: 0x7a},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xc6, idx: 0x0},
	{cur: 0xff, idx: 0x59a},
	{cur: 0x4, idx: 0x3a7},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xff, idx: 0x5a0},
	{cur: 0x92, idx: 0x4},
	{cur: 0x92, idx: 0x4},
	{cur: 0x13, idx: 0xec},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xf4, idx: 0x247},
	{cur: 0x83, idx: 0x25},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xf8, idx: 0x2f1},
	{cur: 0xb8, idx: 0x93},
	{cur: 0x13, idx: 0xec},
	{cur: 0x42, idx: 0x4a8},
	{cur: 0x79, idx: 0x5a7},
	{cur: 0x8b, idx: 0x5ab},
	{cur: 0x42, idx: 0x20},
	{cur: 0x42, idx: 0x20},
	{cur: 0xa8, idx: 0x362},
	{cur: 0x42, idx: 0x20},
	{cur: 0xda, idx: 0x4},
	{cur: 0x13, idx: 0xec},
	{cur: 0x83, idx: 0x25},
	{cur: 0x8b, idx: 0x5ab},
	{cur: 0xf3, idx: 0x4},
	{cur: 0x8b, idx: 0x6a},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xa8, idx: 0x362},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0x122, idx: 0xe1},
}

// Size: 1446 bytes, 711 elements
var narrowLangIndex = []uint16{
	// Entry 0 - 3F
	0x0000, 0x0060, 0x0060, 0x0060, 0x0061, 0x0061, 0x0061, 0x0061,
	0x0061, 0x0061, 0x0061, 0x0062, 0x0062, 0x007f, 0x007f, 0x0080,
	0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
	0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
	0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080,
	0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0080, 0x0089, 0x0089,
	0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x008b, 0x00a4,
	0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00a4, 0x00d3, 0x00d3, 0x00d3,
	// Entry 40 - 7F
	0x00d3, 0x00d4, 0x00d4, 0x00d4, 0x00d4, 0x00d4, 0x00d4, 0x00d7,
	0x00d7, 0x00d7, 0x00d7, 0x00d8, 0x00d8, 0x00d8, 0x00d8, 0x00d8,
	0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2,
	0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e2, 0x00e3, 0x00e3,
	0x00e3, 0x00e3, 0x00e9, 0x00e9, 0x00ee, 0x00ee, 0x00ee, 0x00ee,
	0x00ee, 0x00f6, 0x00f6, 0x00f6, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
	0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
	0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
	// Entry 80 - BF
	0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7, 0x00f7,
	0x00f7, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	// Entry C0 - FF
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0100,
	0x0100, 0x0100, 0x0100, 0x0100, 0x0100, 0x0102, 0x0102, 0x0104,
	0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104,
	0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0104, 0x0108, 0x0108,
	// Entry 100 - 13F
	0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108, 0x0108,
	0x0109, 0x010a, 0x010a, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b,
	0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010b, 0x010d,
	0x010d, 0x010e, 0x010e, 0x010e, 0x010e, 0x010e, 0x0115, 0x0115,
	0x0115, 0x0115, 0x0115, 0x0115, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	// Entry 140 - 17F
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118, 0x0118,
	0x0118, 0x0119, 0x0119, 0x011a, 0x011a, 0x011c, 0x011c, 0x011c,
	0x011c, 0x011c, 0x011c, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e,
	0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011e, 0x011f,
	0x011f, 0x0122, 0x0122, 0x0123, 0x0123, 0x0123, 0x0123, 0x0123,
	0x0124, 0x0124, 0x0125, 0x0125, 0x0126, 0x0126, 0x0126, 0x0126,
	0x0126, 0x0126, 0x0127, 0x0127, 0x012d, 0x012d, 0x012d, 0x012d,
	// Entry 180 - 1BF
	0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0130, 0x0131, 0x0131,
	0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131, 0x0131,
	0x0131, 0x0131, 0x0131, 0x0131, 0x0132, 0x0132, 0x0132, 0x0132,
	0x0132, 0x0132, 0x0132, 0x0132, 0x0133, 0x0133, 0x0134, 0x0134,
	0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135,
	0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0135, 0x0140,
	0x0140, 0x0140, 0x0140, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141,
	0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0141, 0x0142, 0x0142,
	// Entry 1C0 - 1FF
	0x0142, 0x0142, 0x0142, 0x014d, 0x014d, 0x014d, 0x014d, 0x014d,
	0x014d, 0x014d, 0x014d, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
	0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e, 0x014e,
	0x014e, 0x014e, 0x014f, 0x014f, 0x0150, 0x0150, 0x0151, 0x0151,
	0x0152, 0x0152, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153, 0x0153,
	0x0153, 0x0153, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154, 0x0154,
	0x0155, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155, 0x0155,
	0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156,
	// Entry 200 - 23F
	0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156,
	0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156, 0x0156,
	0x0156, 0x0156, 0x0157, 0x0157, 0x0157, 0x0157, 0x0157, 0x0158,
	0x0158, 0x0158, 0x0158, 0x0158, 0x0158, 0x0159, 0x0159, 0x0159,
	0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159,
	0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x0159, 0x015a,
	0x015a, 0x015a, 0x015a, 0x015a, 0x015b, 0x015b, 0x015b, 0x015b,
	0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b,
	// Entry 240 - 27F
	0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b,
	0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b, 0x015b,
	0x015b, 0x015b, 0x015b, 0x015b, 0x015d, 0x015d, 0x015e, 0x015e,
	0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f,
	0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x015f, 0x0161,
	0x0161, 0x0161, 0x0161, 0x0161, 0x0161, 0x0164, 0x0164, 0x0164,
	0x0164, 0x0164, 0x0166, 0x0166, 0x0166, 0x0166, 0x0167, 0x0167,
	0x0167, 0x0167, 0x0167, 0x0168, 0x0168, 0x0168, 0x0168, 0x0168,
	// Entry 280 - 2BF
	0x0169, 0x0169, 0x0169, 0x0169, 0x0169, 0x016a, 0x016a, 0x016a,
	0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016a, 0x016b, 0x016b,
	0x016b, 0x016b, 0x016b, 0x016b, 0x016b, 0x016b, 0x016b, 0x016c,
	0x016c, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d,
	0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d, 0x016d,
	0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e,
	0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e, 0x016e,
	0x016e, 0x016e, 0x016e, 0x016f, 0x016f, 0x016f, 0x016f, 0x016f,
	// Entry 2C0 - 2FF
	0x016f, 0x016f, 0x016f, 0x016f, 0x016f, 0x0177, 0x0177,
}

// Size: 1524 bytes, 375 elements
var narrowSymIndex = []curToIndex{
	{cur: 0x9, idx: 0x1},
	{cur: 0x11, idx: 0x4},
	{cur: 0x13, idx: 0x4},
	{cur: 0x18, idx: 0x9},
	{cur: 0x1a, idx: 0x4},
	{cur: 0x1b, idx: 0xc},
	{cur: 0x25, idx: 0x4},
	{cur: 0x26, idx: 0x4},
	{cur: 0x27, idx: 0x10},
	{cur: 0x2e, idx: 0x13},
	{cur: 0x32, idx: 0x4},
	{cur: 0x35, idx: 0x16},
	{cur: 0x37, idx: 0x18},
	{cur: 0x38, idx: 0x4},
	{cur: 0x39, idx: 0x4},
	{cur: 0x40, idx: 0x4},
	{cur: 0x42, idx: 0x25},
	{cur: 0x43, idx: 0x4},
	{cur: 0x45, idx: 0x28},
	{cur: 0x48, idx: 0x4},
	{cur: 0x49, idx: 0x4},
	{cur: 0x4c, idx: 0x2c},
	{cur: 0x50, idx: 0x30},
	{cur: 0x51, idx: 0x4},
	{cur: 0x56, idx: 0x33},
	{cur: 0x5a, idx: 0x37},
	{cur: 0x5c, idx: 0x3b},
	{cur: 0x5e, idx: 0x4},
	{cur: 0x5f, idx: 0x3f},
	{cur: 0x61, idx: 0x3f},
	{cur: 0x66, idx: 0x3f},
	{cur: 0x68, idx: 0x42},
	{cur: 0x6c, idx: 0x45},
	{cur: 0x6f, idx: 0x4},
	{cur: 0x70, idx: 0x4},
	{cur: 0x71, idx: 0x4b},
	{cur: 0x73, idx: 0x4d},
	{cur: 0x75, idx: 0x50},
	{cur: 0x76, idx: 0x53},
	{cur: 0x7a, idx: 0x56},
	{cur: 0x7b, idx: 0x5a},
	{cur: 0x7f, idx: 0x30},
	{cur: 0x81, idx: 0x4},
	{cur: 0x83, idx: 0x25},
	{cur: 0x86, idx: 0x63},
	{cur: 0x87, idx: 0x67},
	{cur: 0x88, idx: 0x6a},
	{cur: 0x8b, idx: 0x6a},
	{cur: 0x8d, idx: 0x4},
	{cur: 0x8e, idx: 0x6e},
	{cur: 0x8f, idx: 0x72},
	{cur: 0x90, idx: 0x76},
	{cur: 0x91, idx: 0x7a},
	{cur: 0x92, idx: 0x4},
	{cur: 0x94, idx: 0x7d},
	{cur: 0x99, idx: 0x80},
	{cur: 0xa1, idx: 0x83},
	{cur: 0xa6, idx: 0x86},
	{cur: 0xa7, idx: 0x88},
	{cur: 0xac, idx: 0x7a},
	{cur: 0xb0, idx: 0x4},
	{cur: 0xb3, idx: 0x90},
	{cur: 0xb7, idx: 0x4},
	{cur: 0xb8, idx: 0x93},
	{cur: 0xba, idx: 0x97},
	{cur: 0xbc, idx: 0x30},
	{cur: 0xbd, idx: 0x7a},
	{cur: 0xbe, idx: 0x4},
	{cur: 0xc5, idx: 0x9e},
	{cur: 0xc6, idx: 0x7a},
	{cur: 0xc7, idx: 0xa2},
	{cur: 0xca, idx: 0xa6},
	{cur: 0xd0, idx: 0xaa},
	{cur: 0xd1, idx: 0x18},
	{cur: 0xd2, idx: 0xae},
	{cur: 0xd4, idx: 0x4},
	{cur: 0xd9, idx: 0x30},
	{cur: 0xda, idx: 0x4},
	{cur: 0xdb, idx: 0x3f},
	{cur: 0xe0, idx: 0x4},
	{cur: 0xe2, idx: 0x3f},
	{cur: 0xe3, idx: 0xb1},
	{cur: 0xe6, idx: 0x3f},
	{cur: 0xe8, idx: 0xb4},
	{cur: 0xee, idx: 0xb8},
	{cur: 0xf1, idx: 0xbb},
	{cur: 0xf2, idx: 0x4},
	{cur: 0xf3, idx: 0x4},
	{cur: 0xf5, idx: 0xc3},
	{cur: 0xf9, idx: 0x4},
	{cur: 0xfe, idx: 0x4},
	{cur: 0x101, idx: 0x10},
	{cur: 0x102, idx: 0xcb},
	{cur: 0x10d, idx: 0x4},
	{cur: 0x122, idx: 0xe1},
	{cur: 0x124, idx: 0xe3},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x11, idx: 0x105},
	{cur: 0x13, idx: 0xec},
	{cur: 0x1a, idx: 0x109},
	{cur: 0x25, idx: 0x117},
	{cur: 0x26, idx: 0x11b},
	{cur: 0x32, idx: 0x11f},
	{cur: 0x38, idx: 0x123},
	{cur: 0x39, idx: 0x1c},
	{cur: 0x40, idx: 0x127},
	{cur: 0x42, idx: 0x20},
	{cur: 0x43, idx: 0x12b},
	{cur: 0x49, idx: 0x12f},
	{cur: 0x51, idx: 0x133},
	{cur: 0x5e, idx: 0x14b},
	{cur: 0x61, idx: 0x14f},
	{cur: 0x6f, idx: 0x154},
	{cur: 0x70, idx: 0x47},
	{cur: 0x81, idx: 0x172},
	{cur: 0x83, idx: 0x5e},
	{cur: 0x8d, idx: 0x197},
	{cur: 0xb0, idx: 0x8c},
	{cur: 0xbe, idx: 0x9a},
	{cur: 0xd4, idx: 0x1e8},
	{cur: 0xe0, idx: 0x1fd},
	{cur: 0xe2, idx: 0x201},
	{cur: 0xf2, idx: 0x226},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf9, idx: 0xc7},
	{cur: 0xfe, idx: 0x22a},
	{cur: 0x26, idx: 0x4},
	{cur: 0x37, idx: 0x0},
	{cur: 0x50, idx: 0x0},
	{cur: 0x73, idx: 0x0},
	{cur: 0x7f, idx: 0x0},
	{cur: 0xbc, idx: 0x0},
	{cur: 0xc7, idx: 0x0},
	{cur: 0xd1, idx: 0x0},
	{cur: 0xd9, idx: 0x0},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xe6, idx: 0x24f},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x13, idx: 0x6},
	{cur: 0x1a, idx: 0x253},
	{cur: 0x25, idx: 0x258},
	{cur: 0x32, idx: 0x25c},
	{cur: 0x38, idx: 0x123},
	{cur: 0x39, idx: 0x1c},
	{cur: 0x48, idx: 0x25f},
	{cur: 0x49, idx: 0x264},
	{cur: 0x51, idx: 0x268},
	{cur: 0x5e, idx: 0x14b},
	{cur: 0x5f, idx: 0x26c},
	{cur: 0x6f, idx: 0x271},
	{cur: 0x7f, idx: 0x274},
	{cur: 0x81, idx: 0x279},
	{cur: 0x8d, idx: 0x27c},
	{cur: 0x92, idx: 0x280},
	{cur: 0xb0, idx: 0x8c},
	{cur: 0xb7, idx: 0x283},
	{cur: 0xbe, idx: 0x9a},
	{cur: 0xd0, idx: 0x286},
	{cur: 0xd4, idx: 0x28e},
	{cur: 0xda, idx: 0x292},
	{cur: 0xf2, idx: 0x226},
	{cur: 0xfe, idx: 0x295},
	{cur: 0x10d, idx: 0xd4},
	{cur: 0x11, idx: 0x0},
	{cur: 0x13, idx: 0x0},
	{cur: 0x1a, idx: 0x0},
	{cur: 0x1b, idx: 0x0},
	{cur: 0x25, idx: 0x0},
	{cur: 0x26, idx: 0x0},
	{cur: 0x2e, idx: 0x0},
	{cur: 0x32, idx: 0x0},
	{cur: 0x37, idx: 0x0},
	{cur: 0x38, idx: 0x0},
	{cur: 0x39, idx: 0x0},
	{cur: 0x40, idx: 0x0},
	{cur: 0x42, idx: 0x0},
	{cur: 0x43, idx: 0x0},
	{cur: 0x45, idx: 0x0},
	{cur: 0x49, idx: 0x0},
	{cur: 0x51, idx: 0x0},
	{cur: 0x5e, idx: 0x0},
	{cur: 0x66, idx: 0x0},
	{cur: 0x6f, idx: 0x0},
	{cur: 0x70, idx: 0x0},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x81, idx: 0x0},
	{cur: 0x86, idx: 0x0},
	{cur: 0x8b, idx: 0x0},
	{cur: 0x8d, idx: 0x0},
	{cur: 0x8e, idx: 0x0},
	{cur: 0x8f, idx: 0x0},
	{cur: 0x92, idx: 0x0},
	{cur: 0xa7, idx: 0x0},
	{cur: 0xb0, idx: 0x0},
	{cur: 0xb7, idx: 0x0},
	{cur: 0xb8, idx: 0x0},
	{cur: 0xbe, idx: 0x0},
	{cur: 0xc5, idx: 0x0},
	{cur: 0xca, idx: 0x0},
	{cur: 0xd4, idx: 0x0},
	{cur: 0xda, idx: 0x0},
	{cur: 0xe0, idx: 0x0},
	{cur: 0xe2, idx: 0x0},
	{cur: 0xf1, idx: 0x0},
	{cur: 0xf2, idx: 0x0},
	{cur: 0xf3, idx: 0x0},
	{cur: 0xf5, idx: 0x0},
	{cur: 0xfe, idx: 0x0},
	{cur: 0x102, idx: 0x0},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x56, idx: 0x2ac},
	{cur: 0x90, idx: 0x2bc},
	{cur: 0xee, idx: 0x2c5},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x9, idx: 0x0},
	{cur: 0x27, idx: 0x0},
	{cur: 0x50, idx: 0x0},
	{cur: 0x6c, idx: 0x0},
	{cur: 0x71, idx: 0x0},
	{cur: 0x7f, idx: 0x0},
	{cur: 0xbc, idx: 0x0},
	{cur: 0xd9, idx: 0x0},
	{cur: 0xe3, idx: 0x0},
	{cur: 0x101, idx: 0x0},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x1b, idx: 0x2fe},
	{cur: 0x35, idx: 0x0},
	{cur: 0x70, idx: 0x47},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x122, idx: 0x0},
	{cur: 0x124, idx: 0x0},
	{cur: 0x50, idx: 0x301},
	{cur: 0x7f, idx: 0x301},
	{cur: 0xbc, idx: 0x301},
	{cur: 0xd9, idx: 0x301},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x48, idx: 0x315},
	{cur: 0x5f, idx: 0x31d},
	{cur: 0x68, idx: 0x322},
	{cur: 0x87, idx: 0x327},
	{cur: 0xd2, idx: 0x32a},
	{cur: 0xe6, idx: 0x0},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x124, idx: 0x86},
	{cur: 0x5c, idx: 0x0},
	{cur: 0x1b, idx: 0x346},
	{cur: 0x27, idx: 0x349},
	{cur: 0x49, idx: 0x9e},
	{cur: 0x56, idx: 0x3f},
	{cur: 0x7f, idx: 0x34c},
	{cur: 0x90, idx: 0x34f},
	{cur: 0xca, idx: 0x355},
	{cur: 0xd9, idx: 0x34c},
	{cur: 0xfe, idx: 0x295},
	{cur: 0x56, idx: 0x0},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x56, idx: 0x33},
	{cur: 0x101, idx: 0x37e},
	{cur: 0x11, idx: 0x389},
	{cur: 0x37, idx: 0x391},
	{cur: 0x51, idx: 0x268},
	{cur: 0xf1, idx: 0x394},
	{cur: 0x101, idx: 0x3a3},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xfe, idx: 0x295},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x56, idx: 0x3f6},
	{cur: 0x87, idx: 0x327},
	{cur: 0x90, idx: 0x2bc},
	{cur: 0xba, idx: 0x42b},
	{cur: 0xd2, idx: 0x432},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x124, idx: 0x452},
	{cur: 0x87, idx: 0x67},
	{cur: 0xba, idx: 0x97},
	{cur: 0x124, idx: 0xe3},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x2e, idx: 0x47e},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xac, idx: 0x48a},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xac, idx: 0x499},
	{cur: 0xc6, idx: 0x499},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x27, idx: 0x349},
	{cur: 0x37, idx: 0x391},
	{cur: 0x48, idx: 0x25f},
	{cur: 0x56, idx: 0x3f6},
	{cur: 0xbc, idx: 0x4a0},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x42, idx: 0x4a8},
	{cur: 0x83, idx: 0x4a8},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x25, idx: 0x258},
	{cur: 0x32, idx: 0x25c},
	{cur: 0x38, idx: 0x123},
	{cur: 0x39, idx: 0x97},
	{cur: 0x51, idx: 0x268},
	{cur: 0x56, idx: 0x4bb},
	{cur: 0x70, idx: 0x47},
	{cur: 0x73, idx: 0x4be},
	{cur: 0x81, idx: 0x279},
	{cur: 0xf2, idx: 0x226},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x1b, idx: 0x0},
	{cur: 0x37, idx: 0x391},
	{cur: 0x7a, idx: 0x0},
	{cur: 0x7b, idx: 0x0},
	{cur: 0x86, idx: 0x0},
	{cur: 0x8f, idx: 0x0},
	{cur: 0xa7, idx: 0x0},
	{cur: 0xc7, idx: 0x4c8},
	{cur: 0xca, idx: 0x355},
	{cur: 0xd0, idx: 0x4cb},
	{cur: 0x102, idx: 0x0},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x38, idx: 0x4d9},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x91, idx: 0x533},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xd0, idx: 0x565},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x37, idx: 0x56c},
	{cur: 0xd0, idx: 0x56f},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x5a, idx: 0x0},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0xf3, idx: 0xbf},
	{cur: 0x37, idx: 0x5af},
	{cur: 0x50, idx: 0x34c},
	{cur: 0x73, idx: 0x4be},
	{cur: 0x7f, idx: 0x34c},
	{cur: 0xbc, idx: 0x34c},
	{cur: 0xc7, idx: 0x5b2},
	{cur: 0xd9, idx: 0x34c},
	{cur: 0xf3, idx: 0xbf},
}

// Total table size 12082 bytes (11KiB); checksum: 359B8A24
