/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.interceptor;

import alt.jiapi.InstrumentationDescriptor;
import alt.jiapi.event.EventProducer;
import alt.jiapi.interceptor.FieldHandler;
import alt.jiapi.interceptor.FieldInstrumentor;
import java.lang.reflect.Field;
import java.util.HashMap;

public class FieldInterceptor2
extends EventProducer {
    private FieldHandler handler;
    private HashMap rfCache = new HashMap();

    public FieldInterceptor2(InstrumentationDescriptor id, FieldHandler handler) {
        this(id, "*", handler);
    }

    public FieldInterceptor2(InstrumentationDescriptor id, String resolution, FieldHandler handler) {
        this(id, new String[]{resolution}, handler);
    }

    public FieldInterceptor2(InstrumentationDescriptor id, String[] resolutions, FieldHandler handler) {
        super(resolutions);
        this.handler = handler;
        id.addInstrumentor(new FieldInstrumentor(this, handler));
    }

    public void setField(Object o, String name, Object value) throws Throwable {
        try {
            Field f = null;
            Class<?> c = null;
            c = o instanceof Class ? (Class<?>)o : o.getClass();
            f = this.getReflectionField(c, name);
            this.handler.setField(o, f, value);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    public Object getField(Object o, String name) throws Throwable {
        try {
            Field f = null;
            Class<?> c = null;
            c = o instanceof Class ? (Class<?>)o : o.getClass();
            f = this.getReflectionField(c, name);
            Object r = this.handler.getField(o, f);
            return r;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    private Field getReflectionField(Class c, String name) {
        Field f = null;
        f = (Field)this.rfCache.get(name);
        if (f != null) {
            return f;
        }
        String fName = name.substring(name.lastIndexOf(46) + 1);
        try {
            f = c.getDeclaredField(fName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rfCache.put(name, f);
        return f;
    }
}

