/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;

public class DoubleStroke
implements Stroke {
    private BasicStroke outlineStroke;
    private float innerWidth;
    private float outlineWidth;
    private double miterLimit;
    private float[] dashes;
    private float dashPhase;

    public DoubleStroke(float f, float f2) {
        this(f, f2, 2, 2, 10.0f, null, 0.0f);
    }

    public DoubleStroke(float f, float f2, int n, int n2, float f3, float[] fArray, float f4) {
        this.innerWidth = f;
        this.outlineWidth = f2;
        this.miterLimit = f3;
        this.outlineStroke = new BasicStroke(f2, n, 2, f3, fArray, f4);
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        BezierPath bezierPath = new BezierPath();
        GeneralPath generalPath = new GeneralPath();
        GeneralPath generalPath2 = new GeneralPath();
        double[] dArray = new double[6];
        PathIterator pathIterator = shape.getPathIterator(null, 0.1);
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 0: {
                    if (bezierPath.size() != 0) {
                        this.traceStroke(bezierPath, generalPath, generalPath2);
                    }
                    bezierPath.clear();
                    bezierPath.setClosed(false);
                    bezierPath.moveTo(dArray[0], dArray[1]);
                    break;
                }
                case 1: {
                    if (dArray[0] == ((BezierPath.Node)bezierPath.get((int)(bezierPath.size() - 1))).x[0] && dArray[1] == ((BezierPath.Node)bezierPath.get((int)(bezierPath.size() - 1))).y[0]) break;
                    bezierPath.lineTo(dArray[0], dArray[1]);
                    break;
                }
                case 2: {
                    bezierPath.quadTo(dArray[0], dArray[1], dArray[2], dArray[3]);
                    break;
                }
                case 3: {
                    bezierPath.curveTo(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                    break;
                }
                case 4: {
                    bezierPath.setClosed(true);
                }
            }
            pathIterator.next();
        }
        if (bezierPath.size() != 0) {
            this.traceStroke(bezierPath, generalPath, generalPath2);
        }
        generalPath2.append(generalPath, false);
        return this.outlineStroke.createStrokedShape(generalPath2);
    }

    protected void traceStroke(BezierPath bezierPath, GeneralPath generalPath, GeneralPath generalPath2) {
        Point2D.Double double_;
        Object object;
        int n;
        BezierPath.Node node;
        double[] dArray = new double[8];
        double[] dArray2 = new double[8];
        if (bezierPath.isClosed()) {
            node = (BezierPath.Node)bezierPath.get(bezierPath.size() - 1);
            for (n = 0; n < bezierPath.size(); ++n) {
                object = (BezierPath.Node)bezierPath.get(n);
                if (node.x[0] == ((BezierPath.Node)object).x[0] && node.y[0] == ((BezierPath.Node)object).y[0]) {
                    bezierPath.remove(n--);
                    continue;
                }
                node = object;
            }
        } else {
            node = (BezierPath.Node)bezierPath.get(0);
            for (n = 1; n < bezierPath.size(); ++n) {
                object = (BezierPath.Node)bezierPath.get(n);
                if (node.x[0] == ((BezierPath.Node)object).x[0] && node.y[0] == ((BezierPath.Node)object).y[0]) {
                    bezierPath.remove(n--);
                    continue;
                }
                node = object;
            }
        }
        if (bezierPath.isClosed() && bezierPath.size() > 1) {
            double_ = Geom.intersect((dArray2 = this.computeThickLine(((BezierPath.Node)bezierPath.get((int)(bezierPath.size() - 1))).x[0], ((BezierPath.Node)bezierPath.get((int)(bezierPath.size() - 1))).y[0], ((BezierPath.Node)bezierPath.get((int)0)).x[0], ((BezierPath.Node)bezierPath.get((int)0)).y[0], this.innerWidth, dArray2))[0], dArray2[1], dArray2[4], dArray2[5], (dArray = this.computeThickLine(((BezierPath.Node)bezierPath.get((int)0)).x[0], ((BezierPath.Node)bezierPath.get((int)0)).y[0], ((BezierPath.Node)bezierPath.get((int)1)).x[0], ((BezierPath.Node)bezierPath.get((int)1)).y[0], this.innerWidth, dArray))[0], dArray[1], dArray[4], dArray[5], this.miterLimit);
            if (double_ != null) {
                generalPath2.moveTo((float)double_.x, (float)double_.y);
            } else {
                generalPath2.moveTo((float)dArray2[4], (float)dArray2[5]);
                generalPath2.lineTo((float)dArray[0], (float)dArray[1]);
            }
            double_ = Geom.intersect(dArray2[2], dArray2[3], dArray2[6], dArray2[7], dArray[2], dArray[3], dArray[6], dArray[7], this.miterLimit);
            if (double_ != null) {
                generalPath.moveTo((float)double_.x, (float)double_.y);
            } else {
                generalPath.moveTo((float)dArray2[6], (float)dArray2[7]);
                generalPath.lineTo((float)dArray[2], (float)dArray[3]);
            }
        } else if (bezierPath.size() > 1) {
            dArray = this.computeThickLine(((BezierPath.Node)bezierPath.get((int)0)).x[0], ((BezierPath.Node)bezierPath.get((int)0)).y[0], ((BezierPath.Node)bezierPath.get((int)1)).x[0], ((BezierPath.Node)bezierPath.get((int)1)).y[0], this.innerWidth, dArray);
            generalPath2.moveTo((float)dArray[0], (float)dArray[1]);
            generalPath.moveTo((float)dArray[2], (float)dArray[3]);
        }
        n = bezierPath.size() - 1;
        for (int i = 1; i < n; ++i) {
            dArray2 = dArray;
            object = dArray2;
            double_ = Geom.intersect(dArray2[0], dArray2[1], dArray2[4], dArray2[5], (dArray = this.computeThickLine(((BezierPath.Node)bezierPath.get((int)i)).x[0], ((BezierPath.Node)bezierPath.get((int)i)).y[0], ((BezierPath.Node)bezierPath.get((int)(i + 1))).x[0], ((BezierPath.Node)bezierPath.get((int)(i + 1))).y[0], this.innerWidth, (double[])object))[0], dArray[1], dArray[4], dArray[5], this.miterLimit);
            if (double_ != null) {
                generalPath2.lineTo((float)double_.x, (float)double_.y);
            } else {
                generalPath2.lineTo((float)dArray2[4], (float)dArray2[5]);
                generalPath2.lineTo((float)dArray[0], (float)dArray[1]);
            }
            double_ = Geom.intersect(dArray2[2], dArray2[3], dArray2[6], dArray2[7], dArray[2], dArray[3], dArray[6], dArray[7], this.miterLimit);
            if (double_ != null) {
                generalPath.lineTo((float)double_.x, (float)double_.y);
                continue;
            }
            generalPath.lineTo((float)dArray2[6], (float)dArray2[7]);
            generalPath.lineTo((float)dArray[2], (float)dArray[3]);
        }
        if (bezierPath.isClosed() && bezierPath.size() > 0) {
            dArray2 = dArray;
            double[] dArray3 = dArray2;
            double_ = Geom.intersect(dArray2[0], dArray2[1], dArray2[4], dArray2[5], (dArray = this.computeThickLine(((BezierPath.Node)bezierPath.get((int)(bezierPath.size() - 1))).x[0], ((BezierPath.Node)bezierPath.get((int)(bezierPath.size() - 1))).y[0], ((BezierPath.Node)bezierPath.get((int)0)).x[0], ((BezierPath.Node)bezierPath.get((int)0)).y[0], this.innerWidth, dArray3))[0], dArray[1], dArray[4], dArray[5], this.miterLimit);
            if (double_ != null) {
                generalPath2.lineTo((float)double_.x, (float)double_.y);
            } else {
                generalPath2.lineTo((float)dArray2[4], (float)dArray2[5]);
                generalPath2.lineTo((float)dArray[0], (float)dArray[1]);
            }
            double_ = Geom.intersect(dArray2[2], dArray2[3], dArray2[6], dArray2[7], dArray[2], dArray[3], dArray[6], dArray[7], this.miterLimit);
            if (double_ != null) {
                generalPath.lineTo((float)double_.x, (float)double_.y);
            } else {
                generalPath.lineTo((float)dArray2[6], (float)dArray2[7]);
                generalPath.lineTo((float)dArray[2], (float)dArray[3]);
            }
            generalPath2.closePath();
            generalPath.closePath();
        } else if (bezierPath.size() > 1) {
            generalPath2.lineTo((float)dArray[4], (float)dArray[5]);
            generalPath.lineTo((float)dArray[6], (float)dArray[7]);
        }
    }

    private double[] computeThickLine(double[] dArray, int n, double[] dArray2) {
        return this.computeThickLine(dArray[0 + n], dArray[1 + n], dArray[2 + n], dArray[3 + n], this.innerWidth, dArray2);
    }

    private double[] computeThickLine(double d, double d2, double d3, double d4, double d5, double[] dArray) {
        double d6 = d3 - d;
        double d7 = d4 - d2;
        double d8 = Math.sqrt(d6 * d6 + d7 * d7);
        double d9 = d5 / (2.0 * d8);
        double d10 = -d9 * d7;
        double d11 = d9 * d6;
        dArray[0] = d + d10;
        dArray[1] = d2 + d11;
        dArray[2] = d - d10;
        dArray[3] = d2 - d11;
        dArray[4] = d3 + d10;
        dArray[5] = d4 + d11;
        dArray[6] = d3 - d10;
        dArray[7] = d4 - d11;
        return dArray;
    }
}

