An attempt was made to retrieve an associated type, but the type was ambiguous.

Erroneous code example:

```compile_fail,E0223
trait Trait { type X; }

fn main() {
    let foo: Trait::X;
}
```

The problem here is that we're attempting to take the associated type of `X`
from `Trait`. Unfortunately, the type of `X` is not defined, because it's only
made concrete in implementations of the trait. A working version of this code
might look like:

```
trait Trait { type X; }

struct Struct;
impl Trait for Struct {
    type X = u32;
}

fn main() {
    let foo: <Struct as Trait>::X;
}
```

This syntax specifies that we want the associated type `X` from `Struct`'s
implementation of `Trait`.

Due to internal limitations of the current compiler implementation we cannot
simply use `Struct::X`.
