#! /usr/bin/python3
# -*- coding: utf-8 -*-
from gi.repository import Unity
from unittest import TestCase
import imp


class ResultSet(Unity.ResultSet):
    def __init__(self):
        Unity.ResultSet.__init__(self)
        self.results = []

    def do_add_result(self, result):
        self.results.append({'uri': result.uri,
                             'title': result.title,
                             'comment': result.comment,
                             'icon': result.icon_hint,
                             'likes': result.metadata['likes'].get_string(),
                             'cuisine': result.metadata['cuisine'].get_string(),
                             'cooktime': result.metadata['cooktime'].get_string(),
                             'preptime': result.metadata['preptime'].get_string(),
                             'ingredients': result.metadata['ingredients'].get_string(),
                             'yields': result.metadata['yields'].get_string(),
                             'instructions': result.metadata['instructions'].get_string()})


class ScopeTestCase(TestCase):
    def init_scope(self, scope_path):
        self.scope_module = imp.load_source('scope', scope_path)
        self.scope = self.scope_module.load_scope()

    def perform_query(self, query, filter_set=Unity.FilterSet.new()):
        result_set = ResultSet()
        ctx = Unity.SearchContext.create(query, 0, filter_set,
                                         None, result_set, None)
        s = self.scope.create_search_for_query(ctx)
        s.run()
        return result_set


class TestGourmet(ScopeTestCase):
    def setUp(self):
        self.init_scope('src/unity_gourmet_daemon.py')

    def tearDown(self):
        self.scope = None
        self.scope_module = None

    def test_search(self):
        self.scope_module.GOURMET_DB = 'tests/data/mock_gourmet_pass.db'
        expected_results = ['http://www.ubuntu.com',
                            'Ubuntu Burgers',
                            '★★★✮☆',
                            'Cook them like you mean it',
                            'Burger',
                            '15 minutes',
                            '30 minutes',
                            '500 g Minced Beef',
                            '1 Burger']
        results = []
        for s in ['burger']:
            result_set = self.perform_query(s)
            results.append(result_set.results[0]['uri'])
            results.append(result_set.results[0]['title'])
            results.append(result_set.results[0]['likes'])
            results.append(result_set.results[0]['instructions'])
            results.append(result_set.results[0]['cuisine'])
            results.append(result_set.results[0]['cooktime'])
            results.append(result_set.results[0]['preptime'])
            results.append(result_set.results[0]['ingredients'])
            results.append(result_set.results[0]['yields'])
        self.assertEqual(results, expected_results)

    def test_failing_search(self):
        self.scope_module.GOURMET_DB = 'tests/data/mock_gourmet_fail'
        for s in ['upnriitnyt']:
            result_set = self.perform_query(s)
            self.assertEqual(len(result_set.results), 0)

    def test_activation(self):
        result = Unity.ScopeResult()
        result.uri = 'http://www.ubuntu.com'
        self.scope_module.GOURMET_EXECUTABLE = 'tests/fake-gourmet.py'
        activation = self.scope.activate(result, Unity.SearchMetadata(), None)
        self.assertEqual(activation.props.goto_uri, None)
        self.assertEqual(activation.props.handled, Unity.HandledType.HIDE_DASH)

if __name__ == '__main__':
    unittest.main()
