/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Style;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.layout.client.Layout;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.AnimatedLayout;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.InsertPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.LayoutCommand;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.ui.WidgetCollection;

public class DeckLayoutPanel
extends ComplexPanel
implements AnimatedLayout,
RequiresResize,
ProvidesResize,
InsertPanel.ForIsWidget,
AcceptsOneWidget {
    private int animationDuration = 0;
    private boolean isAnimationVertical;
    private Widget hidingWidget;
    private Widget lastVisibleWidget;
    private final Layout layout;
    private final LayoutCommand layoutCmd;
    private Widget visibleWidget;

    public DeckLayoutPanel() {
        this.setElement(Document.get().createDivElement());
        this.layout = new Layout(this.getElement());
        this.layoutCmd = new DeckAnimateCommand(this.layout);
    }

    public void add(Widget w) {
        this.insert(w, this.getWidgetCount());
    }

    public void animate(int duration) {
        this.animate(duration, null);
    }

    public void animate(int duration, Layout.AnimationCallback callback) {
        this.layoutCmd.schedule(duration, callback);
    }

    public void forceLayout() {
        this.layoutCmd.cancel();
        this.doBeforeLayout();
        this.layout.layout();
        this.doAfterLayout();
        this.onResize();
    }

    public int getAnimationDuration() {
        return this.animationDuration;
    }

    public Widget getVisibleWidget() {
        return this.visibleWidget;
    }

    public int getVisibleWidgetIndex() {
        return this.getWidgetIndex(this.visibleWidget);
    }

    public void insert(IsWidget w, int beforeIndex) {
        this.insert(DeckLayoutPanel.asWidgetOrNull(w), beforeIndex);
    }

    public void insert(Widget widget, int beforeIndex) {
        Widget before = beforeIndex < this.getWidgetCount() ? this.getWidget(beforeIndex) : null;
        this.insert(widget, before);
    }

    public void insert(Widget widget, Widget before) {
        this.assertIsChild(before);
        widget.removeFromParent();
        WidgetCollection children = this.getChildren();
        if (before == null) {
            children.add(widget);
        } else {
            int index = children.indexOf(before);
            children.insert(widget, index);
        }
        Layout.Layer layer = this.layout.attachChild(widget.getElement(), before != null ? before.getElement() : null, widget);
        this.setWidgetVisible(widget, layer, false);
        widget.setLayoutData(layer);
        this.adopt(widget);
        this.animate(0);
    }

    public boolean isAnimationVertical() {
        return this.isAnimationVertical;
    }

    public void onResize() {
        for (Widget child : this.getChildren()) {
            if (!(child instanceof RequiresResize)) continue;
            ((RequiresResize)((Object)child)).onResize();
        }
    }

    public boolean remove(Widget w) {
        boolean removed = super.remove(w);
        if (removed) {
            Layout.Layer layer = (Layout.Layer)w.getLayoutData();
            this.layout.removeChild(layer);
            w.setLayoutData(null);
            if (this.visibleWidget == w) {
                this.visibleWidget = null;
            }
            if (this.hidingWidget == w) {
                this.hidingWidget = null;
            }
            if (this.lastVisibleWidget == w) {
                this.lastVisibleWidget = null;
            }
        }
        return removed;
    }

    public void setAnimationDuration(int duration) {
        this.animationDuration = duration;
    }

    public void setAnimationVertical(boolean isVertical) {
        this.isAnimationVertical = isVertical;
    }

    public void setWidget(IsWidget w) {
        if (w == null) {
            this.showWidget(null);
            return;
        }
        if (w.asWidget().getParent() != this) {
            this.add(w);
        }
        this.showWidget(w.asWidget());
    }

    public void showWidget(int index) {
        this.checkIndexBoundsForAccess(index);
        this.showWidget(this.getWidget(index));
    }

    public void showWidget(Widget widget) {
        if (widget == this.visibleWidget) {
            return;
        }
        this.assertIsChild(widget);
        this.visibleWidget = widget;
        this.animate(widget == null ? 0 : this.animationDuration);
    }

    void assertIsChild(Widget widget) {
        assert (widget == null || widget.getParent() == this) : "The specified widget is not a child of this panel";
    }

    private void doAfterLayout() {
        if (this.hidingWidget != null) {
            Layout.Layer layer = (Layout.Layer)this.hidingWidget.getLayoutData();
            this.setWidgetVisible(this.hidingWidget, layer, false);
            this.layout.layout();
            this.hidingWidget = null;
        }
    }

    private void doBeforeLayout() {
        double vDirection;
        Layout.Layer oldLayer = this.lastVisibleWidget == null ? null : (Layout.Layer)this.lastVisibleWidget.getLayoutData();
        Layout.Layer newLayer = this.visibleWidget == null ? null : (Layout.Layer)this.visibleWidget.getLayoutData();
        int oldIndex = this.getWidgetIndex(this.lastVisibleWidget);
        int newIndex = this.getWidgetIndex(this.visibleWidget);
        double direction = oldIndex < newIndex ? 100.0 : -100.0;
        double d = vDirection = this.isAnimationVertical ? direction : 0.0;
        double hDirection = this.isAnimationVertical ? 0.0 : (LocaleInfo.getCurrentLocale().isRTL() ? -direction : direction);
        this.hidingWidget = null;
        if (this.visibleWidget != this.lastVisibleWidget) {
            if (oldLayer != null) {
                oldLayer.setTopHeight(0.0, Style.Unit.PCT, 100.0, Style.Unit.PCT);
                oldLayer.setLeftWidth(0.0, Style.Unit.PCT, 100.0, Style.Unit.PCT);
                this.setWidgetVisible(this.lastVisibleWidget, oldLayer, true);
            }
            if (newLayer != null) {
                newLayer.setTopHeight(vDirection, Style.Unit.PCT, 100.0, Style.Unit.PCT);
                newLayer.setLeftWidth(hDirection, Style.Unit.PCT, 100.0, Style.Unit.PCT);
                this.setWidgetVisible(this.visibleWidget, newLayer, true);
            }
            this.layout.layout();
            this.hidingWidget = this.lastVisibleWidget;
        }
        if (oldLayer != null) {
            oldLayer.setTopHeight(-vDirection, Style.Unit.PCT, 100.0, Style.Unit.PCT);
            oldLayer.setLeftWidth(-hDirection, Style.Unit.PCT, 100.0, Style.Unit.PCT);
            this.setWidgetVisible(this.lastVisibleWidget, oldLayer, true);
        }
        if (newLayer != null) {
            newLayer.setTopHeight(0.0, Style.Unit.PCT, 100.0, Style.Unit.PCT);
            newLayer.setLeftWidth(0.0, Style.Unit.PCT, 100.0, Style.Unit.PCT);
            this.setWidgetVisible(this.visibleWidget, newLayer, true);
        }
        this.lastVisibleWidget = this.visibleWidget;
    }

    private void setWidgetVisible(Widget w, Layout.Layer layer, boolean visible) {
        layer.setVisible(visible);
        w.setVisible(visible);
    }

    private class DeckAnimateCommand
    extends LayoutCommand {
        public DeckAnimateCommand(Layout layout) {
            super(layout);
        }

        public void schedule(int duration, final Layout.AnimationCallback callback) {
            super.schedule(duration, new Layout.AnimationCallback(){

                public void onAnimationComplete() {
                    DeckLayoutPanel.this.doAfterLayout();
                    if (callback != null) {
                        callback.onAnimationComplete();
                    }
                }

                public void onLayout(Layout.Layer layer, double progress) {
                    if (callback != null) {
                        callback.onLayout(layer, progress);
                    }
                }
            });
        }

        protected void doBeforeLayout() {
            DeckLayoutPanel.this.doBeforeLayout();
        }
    }
}

