/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateReservedInstancesListingRequest;
import com.amazonaws.services.ec2.model.PriceScheduleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateReservedInstancesListingRequestMarshaller
implements Marshaller<Request<CreateReservedInstancesListingRequest>, CreateReservedInstancesListingRequest> {
    public Request<CreateReservedInstancesListingRequest> marshall(CreateReservedInstancesListingRequest createReservedInstancesListingRequest) {
        if (createReservedInstancesListingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createReservedInstancesListingRequest, "AmazonEC2");
        request.addParameter("Action", "CreateReservedInstancesListing");
        request.addParameter("Version", "2013-10-15");
        if (createReservedInstancesListingRequest.isDryRun() != null) {
            request.addParameter("DryRun", StringUtils.fromBoolean((Boolean)createReservedInstancesListingRequest.isDryRun()));
        }
        if (createReservedInstancesListingRequest.getReservedInstancesId() != null) {
            request.addParameter("ReservedInstancesId", StringUtils.fromString((String)createReservedInstancesListingRequest.getReservedInstancesId()));
        }
        if (createReservedInstancesListingRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)createReservedInstancesListingRequest.getInstanceCount()));
        }
        List<PriceScheduleRequest> priceSchedulesList = createReservedInstancesListingRequest.getPriceSchedules();
        int priceSchedulesListIndex = 1;
        for (PriceScheduleRequest priceSchedulesListValue : priceSchedulesList) {
            PriceScheduleRequest priceScheduleRequestMember = priceSchedulesListValue;
            if (priceScheduleRequestMember != null) {
                if (priceScheduleRequestMember.getTerm() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Term", StringUtils.fromLong((Long)priceScheduleRequestMember.getTerm()));
                }
                if (priceScheduleRequestMember.getPrice() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".Price", StringUtils.fromDouble((Double)priceScheduleRequestMember.getPrice()));
                }
                if (priceScheduleRequestMember.getCurrencyCode() != null) {
                    request.addParameter("PriceSchedules." + priceSchedulesListIndex + ".CurrencyCode", StringUtils.fromString((String)priceScheduleRequestMember.getCurrencyCode()));
                }
            }
            ++priceSchedulesListIndex;
        }
        if (createReservedInstancesListingRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createReservedInstancesListingRequest.getClientToken()));
        }
        return request;
    }
}

