/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auth.identity.cli.model;

import com.amazonaws.services.auth.identity.cli.model.CLIRequest;
import com.amazonaws.services.auth.identity.cli.policy.Effect;
import java.util.List;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UserAddPolicyRequest
extends CLIRequest {
    private static final String NAME = "iam-useraddpolicy";
    private static final String DESCRIPTION = "Adds a policy with no conditions to a user. This will overwrite an existing policy with the same name and entity association. \nExample: Add a policy to User1 to use iam:UpdateUser on all resources. aws-policy add -p User1_Policy s-t User -n User1 -e Allow -a iam:UpdateUser -r *\n For more information about how to construct policies, refer to the AWS Identity and Access Management Developer Guide.";
    @Option(name="-r", usage="the resource in ARN format", required=true, metaVar="AMAZON RESOURCE NAME")
    private List<String> resource_;
    @Option(name="-p", usage="the name of the policy", required=true, metaVar="POLICYNAME")
    private String policyName_;
    @Option(name="-u", usage="the name of the user to associate the policy with", required=true, metaVar="USERNAME")
    private String userName_;
    @Option(name="-e", usage="the effect of the entity, one of {Allow, Deny}", required=true, metaVar="EFFECT")
    private Effect effect_;
    @Option(name="-a", usage="the action to perform on the resource, i.e. s3:put", required=true, metaVar="ACTION")
    private List<String> action_;
    @Option(name="-o", usage="display the resulting policy")
    private boolean isVerbose_ = false;

    public List<String> getResources() {
        return this.resource_;
    }

    public String getPolicyName() {
        return this.policyName_;
    }

    public String getUserName() {
        return this.userName_;
    }

    public Effect getEffect() {
        return this.effect_;
    }

    public List<String> getActions() {
        return this.action_;
    }

    public boolean isVerbose() {
        return this.isVerbose_;
    }

    @Override
    public String getRequestName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PolicyAddRequest [action_=");
        builder.append(this.action_);
        builder.append(", effect_=");
        builder.append((Object)this.effect_);
        builder.append(", isVerbose_=");
        builder.append(this.isVerbose_);
        builder.append(", policyName_=");
        builder.append(this.policyName_);
        builder.append(", resource_=");
        builder.append(this.resource_);
        builder.append(", userName_=");
        builder.append(this.userName_);
        builder.append(", toString()=");
        builder.append(super.toString());
        builder.append("]");
        return builder.toString();
    }
}

