/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.na12878kb.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.CallSet;
import org.broadinstitute.sting.gatk.walkers.na12878kb.core.TruthStatus;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;

public class SiteSelector {
    private static Logger logger = Logger.getLogger(SiteSelector.class);
    final GenomeLocParser parser;
    GenomeLocSortedSet intervals = null;
    final Set<CallSet> setsToInclude = new HashSet<CallSet>();
    final Set<TruthStatus> typesToInclude = new HashSet<TruthStatus>();
    boolean onlyReviewed = false;

    public SiteSelector(GenomeLocParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("GenomeLocParser cannot be null");
        }
        this.parser = parser;
    }

    public SiteSelector addIntervals(GenomeLocSortedSet locs) {
        if (locs == null) {
            throw new IllegalArgumentException("Locs cannot be null");
        }
        for (GenomeLoc loc : locs) {
            this.addInterval(loc);
        }
        return this;
    }

    public SiteSelector addInterval(GenomeLoc loc) {
        if (loc == null) {
            throw new IllegalArgumentException("Loc cannot be null");
        }
        if (this.intervals == null) {
            this.intervals = new GenomeLocSortedSet(this.parser);
        }
        this.intervals.addRegion(loc);
        return this;
    }

    public SiteSelector addInterval(String contig, int start, int stop) {
        return this.addInterval(this.parser.createGenomeLoc(contig, start, stop));
    }

    public SiteSelector addSetToInclude(CallSet set) {
        this.setsToInclude.add(set);
        return this;
    }

    public SiteSelector addTypeToInclude(TruthStatus type) {
        this.typesToInclude.add(type);
        return this;
    }

    public SiteSelector onlyReviewed() {
        this.onlyReviewed = true;
        return this;
    }

    public GenomeLocSortedSet getIntervals() {
        return this.intervals;
    }

    public Set<CallSet> getSetsToInclude() {
        return this.setsToInclude;
    }

    public Set<TruthStatus> getTypesToInclude() {
        return this.typesToInclude;
    }

    public DBObject toQuery() {
        BasicDBObject query;
        LinkedList<BasicDBObject> conditions = new LinkedList<BasicDBObject>();
        if (this.intervals != null) {
            LinkedList<BasicDBObject> regionsToOr = new LinkedList<BasicDBObject>();
            for (GenomeLoc interval : this.intervals.toList()) {
                BasicDBObject StartRange = new BasicDBObject("$gte", (Object)interval.getStart()).append("$lte", (Object)interval.getStop());
                regionsToOr.add(new BasicDBObject("Chr", (Object)interval.getContig()).append("Start", (Object)StartRange));
            }
            conditions.add(new BasicDBObject("$or", regionsToOr));
        }
        if (this.onlyReviewed) {
            conditions.add(new BasicDBObject("Reviewed", (Object)true));
        }
        if (!this.getSetsToInclude().isEmpty()) {
            throw new UnsupportedOperationException("SetsToInclude not yet implemented");
        }
        if (!this.getTypesToInclude().isEmpty()) {
            throw new UnsupportedOperationException("TypesToInclude not yet implemented");
        }
        BasicDBObject basicDBObject = query = conditions.isEmpty() ? new BasicDBObject() : new BasicDBObject("$and", conditions);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Query " + query));
        }
        return query;
    }
}

