/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.recalibration;

import com.google.java.contract.Ensures;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SAMUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.gatk.utils.MathUtils;
import org.broadinstitute.gatk.utils.QualityUtils;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.recalibration.EventType;
import org.broadinstitute.gatk.utils.recalibration.QuantizationInfo;
import org.broadinstitute.gatk.utils.recalibration.ReadCovariates;
import org.broadinstitute.gatk.utils.recalibration.RecalDatum;
import org.broadinstitute.gatk.utils.recalibration.RecalUtils;
import org.broadinstitute.gatk.utils.recalibration.RecalibrationReport;
import org.broadinstitute.gatk.utils.recalibration.RecalibrationTables;
import org.broadinstitute.gatk.utils.recalibration.covariates.Covariate;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public class BaseRecalibration {
    private static Logger logger = Logger.getLogger(BaseRecalibration.class);
    private static final boolean TEST_CACHING = false;
    private final QuantizationInfo quantizationInfo;
    private final RecalibrationTables recalibrationTables;
    private final Covariate[] requestedCovariates;
    private final boolean disableIndelQuals;
    private final int preserveQLessThan;
    private final double globalQScorePrior;
    private final boolean emitOriginalQuals;

    public BaseRecalibration(File RECAL_FILE, int quantizationLevels, boolean disableIndelQuals, int preserveQLessThan, boolean emitOriginalQuals, double globalQScorePrior) {
        RecalibrationReport recalibrationReport = new RecalibrationReport(RECAL_FILE);
        this.recalibrationTables = recalibrationReport.getRecalibrationTables();
        this.requestedCovariates = recalibrationReport.getRequestedCovariates();
        this.quantizationInfo = recalibrationReport.getQuantizationInfo();
        if (quantizationLevels == 0) {
            this.quantizationInfo.noQuantization();
        } else if (quantizationLevels > 0 && quantizationLevels != this.quantizationInfo.getQuantizationLevels()) {
            this.quantizationInfo.quantizeQualityScores(quantizationLevels);
        }
        this.disableIndelQuals = disableIndelQuals;
        this.preserveQLessThan = preserveQLessThan;
        this.globalQScorePrior = globalQScorePrior;
        this.emitOriginalQuals = emitOriginalQuals;
    }

    public void recalibrateRead(GATKSAMRecord read) {
        if (this.emitOriginalQuals && read.getAttribute(SAMTag.OQ.name()) == null) {
            try {
                read.setAttribute(SAMTag.OQ.name(), SAMUtils.phredToFastq((byte[])read.getBaseQualities()));
            }
            catch (IllegalArgumentException e) {
                throw new UserException.MalformedBAM((SAMRecord)read, "illegal base quality encountered; " + e.getMessage());
            }
        }
        ReadCovariates readCovariates = RecalUtils.computeCovariates(read, this.requestedCovariates);
        int readLength = read.getReadLength();
        for (EventType errorModel : EventType.values()) {
            if (this.disableIndelQuals && errorModel != EventType.BASE_SUBSTITUTION) {
                read.setBaseQualities(null, errorModel);
                continue;
            }
            byte[] quals = read.getBaseQualities(errorModel);
            int[][] fullReadKeySet = readCovariates.getKeySet(errorModel);
            int rgKey = fullReadKeySet[0][0];
            RecalDatum empiricalQualRG = this.recalibrationTables.getReadGroupTable().get(rgKey, errorModel.ordinal());
            if (empiricalQualRG != null) {
                double epsilon = this.globalQScorePrior > 0.0 && errorModel.equals((Object)EventType.BASE_SUBSTITUTION) ? this.globalQScorePrior : empiricalQualRG.getEstimatedQReported();
                for (int offset = 0; offset < readLength; ++offset) {
                    byte recalibratedQualityScore;
                    byte origQual = quals[offset];
                    if (origQual < this.preserveQLessThan) continue;
                    int[] keySet = fullReadKeySet[offset];
                    RecalDatum empiricalQualQS = this.recalibrationTables.getQualityScoreTable().get(keySet[0], keySet[1], errorModel.ordinal());
                    ArrayList<RecalDatum> empiricalQualCovs = new ArrayList<RecalDatum>();
                    for (int i = 2; i < this.requestedCovariates.length; ++i) {
                        if (keySet[i] < 0) continue;
                        empiricalQualCovs.add(this.recalibrationTables.getTable(i).get(keySet[0], keySet[1], keySet[i], errorModel.ordinal()));
                    }
                    double recalibratedQualDouble = BaseRecalibration.hierarchicalBayesianQualityEstimate(epsilon, empiricalQualRG, empiricalQualQS, empiricalQualCovs);
                    byte recalibratedQual = QualityUtils.boundQual(MathUtils.fastRound(recalibratedQualDouble), (byte)93);
                    quals[offset] = recalibratedQualityScore = this.quantizationInfo.getQuantizedQuals().get(recalibratedQual).byteValue();
                }
            }
            read.setBaseQualities(quals, errorModel);
        }
    }

    @Ensures(value={"result > 0.0"})
    protected static double hierarchicalBayesianQualityEstimate(double epsilon, RecalDatum empiricalQualRG, RecalDatum empiricalQualQS, List<RecalDatum> empiricalQualCovs) {
        double globalDeltaQ = empiricalQualRG == null ? 0.0 : empiricalQualRG.getEmpiricalQuality(epsilon) - epsilon;
        double deltaQReported = empiricalQualQS == null ? 0.0 : empiricalQualQS.getEmpiricalQuality(globalDeltaQ + epsilon) - (globalDeltaQ + epsilon);
        double deltaQCovariates = 0.0;
        for (RecalDatum empiricalQualCov : empiricalQualCovs) {
            deltaQCovariates += empiricalQualCov == null ? 0.0 : empiricalQualCov.getEmpiricalQuality(deltaQReported + globalDeltaQ + epsilon) - (deltaQReported + globalDeltaQ + epsilon);
        }
        return epsilon + globalDeltaQ + deltaQReported + deltaQCovariates;
    }
}

