/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.DataReaderFactory;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ContainerParser {
    private static final Log log = Log.getInstance(ContainerParser.class);
    private final SAMFileHeader samFileHeader;
    private final Map<String, Long> nanosecondsMap = new TreeMap<String, Long>();

    public ContainerParser(SAMFileHeader samFileHeader) {
        this.samFileHeader = samFileHeader;
    }

    public List<CramCompressionRecord> getRecords(Container container, ArrayList<CramCompressionRecord> records) throws IllegalArgumentException, IllegalAccessException {
        long time1 = System.nanoTime();
        if (records == null) {
            records = new ArrayList(container.nofRecords);
        }
        for (Slice slice : container.slices) {
            records.addAll(this.getRecords(slice, container.header));
        }
        long time2 = System.nanoTime();
        container.parseTime = time2 - time1;
        if (log.isEnabled(Log.LogLevel.DEBUG)) {
            for (String key : this.nanosecondsMap.keySet()) {
                log.debug(String.format("%s: %dms.", key, this.nanosecondsMap.get(key) / 1000000L));
            }
        }
        return records;
    }

    ArrayList<CramCompressionRecord> getRecords(ArrayList<CramCompressionRecord> records, Slice slice, CompressionHeader header) throws IllegalArgumentException, IllegalAccessException {
        String seqName = "*";
        switch (slice.sequenceId) {
            case -2: 
            case -1: {
                break;
            }
            default: {
                SAMSequenceRecord sequence = this.samFileHeader.getSequence(slice.sequenceId);
                seqName = sequence.getSequenceName();
            }
        }
        DataReaderFactory dataReaderFactory = new DataReaderFactory();
        HashMap<Integer, InputStream> inputMap = new HashMap<Integer, InputStream>();
        for (Integer exId : slice.external.keySet()) {
            log.debug("Adding external data: " + exId);
            inputMap.put(exId, new ByteArrayInputStream(slice.external.get(exId).getRawContent()));
        }
        CramRecordReader reader = new CramRecordReader();
        dataReaderFactory.buildReader(reader, new DefaultBitInputStream(new ByteArrayInputStream(slice.coreBlock.getRawContent())), inputMap, header, slice.sequenceId);
        if (records == null) {
            records = new ArrayList(slice.nofRecords);
        }
        long readNanos = 0L;
        int prevStart = slice.alignmentStart;
        for (int i = 0; i < slice.nofRecords; ++i) {
            CramCompressionRecord record = new CramCompressionRecord();
            record.sliceIndex = slice.index;
            record.index = i;
            long time = System.nanoTime();
            reader.read(record);
            readNanos += System.nanoTime() - time;
            if (record.sequenceId == slice.sequenceId) {
                record.sequenceName = seqName;
                record.sequenceId = slice.sequenceId;
            } else {
                record.sequenceName = record.sequenceId == -1 ? "*" : this.samFileHeader.getSequence(record.sequenceId).getSequenceName();
            }
            records.add(record);
            if (!header.APDelta) continue;
            record.alignmentStart = prevStart += record.alignmentDelta;
        }
        log.debug("Slice records read time: " + readNanos / 1000000L);
        Map<String, DataReaderFactory.DataReaderWithStats> statMap = dataReaderFactory.getStats(reader);
        for (String key : statMap.keySet()) {
            long value;
            if (!this.nanosecondsMap.containsKey(key)) {
                this.nanosecondsMap.put(key, 0L);
                value = 0L;
            } else {
                value = this.nanosecondsMap.get(key);
            }
            this.nanosecondsMap.put(key, value + statMap.get((Object)key).nanos);
        }
        return records;
    }

    List<CramCompressionRecord> getRecords(Slice slice, CompressionHeader header) throws IllegalArgumentException, IllegalAccessException {
        return this.getRecords(null, slice, header);
    }
}

