/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import oracle.jdbc.driver.NTFJMSPerDatabaseManager;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.pool.OracleDataSource;

class NTFJMSConnection
extends Thread {
    int tcpport;
    String clientId;
    String instanceName;
    String serviceName;
    String url;
    String userName;
    String password;
    String connClass;
    ArrayList<String> listenerAddresses;
    Connection conn = null;
    T4CTTIoaqnfy oaqnfy = null;
    NTFJMSPerDatabaseManager jmsPerDatabaseManager;
    private boolean needToBeClosed = false;
    private boolean safeToClose = true;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    NTFJMSConnection(NTFJMSPerDatabaseManager nTFJMSPerDatabaseManager, String string, ArrayList<String> arrayList, String string2, String string3, String string4, String string5, String string6) {
        this.userName = string4;
        this.password = string5;
        this.serviceName = string3;
        this.jmsPerDatabaseManager = nTFJMSPerDatabaseManager;
        this.clientId = string;
        this.listenerAddresses = arrayList;
        this.instanceName = string2;
        assert (this.listenerAddresses != null) : "listenerAddresses is null";
        assert (this.instanceName != null) : "instancename is null";
        String string7 = this.listenerAddresses.get(0);
        this.url = "jdbc:oracle:thin:@(DESCRIPTION=" + string7 + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
        this.connClass = string6;
    }

    @Override
    public void run() {
        if (!this.needToBeClosed) {
            this.safeToClose = false;
            try {
                this.conn = this.getConnection(this.url, this.connClass);
                this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.clientId, this.jmsPerDatabaseManager);
                this.safeToClose = true;
                this.oaqnfy.doRPC();
            }
            catch (Exception exception) {
                this.safeToClose = true;
            }
        }
    }

    synchronized Connection getConnection(String string, String string2) throws Exception {
        OracleDataSource oracleDataSource = new OracleDataSource();
        oracleDataSource.setURL(string);
        oracleDataSource.setUser(this.userName);
        oracleDataSource.setPassword(this.password);
        if (string2 != null) {
            Properties properties = new Properties();
            properties.put("oracle.jdbc.DRCPConnectionClass", string2);
            properties.put("oracle.jdbc.jmsNotification", "true");
            properties.put("oracle.jdbc.ReadTimeout", (Object)0);
            properties.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
            oracleDataSource.setConnectionProperties(properties);
        }
        return oracleDataSource.getConnection();
    }

    void closeThisListener() {
        while (!this.safeToClose) {
        }
        this.needToBeClosed = true;
        try {
            if (this.oaqnfy != null) {
                this.oaqnfy.stopListening();
            }
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

