/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.executables;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.debug.core.executables.Executable;
import org.eclipse.cdt.debug.core.executables.ISourceFilesProvider;
import org.eclipse.cdt.internal.core.model.BinaryParserConfig;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;

public class StandardSourceFilesProvider
extends PlatformObject
implements ISourceFilesProvider {
    public IBinaryParser.IBinaryFile createBinaryFile(Executable executable) {
        CModelManager factory = CModelManager.getDefault();
        IResource resource = executable.getResource();
        IPath path = executable.getPath();
        if (resource != null && resource instanceof IFile) {
            return factory.createBinaryFile((IFile)resource);
        }
        BinaryParserConfig[] parsers = factory.getBinaryParser(executable.getProject());
        if (parsers.length == 0) {
            return null;
        }
        if (!Executable.isBinaryFile(executable.getPath())) {
            return null;
        }
        File f = new File(path.toOSString());
        if (f.length() == 0L) {
            return null;
        }
        int hints = 0;
        int i = 0;
        while (i < parsers.length) {
            IBinaryParser parser = null;
            try {
                parser = parsers[i].getBinaryParser();
                if (parser.getHintBufferSize() > hints) {
                    hints = parser.getHintBufferSize();
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        byte[] bytes = new byte[hints];
        if (hints > 0) {
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(path.toFile());
                    int count = 0;
                    while (count < hints) {
                        int bytesRead = ((InputStream)is).read(bytes, count, hints - count);
                        if (bytesRead < 0) break;
                        count += bytesRead;
                    }
                    if (count > 0 && count < bytes.length) {
                        byte[] array = new byte[count];
                        System.arraycopy(bytes, 0, array, 0, count);
                        bytes = array;
                    }
                }
                catch (IOException iOException) {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException2) {}
                    }
                    return null;
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        int i2 = 0;
        while (i2 < parsers.length) {
            try {
                IBinaryParser.IBinaryFile binFile;
                IBinaryParser parser = parsers[i2].getBinaryParser();
                if (parser.isBinary(bytes, path) && (binFile = parser.getBinary(bytes, path)) != null) {
                    return binFile;
                }
            }
            catch (IOException iOException) {
            }
            catch (CoreException coreException) {}
            ++i2;
        }
        return null;
    }

    @Override
    public String[] getSourceFiles(Executable executable, IProgressMonitor monitor) {
        ISymbolReader symbolreader;
        IBinaryParser.IBinaryFile bin = this.createBinaryFile(executable);
        if (bin != null && (symbolreader = (ISymbolReader)bin.getAdapter(ISymbolReader.class)) != null) {
            return symbolreader.getSourceFiles(monitor);
        }
        return new String[0];
    }

    @Override
    public int getPriority(Executable executable) {
        return 50;
    }
}

