/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import java.util.HashMap;
import java.util.Map;

public enum CuptiActivityMemoryKind {
    CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN(0, null, null),
    CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE(1, "Pageable", "The memory is pageable"),
    CUPTI_ACTIVITY_MEMORY_KIND_PINNED(2, "Pinned", "The memory is pinned"),
    CUPTI_ACTIVITY_MEMORY_KIND_DEVICE(3, "Device", "The memory is on device"),
    CUPTI_ACTIVITY_MEMORY_KIND_ARRAY(4, "Array", "The memory is an array"),
    CUPTI_ACTIVITY_MEMORY_KIND_UNIFIED(5, "Managed", "The memory is managed"),
    CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC(6, "Device static", "The memory is device static"),
    CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC(7, "Managed static", "The memory is managed static");

    private int code;
    private String shortName;
    private String longName;
    private static Map<Integer, CuptiActivityMemoryKind> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiActivityMemoryKind>();
        CuptiActivityMemoryKind[] cuptiActivityMemoryKindArray = CuptiActivityMemoryKind.values();
        int n = cuptiActivityMemoryKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiActivityMemoryKind res = cuptiActivityMemoryKindArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiActivityMemoryKind(int code, String shortName, String longName) {
        this.code = code;
        this.shortName = shortName;
        this.longName = longName;
    }

    public int getCode() {
        return this.code;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public static CuptiActivityMemoryKind valueOf(String string) {
        return Enum.valueOf(CuptiActivityMemoryKind.class, string);
    }
}

