/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class InconsistentColumnsValidator
extends AbstractElementValidator {
    private static InconsistentColumnsValidator instance = new InconsistentColumnsValidator();

    public static InconsistentColumnsValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        DesignElement toValidate = element;
        if (!(toValidate instanceof GridItem) && !(toValidate instanceof TableItem)) {
            return Collections.emptyList();
        }
        return this.doValidate(module, toValidate);
    }

    private List<SemanticException> doValidate(Module module, DesignElement element) {
        int maxCols;
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        int colDefnCount = this.getColDefnCount(module, element);
        if (colDefnCount != (maxCols = this.findMaxCols(module, element)) && colDefnCount != 0) {
            String errorCode = "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT";
            if (this.hasDroppingCell(element)) {
                errorCode = "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT_COZ_DROP";
            }
            if (element instanceof GridItem) {
                errorCode = "Error.SemanticError.INCONSISTENT_GRID_COL_COUNT";
            }
            list.add(new SemanticError(element, errorCode));
        }
        return list;
    }

    private int getColDefnCount(Module module, DesignElement element) {
        if (element instanceof GridItem) {
            return ((GridItem)element).getColDefnCount(module);
        }
        return ((TableItem)element).getColDefnCount(module);
    }

    private int findMaxCols(Module module, DesignElement element) {
        if (element instanceof GridItem) {
            return ((GridItem)element).findMaxCols(module);
        }
        return ((TableItem)element).findMaxCols(module);
    }

    private boolean hasDroppingCell(DesignElement element) {
        if (element instanceof GridItem) {
            return false;
        }
        ContainerSlot groups = element.getSlot(1);
        int groupCount = groups.getCount();
        int groupIndex = 0;
        while (groupIndex < groupCount) {
            TableGroup group = (TableGroup)groups.getContent(groupIndex);
            ContainerSlot header = group.getSlot(0);
            if (header.getCount() > 0) {
                TableRow row = (TableRow)header.getContent(header.getCount() - 1);
                ContainerSlot cells = row.getSlot(0);
                int cellIndex = 0;
                while (cellIndex < cells.getCount()) {
                    Cell cell = (Cell)cells.getContent(cellIndex);
                    String drop = (String)cell.getLocalProperty(null, "drop");
                    if ("all".equalsIgnoreCase(drop) || "detail".equalsIgnoreCase(drop)) {
                        return true;
                    }
                    ++cellIndex;
                }
            }
            ++groupIndex;
        }
        return false;
    }
}

