/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.MIEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MIStoppedEvent
extends MIEvent<IRunControl.IExecutionDMContext> {
    private final MIFrame frame;

    protected MIStoppedEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame) {
        super(ctx, token, results);
        this.frame = frame;
    }

    public MIFrame getFrame() {
        return this.frame;
    }

    public static MIStoppedEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results) {
        MITuple frameTuple = null;
        String frameExceptionPC = null;
        int frameExceptionLine = -1;
        String frameExceptionFile = null;
        MIFrame frame = null;
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            if (var.equals("frame")) {
                if (value instanceof MITuple) {
                    frameTuple = (MITuple)value;
                }
            } else if (var.equals("pc") && value instanceof MIConst) {
                frameExceptionPC = ((MIConst)value).getCString();
            } else if (var.equals("filename") && value instanceof MIConst) {
                frameExceptionFile = ((MIConst)value).getCString();
            } else if (var.equals("line") && value instanceof MIConst) {
                String lineString = ((MIConst)value).getCString();
                frameExceptionLine = Integer.parseInt(lineString);
            }
            ++i;
        }
        if (frameTuple != null) {
            frame = new MIFrame(frameTuple, frameExceptionPC, frameExceptionFile, frameExceptionLine);
        }
        return new MIStoppedEvent(dmc, token, results, frame);
    }
}

