#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Anna Lea
set -o errexit

###
# Hugo I: Hugoʼs House of Horrors
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20221203.1

# Set game-specific variables

GAME_ID='hugo-1'
GAME_NAME='Hugo I: Hugoʼs House of Horrors'

ARCHIVE_BASE_0='the_hugo_trilogy_en_gog_2_19789.sh'
ARCHIVE_BASE_0_MD5='48a853bb5936e29bf22cb1d4ae8fcfdb'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_SIZE='100000'
ARCHIVE_BASE_0_VERSION='2-gog19789'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_hugo_trilogy'

ARCHIVE_DOC0_MAIN_PATH='data/noarch/docs'
ARCHIVE_DOC0_MAIN_FILES='*.txt'

ARCHIVE_DOC1_MAIN_PATH='data/noarch/data/hwin_1/'
ARCHIVE_DOC1_MAIN_FILES='*.txt'

ARCHIVE_GAME_MAIN_PATH='data/noarch/data/hwin_1'
ARCHIVE_GAME_MAIN_FILES='*.bsf *.dat'

APP_MAIN_TYPE='scummvm'
APP_MAIN_SCUMMID='hugo1'
APP_MAIN_ICON='data/noarch/support/icon.png'

PACKAGES_LIST='PKG_MAIN'

PKG_MAIN_DEPS='scummvm'

# Load common functions

target_version='2.13'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "${path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
tolower "$PLAYIT_WORKDIR/gamedata"
prepare_package_layout

# Get icon

PKG='PKG_MAIN'
icons_get_from_workdir 'APP_MAIN'

# Clean up temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "${PLAYIT_WORKDIR}"

# Print instructions

print_instructions

exit 0
