#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Teslagrad
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220707.1

GAME_ID='teslagrad'
GAME_NAME='Teslagrad'

ARCHIVE_BASE_0='gog_teslagrad_2.1.0.4.sh'
ARCHIVE_BASE_0_MD5='e9683e188615ddd341f8a95a2e8102ed'
ARCHIVE_BASE_0_TYPE='mojosetup'
ARCHIVE_BASE_0_VERSION='1.4-gog2.1.0.4'
ARCHIVE_BASE_0_SIZE='1600000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/teslagrad'

UNITY3D_NAME='Teslagrad'

CONTENT_PATH_DEFAULT='data/noarch/game/Teslagrad_linux32_fullversion_1_4'
ARCHIVE_GAME_BIN32_FILES="
${UNITY3D_NAME}
${UNITY3D_NAME}_Data/Mono
${UNITY3D_NAME}_Data/Plugins"
ARCHIVE_GAME_BIN64_PATH="${CONTENT_PATH_DEFAULT}/../Teslagrad_linux64_fullversion_1_4"
ARCHIVE_GAME_BIN64_FILES="
${UNITY3D_NAME}
${UNITY3D_NAME}_Data/Mono
${UNITY3D_NAME}_Data/Plugins"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

APP_MAIN_TYPE='native'
APP_MAIN_EXE="${UNITY3D_NAME}"
APP_MAIN_ICON="${UNITY3D_NAME}_Data/Resources/UnityPlayer.png"

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGLU.so.1 xcursor"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
