#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Edna & Harvey: Harvey's New Eyes
# send your bug reports to contact@dotslashplay.it
###

script_version=20231005.1

PLAYIT_COMPATIBILITY_LEVEL='2.26'

GAME_ID='edna-and-harvey-harveys-new-eyes'
GAME_NAME='Edna & Harvey: Harveyʼs New Eyes'

ARCHIVE_BASE_0_NAME='gog_edna_harvey_harvey_s_new_eyes_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='fa6f7fd271fe63bbe71e3190e0596546'
ARCHIVE_BASE_0_SIZE='990000'
ARCHIVE_BASE_0_VERSION='3.0.0442-gog2.0.0.1'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/edna_harvey_harveys_new_eyes'

VISIONAIRE_NAME='harvey'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_LIBS_BIN_PATH="${CONTENT_PATH_DEFAULT}/libs64"
CONTENT_LIBS_BIN_FILES='
libavcodec.so.56
libavdevice.so.56
libavfilter.so.5
libavformat.so.56
libavutil.so.54
libswresample.so.1
libswscale.so.3'
CONTENT_GAME_BIN_FILES="
$VISIONAIRE_NAME
config.ini"
CONTENT_GAME_DATA_FILES='
characters
lua
scenes
videos
data.vis'
CONTENT_DOC_DATA_PATH="${CONTENT_PATH_DEFAULT}/documents"
CONTENT_DOC_DATA_FILES='
licenses'

APP_MAIN_EXE="$VISIONAIRE_NAME"
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

PKG='PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
