#!/bin/sh -e
set -o errexit

###
# Copyright (c) 2015-2018, Antoine Le Gonidec
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Oddworld: Abe's Oddysee
# build native Linux packages from the original installers
# send your bug reports to mopi@dotslashplay.it
###

script_version=20180802.1

# Set game-specific variables

GAME_ID='oddworld-abes-oddysee'
GAME_NAME='Oddworld: Abe’s Oddysee'

ARCHIVE_GOG='setup_abes_oddysee_1.0_(19071).exe'
ARCHIVE_GOG_URL='https://www.gog.com/game/oddworld_abes_oddysee'
ARCHIVE_GOG_MD5='1c60cd9f43cc6392fc7c5185580eb048'
ARCHIVE_GOG_SIZE='650000'
ARCHIVE_GOG_VERSION='1.0-gog19071'

ARCHIVE_GOG_OLD='setup_abes_oddysee_2.0.0.4.exe'
ARCHIVE_GOG_OLD_MD5='c22a44d208e524dc2760ea6ce57829d5'
ARCHIVE_GOG_OLD_SIZE='660000'
ARCHIVE_GOG_OLD_VERSION='2.1-gog2.0.0.4'

ARCHIVE_DOC_DATA_PATH='app'
ARCHIVE_DOC_DATA_FILES='./*.txt ./*.pdf'

ARCHIVE_GAME_BIN_PATH='app'
ARCHIVE_GAME_BIN_FILES='./abewin.exe'

ARCHIVE_GAME_DATA_PATH='app'
ARCHIVE_GAME_DATA_FILES='./*.ddv ./*.lvl'

CONFIG_FILES='./*.ini'
DATA_DIRS='./save'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='abewin.exe'
APP_MAIN_ICON='abewin.exe'
APP_MAIN_ICON_RES='16 32 48'

PACKAGES_LIST='PKG_DATA PKG_BIN'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Load common functions

target_version='2.7'

if [ -z "$PLAYIT_LIB2" ]; then
	[ -n "$XDG_DATA_HOME" ] || XDG_DATA_HOME="$HOME/.local/share"
	if [ -e "$XDG_DATA_HOME/play.it/play.it-2/lib/libplayit2.sh" ]; then
		PLAYIT_LIB2="$XDG_DATA_HOME/play.it/play.it-2/lib/libplayit2.sh"
	elif [ -e './libplayit2.sh' ]; then
		PLAYIT_LIB2='./libplayit2.sh'
	else
		printf '\n\033[1;31mError:\033[0m\n'
		printf 'libplayit2.sh not found.\n'
		exit 1
	fi
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"

prepare_package_layout

PKG='PKG_BIN'
extract_and_sort_icons_from 'APP_MAIN'
move_icons_to 'PKG_DATA'

rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Write launchers

PKG='PKG_BIN'
write_launcher 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
