# extract the content of an archive using bsdtar
# USAGE: archive_extraction_using_bsdtar $archive $destination_directory $log_file
archive_extraction_using_bsdtar() {
	local archive destination_directory log_file
	archive="$1"
	destination_directory="$2"
	log_file="$3"

	local archive_path
	archive_path=$(archive_path "$archive")

	local extractor_options
	extractor_options=$(archive_extractor_options "$archive")
	if ! {
		printf 'bsdtar --verbose %s --directory "%s" --extract --file "%s"\n' "$extractor_options" "$destination_directory" "$archive_path"
		bsdtar --verbose $extractor_options --directory "$destination_directory" --extract --file "$archive_path" 2>&1
	} >> "$log_file"
	then
		error_archive_extraction_failure "$archive"
		return 1
	fi
}

