/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.derby.jdbc.ClientConnectionPoolDataSource;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.jdbc.ClientXADataSource;

public class ClientDataSourceFactory
implements ObjectFactory {
    private static final Class[] STRING_ARG = new Class[]{"".getClass()};
    private static final Class[] INT_ARG = new Class[]{Integer.TYPE};
    private static final Class[] BOOLEAN_ARG = new Class[]{Boolean.TYPE};
    private static final Class[] SHORT_ARG = new Class[]{Short.TYPE};

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Reference reference = (Reference)object;
        ClientDataSource clientDataSource = null;
        if (reference.getClassName().equals("org.apache.derby.jdbc.ClientDataSource")) {
            clientDataSource = new ClientDataSource();
        } else if (reference.getClassName().equals("org.apache.derby.jdbc.ClientXADataSource")) {
            clientDataSource = new ClientXADataSource();
        } else if (reference.getClassName().equals("org.apache.derby.jdbc.ClientConnectionPoolDataSource")) {
            clientDataSource = new ClientConnectionPoolDataSource();
        } else {
            return null;
        }
        ClientDataSourceFactory.setBeanProperties(clientDataSource, reference);
        return clientDataSource;
    }

    private static void setBeanProperties(Object object, Reference reference) throws Exception {
        Enumeration<RefAddr> enumeration = reference.getAll();
        while (enumeration.hasMoreElements()) {
            Object object2;
            Method method;
            RefAddr refAddr = enumeration.nextElement();
            String string = refAddr.getType();
            String string2 = (String)refAddr.getContent();
            String string3 = "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
            try {
                method = object.getClass().getMethod(string3, STRING_ARG);
                object2 = string2;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    method = object.getClass().getMethod(string3, INT_ARG);
                    object2 = Integer.valueOf(string2);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        method = object.getClass().getMethod(string3, BOOLEAN_ARG);
                        object2 = Boolean.valueOf(string2);
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        method = object.getClass().getMethod(string3, SHORT_ARG);
                        object2 = Short.valueOf(string2);
                    }
                }
            }
            method.invoke(object, object2);
        }
    }
}

