/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.LayoutBinder;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.JavaFileWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DataBinder {
    List<LayoutBinder> mLayoutBinders = new ArrayList<LayoutBinder>();
    private JavaFileWriter mFileWriter;

    public DataBinder(ResourceBundle resourceBundle) {
        L.d("reading resource bundle into data binder", new Object[0]);
        for (Map.Entry<String, List<ResourceBundle.LayoutFileBundle>> entry : resourceBundle.getLayoutBundles().entrySet()) {
            for (ResourceBundle.LayoutFileBundle bundle : entry.getValue()) {
                this.mLayoutBinders.add(new LayoutBinder(bundle));
            }
        }
    }

    public List<LayoutBinder> getLayoutBinders() {
        return this.mLayoutBinders;
    }

    public void writerBaseClasses(boolean isLibrary) {
        HashSet<String> writtenFiles = new HashSet<String>();
        for (LayoutBinder layoutBinder : this.mLayoutBinders) {
            String className;
            if (!isLibrary && !layoutBinder.hasVariations() || writtenFiles.contains(className = layoutBinder.getClassName())) continue;
            this.mFileWriter.writeToFile(layoutBinder.getPackage() + "." + className, layoutBinder.writeViewBinderBaseClass());
            writtenFiles.add(className);
        }
    }

    public void writeBinders(int minSdk) {
        for (LayoutBinder layoutBinder : this.mLayoutBinders) {
            String className = layoutBinder.getImplementationName();
            L.d("writing data binder %s", className);
            this.mFileWriter.writeToFile(layoutBinder.getPackage() + "." + className, layoutBinder.writeViewBinder(minSdk));
        }
    }

    public void setFileWriter(JavaFileWriter fileWriter) {
        this.mFileWriter = fileWriter;
    }

    public JavaFileWriter getFileWriter() {
        return this.mFileWriter;
    }
}

