/* Copyright (c) 2007  Dmitry Xmelkov
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
   * Neither the name of the copyright holders nor the names of
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
 */

/* Test of asin() function. 500 random cases.
   $Id$
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x;		/* argument	*/
    long z;		/* asin(x)	*/
} t[] = {

    /* x, asin(x)	*/
    { 0xbf785a73,0xbfa9b2b9 }, /*   1: -9.7013015e-01 -1.3257667e+00 */
    { 0x3f478481,0x3f64c66c }, /*   2:  7.7936560e-01  8.9365268e-01 */
    { 0xbf75e53e,0xbfa4faa0 }, /*   3: -9.6052921e-01 -1.2888985e+00 */
    { 0xbcc573c9,0xbcc578ae }, /*   4: -2.4103062e-02 -2.4105396e-02 */
    { 0x3f115401,0x3f1a8bbe }, /*   5:  5.6768805e-01  6.0369480e-01 */
    { 0x3e3bf43d,0x3e3d0698 }, /*   6:  1.8354888e-01  1.8459547e-01 */
    { 0xbf0a4440,0xbf121042 }, /*   7: -5.4010391e-01 -5.7056057e-01 */
    { 0x3ef1472e,0x3efb3d71 }, /*   8:  4.7124618e-01  4.9070314e-01 */
    { 0xbea9762f,0xbeacb80d }, /*   9: -3.3097979e-01 -3.3734170e-01 */
    { 0x3ead4726,0x3eb0c4d1 }, /*  10:  3.3843344e-01  3.4525159e-01 */
    { 0x3f5cbd1f,0x3f85156f }, /*  11:  8.6226076e-01  1.0397166e+00 */
    { 0x3f7ec2f1,0x3fbc774c }, /*  12:  9.9516207e-01  1.4723907e+00 */
    { 0x3dd22580,0x3dd2845b }, /*  13:  1.0261059e-01  1.0279151e-01 */
    { 0x3f590356,0x3f817dae }, /*  14:  8.4770715e-01  1.0116479e+00 */
    { 0x3e150d41,0x3e15954c }, /*  15:  1.4555837e-01  1.4607733e-01 */
    { 0xbec2d9b5,0xbec7e3c4 }, /*  16: -3.8056722e-01 -3.9040959e-01 */
    { 0xbe9d1156,0xbe9fa453 }, /*  17: -3.0677289e-01 -3.1180057e-01 */
    { 0xbf2b4501,0xbf3b9eca }, /*  18: -6.6902167e-01 -7.3289168e-01 */
    { 0x3e8fcd84,0x3e91c38e }, /*  19:  2.8086483e-01  2.8469509e-01 */
    { 0x3f2b6ba2,0x3f3bd2c8 }, /*  20:  6.6961110e-01  7.3368502e-01 */
    { 0xbf1375e1,0xbf1d2529 }, /*  21: -5.7601744e-01 -6.1384827e-01 */
    { 0x3f2001d7,0x3f2cd7c7 }, /*  22:  6.2502807e-01  6.7516750e-01 */
    { 0xbf5f78cf,0xbf87d51c }, /*  23: -8.7293714e-01 -1.0611911e+00 */
    { 0x3f689388,0x3f91e123 }, /*  24:  9.0850115e-01  1.1396831e+00 */
    { 0xbf59be65,0xbf822ec3 }, /*  25: -8.5056144e-01 -1.0170521e+00 */
    { 0xbf555081,0xbf7c277c }, /*  26: -8.3325964e-01 -9.8497748e-01 */
    { 0xbf15353d,0xbf1f4a0f }, /*  27: -5.8284360e-01 -6.2222379e-01 */
    { 0x3f4cffee,0x3f6db882 }, /*  28:  8.0078018e-01  9.2859662e-01 */
    { 0xbf4d2c6f,0xbf6e02de }, /*  29: -8.0145925e-01 -9.2973125e-01 */
    { 0x3e87e4d3,0x3e898acd }, /*  30:  2.6541767e-01  2.6863709e-01 */
    { 0xbf6a1c28,0xbf93be7e }, /*  31: -9.1449213e-01 -1.1542509e+00 */
    { 0xbf4586e2,0xbf619f3c }, /*  32: -7.7158940e-01 -8.8133597e-01 */
    { 0x3d376ea8,0x3d377e5e }, /*  33:  4.4783264e-02  4.4798248e-02 */
    { 0xbf600167,0xbf8861a6 }, /*  34: -8.7502140e-01 -1.0654800e+00 */
    { 0x3e5135fe,0x3e52b1c5 }, /*  35:  2.0430753e-01  2.0575626e-01 */
    { 0xbec66a2a,0xbecbc003 }, /*  36: -3.8752872e-01 -3.9794931e-01 */
    { 0x3e9df751,0x3ea09607 }, /*  37:  3.0852750e-01  3.1364462e-01 */
    { 0x3f2a0940,0x3f39f730 }, /*  38:  6.6420364e-01  7.2642803e-01 */
    { 0xbf6a917e,0xbf94503a }, /*  39: -9.1628253e-01 -1.1586983e+00 */
    { 0x3f7a4091,0x3fade307 }, /*  40:  9.7754771e-01  1.3584908e+00 */
    { 0x3b2cd2de,0x3b2cd2eb }, /*  41:  2.6370804e-03  2.6370834e-03 */
    { 0x3f722ba1,0x3f9ecbef }, /*  42:  9.4597822e-01  1.2405986e+00 */
    { 0x3f790382,0x3fab16ed }, /*  43:  9.7270977e-01  1.3366371e+00 */
    { 0xbf650e7d,0xbf8dcee4 }, /*  44: -8.9475232e-01 -1.1078763e+00 */
    { 0x3f4b2ef8,0x3f6ab643 }, /*  45:  7.9368544e-01  9.1684359e-01 */
    { 0x3df23694,0x3df2c80c }, /*  46:  1.1826816e-01  1.1854562e-01 */
    { 0xbe8cf6af,0xbe8ecee0 }, /*  47: -2.7531955e-01 -2.7892208e-01 */
    { 0xbf0359b3,0xbf09ed5a }, /*  48: -5.1308745e-01 -5.3877795e-01 */
    { 0x3ee603a3,0x3eee8d4c }, /*  49:  4.4924650e-01  4.6592176e-01 */
    { 0xbf7e9496,0xbfbb9369 }, /*  50: -9.9445474e-01 -1.4654361e+00 */
    { 0xbf57ee11,0xbf8079f9 }, /*  51: -8.4347636e-01 -1.0037223e+00 */
    { 0x3f5f8bf1,0x3f87e8bb }, /*  52:  8.7322909e-01  1.0617899e+00 */
    { 0x3f216d41,0x3f2eaaab }, /*  53:  6.3057333e-01  6.8229169e-01 */
    { 0xbf3766e0,0xbf4c7432 }, /*  54: -7.1641350e-01 -7.9864800e-01 */
    { 0x3f481f79,0x3f65be56 }, /*  55:  7.8173023e-01  8.9743555e-01 */
    { 0x3f47aedc,0x3f650a11 }, /*  56:  7.8001189e-01  8.9468485e-01 */
    { 0xbf0cb761,0xbf14fc2d }, /*  57: -5.4967314e-01 -5.8197290e-01 */
    { 0xbf4d15c4,0xbf6ddcfb }, /*  58: -8.0111337e-01 -9.2915314e-01 */
    { 0x3f14aec9,0x3f1ea4be }, /*  59:  5.8079201e-01  6.1970127e-01 */
    { 0xbeb3c7a0,0xbeb7b20b }, /*  60: -3.5113239e-01 -3.5878024e-01 */
    { 0x3eedb94b,0x3ef737fa }, /*  61:  4.6430430e-01  4.8284894e-01 */
    { 0x3f2a92a1,0x3f3aaf30 }, /*  62:  6.6629988e-01  7.2923565e-01 */
    { 0xbdfb5593,0xbdfbf82f }, /*  63: -1.2272181e-01 -1.2303197e-01 */
    { 0xbefb58e0,0xbf035cee }, /*  64: -4.9091244e-01 -5.1313674e-01 */
    { 0x3f4a913b,0x3f69b3a1 }, /*  65:  7.9127854e-01  9.1289717e-01 */
    { 0xbf6b1d33,0xbf94ffb4 }, /*  66: -9.1841429e-01 -1.1640534e+00 */
    { 0x3df8f3d9,0x3df991db }, /*  67:  1.2155885e-01  1.2186023e-01 */
    { 0x3dcc6718,0x3dccbe5c }, /*  68:  9.9806011e-02  9.9972457e-02 */
    { 0x3f3eec0d,0x3f577ae4 }, /*  69:  7.4578935e-01  8.4171891e-01 */
    { 0x3e5233f6,0x3e53b53d }, /*  70:  2.0527634e-01  2.0674606e-01 */
    { 0x3d9e6ba2,0x3d9e9430 }, /*  71:  7.7353731e-02  7.7431083e-02 */
    { 0xbe80ce40,0xbe82345e }, /*  72: -2.5157356e-01 -2.5430578e-01 */
    { 0x3e1ae27c,0x3e1b7b40 }, /*  73:  1.5125459e-01  1.5183735e-01 */
    { 0x3d4d0f6a,0x3d4d255e }, /*  74:  5.0063528e-02  5.0084464e-02 */
    { 0xbe15d675,0xbe1660ad }, /*  75: -1.4632590e-01 -1.4685316e-01 */
    { 0xbd618695,0xbd61a3cb }, /*  76: -5.5059988e-02 -5.5087846e-02 */
    { 0xbf54e837,0xbf7b6b43 }, /*  77: -8.3166832e-01 -9.8210543e-01 */
    { 0x3f140f0b,0x3f1de0b9 }, /*  78:  5.7835454e-01  6.1671025e-01 */
    { 0x3edd1bc7,0x3ee4a1a4 }, /*  79:  4.3185255e-01  4.4654572e-01 */
    { 0x3f1e199b,0x3f2a68ae }, /*  80:  6.1757821e-01  6.6565979e-01 */
    { 0x3f157a76,0x3f1f9f49 }, /*  81:  5.8389986e-01  6.2352425e-01 */
    { 0x3f169fd2,0x3f21095d }, /*  82:  5.8837616e-01  6.2904912e-01 */
    { 0x3efb4b17,0x3f035505 }, /*  83:  4.9080727e-01  5.1301605e-01 */
    { 0x3e5b9edb,0x3e5d570f }, /*  84:  2.1447317e-01  2.1615241e-01 */
    { 0x3f5f38f2,0x3f8793c5 }, /*  85:  8.7196267e-01  1.0591971e+00 */
    { 0x3e8b8a08,0x3e8d53b8 }, /*  86:  2.7253747e-01  2.7602935e-01 */
    { 0xbbb4b6d5,0xbbb4b711 }, /*  87: -5.5149593e-03 -5.5149873e-03 */
    { 0xbf2d7e70,0xbf3ea108 }, /*  88: -6.7771053e-01 -7.4464464e-01 */
    { 0x3ef15e80,0x3efb57e2 }, /*  89:  4.7142410e-01  4.9090487e-01 */
    { 0xbed97548,0xbee0977e }, /*  90: -4.2472291e-01 -4.3865579e-01 */
    { 0xbcec47f5,0xbcec5059 }, /*  91: -2.8842906e-02 -2.8846906e-02 */
    { 0xbd83a0d3,0xbd83b811 }, /*  92: -6.4271592e-02 -6.4315923e-02 */
    { 0xbf422803,0xbf5c634c }, /*  93: -7.5842303e-01 -8.6089015e-01 */
    { 0x3f59330e,0x3f81aab5 }, /*  94:  8.4843528e-01  1.0130221e+00 */
    { 0x3ee3beeb,0x3eec0419 }, /*  95:  4.4481596e-01  4.6096876e-01 */
    { 0xbf7796c8,0xbfa828e2 }, /*  96: -9.6714449e-01 -1.3137476e+00 */
    { 0x3f6e15db,0x3f98e464 }, /*  97:  9.3002099e-01  1.1944699e+00 */
    { 0xbede041e,0xbee5a35c }, /*  98: -4.3362516e-01 -4.4851196e-01 */
    { 0x3e07d86a,0x3e083f3c }, /*  99:  1.3266149e-01  1.3305372e-01 */
    { 0x3f2d01e8,0x3f3df7e0 }, /* 100:  6.7581034e-01  7.4206352e-01 */
    { 0x3f458aee,0x3f61a598 }, /* 101:  7.7165115e-01  8.8143301e-01 */
    { 0xbf4a3c71,0xbf692926 }, /* 102: -7.8998476e-01 -9.1078413e-01 */
    { 0xbf136538,0xbf1d10c8 }, /* 103: -5.7576323e-01 -6.1353731e-01 */
    { 0xbd9de395,0xbd9e0bbb }, /* 104: -7.7094235e-02 -7.7170812e-02 */
    { 0x3e85290b,0x3e86b589 }, /* 105:  2.6007876e-01  2.6310375e-01 */
    { 0x3e8e4a56,0x3e903051 }, /* 106:  2.7791089e-01  2.8161862e-01 */
    { 0x3f5e2b24,0x3f86823f }, /* 107:  8.6784577e-01  1.0508498e+00 */
    { 0x3edb589d,0x3ee2ade2 }, /* 108:  4.2841044e-01  4.4273287e-01 */
    { 0xbe132f26,0xbe13b21c }, /* 109: -1.4373454e-01 -1.4423412e-01 */
    { 0x3e99720f,0x3e9bd73a }, /* 110:  2.9969832e-01  3.0437642e-01 */
    { 0x3d3c5e95,0x3d3c6f99 }, /* 111:  4.5988638e-02  4.6004865e-02 */
    { 0xbf0f5154,0xbf181c98 }, /* 112: -5.5983472e-01 -5.9418631e-01 */
    { 0xbde53935,0xbde5b46c }, /* 113: -1.1192552e-01 -1.1216053e-01 */
    { 0xbeed2917,0xbef69536 }, /* 114: -4.6320412e-01 -4.8160714e-01 */
    { 0x3f279663,0x3f36b553 }, /* 115:  6.5463847e-01  7.1370429e-01 */
    { 0xbe75b8d4,0xbe7824bb }, /* 116: -2.3996288e-01 -2.4232762e-01 */
    { 0x3f4f3079,0x3f716984 }, /* 117:  8.0933338e-01  9.4301629e-01 */
    { 0xbeb3a616,0xbeb78e39 }, /* 118: -3.5087651e-01 -3.5850695e-01 */
    { 0x3da89adc,0x3da8cbc4 }, /* 119:  8.2326621e-02  8.2419902e-02 */
    { 0x3e8fbf71,0x3e91b4e4 }, /* 120:  2.8075746e-01  2.8458321e-01 */
    { 0x3e65c943,0x3e67c27e }, /* 121:  2.2440057e-01  2.2632787e-01 */
    { 0xbf724ee4,0xbf9f0271 }, /* 122: -9.4651628e-01 -1.2422620e+00 */
    { 0xbf489462,0xbf667a25 }, /* 123: -7.8351414e-01 -9.0030128e-01 */
    { 0x3eee949b,0x3ef82fb9 }, /* 124:  4.6597752e-01  4.8473909e-01 */
    { 0x3f66e42a,0x3f8fe588 }, /* 125:  9.0191901e-01  1.1241922e+00 */
    { 0x3f294b14,0x3f38f93b }, /* 126:  6.6130185e-01  7.2255296e-01 */
    { 0x3eff670a,0x3f05b24b }, /* 127:  4.9883300e-01  5.2225178e-01 */
    { 0x3f54fa05,0x3f7b8b57 }, /* 128:  8.3194000e-01  9.8259491e-01 */
    { 0xbf45b6fb,0xbf61eae6 }, /* 129: -7.7232331e-01 -8.8249052e-01 */
    { 0xbebcacc0,0xbec13aaf }, /* 130: -3.6850548e-01 -3.7740085e-01 */
    { 0x3f01fbed,0x3f08569a }, /* 131:  5.0775033e-01  5.3257143e-01 */
    { 0x3f7fd3f3,0x3fc45e59 }, /* 132:  9.9932784e-01  1.5341293e+00 */
    { 0xbe224b45,0xbe22fb34 }, /* 133: -1.5849026e-01 -1.5916139e-01 */
    { 0x3f6e96b6,0x3f9994e8 }, /* 134:  9.3198717e-01  1.1998568e+00 */
    { 0xbd9f43fc,0xbd9f6d31 }, /* 135: -7.7766389e-02 -7.7844985e-02 */
    { 0xbf65fe4c,0xbf8edda3 }, /* 136: -8.9841151e-01 -1.1161388e+00 */
    { 0x3e56ef83,0x3e588bc5 }, /* 137:  2.0989804e-01  2.1147068e-01 */
    { 0xbe56f56e,0xbe5891d2 }, /* 138: -2.0992061e-01 -2.1149376e-01 */
    { 0x3f07ae03,0x3f0f005e }, /* 139:  5.2999896e-01  5.5859935e-01 */
    { 0xbf6f0fe9,0xbf9a3d31 }, /* 140: -9.3383652e-01 -1.2049924e+00 */
    { 0xbf690454,0xbf9268b6 }, /* 141: -9.1022229e-01 -1.1438205e+00 */
    { 0xbed91828,0xbee030a6 }, /* 142: -4.2401242e-01 -4.3787116e-01 */
    { 0xbefcc27a,0xbf042ca5 }, /* 143: -4.9367124e-01 -5.1630622e-01 */
    { 0xbcb56f55,0xbcb57321 }, /* 144: -2.2147814e-02 -2.2149624e-02 */
    { 0x3de6fb06,0x3de7791b }, /* 145:  1.1278348e-01  1.1302396e-01 */
    { 0xbf56cada,0xbf7ed94a }, /* 146: -8.3903277e-01 -9.9550307e-01 */
    { 0x3f3ce650,0x3f5476cb }, /* 147:  7.3788929e-01  8.2993764e-01 */
    { 0xbd9f8136,0xbd9faa9b }, /* 148: -7.7883169e-02 -7.7962123e-02 */
    { 0xbe427795,0xbe43a7ca }, /* 149: -1.8990929e-01 -1.9106975e-01 */
    { 0xbe381950,0xbe391af7 }, /* 150: -1.7978406e-01 -1.8076693e-01 */
    { 0xbf4c106e,0xbf6c2a44 }, /* 151: -7.9712570e-01 -9.2251992e-01 */
    { 0xbf772b95,0xbfa75891 }, /* 152: -9.6550876e-01 -1.3073903e+00 */
    { 0xbe0154e1,0xbe01ad8b }, /* 153: -1.2630035e-01 -1.2663858e-01 */
    { 0xbf14a4d0,0xbf1e987e }, /* 154: -5.8063984e-01 -6.1951435e-01 */
    { 0x3f001eb9,0x3f062e0d }, /* 155:  5.0046879e-01  5.2414018e-01 */
    { 0xbe65c43a,0xbe67bd54 }, /* 156: -2.2438136e-01 -2.2630817e-01 */
    { 0xbf6b59bc,0xbf954c6c }, /* 157: -9.1933799e-01 -1.1663947e+00 */
    { 0xba3706a8,0xba3706a9 }, /* 158: -6.9818879e-04 -6.9818884e-04 */
    { 0xbec8ee13,0xbece7b4b }, /* 159: -3.9244136e-01 -4.0328440e-01 */
    { 0xbf3110b7,0xbf438788 }, /* 160: -6.9166130e-01 -7.6378679e-01 */
    { 0x3f217bde,0x3f2ebd80 }, /* 161:  6.3079631e-01  6.8257904e-01 */
    { 0xbf627b1c,0xbf8afc81 }, /* 162: -8.8469100e-01 -1.0858308e+00 */
    { 0xbf313cc4,0xbf43c48d }, /* 163: -6.9233346e-01 -7.6471788e-01 */
    { 0xbf0716f3,0xbf0e4e60 }, /* 164: -5.2769393e-01 -5.5588341e-01 */
    { 0xbf73e466,0xbfa1899f }, /* 165: -9.5270383e-01 -1.2620124e+00 */
    { 0x3e6b6af3,0x3e6d8ae1 }, /* 166:  2.2990017e-01  2.3197509e-01 */
    { 0xbeda2a7e,0xbee15fba }, /* 167: -4.2610544e-01 -4.4018346e-01 */
    { 0x3e83aef5,0x3e852e22 }, /* 168:  2.5719419e-01  2.6011759e-01 */
    { 0xbf7ae29f,0xbfaf6ea7 }, /* 169: -9.8002046e-01 -1.3705643e+00 */
    { 0xbf65673c,0xbf8e328f }, /* 170: -8.9610648e-01 -1.1109179e+00 */
    { 0x3ea58f23,0x3ea896d1 }, /* 171:  3.2335767e-01  3.2927564e-01 */
    { 0xbf63e6f3,0xbf8c8743 }, /* 172: -8.9024276e-01 -1.0978779e+00 */
    { 0xbea3e6a0,0xbea6d677 }, /* 173: -3.2011890e-01 -3.2585499e-01 */
    { 0x3f546654,0x3f7a81f8 }, /* 174:  8.2968640e-01  9.7854567e-01 */
    { 0x3db36c95,0x3db3a78b }, /* 175:  8.7609448e-02  8.7721907e-02 */
    { 0x3f4aec11,0x3f6a4867 }, /* 176:  7.9266459e-01  9.1516727e-01 */
    { 0x3f7d9b7a,0x3fb78c46 }, /* 177:  9.9065363e-01  1.4339683e+00 */
    { 0xbe32b074,0xbe339bda }, /* 178: -1.7450124e-01 -1.7539921e-01 */
    { 0xbe92082c,0xbe94168b }, /* 179: -2.8521860e-01 -2.8923449e-01 */
    { 0xbe4c09ad,0xbe4d69a3 }, /* 180: -1.9925566e-01 -2.0059828e-01 */
    { 0x3f254d8f,0x3f33b394 }, /* 181:  6.4571470e-01  7.0195889e-01 */
    { 0xbda8a41f,0xbda8d50f }, /* 182: -8.2344286e-02 -8.2437627e-02 */
    { 0xbe28b7ff,0xbe297dd9 }, /* 183: -1.6476439e-01 -1.6551913e-01 */
    { 0xbef60f53,0xbf0056ab }, /* 184: -4.8058566e-01 -5.0132245e-01 */
    { 0x3eac8d59,0x3eafff6b }, /* 185:  3.3701590e-01  3.4374556e-01 */
    { 0xbf2a0f47,0xbf39ff40 }, /* 186: -6.6429561e-01 -7.2655106e-01 */
    { 0x3e970e90,0x3e9956c2 }, /* 187:  2.9503298e-01  2.9949003e-01 */
    { 0x3ed5d9e1,0x3edc9d5e }, /* 188:  4.1767791e-01  4.3088812e-01 */
    { 0x3eab85ef,0x3eaee7bf }, /* 189:  3.3500621e-01  3.4161183e-01 */
    { 0x3f67103f,0x3f9018a5 }, /* 190:  9.0259165e-01  1.1257521e+00 */
    { 0x3f39dc3a,0x3f5000c3 }, /* 191:  7.2601664e-01  8.1251162e-01 */
    { 0xbd0c12a4,0xbd0c19a2 }, /* 192: -3.4197465e-02 -3.4204133e-02 */
    { 0xbf7b6add,0xbfb0ce76 }, /* 193: -9.8209935e-01 -1.3813007e+00 */
    { 0xbf77608a,0xbfa7bedb }, /* 194: -9.6631682e-01 -1.3105119e+00 */
    { 0x3ee04fc5,0x3ee8304d }, /* 195:  4.3810859e-01  4.5349351e-01 */
    { 0xbf6f4f43,0xbf9a9610 }, /* 196: -9.3480319e-01 -1.2077045e+00 */
    { 0x3e86f466,0x3e88917f }, /* 197:  2.6358336e-01  2.6673505e-01 */
    { 0xbf7ced5c,0xbfb535b1 }, /* 198: -9.8799682e-01 -1.4157010e+00 */
    { 0x3ea5106e,0x3ea810f1 }, /* 199:  3.2239097e-01  3.2825425e-01 */
    { 0x3e912f28,0x3e93342e }, /* 200:  2.8356290e-01  2.8750747e-01 */
    { 0xbf625498,0xbf8ad33e }, /* 201: -8.8410330e-01 -1.0845716e+00 */
    { 0xbeb5606f,0xbeb966ed }, /* 202: -3.5425135e-01 -3.6211339e-01 */
    { 0x3ec96143,0x3ecef88d }, /* 203:  3.9332017e-01  4.0424004e-01 */
    { 0xbe511fa1,0xbe529aed }, /* 204: -2.0422222e-01 -2.0566912e-01 */
    { 0xbf0649e3,0xbf0d5d3e }, /* 205: -5.2456492e-01 -5.5220401e-01 */
    { 0xbf04e1cc,0xbf0bb71f }, /* 206: -5.1907039e-01 -5.4576296e-01 */
    { 0xbed2b7af,0xbed92bd4 }, /* 207: -4.1155764e-01 -4.2416251e-01 */
    { 0xbf08ae69,0xbf102f29 }, /* 208: -5.3391129e-01 -5.6321961e-01 */
    { 0x3e9ce42e,0x3e9f74e2 }, /* 209:  3.0642837e-01  3.1143862e-01 */
    { 0x3e9b4025,0x3e9dbbdc }, /* 210:  3.0322376e-01  3.0807388e-01 */
    { 0x3e889e57,0x3e8a4b42 }, /* 211:  2.6683304e-01  2.7010542e-01 */
    { 0xbd4405a5,0xbd4418d2 }, /* 212: -4.7856946e-02 -4.7875233e-02 */
    { 0xbf477471,0xbf64accb }, /* 213: -7.7912050e-01 -8.9326161e-01 */
    { 0xbf65ded4,0xbf8eb9da }, /* 214: -8.9793134e-01 -1.1150467e+00 */
    { 0x3ef16ff8,0x3efb6bb2 }, /* 215:  4.7155738e-01  4.9105603e-01 */
    { 0x3f0ed23b,0x3f178354 }, /* 216:  5.5789536e-01  5.9184766e-01 */
    { 0xbf0fee1b,0xbf18d9fc }, /* 217: -5.6222695e-01 -5.9707618e-01 */
    { 0xbe6f02ee,0xbe713c96 }, /* 218: -2.3340961e-01 -2.3558268e-01 */
    { 0xbcc81a81,0xbcc81f99 }, /* 219: -2.4426701e-02 -2.4429129e-02 */
    { 0x3f45d4dd,0x3f6219f6 }, /* 220:  7.7277929e-01  8.8320863e-01 */
    { 0xbea960f9,0xbeaca193 }, /* 221: -3.3081797e-01 -3.3717021e-01 */
    { 0xbe98c935,0xbe9b2647 }, /* 222: -2.9841009e-01 -3.0302641e-01 */
    { 0xbe85d89b,0xbe876b64 }, /* 223: -2.6141819e-01 -2.6449120e-01 */
    { 0xbea036b4,0xbea2f361 }, /* 224: -3.1291735e-01 -3.1826308e-01 */
    { 0xbe878a48,0xbe892ce6 }, /* 225: -2.6472688e-01 -2.6792067e-01 */
    { 0xbf52c46b,0xbf779b92 }, /* 226: -8.2330960e-01 -9.6721756e-01 */
    { 0xbe7daa75,0xbe802ad4 }, /* 227: -2.4772055e-01 -2.5032675e-01 */
    { 0x3f7fb50f,0x3fc2f0a5 }, /* 228:  9.9885648e-01  1.5229689e+00 */
    { 0xbf4fb1c7,0xbf72462d }, /* 229: -8.1130642e-01 -9.4638330e-01 */
    { 0xbf6ce266,0xbf9748a0 }, /* 230: -9.2532957e-01 -1.1819038e+00 */
    { 0x3e909945,0x3e9297e8 }, /* 231:  2.8241935e-01  2.8631520e-01 */
    { 0xbf320660,0xbf44dc87 }, /* 232: -6.9540977e-01 -7.6898998e-01 */
    { 0xbe8f253c,0xbe911440 }, /* 233: -2.7958095e-01 -2.8335762e-01 */
    { 0xbea60578,0xbea913e3 }, /* 234: -3.2426047e-01 -3.3022985e-01 */
    { 0x3dcd8dc2,0x3dcde683 }, /* 235:  1.0036804e-01  1.0053732e-01 */
    { 0x3e488dfb,0x3e49dc04 }, /* 236:  1.9585411e-01  1.9712836e-01 */
    { 0x3e206ddf,0x3e2117c4 }, /* 237:  1.5666912e-01  1.5731722e-01 */
    { 0x3f3055e1,0x3f428552 }, /* 238:  6.8881041e-01  7.5984681e-01 */
    { 0x3f297516,0x3f393141 }, /* 239:  6.6194284e-01  7.2340780e-01 */
    { 0xbf097271,0xbf111743 }, /* 240: -5.3690249e-01 -5.6676120e-01 */
    { 0xbc02831e,0xbc028378 }, /* 241: -7.9658311e-03 -7.9659149e-03 */
    { 0xbd91ddf5,0xbd91fd9a }, /* 242: -7.1224131e-02 -7.1284488e-02 */
    { 0x3ed49a69,0x3edb3dfa }, /* 243:  4.1524056e-01  4.2820722e-01 */
    { 0x3e5a060a,0x3e5bb494 }, /* 244:  2.1291366e-01  2.1455604e-01 */
    { 0x3cfcada7,0x3cfcb7ea }, /* 245:  3.0844523e-02  3.0849416e-02 */
    { 0xbde7d67c,0xbde855fb }, /* 246: -1.1320207e-01 -1.1344524e-01 */
    { 0xbe6ab109,0xbe6ccbde }, /* 247: -2.2919096e-01 -2.3124644e-01 */
    { 0x3eefeea5,0x3ef9b720 }, /* 248:  4.6861759e-01  4.8772526e-01 */
    { 0x3f274475,0x3f364905 }, /* 249:  6.5338832e-01  7.1205169e-01 */
    { 0x3f3f12ea,0x3f57b542 }, /* 250:  7.4638236e-01  8.4260952e-01 */
    { 0x3e7730bc,0x3e79a805 }, /* 251:  2.4139684e-01  2.4380501e-01 */
    { 0xbf2d6c08,0xbf3e8801 }, /* 252: -6.7742968e-01 -7.4426275e-01 */
    { 0xbf0d51b1,0xbf15b512 }, /* 253: -5.5202776e-01 -5.8479416e-01 */
    { 0x3f7adfe1,0x3faf67c3 }, /* 254:  9.7997862e-01  1.3703541e+00 */
    { 0x3c1e279b,0x3c1e283c }, /* 255:  9.6529974e-03  9.6531473e-03 */
    { 0x3e3ba4ad,0x3e3cb5a8 }, /* 256:  1.8324538e-01  1.8428671e-01 */
    { 0xbf57e489,0xbf80711b }, /* 257: -8.4333092e-01 -1.0034517e+00 */
    { 0x3f430e01,0x3f5dc54a }, /* 258:  7.6193243e-01  8.6629164e-01 */
    { 0x3e3a78e7,0x3e3b84c1 }, /* 259:  1.8210183e-01  1.8312360e-01 */
    { 0xbf279651,0xbf36b53b }, /* 260: -6.5463740e-01 -7.1370286e-01 */
    { 0x3f562b9b,0x3f7db599 }, /* 261:  8.3660287e-01  9.9105221e-01 */
    { 0xbf091524,0xbf10a8bb }, /* 262: -5.3547883e-01 -5.6507462e-01 */
    { 0xbeb33960,0xbeb71a27 }, /* 263: -3.5004711e-01 -3.5762140e-01 */
    { 0xbee2ce06,0xbeeaf744 }, /* 264: -4.4297808e-01 -4.5891774e-01 */
    { 0x3e0fa081,0x3e101a24 }, /* 265:  1.4026071e-01  1.4072472e-01 */
    { 0x3f401508,0x3f593a67 }, /* 266:  7.5032091e-01  8.4854740e-01 */
    { 0x3f40bc7c,0x3f5a3844 }, /* 267:  7.5287604e-01  8.5242105e-01 */
    { 0xbf33fc68,0xbf479acb }, /* 268: -7.0307016e-01 -7.7970570e-01 */
    { 0x3ee0d5d2,0x3ee8c577 }, /* 269:  4.3913132e-01  4.5463154e-01 */
    { 0x3ed46322,0x3edb0138 }, /* 270:  4.1481882e-01  4.2774367e-01 */
    { 0xbe75bb65,0xbe78275f }, /* 271: -2.3997267e-01 -2.4233769e-01 */
    { 0xbf119f24,0xbf1ae70e }, /* 272: -5.6883454e-01 -6.0508811e-01 */
    { 0xbf280a2d,0xbf374ea6 }, /* 273: -6.5640527e-01 -7.1604383e-01 */
    { 0xbf5321a5,0xbf78401e }, /* 274: -8.2473212e-01 -9.6972835e-01 */
    { 0x3f24e25f,0x3f332755 }, /* 275:  6.4407915e-01  6.9981891e-01 */
    { 0x3ebfb680,0x3ec48061 }, /* 276:  3.7443924e-01  3.8379195e-01 */
    { 0x3d7e38b8,0x3d7e6293 }, /* 277:  6.2065810e-02  6.2105726e-02 */
    { 0xbf15c9e3,0xbf20012c }, /* 278: -5.8511180e-01 -6.2501788e-01 */
    { 0xbe20b5b7,0xbe216082 }, /* 279: -1.5694319e-01 -1.5759471e-01 */
    { 0xbe91afff,0xbe93ba8e }, /* 280: -2.8454587e-01 -2.8853267e-01 */
    { 0xbf56b6fa,0xbf7eb4c6 }, /* 281: -8.3872950e-01 -9.9494588e-01 */
    { 0xbf6a613f,0xbf941420 }, /* 282: -9.1554636e-01 -1.1568642e+00 */
    { 0x3d1bbf8c,0x3d1bc929 }, /* 283:  3.8024470e-02  3.8033638e-02 */
    { 0xbec81155,0xbecd8b64 }, /* 284: -3.9075723e-01 -4.0145409e-01 */
    { 0xbf6f815d,0xbf9adccc }, /* 285: -9.3556768e-01 -1.2098632e+00 */
    { 0xbf73cb69,0xbfa16097 }, /* 286: -9.5232254e-01 -1.2607602e+00 */
    { 0x3f4ae081,0x3f6a3571 }, /* 287:  7.9248816e-01  9.1487795e-01 */
    { 0xbf4765e7,0xbf64959b }, /* 288: -7.7889866e-01 -8.9290780e-01 */
    { 0x3f4f4298,0x3f718860 }, /* 289:  8.0960989e-01  9.4348717e-01 */
    { 0xbcd028b1,0xbcd02e6d }, /* 290: -2.5410028e-02 -2.5412763e-02 */
    { 0xbeddf86f,0xbee59665 }, /* 291: -4.3353602e-01 -4.4841304e-01 */
    { 0x3f256e33,0x3f33de56 }, /* 292:  6.4621276e-01  7.0261133e-01 */
    { 0x3ee0d32e,0x3ee8c287 }, /* 293:  4.3911117e-01  4.5460913e-01 */
    { 0x3e5d9c62,0x3e5f60d7 }, /* 294:  2.1641687e-01  2.1814285e-01 */
    { 0xbf4bf8d0,0xbf6c032a }, /* 295: -7.9676533e-01 -9.2192328e-01 */
    { 0xbed75c92,0xbede4747 }, /* 296: -4.2062813e-01 -4.3413755e-01 */
    { 0xbd083df4,0xbd084463 }, /* 297: -3.3262208e-02 -3.3268344e-02 */
    { 0x3f74c3ab,0x3fa2ffaa }, /* 298:  9.5611066e-01  1.2734272e+00 */
    { 0xbdfd5588,0xbdfdfc12 }, /* 299: -1.2369829e-01 -1.2401594e-01 */
    { 0xbf1818f6,0xbf22dd00 }, /* 300: -5.9413087e-01 -6.3618469e-01 */
    { 0x3ebdea79,0x3ec290a3 }, /* 301:  3.7092951e-01  3.8000974e-01 */
    { 0x3f22e676,0x3f309228 }, /* 302:  6.3632905e-01  6.8973017e-01 */
    { 0xbe26e067,0xbe279fcb }, /* 303: -1.6296540e-01 -1.6369550e-01 */
    { 0x3f36eb0f,0x3f4bc2f9 }, /* 304:  7.1452421e-01  7.9594380e-01 */
    { 0x3f4fc4d1,0x3f7266c1 }, /* 305:  8.1159693e-01  9.4688040e-01 */
    { 0xbf04d5bb,0xbf0ba902 }, /* 306: -5.1888627e-01 -5.4554760e-01 */
    { 0x3db63279,0x3db67038 }, /* 307:  8.8963456e-02  8.9081228e-02 */
    { 0xbe015e90,0xbe01b74e }, /* 308: -1.2633729e-01 -1.2667581e-01 */
    { 0xbdd4fcf4,0xbdd55fb9 }, /* 309: -1.0399809e-01 -1.0418648e-01 */
    { 0x3f6e98e1,0x3f9997e6 }, /* 310:  9.3202025e-01  1.1999481e+00 */
    { 0x3f16d05d,0x3f21456b }, /* 311:  5.8911687e-01  6.2996548e-01 */
    { 0x3d6a967c,0x3d6ab75d }, /* 312:  5.7272419e-02  5.7303775e-02 */
    { 0xbf7bc85d,0xbfb1cbc2 }, /* 313: -9.8352605e-01 -1.3890307e+00 */
    { 0xbebee755,0xbec3a108 }, /* 314: -3.7285867e-01 -3.8208795e-01 */
    { 0x3f2aa0bd,0x3f3ac21d }, /* 315:  6.6651517e-01  7.2952443e-01 */
    { 0xbf6b49bb,0xbf953819 }, /* 316: -9.1909379e-01 -1.1657745e+00 */
    { 0xbea67e27,0xbea9937c }, /* 317: -3.2518122e-01 -3.3120334e-01 */
    { 0x3eeb027c,0x3ef428b4 }, /* 318:  4.5900333e-01  4.7687304e-01 */
    { 0xbf32afa2,0xbf45c879 }, /* 319: -6.9799244e-01 -7.7259022e-01 */
    { 0xbf03fc7b,0xbf0aab2a }, /* 320: -5.1557130e-01 -5.4167426e-01 */
    { 0xbf110007,0xbf1a25ca }, /* 321: -5.6640667e-01 -6.0213912e-01 */
    { 0xbe06af63,0xbe071395 }, /* 322: -1.3152842e-01 -1.3191064e-01 */
    { 0xbf5e8e48,0xbf86e64a }, /* 323: -8.6935854e-01 -1.0539029e+00 */
    { 0x3f5f698f,0x3f87c57c }, /* 324:  8.7270445e-01  1.0607142e+00 */
    { 0xbf6a44c0,0xbf93f0bf }, /* 325: -9.1511154e-01 -1.1557845e+00 */
    { 0xbf2a8718,0xbf3a9fb9 }, /* 326: -6.6612387e-01 -7.2899967e-01 */
    { 0xbf0c44ba,0xbf147307 }, /* 327: -5.4792368e-01 -5.7988018e-01 */
    { 0x3d537609,0x3d538e1c }, /* 328:  5.1626239e-02  5.1649198e-02 */
    { 0xbf35c36d,0xbf4a1dc9 }, /* 329: -7.1001321e-01 -7.8951699e-01 */
    { 0x3ea8212b,0x3eab4ed7 }, /* 330:  3.2837805e-01  3.3458588e-01 */
    { 0x3eea3cd4,0x3ef34a53 }, /* 331:  4.5749533e-01  4.7517642e-01 */
    { 0x3f2931d0,0x3f38d78e }, /* 332:  6.6091633e-01  7.2203910e-01 */
    { 0xbd108f4d,0xbd1096fd }, /* 333: -3.5292912e-02 -3.5300244e-02 */
    { 0xbf3499b0,0xbf487856 }, /* 334: -7.0547009e-01 -7.8308618e-01 */
    { 0x3ec039bf,0x3ec50df4 }, /* 335:  3.7544057e-01  3.8487208e-01 */
    { 0xbe651091,0xbe6704fb }, /* 336: -2.2369601e-01 -2.2560494e-01 */
    { 0xbe65bdaa,0xbe67b698 }, /* 337: -2.2435632e-01 -2.2628248e-01 */
    { 0xbf091cd2,0xbf10b1d3 }, /* 338: -5.3559601e-01 -5.6521338e-01 */
    { 0x3f266438,0x3f352162 }, /* 339:  6.4996672e-01  7.0754063e-01 */
    { 0x3f2bf0f7,0x3f3c8687 }, /* 340:  6.7164558e-01  7.3642772e-01 */
    { 0xbf1a83f0,0xbf25e1e7 }, /* 341: -6.0357571e-01 -6.4797825e-01 */
    { 0x3e74d252,0x3e77374f }, /* 342:  2.3908356e-01  2.4142192e-01 */
    { 0xbe8acb43,0xbe8c8d7d }, /* 343: -2.7108201e-01 -2.7451697e-01 */
    { 0xbf164c4e,0xbf20a223 }, /* 344: -5.8710182e-01 -6.2747401e-01 */
    { 0x3f5dc0ea,0x3f8617a6 }, /* 345:  8.6622488e-01  1.0475967e+00 */
    { 0xbf1ac4e4,0xbf263369 }, /* 346: -6.0456681e-01 -6.4922196e-01 */
    { 0xbf019608,0xbf07e064 }, /* 347: -5.0619555e-01 -5.3076768e-01 */
    { 0xbeeafc53,0xbef421c5 }, /* 348: -4.5895633e-01 -4.7682014e-01 */
    { 0x3f5abc5a,0x3f8321ae }, /* 349:  8.5443652e-01  1.0244653e+00 */
    { 0xbe5116a8,0xbe5291c2 }, /* 350: -2.0418799e-01 -2.0563415e-01 */
    { 0x3cd0ab63,0x3cd0b12a }, /* 351:  2.5472349e-02  2.5475103e-02 */
    { 0xbf3643ad,0xbf4ad42a }, /* 352: -7.1197015e-01 -7.9229987e-01 */
    { 0x3f2a0e7d,0x3f39fe32 }, /* 353:  6.6428357e-01  7.2653496e-01 */
    { 0x3e1fdc4c,0x3e208461 }, /* 354:  1.5611380e-01  1.5675499e-01 */
    { 0xbf56da1e,0xbf7ef55b }, /* 355: -8.3926570e-01 -9.9593133e-01 */
    { 0x3f3fc9bd,0x3f58c89e }, /* 356:  7.4917203e-01  8.4681118e-01 */
    { 0x3efadff6,0x3f03178f }, /* 357:  4.8998994e-01  5.1207823e-01 */
    { 0xbec63daf,0xbecb8fc4 }, /* 358: -3.8718936e-01 -3.9758122e-01 */
    { 0xbe4bfb89,0xbe4d5b35 }, /* 359: -1.9920172e-01 -2.0054324e-01 */
    { 0x3f47ac8e,0x3f650662 }, /* 360:  7.7997673e-01  8.9462864e-01 */
    { 0x3f70f1be,0x3f9cf1df }, /* 361:  9.4118869e-01  1.2261313e+00 */
    { 0xbf3de078,0xbf55ea98 }, /* 362: -7.4170637e-01 -8.3561087e-01 */
    { 0x3ee1bcbc,0x3ee9c69d }, /* 363:  4.4089305e-01  4.5659342e-01 */
    { 0xbdc0b9b5,0xbdc102d1 }, /* 364: -9.4104208e-02 -9.4243653e-02 */
    { 0xbee4f450,0xbeed5dc7 }, /* 365: -4.4717646e-01 -4.6360609e-01 */
    { 0xbe3c130b,0xbe3d25ee }, /* 366: -1.8366639e-01 -1.8471500e-01 */
    { 0x3f2ea4a5,0x3f403244 }, /* 367:  6.8219978e-01  7.5076699e-01 */
    { 0x3ea82cdb,0x3eab5b37 }, /* 368:  3.2846722e-01  3.3468029e-01 */
    { 0x3e8fbcd8,0x3e91b22f }, /* 369:  2.8073764e-01  2.8456256e-01 */
    { 0x3eaa11ba,0x3ead5cec }, /* 370:  3.3216649e-01  3.3859956e-01 */
    { 0x38ec9240,0x38ec9240 }, /* 371:  1.1280598e-04  1.1280598e-04 */
    { 0x3f2d5a7c,0x3f3e7027 }, /* 372:  6.7716193e-01  7.4389881e-01 */
    { 0xbedb851d,0xbee2df23 }, /* 373: -4.2874995e-01 -4.4310865e-01 */
    { 0x3f3aa1c3,0x3f5120ae }, /* 374:  7.2903079e-01  8.1690490e-01 */
    { 0xbf68f1d2,0xbf925262 }, /* 375: -9.0993989e-01 -1.1431391e+00 */
    { 0xbf1001a5,0xbf18f19e }, /* 376: -5.6252509e-01 -5.9743679e-01 */
    { 0xbf602321,0xbf888485 }, /* 377: -8.7553602e-01 -1.0665442e+00 */
    { 0xbed50fb5,0xbedbbef2 }, /* 378: -4.1613546e-01 -4.2919117e-01 */
    { 0xbcaff9c6,0xbcaffd3d }, /* 379: -2.1481406e-02 -2.1483058e-02 */
    { 0x3f7a993a,0x3faeb8a3 }, /* 380:  9.7890055e-01  1.3650097e+00 */
    { 0x3ec264f7,0x3ec7658d }, /* 381:  3.7967655e-01  3.8944665e-01 */
    { 0xbf7efa73,0xbfbd9f57 }, /* 382: -9.9600905e-01 -1.4814252e+00 */
    { 0xbf3baa74,0xbf52a49c }, /* 383: -7.3306966e-01 -8.2282424e-01 */
    { 0x3d340f8d,0x3d341e69 }, /* 384:  4.3960143e-02  4.3974314e-02 */
    { 0x3e23f280,0x3e24a7e9 }, /* 385:  1.6010475e-01  1.6079678e-01 */
    { 0xbf128491,0xbf1bfe6c }, /* 386: -5.7233530e-01 -6.0935092e-01 */
    { 0xbe53d528,0xbe555f95 }, /* 387: -2.0686781e-01 -2.0837243e-01 */
    { 0xbeb326cb,0xbeb70651 }, /* 388: -3.4990534e-01 -3.5747007e-01 */
    { 0x3d25c976,0x3d25d50f }, /* 389:  4.0475331e-02  4.0486392e-02 */
    { 0x3f180bd4,0x3f22ccad }, /* 390:  5.9393048e-01  6.3593560e-01 */
    { 0xbf11e6d7,0xbf1b3e46 }, /* 391: -5.6992859e-01 -6.0641897e-01 */
    { 0xbc96354d,0xbc963775 }, /* 392: -1.8335963e-02 -1.8336991e-02 */
    { 0x3f5a2b5b,0x3f8296a0 }, /* 393:  8.5222405e-01  1.0202217e+00 */
    { 0x3f5ef787,0x3f875114 }, /* 394:  8.7096447e-01  1.0571618e+00 */
    { 0x3f63371f,0x3f8bc759 }, /* 395:  8.8755983e-01  1.0920211e+00 */
    { 0xbf184ecc,0xbf231ff5 }, /* 396: -5.9495234e-01 -6.3720638e-01 */
    { 0xbea01a78,0xbea2d5a7 }, /* 397: -3.1270194e-01 -3.1803629e-01 */
    { 0x3f11dbc4,0x3f1b30cc }, /* 398:  5.6975961e-01  6.0621333e-01 */
    { 0x3f3bc7a1,0x3f52cf85 }, /* 399:  7.3351485e-01  8.2347900e-01 */
    { 0x3f77d130,0x3fa89c87 }, /* 400:  9.6803570e-01  1.3172768e+00 */
    { 0xbdc8daf6,0xbdc92dc0 }, /* 401: -9.8073885e-02 -9.8231792e-02 */
    { 0xbe8861f4,0xbe8a0c9a }, /* 402: -2.6637232e-01 -2.6962739e-01 */
    { 0x3f252bab,0x3f338735 }, /* 403:  6.4519757e-01  7.0128185e-01 */
    { 0x3ef24426,0x3efc5c6c }, /* 404:  4.7317618e-01  4.9289262e-01 */
    { 0xbf098f37,0xbf113960 }, /* 405: -5.3734154e-01 -5.6728172e-01 */
    { 0x3f3c39d9,0x3f5377cd }, /* 406:  7.3525769e-01  8.2604676e-01 */
    { 0x3f69206e,0x3f928aae }, /* 407:  9.1065109e-01  1.1448572e+00 */
    { 0xbed364af,0xbed9e9b6 }, /* 408: -4.1287753e-01 -4.2561120e-01 */
    { 0xbf2e4e01,0xbf3fbbdf }, /* 409: -6.8087775e-01 -7.4896044e-01 */
    { 0xbde2fafe,0xbde3729d }, /* 410: -1.1083029e-01 -1.1105845e-01 */
    { 0xbede323c,0xbee5d68c }, /* 411: -4.3397701e-01 -4.4890249e-01 */
    { 0x3f32e47a,0x3f46124e }, /* 412:  6.9879878e-01  7.7371681e-01 */
    { 0xbddace97,0xbddb39b5 }, /* 413: -1.0683935e-01 -1.0704366e-01 */
    { 0xbe2b0e46,0xbe2bdc88 }, /* 414: -1.6704664e-01 -1.6783345e-01 */
    { 0xbe83b51a,0xbe85347e }, /* 415: -2.5724107e-01 -2.6016611e-01 */
    { 0xbf725d33,0xbf9f18a3 }, /* 416: -9.4673461e-01 -1.2429394e+00 */
    { 0x3e856fba,0x3e86febf }, /* 417:  2.6061803e-01  2.6366231e-01 */
    { 0x3f093029,0x3f10c8ba }, /* 418:  5.3589112e-01  5.6556284e-01 */
    { 0xbe97e130,0xbe9a3341 }, /* 419: -2.9663992e-01 -3.0117229e-01 */
    { 0xbf32eb8c,0xbf461c31 }, /* 420: -6.9890666e-01 -7.7386767e-01 */
    { 0x3e04eff3,0x3e055046 }, /* 421:  1.2982158e-01  1.3018903e-01 */
    { 0x3e08a242,0x3e090ae4 }, /* 422:  1.3343146e-01  1.3383061e-01 */
    { 0x3e90c594,0x3e92c619 }, /* 423:  2.8275740e-01  2.8666762e-01 */
    { 0xbc9314fd,0xbc931703 }, /* 424: -1.7954344e-02 -1.7955309e-02 */
    { 0x3b900ba3,0x3b900bc1 }, /* 425:  4.3959185e-03  4.3959324e-03 */
    { 0x3e2e67a4,0x3e2f425d }, /* 426:  1.7031723e-01  1.7115159e-01 */
    { 0x3ec63118,0x3ecb821c }, /* 427:  3.8709331e-01  3.9747703e-01 */
    { 0x3f3112db,0x3f438a7f }, /* 428:  6.9169396e-01  7.6383203e-01 */
    { 0xbe8514a6,0xbe86a06b }, /* 429: -2.5992316e-01 -2.6294264e-01 */
    { 0x3df70168,0x3df79bb9 }, /* 430:  1.2060815e-01  1.2090249e-01 */
    { 0x3f28e40b,0x3f387000 }, /* 431:  6.5972966e-01  7.2045898e-01 */
    { 0x3f245a4e,0x3f3275a9 }, /* 432:  6.4200294e-01  6.9710785e-01 */
    { 0x3f5aaf33,0x3f831507 }, /* 433:  8.5423583e-01  1.0240792e+00 */
    { 0x3e9c1f6d,0x3e9ea63d }, /* 434:  3.0492726e-01  3.0986205e-01 */
    { 0x3debe30b,0x3dec695d }, /* 435:  1.1517914e-01  1.1543534e-01 */
    { 0xbf2ee004,0xbf408384 }, /* 436: -6.8310571e-01 -7.5200677e-01 */
    { 0x3d2498ff,0x3d24a458 }, /* 437:  4.0184971e-02  4.0195793e-02 */
    { 0x3cd399fa,0x3cd3a001 }, /* 438:  2.5830258e-02  2.5833132e-02 */
    { 0xbdc492dc,0xbdc4e073 }, /* 439: -9.5983237e-02 -9.6131228e-02 */
    { 0x3eb7f71e,0x3ebc2c4b }, /* 440:  3.5930723e-01  3.6752543e-01 */
    { 0x3f6a3d70,0x3f93e7ae }, /* 441:  9.1499996e-01  1.1555078e+00 */
    { 0x3ef0a90d,0x3efa8a39 }, /* 442:  4.7003976e-01  4.8933581e-01 */
    { 0x3d6e0093,0x3d6e22e9 }, /* 443:  5.8106016e-02  5.8138762e-02 */
    { 0xbe44718b,0xbe45ab3a }, /* 444: -1.9183938e-01 -1.9303599e-01 */
    { 0xbf326f0b,0xbf456e56 }, /* 445: -6.9700688e-01 -7.7121484e-01 */
    { 0x3f4d057c,0x3f6dc1c9 }, /* 446:  8.0086493e-01  9.2873818e-01 */
    { 0xbe0de657,0xbe0e5b9e }, /* 447: -1.3857399e-01 -1.3902137e-01 */
    { 0x3f1048d2,0x3f1947be }, /* 448:  5.6361115e-01  5.9875095e-01 */
    { 0x3eac6b4b,0x3eafdb40 }, /* 449:  3.3675608e-01  3.4346962e-01 */
    { 0x3f1095d2,0x3f19a501 }, /* 450:  5.6478608e-01  6.0017401e-01 */
    { 0x3f5d5d46,0x3f85b433 }, /* 451:  8.6470449e-01  1.0445617e+00 */
    { 0xbf088e5e,0xbf100946 }, /* 452: -5.3342235e-01 -5.6264150e-01 */
    { 0xbe9a833b,0xbe9cf5a9 }, /* 453: -3.0178246e-01 -3.0656174e-01 */
    { 0x3e170042,0x3e178dbe }, /* 454:  1.4746192e-01  1.4800164e-01 */
    { 0x3ee5b1f5,0x3eee31e3 }, /* 455:  4.4862333e-01  4.6522436e-01 */
    { 0x3f33de7a,0x3f4770b8 }, /* 456:  7.0261347e-01  7.7906370e-01 */
    { 0xbf2ea607,0xbf403429 }, /* 457: -6.8222088e-01 -7.5079590e-01 */
    { 0xbe2839e7,0xbe28fe03 }, /* 458: -1.6428338e-01 -1.6503148e-01 */
    { 0x3ec9e2aa,0x3ecf8555 }, /* 459:  3.9430743e-01  4.0531412e-01 */
    { 0x3d6cfa6a,0x3d6d1c4f }, /* 460:  5.7856001e-02  5.7888325e-02 */
    { 0x3f74d1b3,0x3fa317a2 }, /* 461:  9.5632476e-01  1.2741587e+00 */
    { 0x3d5d5604,0x3d5d71a1 }, /* 462:  5.4037109e-02  5.4063443e-02 */
    { 0xbe99ac16,0xbe9c140e }, /* 463: -3.0014104e-01 -3.0484051e-01 */
    { 0x3f4f80e6,0x3f71f2a4 }, /* 464:  8.1056058e-01  9.4510865e-01 */
    { 0xbf241ae9,0xbf322304 }, /* 465: -6.4103562e-01 -6.9584680e-01 */
    { 0x3f50a656,0x3f73ea5e }, /* 466:  8.1503808e-01  9.5279491e-01 */
    { 0xbf5f5f1e,0xbf87bacc }, /* 467: -8.7254512e-01 -1.0603881e+00 */
    { 0x3ecc5d4d,0x3ed238b4 }, /* 468:  3.9914933e-01  4.1058886e-01 */
    { 0xbe22f367,0xbe23a580 }, /* 469: -1.5913163e-01 -1.5981102e-01 */
    { 0x3d00e86c,0x3d00eddf }, /* 470:  3.1471655e-02  3.1476852e-02 */
    { 0xbe77572a,0xbe79cf9f }, /* 471: -2.4154344e-01 -2.4395607e-01 */
    { 0xbe79fda7,0xbe7c8b0c }, /* 472: -2.4413167e-01 -2.4662417e-01 */
    { 0xbeff39e5,0xbf059840 }, /* 473: -4.9848858e-01 -5.2185440e-01 */
    { 0x3f510a3f,0x3f749720 }, /* 474:  8.1656259e-01  9.5543098e-01 */
    { 0x3f106434,0x3f1968e6 }, /* 475:  5.6402898e-01  5.9925687e-01 */
    { 0xbe482ff7,0xbe497c26 }, /* 476: -1.9549547e-01 -1.9676265e-01 */
    { 0x3f1e0fbb,0x3f2a5c20 }, /* 477:  6.1742753e-01  6.6546822e-01 */
    { 0xbf131562,0xbf1caf30 }, /* 478: -5.7454503e-01 -6.1204815e-01 */
    { 0xbf21c32c,0xbf2f1972 }, /* 479: -6.3188434e-01 -6.8398201e-01 */
    { 0xbd3ba9f3,0xbd3bbac6 }, /* 480: -4.5816373e-02 -4.5832418e-02 */
    { 0x3f7d8070,0x3fb72a39 }, /* 481:  9.9024105e-01  1.4309760e+00 */
    { 0xbf4465e6,0xbf5fdad5 }, /* 482: -7.6717985e-01 -8.7443286e-01 */
    { 0x3ed76e06,0x3ede5a85 }, /* 483:  4.2076129e-01  4.3428436e-01 */
    { 0xbe9f825b,0xbea2358b }, /* 484: -3.1154141e-01 -3.1681475e-01 */
    { 0x3ec2b456,0x3ec7bb5b }, /* 485:  3.8028210e-01  3.9010128e-01 */
    { 0xbe05c00a,0xbe062227 }, /* 486: -1.3061538e-01 -1.3098966e-01 */
    { 0xbf1be2b4,0xbf279af8 }, /* 487: -6.0892797e-01 -6.5470839e-01 */
    { 0x3f32b424,0x3f45cec4 }, /* 488:  6.9806123e-01  7.7268624e-01 */
    { 0x3f348184,0x3f48563e }, /* 489:  7.0510125e-01  7.8256595e-01 */
    { 0x3f490ea1,0x3f673f41 }, /* 490:  7.8537947e-01  9.0330893e-01 */
    { 0xbe79f0d4,0xbe7c7dd2 }, /* 491: -2.4408275e-01 -2.4657372e-01 */
    { 0x3f295337,0x3f390414 }, /* 492:  6.6142601e-01  7.2271848e-01 */
    { 0xbe246ffa,0xbe252708 }, /* 493: -1.6058341e-01 -1.6128170e-01 */
    { 0x3ee95b80,0x3ef24d0c }, /* 494:  4.5577621e-01  4.7324407e-01 */
    { 0x3ef1a83a,0x3efbab80 }, /* 495:  4.7198659e-01  4.9154282e-01 */
    { 0x3e4b2461,0x3e4c7fac }, /* 496:  1.9838096e-01  1.9970578e-01 */
    { 0x3e8aa82d,0x3e8c690a }, /* 497:  2.7081433e-01  2.7423888e-01 */
    { 0x3f1974ff,0x3f248ebf }, /* 498:  5.9944147e-01  6.4280313e-01 */
    { 0xbece1082,0xbed413bd }, /* 499: -4.0246969e-01 -4.1421309e-01 */
    { 0xbf6368c3,0xbf8bfd4f }, /* 500: -8.8831729e-01 -1.0936679e+00 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = asin (x.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 7) x_exit (i+1);
    }
    return 0;
}
