/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.col;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import yuku.alkitabconverter.col.ColProses;
import yuku.alkitabconverter.util.Rec;
import yuku.alkitabconverter.yes1.Yes1File;

public class CuvColProses {
    static int edisi_index = -1;
    static final Charset ascii = Charset.forName("ascii");
    static final Charset utf8 = Charset.forName("utf-8");

    static String getKodeEdisi() {
        return (new String[]{"cuvs", "cuvt"})[edisi_index];
    }

    static String getShortTitleEdisi() {
        return (new String[]{"CUVS", "CUVT"})[edisi_index];
    }

    static String getJudulEdisi() {
        return (new String[]{"Chinese Union Version (Simplified)", "Chinese Union Version (Traditional)"})[edisi_index];
    }

    static String getKeteranganEdisi() {
        return "Public domain.";
    }

    private static String getTeksCol() {
        return "../Alkitab/publikasi/" + CuvColProses.getKodeEdisi() + "_teks_col.txt";
    }

    private static String getYesOutput() {
        return "../Alkitab/publikasi/" + CuvColProses.getKodeEdisi() + ".yes";
    }

    public static void main(String[] args) throws Exception {
        edisi_index = Integer.parseInt(args[0]);
        ArrayList<Rec> xrec = new ColProses().parse(CuvColProses.getTeksCol());
        final Yes1File.InfoEdisi infoEdisi = CuvColProses.infoEdisi();
        final Yes1File.InfoKitab infoKitab = CuvColProses.infoKitab(xrec);
        final Yes1File.Teks teks = CuvColProses.teks(xrec);
        Yes1File file = new Yes1File(){
            {
                this.xseksi = new Yes1File.Seksi[]{new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "infoEdisi___".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return infoEdisi;
                    }
                }, new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "infoKitab___".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return infoKitab;
                    }
                }, new Yes1File.Seksi(){

                    @Override
                    public byte[] nama() {
                        return "teks________".getBytes(ascii);
                    }

                    @Override
                    public Yes1File.IsiSeksi isi() {
                        return teks;
                    }
                }};
            }
        };
        file.output(new RandomAccessFile(CuvColProses.getYesOutput(), "rw"));
    }

    private static Yes1File.Teks teks(ArrayList<Rec> xrec) {
        final ArrayList<String> ss = new ArrayList<String>();
        for (Rec rec : xrec) {
            ss.add(rec.text);
        }
        return new Yes1File.Teks("utf-8"){
            {
                super(encoding);
                this.xisi = ss.toArray(new String[ss.size()]);
            }
        };
    }

    private static Yes1File.InfoEdisi infoEdisi() {
        return new Yes1File.InfoEdisi(){
            {
                this.versi = 1;
                this.nama = CuvColProses.getKodeEdisi();
                this.shortName = CuvColProses.getShortTitleEdisi();
                this.longName = CuvColProses.getJudulEdisi();
                this.keterangan = CuvColProses.getKeteranganEdisi();
                this.nkitab = 66;
                this.perikopAda = 0;
                this.encoding = 2;
            }
        };
    }

    private static Yes1File.InfoKitab infoKitab(ArrayList<Rec> xrec) throws Exception {
        final Yes1File.Kitab[] xkitab_ = new Yes1File.Kitab[66];
        String[] xjudul = new String[66];
        String[] xnama = new String[66];
        int p = 0;
        Scanner sc = new Scanner(new File("../Alkitab/publikasi/" + CuvColProses.getKodeEdisi() + "_kitab.txt"));
        while (sc.hasNextLine()) {
            String judul = sc.nextLine().trim();
            if (judul.length() <= 0) continue;
            xjudul[p] = judul;
            xnama[p] = judul.replaceAll(" ", "_");
            ++p;
        }
        sc.close();
        int offsetTotal = 0;
        int offsetLewat = 0;
        int maxpasal_1 = 1;
        int lastpasal_1 = 1;
        int[] xnayat = new int[256];
        int[] xpasal_offset = new int[256];
        for (int kitabPos = 0; kitabPos < 66; ++kitabPos) {
            xpasal_offset[0] = 0;
            for (Rec rec : xrec) {
                if (kitabPos + 1 != rec.book_1) continue;
                int n = rec.chapter_1 - 1;
                xnayat[n] = xnayat[n] + 1;
                if (rec.chapter_1 > maxpasal_1) {
                    maxpasal_1 = rec.chapter_1;
                }
                if (rec.chapter_1 != lastpasal_1) {
                    xpasal_offset[lastpasal_1] = offsetLewat;
                    lastpasal_1 = rec.chapter_1;
                }
                offsetLewat += rec.text.getBytes(utf8).length + 1;
            }
            xpasal_offset[maxpasal_1] = offsetLewat;
            Yes1File.Kitab kitab = new Yes1File.Kitab();
            kitab.versi = 1;
            kitab.pos = kitabPos;
            kitab.nama = xnama[kitabPos];
            kitab.judul = xjudul[kitabPos];
            kitab.npasal = maxpasal_1;
            kitab.nayat = new int[kitab.npasal];
            System.arraycopy(xnayat, 0, kitab.nayat, 0, kitab.npasal);
            System.out.println("kitab " + kitab.judul + " nayat: " + Arrays.toString(kitab.nayat));
            kitab.ayatLoncat = 0;
            kitab.pasal_offset = new int[kitab.npasal + 1];
            System.arraycopy(xpasal_offset, 0, kitab.pasal_offset, 0, kitab.npasal + 1);
            System.out.println("kitab " + kitab.judul + " pasal_offset: " + Arrays.toString(kitab.pasal_offset));
            kitab.encoding = 1;
            kitab.offset = offsetTotal;
            System.out.println("kitab " + kitab.judul + " offset: " + kitab.offset);
            xkitab_[kitabPos] = kitab;
            offsetTotal += offsetLewat;
            offsetLewat = 0;
            for (int i = 0; i < xnayat.length; ++i) {
                xnayat[i] = 0;
            }
            maxpasal_1 = 1;
            lastpasal_1 = 0;
        }
        return new Yes1File.InfoKitab(){
            {
                this.xkitab = xkitab_;
            }
        };
    }
}

