#include "Bdef.h"


#if (INTFACE == C_CALL)
void Ccgesd2d(ConTxt, m, n, A, lda, rdest, cdest)
int  ConTxt;
int  m;
int  n;
float  *A;
int  lda;
int  rdest;
int  cdest;
#else
void cgesd2d_(ConTxt, m, n, A, lda, rdest, cdest)
int  *ConTxt;
int  *m;
int  *n;
float  *A;
int  *lda;
int  *rdest;
int  *cdest;
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Locally-blocking point-to-point general complex send.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (input) Ptr to complex two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *  RDEST   (input) Ptr to int
 *          The process row of the destination process.
 *
 *  CDEST   (input) Ptr to int
 *          The process column of the destination process.
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
   void cpack00();
   void Ssend2dID();

   int tlda;
   BLACSCONTEXT *ctxt;

   MGetConTxt(Mpval(ConTxt), ctxt);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_SD, __FILE__, 'a', 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rdest), Mpaddress(cdest));
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);

   cpack00(Mpval(m), Mpval(n), (SCOMPLEX *) A, tlda);
   Ssend2dID(ctxt, Mpval(rdest), Mpval(cdest));
}  /* end of cgesd2d_ */
