//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Tool/ItemDelegateForHTML.h
//! @brief     Defines class ItemDelegateForHTML
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_TOOL_ITEMDELEGATEFORHTML_H
#define BORNAGAIN_GUI_VIEW_TOOL_ITEMDELEGATEFORHTML_H

#include <QStyledItemDelegate>

//! For representing HTML text in an item */
class ItemDelegateForHTML : public QStyledItemDelegate {
    Q_OBJECT
public:
    ItemDelegateForHTML(QObject* parent);

    QString anchorAtGlobalPos(QAbstractItemView* view, const QModelIndex& index,
                              const QPoint& globalPos) const;

protected:
    void paint(QPainter* painter, const QStyleOptionViewItem& option,
               const QModelIndex& index) const override;
    QSize sizeHint(const QStyleOptionViewItem& option, const QModelIndex& index) const override;
};


#endif // BORNAGAIN_GUI_VIEW_TOOL_ITEMDELEGATEFORHTML_H
