//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Widget/ItemComboWidget.h
//! @brief     Defines class ItemComboWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_WIDGET_ITEMCOMBOWIDGET_H
#define BORNAGAIN_GUI_VIEW_WIDGET_ITEMCOMBOWIDGET_H

#include "Base/Util/IFactory.h"
#include "GUI/View/Common/DataAccessWidget.h"
#include <QMap>
#include <QStackedWidget>

class ItemComboToolbar;

//! The ItemComboWidget class combines stack of widgets with QComboBox controller to switch between
//! widgets. It is used in the case when corresponding item can be presented with different widgets.

//! For example, in JobDatafieldWidget the results of the job can be presented with either
//! IntensityDataWidget or FitDataWidget, depending from the JobView's activity type.

//! For the presentation the special value of an empty string can be used which results in an
//! empty widget being shown (with the toolbar hidden). In this case the current item can also
//! be \c nullptr and this presentation needs not to be listed in the (active)PresentationList
//! functions.

class ItemComboWidget : public DataAccessWidget {
    Q_OBJECT

public:
    using factory_function_t = std::function<DataAccessWidget*()>;

    explicit ItemComboWidget(QWidget* parent = nullptr);

    void registerWidget(const QString& presentationType, factory_function_t);

    virtual void setPresentation(const QString& presentationType);

    void setToolbarVisible(bool value);

    void setJobOrRealItem(QObject* job_or_real_item) override;

protected:
    virtual QStringList activePresentationList() const;
    virtual QStringList presentationList() const;
    virtual QString itemPresentation() const;
    QString selectedPresentation() const;

private slots:
    void onComboChanged(const QString& name);

private:
    void setSizeToCurrentWidget();

    ItemComboToolbar* m_toolbar;
    QStackedWidget* m_stackedWidget;
    IFactory<QString, DataAccessWidget> m_widgetFactory;
    QMap<QString, DataAccessWidget*> m_presentationTypeToWidget;
    QWidget* m_blankWidget;
};

#endif // BORNAGAIN_GUI_VIEW_WIDGET_ITEMCOMBOWIDGET_H
