#!/bin/sh
# Sometimes, by the time we get around to packaging cargo, the crates.io
# ecosystem has moved on from the versions that cargo-vendor *would have* used
# when that version of cargo was released. This places a lot of maintenance
# burden on us, since it requires us to keep debcargo-conf always up-to-date.
#
# This script allows us to force cargo-vendor to use old versions of dependency
# crates, that better match our debcargo-conf patches, as well as the versions
# of crates used when a particular version of cargo was actually released.
#
# Example:
# cargo update -p filetime --precise 0.2.12
#

# Drop the "vendored" feature since we patch it out of debcargo
sed -i /vendored/d Cargo.toml

# avoid pulling in windows-sys for now
cargo update -p schannel --precise 0.1.19

# pin the dependencies as Debian intended
cargo update -p ignore --precise 0.4.19
cargo update -p regex --precise 1.7.0
cargo update -p proc-macro2 --precise 1.0.49
cargo update -p termcolor --precise 1.1.3
cargo update -p git2 --precise 0.16.0
cargo update -p libgit2-sys --precise 0.14.1+1.5.0
cargo update -p unicode-bidi --precise 0.3.8
