DACS_VFS(8)                DACS Web Services Manual                DACS_VFS(8)



[1mNAME[0m
       dacs_vfs - access objects through the [1mDACS [22mvirtual filestore

[1mSYNOPSIS[0m
       [1mdacs_vfs [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       The [1mdacs_vfs [22mweb service is an interface to the [1mDACS [22mvirtual filestore.
       It provides a way to examine, change, and delete items independently of
       how and where they are stored.

       This program is also available as a [1mDACS [22mutility, [34m[1mdacsvfs(1)[0m[1m[22m[2].

           [1mSecurity[0m
           Only the [1mDACS [22madministrator should be able to successfully run this
           program; therefore, access to it is totally denied by the default
           rules as a security precaution.

[1mOPTIONS[0m
   [1mWeb Service Arguments[0m
       In addition to the [34m[1mstandard CGI arguments[0m[1m[22m[3], [1mdacs_vfs [22mrequires the
       following CGI arguments:

       [4mITEM_TYPE[0m
           This is the [1mDACS [22mitem type, as configured in dacs.conf
           ([34m[1mdacs.conf(5)[0m[1m[22m[4]), to which the request is to be applied. As a
           special case, if the value of this argument is the word "enabled",
           a list of enabled storage methods is displayed.

       [4mREQUEST[0m
           The value of this argument is the name of an operation followed by
           zero or more arguments. The syntax is identical to that of
           [34m[1mdacsvfs(1)[0m[1m[22m[2], except that the edit, update, and help operations
           are unavailable. For the put operation, the value to store is taken
           from the [4mVALUE[24m argument.

       [4mVALUE[0m
           The object to use for the put and load operations.

       [4mFIELD_SEP[0m
           The field separator character to use for the load and dump
           operations.

[1mEXAMPLES[0m
       The following examples assume that the web service requests are
       granted.

       This request will return the revocation list:

           https://example.com/cgi-bin/dacs/dacs_vfs?REQUEST=get&ITEM_TYPE=revocations

       Assuming the jurisdiction is configured appropriately, the following
       request will return the roles associated with DEMO::EXAMPLE:jones:

           https://demo.example.com/cgi-bin/dacs/dacs_vfs?REQUEST=get+jones&ITEM_TYPE=roles

       If the jurisdiction is configured with the directives:

           LOG_FILE "${Conf::DACS_HOME}/logs/dacs_log-" . strftime("%d-%b-%y")
           VFS "[logfile]dacs-fs:${Conf::DACS_HOME}/logs/dacs_log-" . strftime("%d-%b-%y")

       then the following request will return the contents of the
       jurisdiction's [1mDACS [22mlog file:

           https://demo.example.com/cgi-bin/dacs/dacs_vfs?REQUEST=get&ITEM_TYPE=logfile


           [1mSecurity[0m
           The logfile item type is not something predefined by [1mDACS[22m; new (not
           predefined) item types can be created at will and that is what was
           done for this example. Since logfiles can potentially include
           sensitive information, as can other resources used by [1mDACS[22m, it
           should be obvious why access to this web service should be very
           carefully managed.

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred. If
       an error occurs during processing, this web service will return an HTTP
       Status of 400, followed by a blank line which is optionally followed by
       a descriptive error message.

[1mBUGS[0m
       Only the text/plain output format is implemented.

[1mSEE ALSO[0m
       [34m[1mdacsvfs(1)[0m[1m[22m[2], [34m[1mdacs.conf(5)[0m[1m[22m[5]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[6])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[7] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

        3. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

        4. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

        5. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

        6. www.dss.ca
           http://www.dss.ca

        7. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                       DACS_VFS(8)
