info = {
    "name": "zh-Hant",
    "date_order": "YMD",
    "january": [
        "1月"
    ],
    "february": [
        "2月"
    ],
    "march": [
        "3月"
    ],
    "april": [
        "4月"
    ],
    "may": [
        "5月"
    ],
    "june": [
        "6月"
    ],
    "july": [
        "7月"
    ],
    "august": [
        "8月"
    ],
    "september": [
        "9月"
    ],
    "october": [
        "10月"
    ],
    "november": [
        "11月"
    ],
    "december": [
        "12月"
    ],
    "monday": [
        "星期一",
        "週一"
    ],
    "tuesday": [
        "星期二",
        "週二"
    ],
    "wednesday": [
        "星期三",
        "週三"
    ],
    "thursday": [
        "星期四",
        "週四"
    ],
    "friday": [
        "星期五",
        "週五"
    ],
    "saturday": [
        "星期六",
        "週六"
    ],
    "sunday": [
        "星期日",
        "週日"
    ],
    "am": [
        "上午"
    ],
    "pm": [
        "下午"
    ],
    "year": [
        "年"
    ],
    "month": [
        "月"
    ],
    "week": [
        "週"
    ],
    "day": [
        "日"
    ],
    "hour": [
        "小時"
    ],
    "minute": [
        "分鐘"
    ],
    "second": [
        "秒"
    ],
    "relative-type": {
        "0 day ago": [
            "今天"
        ],
        "0 hour ago": [
            "這一小時"
        ],
        "0 minute ago": [
            "這一分鐘"
        ],
        "0 month ago": [
            "本月"
        ],
        "0 second ago": [
            "現在"
        ],
        "0 week ago": [
            "本週"
        ],
        "0 year ago": [
            "今年"
        ],
        "1 day ago": [
            "昨天"
        ],
        "1 month ago": [
            "上個月"
        ],
        "1 week ago": [
            "上週"
        ],
        "1 year ago": [
            "去年"
        ],
        "in 1 day": [
            "明天"
        ],
        "in 1 month": [
            "下個月"
        ],
        "in 1 week": [
            "下週"
        ],
        "in 1 year": [
            "明年"
        ]
    },
    "relative-type-regex": {
        "\\1 day ago": [
            "(\\d+) 天前"
        ],
        "\\1 hour ago": [
            "(\\d+) 小時前"
        ],
        "\\1 minute ago": [
            "(\\d+) 分鐘前"
        ],
        "\\1 month ago": [
            "(\\d+) 個月前"
        ],
        "\\1 second ago": [
            "(\\d+) 秒前"
        ],
        "\\1 week ago": [
            "(\\d+) 週前"
        ],
        "\\1 year ago": [
            "(\\d+) 年前"
        ],
        "in \\1 day": [
            "(\\d+) 天後"
        ],
        "in \\1 hour": [
            "(\\d+) 小時後"
        ],
        "in \\1 minute": [
            "(\\d+) 分鐘後"
        ],
        "in \\1 month": [
            "(\\d+) 個月後"
        ],
        "in \\1 second": [
            "(\\d+) 秒後"
        ],
        "in \\1 week": [
            "(\\d+) 週後"
        ],
        "in \\1 year": [
            "(\\d+) 年後"
        ]
    },
    "locale_specific": {
        "zh-Hant-HK": {
            "name": "zh-Hant-HK",
            "date_order": "DMY",
            "week": [
                "星期"
            ],
            "hour": [
                "時"
            ],
            "minute": [
                "分"
            ],
            "relative-type": {
                "0 day ago": [
                    "今日"
                ],
                "0 hour ago": [
                    "這個小時"
                ],
                "0 minute ago": [
                    "這分鐘"
                ],
                "0 week ago": [
                    "本星期"
                ],
                "1 day ago": [
                    "昨日"
                ],
                "1 month ago": [
                    "上月"
                ],
                "1 week ago": [
                    "上星期"
                ],
                "1 year ago": [
                    "上年"
                ],
                "in 1 day": [
                    "明日"
                ],
                "in 1 month": [
                    "下月"
                ],
                "in 1 week": [
                    "下星期"
                ],
                "in 1 year": [
                    "下年"
                ]
            },
            "relative-type-regex": {
                "\\1 day ago": [
                    "(\\d+) 日前",
                    "(\\d+)日前"
                ],
                "\\1 hour ago": [
                    "(\\d+)小時前"
                ],
                "\\1 minute ago": [
                    "(\\d+)分前"
                ],
                "\\1 month ago": [
                    "(\\d+)個月前"
                ],
                "\\1 second ago": [
                    "(\\d+)秒前"
                ],
                "\\1 week ago": [
                    "(\\d+) 星期前",
                    "(\\d+)週前"
                ],
                "\\1 year ago": [
                    "(\\d+)年前"
                ],
                "in \\1 day": [
                    "(\\d+) 日後",
                    "(\\d+)日後"
                ],
                "in \\1 hour": [
                    "(\\d+)小時後"
                ],
                "in \\1 minute": [
                    "(\\d+)分後"
                ],
                "in \\1 month": [
                    "(\\d+)個月後"
                ],
                "in \\1 second": [
                    "(\\d+)秒後"
                ],
                "in \\1 week": [
                    "(\\d+) 星期後",
                    "(\\d+)週後"
                ],
                "in \\1 year": [
                    "(\\d+)年後"
                ]
            }
        },
        "zh-Hant-MO": {
            "name": "zh-Hant-MO",
            "date_order": "DMY",
            "week": [
                "星期"
            ],
            "hour": [
                "時"
            ],
            "minute": [
                "分"
            ],
            "relative-type": {
                "0 day ago": [
                    "今日"
                ],
                "0 hour ago": [
                    "這個小時"
                ],
                "0 minute ago": [
                    "這分鐘"
                ],
                "0 week ago": [
                    "本星期"
                ],
                "1 day ago": [
                    "昨日"
                ],
                "1 month ago": [
                    "上月"
                ],
                "1 week ago": [
                    "上星期"
                ],
                "1 year ago": [
                    "上年"
                ],
                "in 1 day": [
                    "明日"
                ],
                "in 1 month": [
                    "下月"
                ],
                "in 1 week": [
                    "下星期"
                ],
                "in 1 year": [
                    "下年"
                ]
            },
            "relative-type-regex": {
                "\\1 day ago": [
                    "(\\d+) 日前",
                    "(\\d+)日前"
                ],
                "\\1 hour ago": [
                    "(\\d+)小時前"
                ],
                "\\1 minute ago": [
                    "(\\d+)分前"
                ],
                "\\1 month ago": [
                    "(\\d+)個月前"
                ],
                "\\1 second ago": [
                    "(\\d+)秒前"
                ],
                "\\1 week ago": [
                    "(\\d+) 星期前",
                    "(\\d+)週前"
                ],
                "\\1 year ago": [
                    "(\\d+)年前"
                ],
                "in \\1 day": [
                    "(\\d+) 日後",
                    "(\\d+)日後"
                ],
                "in \\1 hour": [
                    "(\\d+)小時後"
                ],
                "in \\1 minute": [
                    "(\\d+)分後"
                ],
                "in \\1 month": [
                    "(\\d+)個月後"
                ],
                "in \\1 second": [
                    "(\\d+)秒後"
                ],
                "in \\1 week": [
                    "(\\d+) 星期後",
                    "(\\d+)週後"
                ],
                "in \\1 year": [
                    "(\\d+)年後"
                ]
            }
        }
    },
    "no_word_spacing": "True",
    "sentence_splitter_group": 4,
    "skip": [
        " ",
        "'",
        ",",
        "-",
        ".",
        "/",
        ";",
        "@",
        "[",
        "]",
        "|",
        "，"
    ]
}
