#include "shortcuts.h"
#include <wreport/error.h>
#include <cstring>

namespace dballe {
namespace impl {

const Shortcut& Shortcut::by_name(const char* key, unsigned len)
{
    switch (len) {
        case 3:
            switch (key[0]) {
                case 'd':
                    if (memcmp(key + 1, "ay", 2) == 0) {
                        return sc::day;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'q':
                    if (memcmp(key + 1, "nh", 2) == 0) {
                        return sc::qnh;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 4:
            switch (key[0]) {
                case 'y':
                    if (memcmp(key + 1, "ear", 3) == 0) {
                        return sc::year;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "our", 3) == 0) {
                        return sc::hour;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 5:
            switch (key[0]) {
                case 'b':
                    if (memcmp(key + 1, "lock", 4) == 0) {
                        return sc::block;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'i':
                    if (memcmp(key + 1, "dent", 4) == 0) {
                        return sc::ident;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "onth", 4) == 0) {
                        return sc::month;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "ress", 4) == 0) {
                        return sc::press;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 6:
            switch (key[0]) {
                case 'n':
                    if (memcmp(key + 1, "avsys", 5) == 0) {
                        return sc::navsys;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "inute", 5) == 0) {
                        return sc::minute;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 's':
                    switch (key[1]) {
                        case 'e':
                            if (memcmp(key + 2, "cond", 4) == 0) {
                                return sc::second;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        case 't':
                            if (memcmp(key + 2, "_dir", 4) == 0) {
                                return sc::st_dir;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 7:
            switch (key[0]) {
                case 's':
                    if (key[1] == 't') {
                    switch (key[2]) {
                        case '_':
                            switch (key[3]) {
                                case 't':
                                    if (memcmp(key + 4, "ype", 3) == 0) {
                                        return sc::st_type;
                                    } else {
                                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                    }
                                    break;
                                case 'n':
                                    if (memcmp(key + 4, "ame", 3) == 0) {
                                        return sc::st_name;
                                    } else {
                                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                    }
                                    break;
                                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        case 'a':
                            if (memcmp(key + 3, "tion", 4) == 0) {
                                return sc::station;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 't':
                    switch (key[1]) {
                        case 'i':
                            if (memcmp(key + 2, "mesig", 5) == 0) {
                                return sc::timesig;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        case 'e':
                            if (memcmp(key + 2, "mp_2m", 5) == 0) {
                                return sc::temp_2m;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "loud_n", 6) == 0) {
                        return sc::cloud_n;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 8:
            switch (key[0]) {
                case 'r':
                    if (memcmp(key + 1, "ep_memo", 7) == 0) {
                        return sc::rep_memo;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "atitude", 7) == 0) {
                        return sc::latitude;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "t_speed", 7) == 0) {
                        return sc::st_speed;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "res", 3) == 0) {
                        switch (key[4]) {
                            case 's':
                                if (memcmp(key + 5, "_3h", 3) == 0) {
                                    return sc::press_3h;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            case '_':
                                if (memcmp(key + 5, "wtr", 3) == 0) {
                                    return sc::pres_wtr;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "ot_snow", 7) == 0) {
                        return sc::tot_snow;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "umidity", 7) == 0) {
                        return sc::humidity;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'w':
                    if (memcmp(key + 1, "ind_dir", 7) == 0) {
                        return sc::wind_dir;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'c':
                    if (memcmp(key + 1, "loud_", 5) == 0) {
                        switch (key[6]) {
                            case 'n':
                                switch (key[7]) {
                                    case 'h':
                                        return sc::cloud_nh;
                                        break;
                                    case '1':
                                        return sc::cloud_n1;
                                        break;
                                    case '2':
                                        return sc::cloud_n2;
                                        break;
                                    case '3':
                                        return sc::cloud_n3;
                                        break;
                                    case '4':
                                        return sc::cloud_n4;
                                        break;
                                    default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            case 'h':
                                switch (key[7]) {
                                    case 'h':
                                        return sc::cloud_hh;
                                        break;
                                    case '1':
                                        return sc::cloud_h1;
                                        break;
                                    case '2':
                                        return sc::cloud_h2;
                                        break;
                                    case '3':
                                        return sc::cloud_h3;
                                        break;
                                    case '4':
                                        return sc::cloud_h4;
                                        break;
                                    default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            case 'c':
                                switch (key[7]) {
                                    case 'l':
                                        return sc::cloud_cl;
                                        break;
                                    case 'm':
                                        return sc::cloud_cm;
                                        break;
                                    case 'h':
                                        return sc::cloud_ch;
                                        break;
                                    case '1':
                                        return sc::cloud_c1;
                                        break;
                                    case '2':
                                        return sc::cloud_c2;
                                        break;
                                    case '3':
                                        return sc::cloud_c3;
                                        break;
                                    case '4':
                                        return sc::cloud_c4;
                                        break;
                                    default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 9:
            switch (key[0]) {
                case 'w':
                    if (memcmp(key + 1, "ind_inst", 8) == 0) {
                        return sc::wind_inst;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "ongitude", 8) == 0) {
                        return sc::longitude;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "ress_", 5) == 0) {
                        switch (key[6]) {
                            case '2':
                                if (memcmp(key + 7, "4h", 2) == 0) {
                                    return sc::press_24h;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            case 'm':
                                if (memcmp(key + 7, "sl", 2) == 0) {
                                    return sc::press_msl;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'm':
                    if (memcmp(key + 1, "etar_wtr", 8) == 0) {
                        return sc::metar_wtr;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "ot_prec", 7) == 0) {
                        switch (key[8]) {
                            case '1':
                                return sc::tot_prec1;
                                break;
                            case '3':
                                return sc::tot_prec3;
                                break;
                            case '6':
                                return sc::tot_prec6;
                                break;
                            default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 10:
            switch (key[0]) {
                case 'p':
                    switch (key[1]) {
                        case 'o':
                            if (memcmp(key + 2, "ll_", 3) == 0) {
                                switch (key[5]) {
                                    case 'l':
                                        if (memcmp(key + 6, "code", 4) == 0) {
                                            return sc::poll_lcode;
                                        } else {
                                            wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                        }
                                        break;
                                    case 's':
                                        if (memcmp(key + 6, "code", 4) == 0) {
                                            return sc::poll_scode;
                                        } else {
                                            wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                        }
                                        break;
                                    case 'a':
                                        if (memcmp(key + 6, "type", 4) == 0) {
                                            return sc::poll_atype;
                                        } else {
                                            wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                        }
                                        break;
                                    case 't':
                                        if (memcmp(key + 6, "type", 4) == 0) {
                                            return sc::poll_ttype;
                                        } else {
                                            wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                        }
                                        break;
                                    default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        case 'r':
                            if (memcmp(key + 2, "ess_tend", 8) == 0) {
                                return sc::press_tend;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ata_relay", 9) == 0) {
                        return sc::data_relay;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "onde_type", 9) == 0) {
                        return sc::sonde_type;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'w':
                    switch (key[1]) {
                        case 'a':
                            if (memcmp(key + 2, "ter_temp", 8) == 0) {
                                return sc::water_temp;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        case 'i':
                            if (memcmp(key + 2, "nd_speed", 8) == 0) {
                                return sc::wind_speed;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'v':
                    if (memcmp(key + 1, "isibility", 9) == 0) {
                        return sc::visibility;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 't':
                    if (memcmp(key + 1, "ot_prec", 7) == 0) {
                        switch (key[8]) {
                            case '1':
                                if (key[9] == '2') {
                                    return sc::tot_prec12;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            case '2':
                                if (key[9] == '4') {
                                    return sc::tot_prec24;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'e':
                    if (memcmp(key + 1, "x_cw_wind", 9) == 0) {
                        return sc::ex_cw_wind;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 11:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "oll_source", 10) == 0) {
                        return sc::poll_source;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'f':
                    if (memcmp(key + 1, "light_roll", 10) == 0) {
                        return sc::flight_roll;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'l':
                    if (memcmp(key + 1, "atlon_spec", 10) == 0) {
                        return sc::latlon_spec;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "eight_", 6) == 0) {
                        switch (key[7]) {
                            case 'b':
                                if (memcmp(key + 8, "aro", 3) == 0) {
                                    return sc::height_baro;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            case 'a':
                                if (memcmp(key + 8, "nem", 3) == 0) {
                                    return sc::height_anem;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'w':
                    if (memcmp(key + 1, "et_temp_2m", 10) == 0) {
                        return sc::wet_temp_2m;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'd':
                    if (memcmp(key + 1, "ewpoint_2m", 10) == 0) {
                        return sc::dewpoint_2m;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'e':
                    if (memcmp(key + 1, "x_ccw_wind", 10) == 0) {
                        return sc::ex_ccw_wind;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 12:
            switch (key[0]) {
                case 's':
                    switch (key[1]) {
                        case 't':
                            switch (key[2]) {
                                case '_':
                                    if (memcmp(key + 3, "name_icao", 9) == 0) {
                                        return sc::st_name_icao;
                                    } else {
                                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                    }
                                    break;
                                case 'a':
                                    if (memcmp(key + 3, "te_ground", 9) == 0) {
                                        return sc::state_ground;
                                    } else {
                                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                    }
                                    break;
                                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        case 'o':
                            if (memcmp(key + 2, "nde_method", 10) == 0) {
                                return sc::sonde_method;
                            } else {
                                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                            }
                            break;
                        default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'f':
                    if (memcmp(key + 1, "light_phase", 11) == 0) {
                        return sc::flight_phase;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'p':
                    if (memcmp(key + 1, "ast_wtr", 7) == 0) {
                        switch (key[8]) {
                            case '1':
                                if (key[9] == '_') {
                                switch (key[10]) {
                                    case '3':
                                        if (key[11] == 'h') {
                                            return sc::past_wtr1_3h;
                                        } else {
                                            wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                        }
                                        break;
                                    case '6':
                                        if (key[11] == 'h') {
                                            return sc::past_wtr1_6h;
                                        } else {
                                            wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                        }
                                        break;
                                    default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            case '2':
                                if (key[9] == '_') {
                                switch (key[10]) {
                                    case '3':
                                        if (key[11] == 'h') {
                                            return sc::past_wtr2_3h;
                                        } else {
                                            wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                        }
                                        break;
                                    case '6':
                                        if (key[11] == 'h') {
                                            return sc::past_wtr2_6h;
                                        } else {
                                            wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                        }
                                        break;
                                    default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 13:
            switch (key[0]) {
                case 'p':
                    if (memcmp(key + 1, "oll_gemscode", 12) == 0) {
                        return sc::poll_gemscode;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'f':
                    if (memcmp(key + 1, "light_reg_no", 12) == 0) {
                        return sc::flight_reg_no;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 14:
            switch (key[0]) {
                case 't':
                    if (memcmp(key + 1, "emp_precision", 13) == 0) {
                        return sc::temp_precision;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 'h':
                    if (memcmp(key + 1, "eight_", 6) == 0) {
                        switch (key[7]) {
                            case 's':
                                if (memcmp(key + 8, "tation", 6) == 0) {
                                    return sc::height_station;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            case 'r':
                                if (memcmp(key + 8, "elease", 6) == 0) {
                                    return sc::height_release;
                                } else {
                                    wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                                }
                                break;
                            default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                        }
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "onde_tracking", 13) == 0) {
                        return sc::sonde_tracking;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 15:
            if (memcmp(key + 0, "meas_equip_type", 15) == 0) {
                return sc::meas_equip_type;
            } else {
                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 16:
            switch (key[0]) {
                case 'i':
                    if (memcmp(key + 1, "sobaric_surface", 15) == 0) {
                        return sc::isobaric_surface;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                case 's':
                    if (memcmp(key + 1, "onde_correction", 15) == 0) {
                        return sc::sonde_correction;
                    } else {
                        wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
                    }
                    break;
                default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 17:
            if (memcmp(key + 0, "wind_gust_max_dir", 17) == 0) {
                return sc::wind_gust_max_dir;
            } else {
                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 19:
            if (memcmp(key + 0, "wind_gust_max_speed", 19) == 0) {
                return sc::wind_gust_max_speed;
            } else {
                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        case 22:
            if (memcmp(key + 0, "station_height_quality", 22) == 0) {
                return sc::station_height_quality;
            } else {
                wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
            }
            break;
        default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
    }
}
}
}
