/*
* gravity.h
* DIN Is Noise is copyright (c) 2006-2021 Jagannathan Sampath
* DIN Is Noise is released under GNU Public License 2.0
* For more information, please visit https://dinisnoise.org/
*/

#ifndef __GRAVITY
#define __GRAVITY

#include "widget.h"
#include "arrow_button.h"
#include "checkbutton.h"
#include "spinner.h"
#include "point.h"
#include "mouse_slider.h"

struct drone;
struct gravity_t : widget, click_listener, mouse_slider_listener {

  arrow_button fold;
  button zero, reset;
  arrow_button left, right, up, down;
  checkbutton mouse, dron, keepsize;
  button changesize;
  MAKE_STATE_LISTENER (mousel, ml)

  int handlesize;
  point<int> base;
  point<int> tip;
  point<int> base2tip, base2tip_ms;
  point<int> p_base2tip;
  point<int> bottomleft, topright;
  point<int> textpos;

  int hitt;
  enum {NEXT_TO_NOTHING = -1, NOTHING, BASE, TIP};
  int hit (const point<int>& p, int mx, int my);
  int lmb_clicked;

  float strength;
  float gx, gy;

  drone* tracked_drone;
  int forcetrack;
  void track (int vx, int vy);

  double mag0, mag;

	int keep_size;

  int maos;
  int dronn;

  gravity_t ();
  void load (std::ifstream& file);
  void save (std::ofstream& file);
  int handle_input ();
  void set (point<int>& p, int mx, int my, int calc_mag = 1);
  void calc (int calc_mag = 1);
  void calcui ();
  void preset (int id);
  void doreset (int keep_size = 0);
	int stop_editing ();

  int gl_base [8];
  float gl_arrow[12];

  void draw ();

  void clicked (button& b);

  
  void moused (int dir, double scl);

  int unfolded ();



};
#endif



