// This code conforms with the UFC specification version 2.3.0
// and was automatically generated by FFC version 1.3.0.
//
// This code was generated with the option '-l dolfin' and
// contains DOLFIN-specific wrappers that depend on DOLFIN.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: False
//   cpp_optimize:                   True
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'dolfin'
//   log_level:                      10
//   log_prefix:                     ''
//   no_ferari:                      True
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      15
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   restrict_keyword:               ''
//   split:                          False

#ifndef __BIHARMONIC_H
#define __BIHARMONIC_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class biharmonic_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  biharmonic_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Real', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 0, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 0)
    {
    return ;
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.333333333333333*vertex_coordinates[0] + 0.333333333333333*vertex_coordinates[2] + 0.333333333333333*vertex_coordinates[4];
      y[1] = 0.333333333333333*vertex_coordinates[1] + 0.333333333333333*vertex_coordinates[3] + 0.333333333333333*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = 0.333333333333333*vertex_coordinates[0] + 0.333333333333333*vertex_coordinates[2] + 0.333333333333333*vertex_coordinates[4];
    y[1] = 0.333333333333333*vertex_coordinates[1] + 0.333333333333333*vertex_coordinates[3] + 0.333333333333333*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new biharmonic_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class biharmonic_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  biharmonic_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 2, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::triangle;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 6;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[2] + vertex_coordinates[4];
    const double C1 = vertex_coordinates[3] + vertex_coordinates[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582063, 0.0544331053951817};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582064, 0.0544331053951818};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 6; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    // Call evaluate_basis if order of derivatives is equal to zero.
    if (n == 0)
    {
      evaluate_basis(i, values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
    return ;
    }
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[2] + vertex_coordinates[4];
    const double C1 = vertex_coordinates[3] + vertex_coordinates[5];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (J[1]*(C1 - 2.0*x[1]) + J[3]*(2.0*x[0] - C0)) / detJ;
    double Y = (J[0]*(2.0*x[1] - C1) + J[2]*(C0 - 2.0*x[0])) / detJ;
    
    // Declare two dimensional array that holds combinations of derivatives and initialise
    unsigned int combinations[4][2];
    for (unsigned int row = 0; row < 4; row++)
    {
      for (unsigned int col = 0; col < 2; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 1)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[2][2] = {{K[0], K[1]}, {K[2], K[3]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double transform[4][4];
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, -0.173205080756888, -0.1, 0.121716123890037, 0.0942809041582063, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.173205080756888, -0.1, 0.121716123890037, -0.0942809041582064, 0.0544331053951818};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.0, 0.0, 0.2, 0.0, 0.0, 0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.23094010767585, 0.133333333333333, 0.0, 0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, -0.23094010767585, 0.133333333333333, 0.0, -0.188561808316413, -0.163299316185545};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[6] = {0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = (1.0 + Y + 2.0*X)/2.0;
      double tmp1 = (1.0 - Y)/2.0;
      double tmp2 = tmp1*tmp1;
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[3] = basisvalues[1]*1.5*tmp0 - basisvalues[0]*0.5*tmp2;
      basisvalues[2] = basisvalues[0]*(0.5 + 1.5*Y);
      basisvalues[4] = basisvalues[1]*(1.5 + 2.5*Y);
      basisvalues[5] = basisvalues[2]*(0.111111111111111 + Y*1.66666666666667) - basisvalues[0]*0.555555555555556;
      basisvalues[0] *= std::sqrt(0.5);
      basisvalues[2] *= std::sqrt(1.0);
      basisvalues[5] *= std::sqrt(1.5);
      basisvalues[1] *= std::sqrt(3.0);
      basisvalues[4] *= std::sqrt(4.5);
      basisvalues[3] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[6] = \
      {0.471404520791032, 0.0, -0.266666666666667, -0.243432247780074, 0.0, 0.0544331053951817};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.89897948556635, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 9.48683298050514, 0.0, 0.0, 0.0, 0.0},
      {4, 0.0, 7.07106781186548, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[6][6] = \
      {{0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.44948974278318, 0.0, 0.0, 0.0, 0.0, 0.0},
      {4.24264068711928, 0.0, 0.0, 0.0, 0.0, 0.0},
      {2.58198889747161, 4.74341649025257, -0.912870929175278, 0.0, 0.0, 0.0},
      {2.0, 6.12372435695795, 3.53553390593274, 0.0, 0.0, 0.0},
      {-2.3094010767585, 0.0, 8.16496580927726, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare array of derivatives on FIAT element.
      double derivatives[4];
      for (unsigned int r = 0; r < 4; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[6][6] = \
      {{1.0, 0.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 6; t++)
        {
          for (unsigned int u = 0; u < 6; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 6; t++)
          {
            for (unsigned int u = 0; u < 6; u++)
            {
              for (unsigned int tu = 0; tu < 6; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 6; s++)
        {
          for (unsigned int t = 0; t < 6; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Call evaluate_basis_all if order of derivatives is equal to zero.
    if (n == 0)
    {
      evaluate_basis_all(values, x, vertex_coordinates, cell_orientation);
      return ;
    }
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 2;
    }// end loop over 'r'
    
    // Set values equal to zero.
    for (unsigned int r = 0; r < 6; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = 0.0;
      }// end loop over 's'
    }// end loop over 'r'
    
    // If order of derivatives is greater than the maximum polynomial degree, return zeros.
    if (n > 2)
    {
      return ;
    }
    
    // Helper variable to hold values of a single dof.
    double dof_values[4];
    for (unsigned int r = 0; r < 4; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 6; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[2];
      y[1] = vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[4];
      y[1] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[4];
      y[1] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[4];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 5:
      {
        y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[2];
      y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[3];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[2];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[2];
    y[1] = vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[4];
    y[1] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[4];
    y[1] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[4];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[4] = vals[0];
    y[0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[2];
    y[1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[3];
    f.evaluate(vals, y, c);
    values[5] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    throw std::runtime_error("map_from_reference_cell not yet implemented.");
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    throw std::runtime_error("map_to_reference_cell not yet implemented.");
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new biharmonic_finite_element_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class biharmonic_dofmap_0: public ufc::dofmap
{
public:

  /// Constructor
  biharmonic_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Real', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 0, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return 1;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension() const
  {
    return 1;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = 0;
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        if (i > 0)
      {
      throw std::runtime_error("i is larger than number of entities (0)");
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = 0.333333333333333*vertex_coordinates[0] + 0.333333333333333*vertex_coordinates[2] + 0.333333333333333*vertex_coordinates[4];
    dof_coordinates[0][1] = 0.333333333333333*vertex_coordinates[1] + 0.333333333333333*vertex_coordinates[3] + 0.333333333333333*vertex_coordinates[5];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new biharmonic_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class biharmonic_dofmap_1: public ufc::dofmap
{
public:

  /// Constructor
  biharmonic_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('triangle', 2), 'triangle_multiverse', 2, 2), 2, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return true;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 2;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 2;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[0] + num_global_entities[1];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension() const
  {
    return 6;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 1;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    offset += num_global_entities[0];
    dofs[3] = offset + c.entity_indices[1][0];
    dofs[4] = offset + c.entity_indices[1][1];
    dofs[5] = offset + c.entity_indices[1][2];
    offset += num_global_entities[1];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 4;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 5;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 2)
    {
    throw std::runtime_error("d is larger than dimension (2)");
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        if (i > 2)
      {
      throw std::runtime_error("i is larger than number of entities (2)");
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 3;
          break;
        }
      case 1:
        {
          dofs[0] = 4;
          break;
        }
      case 2:
        {
          dofs[0] = 5;
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[1][0] = vertex_coordinates[2];
    dof_coordinates[1][1] = vertex_coordinates[3];
    dof_coordinates[2][0] = vertex_coordinates[4];
    dof_coordinates[2][1] = vertex_coordinates[5];
    dof_coordinates[3][0] = 0.5*vertex_coordinates[2] + 0.5*vertex_coordinates[4];
    dof_coordinates[3][1] = 0.5*vertex_coordinates[3] + 0.5*vertex_coordinates[5];
    dof_coordinates[4][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[4];
    dof_coordinates[4][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[5];
    dof_coordinates[5][0] = 0.5*vertex_coordinates[0] + 0.5*vertex_coordinates[2];
    dof_coordinates[5][1] = 0.5*vertex_coordinates[1] + 0.5*vertex_coordinates[3];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new biharmonic_dofmap_1();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class biharmonic_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  biharmonic_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_cell_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double*  A,
                               const double * const *  w,
                               const double*  vertex_coordinates,
                               int cell_orientation) const
  {
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell volume
    
    // Compute circumradius of triangle in 2D
    
    
    // Array of quadrature weights.
    static const double W1 = 0.5;
    // Quadrature points on the UFC reference element: (0.333333333333333, 0.333333333333333)
    
    // Value of basis functions at quadrature points.
    static const double FE0_D02[1][3] = \
    {{4, 4, -8}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[3] = {0, 2, 4};
    
    // Array of non-zero columns
    static const unsigned int nzc4[3] = {0, 1, 5};
    
    static const double FE0_D11[1][4] = \
    {{4.0, 4, -4, -4.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc3[4] = {0, 3, 4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 36; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 81.
    double G[6];
    G[0] = W1*det*(K[2]*K[2]*K[2]*K[2] + K[3]*K[3]*(2.0*K[2]*K[2] + K[3]*K[3]));
    G[1] = W1*det*(K[2]*K[2]*(K[0]*K[0] + K[1]*K[1]) + K[3]*K[3]*(K[0]*K[0] + K[1]*K[1]));
    G[2] = W1*det*(K[0]*K[0]*K[0]*K[0] + K[1]*K[1]*(2.0*K[0]*K[0] + K[1]*K[1]));
    G[3] = 2.0*W1*det*(K[0]*K[2]*K[2]*K[2] + K[3]*(K[1]*K[2]*K[2] + K[3]*(K[0]*K[2] + K[1]*K[3])));
    G[4] = 2.0*W1*det*(K[0]*K[0]*K[0]*K[2] + K[1]*(K[0]*K[1]*K[2] + K[3]*(K[0]*K[0] + K[1]*K[1])));
    G[5] = W1*det*(4.0*K[0]*K[0]*K[2]*K[2] + K[1]*K[3]*(4.0*K[1]*K[3] + 8.0*K[0]*K[2]));
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 300
    // Only 1 integration point, omitting IP loop.
    
    // Number of operations for primary indices: 108
    for (unsigned int j = 0; j < 3; j++)
    {
      for (unsigned int k = 0; k < 3; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc1[j]*6 + nzc1[k]] += FE0_D02[0][j]*FE0_D02[0][k]*G[0];
        // Number of operations to compute entry: 3
        A[nzc1[j]*6 + nzc4[k]] += FE0_D02[0][j]*FE0_D02[0][k]*G[1];
        // Number of operations to compute entry: 3
        A[nzc4[j]*6 + nzc1[k]] += FE0_D02[0][j]*FE0_D02[0][k]*G[1];
        // Number of operations to compute entry: 3
        A[nzc4[j]*6 + nzc4[k]] += FE0_D02[0][j]*FE0_D02[0][k]*G[2];
      }// end loop over 'k'
    }// end loop over 'j'
    
    // Number of operations for primary indices: 72
    for (unsigned int j = 0; j < 4; j++)
    {
      for (unsigned int k = 0; k < 3; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc3[j]*6 + nzc1[k]] += FE0_D02[0][k]*FE0_D11[0][j]*G[3];
        // Number of operations to compute entry: 3
        A[nzc3[j]*6 + nzc4[k]] += FE0_D02[0][k]*FE0_D11[0][j]*G[4];
      }// end loop over 'k'
    }// end loop over 'j'
    
    // Number of operations for primary indices: 48
    for (unsigned int j = 0; j < 4; j++)
    {
      for (unsigned int k = 0; k < 4; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc3[j]*6 + nzc3[k]] += FE0_D11[0][j]*FE0_D11[0][k]*G[5];
      }// end loop over 'k'
    }// end loop over 'j'
    
    // Number of operations for primary indices: 72
    for (unsigned int j = 0; j < 3; j++)
    {
      for (unsigned int k = 0; k < 4; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc1[j]*6 + nzc3[k]] += FE0_D02[0][j]*FE0_D11[0][k]*G[3];
        // Number of operations to compute entry: 3
        A[nzc4[j]*6 + nzc3[k]] += FE0_D02[0][j]*FE0_D11[0][k]*G[4];
      }// end loop over 'k'
    }// end loop over 'j'
  }

};

/// This class defines the interface for the tabulation of the
/// interior facet tensor corresponding to the local contribution to
/// a form from the integral over an interior facet.

class biharmonic_interior_facet_integral_0_otherwise: public ufc::interior_facet_integral
{
public:

  /// Constructor
  biharmonic_interior_facet_integral_0_otherwise() : ufc::interior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_interior_facet_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local interior facet
  virtual void tabulate_tensor(double*  A,
                               const double * const *  w,
                               const double*  vertex_coordinates_0,
                               const double*  vertex_coordinates_1,
                               std::size_t facet_0,
                               std::size_t facet_1) const
  {
    // Compute Jacobian
    double J_0[4];
    compute_jacobian_triangle_2d(J_0, vertex_coordinates_0);
    
    // Compute Jacobian inverse and determinant
    double K_0[4];
    double detJ_0;
    compute_jacobian_inverse_triangle_2d(K_0, detJ_0, J_0);
    
    // Compute Jacobian
    double J_1[4];
    compute_jacobian_triangle_2d(J_1, vertex_coordinates_1);
    
    // Compute Jacobian inverse and determinant
    double K_1[4];
    double detJ_1;
    compute_jacobian_inverse_triangle_2d(K_1, detJ_1, J_1);
    
    
    
    // Get vertices on edge
    static unsigned int edge_vertices[3][2] = {{1, 2}, {0, 2}, {0, 1}};
    const unsigned int v0 = edge_vertices[facet_0][0];
    const unsigned int v1 = edge_vertices[facet_0][1];
    
    // Compute scale factor (length of edge scaled by length of reference interval)
    const double dx0 = vertex_coordinates_0[2*v1 + 0] - vertex_coordinates_0[2*v0 + 0];
    const double dx1 = vertex_coordinates_0[2*v1 + 1] - vertex_coordinates_0[2*v0 + 1];
    const double det = std::sqrt(dx0*dx0 + dx1*dx1);
    
    
    const bool direction = dx1*(vertex_coordinates_0[2*facet_0] - vertex_coordinates_0[2*v0]) - dx0*(vertex_coordinates_0[2*facet_0 + 1] - vertex_coordinates_0[2*v0 + 1]) < 0;
    // Compute facet normals from the facet scale factor constants
    const double n_00 = direction ? dx1 / det : -dx1 / det;
    const double n_01 = direction ? -dx0 / det : dx0 / det;// Compute facet normals from the facet scale factor constants
    const double n_10 = !direction ? dx1 / det : -dx1 / det;
    const double n_11 = !direction ? -dx0 / det : dx0 / det;
    
    // Facet area
    
    // Cell volume
    const double volume_0 = std::abs(detJ_0)/2.0;// Cell volume
    const double volume_1 = std::abs(detJ_1)/2.0;
    
    // Compute circumradius of triangle in 2D
    const double v1v2_0  = std::sqrt((vertex_coordinates_0[4] - vertex_coordinates_0[2])*(vertex_coordinates_0[4] - vertex_coordinates_0[2]) + (vertex_coordinates_0[5] - vertex_coordinates_0[3])*(vertex_coordinates_0[5] - vertex_coordinates_0[3]) );
    const double v0v2_0  = std::sqrt(J_0[3]*J_0[3] + J_0[1]*J_0[1]);
    const double v0v1_0  = std::sqrt(J_0[0]*J_0[0] + J_0[2]*J_0[2]);
    
    const double circumradius_0 = 0.25*(v1v2_0*v0v2_0*v0v1_0)/(volume_0);// Compute circumradius of triangle in 2D
    const double v1v2_1  = std::sqrt((vertex_coordinates_1[4] - vertex_coordinates_1[2])*(vertex_coordinates_1[4] - vertex_coordinates_1[2]) + (vertex_coordinates_1[5] - vertex_coordinates_1[3])*(vertex_coordinates_1[5] - vertex_coordinates_1[3]) );
    const double v0v2_1  = std::sqrt(J_1[3]*J_1[3] + J_1[1]*J_1[1]);
    const double v0v1_1  = std::sqrt(J_1[0]*J_1[0] + J_1[2]*J_1[2]);
    
    const double circumradius_1 = 0.25*(v1v2_1*v0v2_1*v0v1_1)/(volume_1);
    
    // Array of quadrature weights.
    static const double W2[2] = {0.5, 0.5};
    // Quadrature points on the UFC reference element: (0.211324865405187), (0.788675134594813)
    
    // Value of basis functions at quadrature points.
    static const double FE0_f0_D01[2][5] = \
    {{1.0, -0.154700538379251, 3.15470053837925, -0.845299461620749, -3.15470053837925},
    {1.0, 2.15470053837925, 0.845299461620748, -3.15470053837925, -0.845299461620748}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[5] = {0, 2, 3, 4, 5};
    
    static const double FE0_f0_D02[2][3] = \
    {{4, 3.99999999999999, -7.99999999999999},
    {4, 4, -7.99999999999999}};
    
    // Array of non-zero columns
    static const unsigned int nzc5[3] = {0, 1, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc2[3] = {0, 2, 4};
    
    // Array of non-zero columns
    static const unsigned int nzc9[3] = {0, 1, 5};
    
    static const double FE0_f0_D10[2][5] = \
    {{1.0, 2.15470053837925, 0.845299461620748, -0.845299461620748, -3.15470053837925},
    {1.0, -0.154700538379252, 3.15470053837925, -3.15470053837925, -0.84529946162075}};
    
    // Array of non-zero columns
    static const unsigned int nzc3[5] = {0, 1, 3, 4, 5};
    
    static const double FE0_f0_D11[2][4] = \
    {{4, 4, -4, -4},
    {4.0, 3.99999999999999, -3.99999999999999, -4.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc4[4] = {0, 3, 4, 5};
    
    static const double FE0_f1_D01[2][3] = \
    {{-2.15470053837925, -0.154700538379252, 2.3094010767585},
    {0.154700538379252, 2.15470053837925, -2.3094010767585}};
    
    // Array of non-zero columns
    static const unsigned int nzc12[3] = {0, 1, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc7[3] = {0, 2, 4};
    
    static const double FE0_f1_D10[2][5] = \
    {{-2.15470053837925, -1.0, 0.845299461620748, -0.845299461620748, 3.15470053837925},
    {0.154700538379252, -1.0, 3.15470053837925, -3.15470053837925, 0.845299461620748}};
    
    // Array of non-zero columns
    static const unsigned int nzc8[5] = {0, 1, 3, 4, 5};
    
    static const double FE0_f2_D01[2][5] = \
    {{-2.15470053837925, -1.0, 0.845299461620748, 3.15470053837925, -0.845299461620749},
    {0.154700538379252, -1.0, 3.15470053837925, 0.845299461620749, -3.15470053837925}};
    
    // Array of non-zero columns
    static const unsigned int nzc11[5] = {0, 2, 3, 4, 5};
    
    static const double FE0_f2_D11[2][4] = \
    {{4, 4.00000000000001, -4.00000000000001, -3.99999999999999},
    {4, 4, -4, -3.99999999999999}};
    
    // Array of non-zero columns
    static const unsigned int nzc13[4] = {0, 3, 4, 5};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 144; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 460.
    double G[34];
    G[0] = -0.5*det*(K_1[2]*K_1[2]*K_1[2]*n_10 + K_1[3]*(K_1[2]*K_1[3]*n_10 + n_11*(K_1[2]*K_1[2] + K_1[3]*K_1[3])));
    G[1] = -0.5*det*(K_1[2]*K_1[2]*(K_1[0]*n_10 + K_1[1]*n_11) + K_1[3]*K_1[3]*(K_1[0]*n_10 + K_1[1]*n_11));
    G[2] = -0.5*det*(K_1[2]*K_1[2]*(K_0[2]*n_00 + K_0[3]*n_01) + K_1[3]*K_1[3]*(K_0[2]*n_00 + K_0[3]*n_01));
    G[3] = -0.5*det*(K_1[2]*K_1[2]*(K_0[0]*n_00 + K_0[1]*n_01) + K_1[3]*K_1[3]*(K_0[0]*n_00 + K_0[1]*n_01));
    G[4] = -0.5*det*(K_1[2]*n_10*(K_1[0]*K_1[0] + K_1[1]*K_1[1]) + K_1[3]*n_11*(K_1[0]*K_1[0] + K_1[1]*K_1[1]));
    G[5] = -0.5*det*(K_1[0]*K_1[0]*K_1[0]*n_10 + K_1[1]*(K_1[0]*K_1[1]*n_10 + n_11*(K_1[0]*K_1[0] + K_1[1]*K_1[1])));
    G[6] = -0.5*det*(K_1[0]*K_1[0]*(K_0[2]*n_00 + K_0[3]*n_01) + K_1[1]*K_1[1]*(K_0[2]*n_00 + K_0[3]*n_01));
    G[7] = -0.5*det*(K_1[0]*K_1[0]*(K_0[0]*n_00 + K_0[1]*n_01) + K_1[1]*K_1[1]*(K_0[0]*n_00 + K_0[1]*n_01));
    G[8] = -0.5*det*(K_1[2]*n_10*(K_0[2]*K_0[2] + K_0[3]*K_0[3]) + K_1[3]*n_11*(K_0[2]*K_0[2] + K_0[3]*K_0[3]));
    G[9] = -0.5*det*(K_1[0]*n_10*(K_0[2]*K_0[2] + K_0[3]*K_0[3]) + K_1[1]*n_11*(K_0[2]*K_0[2] + K_0[3]*K_0[3]));
    G[10] = -0.5*det*(K_0[2]*K_0[2]*K_0[2]*n_00 + K_0[3]*(K_0[2]*K_0[3]*n_00 + n_01*(K_0[2]*K_0[2] + K_0[3]*K_0[3])));
    G[11] = -0.5*det*(K_0[2]*K_0[2]*(K_0[0]*n_00 + K_0[1]*n_01) + K_0[3]*K_0[3]*(K_0[0]*n_00 + K_0[1]*n_01));
    G[12] = -0.5*det*(K_1[2]*n_10*(K_0[0]*K_0[0] + K_0[1]*K_0[1]) + K_1[3]*n_11*(K_0[0]*K_0[0] + K_0[1]*K_0[1]));
    G[13] = -0.5*det*(K_1[0]*n_10*(K_0[0]*K_0[0] + K_0[1]*K_0[1]) + K_1[1]*n_11*(K_0[0]*K_0[0] + K_0[1]*K_0[1]));
    G[14] = -0.5*det*(K_0[2]*n_00*(K_0[0]*K_0[0] + K_0[1]*K_0[1]) + K_0[3]*n_01*(K_0[0]*K_0[0] + K_0[1]*K_0[1]));
    G[15] = -0.5*det*(K_0[0]*K_0[0]*K_0[0]*n_00 + K_0[1]*(K_0[0]*K_0[1]*n_00 + n_01*(K_0[0]*K_0[0] + K_0[1]*K_0[1])));
    G[16] =  - det*(K_1[0]*K_1[2]*K_1[2]*n_10 + K_1[3]*(K_1[1]*K_1[2]*n_10 + n_11*(K_1[0]*K_1[2] + K_1[1]*K_1[3])));
    G[17] =  - det*(K_1[0]*K_1[0]*K_1[2]*n_10 + K_1[1]*(K_1[0]*K_1[3]*n_10 + n_11*(K_1[0]*K_1[2] + K_1[1]*K_1[3])));
    G[18] =  - det*(K_1[0]*K_1[2]*(K_0[2]*n_00 + K_0[3]*n_01) + K_1[1]*K_1[3]*(K_0[2]*n_00 + K_0[3]*n_01));
    G[19] =  - det*(K_1[0]*K_1[2]*(K_0[0]*n_00 + K_0[1]*n_01) + K_1[1]*K_1[3]*(K_0[0]*n_00 + K_0[1]*n_01));
    G[20] =  - det*(K_1[2]*n_10*(K_0[0]*K_0[2] + K_0[1]*K_0[3]) + K_1[3]*n_11*(K_0[0]*K_0[2] + K_0[1]*K_0[3]));
    G[21] =  - det*(K_1[0]*n_10*(K_0[0]*K_0[2] + K_0[1]*K_0[3]) + K_1[1]*n_11*(K_0[0]*K_0[2] + K_0[1]*K_0[3]));
    G[22] =  - det*(K_0[0]*K_0[2]*K_0[2]*n_00 + K_0[3]*(K_0[1]*K_0[2]*n_00 + n_01*(K_0[0]*K_0[2] + K_0[1]*K_0[3])));
    G[23] =  - det*(K_0[0]*K_0[0]*K_0[2]*n_00 + K_0[1]*(K_0[0]*K_0[3]*n_00 + n_01*(K_0[0]*K_0[2] + K_0[1]*K_0[3])));
    G[24] = det*w[0][0]*(K_1[2]*K_1[2]*n_10*n_10 + K_1[3]*n_11*(2.0*K_1[2]*n_10 + K_1[3]*n_11))/(circumradius_0 + circumradius_1);
    G[25] = det*w[0][0]*(K_1[0]*K_1[2]*n_10*n_10 + n_11*(K_1[1]*K_1[3]*n_11 + n_10*(K_1[0]*K_1[3] + K_1[1]*K_1[2])))/(circumradius_0 + circumradius_1);
    G[26] = det*w[0][0]*(K_1[2]*n_10*(K_0[2]*n_00 + K_0[3]*n_01) + K_1[3]*n_11*(K_0[2]*n_00 + K_0[3]*n_01))/(circumradius_0 + circumradius_1);
    G[27] = det*w[0][0]*(K_1[2]*n_10*(K_0[0]*n_00 + K_0[1]*n_01) + K_1[3]*n_11*(K_0[0]*n_00 + K_0[1]*n_01))/(circumradius_0 + circumradius_1);
    G[28] = det*w[0][0]*(K_1[0]*K_1[0]*n_10*n_10 + K_1[1]*n_11*(2.0*K_1[0]*n_10 + K_1[1]*n_11))/(circumradius_0 + circumradius_1);
    G[29] = det*w[0][0]*(K_1[0]*n_10*(K_0[2]*n_00 + K_0[3]*n_01) + K_1[1]*n_11*(K_0[2]*n_00 + K_0[3]*n_01))/(circumradius_0 + circumradius_1);
    G[30] = det*w[0][0]*(K_1[0]*n_10*(K_0[0]*n_00 + K_0[1]*n_01) + K_1[1]*n_11*(K_0[0]*n_00 + K_0[1]*n_01))/(circumradius_0 + circumradius_1);
    G[31] = det*w[0][0]*(K_0[2]*K_0[2]*n_00*n_00 + K_0[3]*n_01*(2.0*K_0[2]*n_00 + K_0[3]*n_01))/(circumradius_0 + circumradius_1);
    G[32] = det*w[0][0]*(K_0[0]*K_0[2]*n_00*n_00 + n_01*(K_0[1]*K_0[3]*n_01 + n_00*(K_0[0]*K_0[3] + K_0[1]*K_0[2])))/(circumradius_0 + circumradius_1);
    G[33] = det*w[0][0]*(K_0[0]*K_0[0]*n_00*n_00 + K_0[1]*n_01*(2.0*K_0[0]*n_00 + K_0[1]*n_01))/(circumradius_0 + circumradius_1);
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    switch (facet_0)
    {
    case 0:
      {
        switch (facet_1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 7268
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 7268
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 480
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[23];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 720
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[15];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 480
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[23];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 1200
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc3[k]] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc3[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc1[k]] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc3[k]] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc3[k]] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 720
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[15];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 6332
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 6332
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 243
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[26];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f1_D01[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f1_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc7[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f1_D01[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc9[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc7[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f1_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f1_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f1_D10[ip][j]*I[30];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc8[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f1_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc1[k]] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc3[k]] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc8[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f1_D10[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc3[k]] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 6332
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 6332
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 243
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f2_D01[ip][k]*FE0_f2_D11[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f2_D11[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f2_D11[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc11[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[26];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f1_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f1_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc3[k]] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc13[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D11[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc13[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f2_D11[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc13[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f2_D11[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc13[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc12[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc12[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f2_D01[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc3[k]] += FE0_f0_D10[ip][k]*FE0_f2_D01[ip][j]*I[30];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + (nzc11[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f2_D01[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc1[k]] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[nzc1[j]*12 + nzc3[k]] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + (nzc11[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f2_D01[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc1[k]] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc3[j]*12 + nzc3[k]] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc12[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        switch (facet_1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 6332
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 6332
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 243
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[26];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f1_D01[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f1_D01[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc4[k]] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc4[k]] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc7[k]] += FE0_f0_D01[ip][j]*FE0_f1_D01[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc9[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc7[k]] += FE0_f0_D10[ip][j]*FE0_f1_D01[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc8[k]] += FE0_f0_D01[ip][j]*FE0_f1_D10[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc8[k]] += FE0_f0_D10[ip][j]*FE0_f1_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f1_D10[ip][j]*I[30];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f1_D10[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc8[k]] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 5444
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 5444
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[28];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 300
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc8[k]] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc8[k]] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 5444
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 5444
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[31]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[33]*W2[ip];
          
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc7[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + nzc7[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f2_D01[ip][k]*FE0_f2_D11[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + nzc8[k]] += FE0_f1_D10[ip][k]*FE0_f2_D11[ip][j]*I[28];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc11[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc8[k]] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc8[k]] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc9[j]*12 + nzc8[k]] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc13[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D11[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc13[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f2_D11[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc13[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + (nzc13[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc7[j]*12 + nzc4[k]] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc9[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 300
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc8[k]] += FE0_f1_D10[ip][k]*FE0_f2_D01[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + (nzc11[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc8[j]*12 + nzc8[k]] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + nzc7[k]] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + (nzc12[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc4[j]*12 + nzc7[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    case 2:
      {
        switch (facet_1)
      {
      case 0:
        {
          // Total number of operations to compute element tensor (from this point): 6332
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 6332
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[33]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[31]*W2[ip];
          
          
          // Number of operations for primary indices: 243
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc12[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D11[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f0_D11[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc11[k]] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f2_D11[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f2_D11[ip][j]*I[26];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + nzc11[k]] += FE0_f2_D01[ip][k]*FE0_f2_D11[ip][j]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f1_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f1_D01[ip][j]*I[14];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D02[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc3[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f0_D10[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 360
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D11[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc13[k]] += FE0_f0_D01[ip][j]*FE0_f2_D11[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D11[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc13[k]] += FE0_f0_D10[ip][j]*FE0_f2_D11[ip][k]*I[26];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc13[k]] += FE0_f2_D01[ip][j]*FE0_f2_D11[ip][k]*I[27];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc13[k]] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[10];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc12[k]] += FE0_f0_D01[ip][j]*FE0_f1_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc2[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc5[k]] += FE0_f0_D01[ip][j]*FE0_f0_D02[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[8];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc12[k]] += FE0_f0_D10[ip][j]*FE0_f1_D01[ip][k]*I[14];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f0_D10[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[21];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 675
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D01[ip][j]*FE0_f0_D10[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc1[j] + 6)*12 + nzc11[k]] += FE0_f0_D01[ip][j]*FE0_f2_D01[ip][k]*I[30];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f0_D10[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][j]*FE0_f0_D10[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc3[j] + 6)*12 + nzc11[k]] += FE0_f0_D10[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc1[k] + 6)] += FE0_f0_D01[ip][k]*FE0_f2_D01[ip][j]*I[30];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc3[k] + 6)] += FE0_f0_D10[ip][k]*FE0_f2_D01[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc11[k]] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 72
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc12[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[6];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 1:
        {
          // Total number of operations to compute element tensor (from this point): 5444
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 5444
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[33]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[31]*W2[ip];
          
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc12[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc12[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc7[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D10[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc13[k]] += FE0_f1_D10[ip][j]*FE0_f2_D11[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f2_D01[ip][j]*I[28];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc13[k]] += FE0_f2_D01[ip][j]*FE0_f2_D11[ip][k]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D10[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc11[k]] += FE0_f0_D11[ip][j]*FE0_f2_D01[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][k]*FE0_f2_D11[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + nzc11[k]] += FE0_f2_D01[ip][k]*FE0_f2_D11[ip][j]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc9[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc8[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D10[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc8[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D10[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc4[j] + 6)*12 + nzc12[k]] += FE0_f0_D11[ip][j]*FE0_f1_D01[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f1_D10[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D10[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc7[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc9[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 300
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][j]*FE0_f1_D10[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc8[j] + 6)*12 + nzc11[k]] += FE0_f1_D10[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc8[k] + 6)] += FE0_f1_D10[ip][k]*FE0_f2_D01[ip][j]*I[32];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc11[k]] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc7[j] + 6)*12 + nzc13[k]] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc4[k] + 6)] += FE0_f0_D11[ip][k]*FE0_f1_D01[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc13[k]] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      case 2:
        {
          // Total number of operations to compute element tensor (from this point): 5444
        
        // Loop quadrature points for integral.
        // Number of operations to compute element tensor for following IP loop = 5444
        for (unsigned int ip = 0; ip < 2; ip++)
        {
          
          // Number of operations to compute ip constants: 34
          double I[34];
          // Number of operations: 1
          I[0] = G[28]*W2[ip];
          
          // Number of operations: 1
          I[1] = G[1]*W2[ip];
          
          // Number of operations: 1
          I[2] = G[5]*W2[ip];
          
          // Number of operations: 1
          I[3] = G[30]*W2[ip];
          
          // Number of operations: 1
          I[4] = G[9]*W2[ip];
          
          // Number of operations: 1
          I[5] = G[13]*W2[ip];
          
          // Number of operations: 1
          I[6] = G[3]*W2[ip];
          
          // Number of operations: 1
          I[7] = G[7]*W2[ip];
          
          // Number of operations: 1
          I[8] = G[33]*W2[ip];
          
          // Number of operations: 1
          I[9] = G[11]*W2[ip];
          
          // Number of operations: 1
          I[10] = G[15]*W2[ip];
          
          // Number of operations: 1
          I[11] = G[17]*W2[ip];
          
          // Number of operations: 1
          I[12] = G[21]*W2[ip];
          
          // Number of operations: 1
          I[13] = G[19]*W2[ip];
          
          // Number of operations: 1
          I[14] = G[23]*W2[ip];
          
          // Number of operations: 1
          I[15] = G[25]*W2[ip];
          
          // Number of operations: 1
          I[16] = G[29]*W2[ip];
          
          // Number of operations: 1
          I[17] = G[0]*W2[ip];
          
          // Number of operations: 1
          I[18] = G[2]*W2[ip];
          
          // Number of operations: 1
          I[19] = G[4]*W2[ip];
          
          // Number of operations: 1
          I[20] = G[6]*W2[ip];
          
          // Number of operations: 1
          I[21] = G[27]*W2[ip];
          
          // Number of operations: 1
          I[22] = G[32]*W2[ip];
          
          // Number of operations: 1
          I[23] = G[8]*W2[ip];
          
          // Number of operations: 1
          I[24] = G[10]*W2[ip];
          
          // Number of operations: 1
          I[25] = G[12]*W2[ip];
          
          // Number of operations: 1
          I[26] = G[14]*W2[ip];
          
          // Number of operations: 1
          I[27] = G[16]*W2[ip];
          
          // Number of operations: 1
          I[28] = G[18]*W2[ip];
          
          // Number of operations: 1
          I[29] = G[20]*W2[ip];
          
          // Number of operations: 1
          I[30] = G[22]*W2[ip];
          
          // Number of operations: 1
          I[31] = G[24]*W2[ip];
          
          // Number of operations: 1
          I[32] = G[26]*W2[ip];
          
          // Number of operations: 1
          I[33] = G[31]*W2[ip];
          
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[0];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc12[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[4];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[5];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[1];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[6];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[2];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[7];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[3];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[6];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[7];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc12[k]] += FE0_f1_D01[ip][j]*FE0_f1_D01[ip][k]*I[8];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[9];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f1_D01[ip][j]*I[10];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[4];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[9];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc12[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[5];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc12[k]] += FE0_f0_D02[ip][j]*FE0_f1_D01[ip][k]*I[10];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f2_D01[ip][k]*FE0_f2_D11[ip][j]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + nzc11[k]] += FE0_f2_D01[ip][k]*FE0_f2_D11[ip][j]*I[28];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + (nzc11[k] + 6)] += FE0_f2_D01[ip][k]*FE0_f2_D11[ip][j]*I[29];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + nzc11[k]] += FE0_f2_D01[ip][k]*FE0_f2_D11[ip][j]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[16];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc2[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[18];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc5[j] + 6)*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[20];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc11[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[21];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc11[k]] += FE0_f1_D01[ip][j]*FE0_f2_D01[ip][k]*I[22];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[23];
              // Number of operations to compute entry: 3
              A[nzc2[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[24];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + (nzc11[k] + 6)] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[25];
              // Number of operations to compute entry: 3
              A[nzc5[j]*12 + nzc11[k]] += FE0_f0_D02[ip][j]*FE0_f2_D01[ip][k]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 240
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc13[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D11[ip][k]*I[27];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc13[k]] += FE0_f2_D01[ip][j]*FE0_f2_D11[ip][k]*I[29];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc13[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D11[ip][k]*I[28];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc13[k]] += FE0_f2_D01[ip][j]*FE0_f2_D11[ip][k]*I[30];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 3; j++)
          {
            for (unsigned int k = 0; k < 4; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + (nzc13[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc12[j] + 6)*12 + nzc13[k]] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[12];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + (nzc13[k] + 6)] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[13];
              // Number of operations to compute entry: 3
              A[nzc12[j]*12 + nzc13[k]] += FE0_f1_D01[ip][j]*FE0_f2_D11[ip][k]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 540
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[15];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[17];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[19];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[21];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[23];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[25];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[16];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc2[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[18];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc5[k] + 6)] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[20];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f2_D01[ip][j]*I[22];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc2[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[24];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc5[k]] += FE0_f0_D02[ip][k]*FE0_f2_D01[ip][j]*I[26];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 300
          for (unsigned int j = 0; j < 5; j++)
          {
            for (unsigned int k = 0; k < 5; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + (nzc11[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[31];
              // Number of operations to compute entry: 3
              A[(nzc11[j] + 6)*12 + nzc11[k]] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + (nzc11[k] + 6)] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[32];
              // Number of operations to compute entry: 3
              A[nzc11[j]*12 + nzc11[k]] += FE0_f2_D01[ip][j]*FE0_f2_D01[ip][k]*I[33];
            }// end loop over 'k'
          }// end loop over 'j'
          
          // Number of operations for primary indices: 144
          for (unsigned int j = 0; j < 4; j++)
          {
            for (unsigned int k = 0; k < 3; k++)
            {
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[11];
              // Number of operations to compute entry: 3
              A[(nzc13[j] + 6)*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[13];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + (nzc12[k] + 6)] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[12];
              // Number of operations to compute entry: 3
              A[nzc13[j]*12 + nzc12[k]] += FE0_f1_D01[ip][k]*FE0_f2_D11[ip][j]*I[14];
            }// end loop over 'k'
          }// end loop over 'j'
        }// end loop over 'ip'
          break;
        }
      }
      
        break;
      }
    }
    
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class biharmonic_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  biharmonic_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_cell_integral_1_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double*  A,
                               const double * const *  w,
                               const double*  vertex_coordinates,
                               int cell_orientation) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      3
    // Number of operations (multiply-add pairs) for geometry tensor:    6
    // Number of operations (multiply-add pairs) for tensor contraction: 21
    // Total number of operations (multiply-add pairs):                  30
    
    // Compute Jacobian
    double J[4];
    compute_jacobian_triangle_2d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[4];
    double detJ;
    compute_jacobian_inverse_triangle_2d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Compute geometry tensor
    const double G0_0 = det*w[0][0]*(1.0);
    const double G0_1 = det*w[0][1]*(1.0);
    const double G0_2 = det*w[0][2]*(1.0);
    const double G0_3 = det*w[0][3]*(1.0);
    const double G0_4 = det*w[0][4]*(1.0);
    const double G0_5 = det*w[0][5]*(1.0);
    
    // Compute element tensor
    A[0] = 0.0166666666666666*G0_0 - 0.00277777777777778*G0_1 - 0.00277777777777778*G0_2 - 0.0111111111111111*G0_3;
    A[1] = -0.00277777777777778*G0_0 + 0.0166666666666667*G0_1 - 0.00277777777777781*G0_2 - 0.0111111111111111*G0_4;
    A[2] = -0.00277777777777778*G0_0 - 0.0027777777777778*G0_1 + 0.0166666666666667*G0_2 - 0.0111111111111111*G0_5;
    A[3] = -0.0111111111111111*G0_0 + 0.0888888888888888*G0_3 + 0.0444444444444443*G0_4 + 0.0444444444444443*G0_5;
    A[4] = -0.0111111111111111*G0_1 + 0.0444444444444443*G0_3 + 0.0888888888888887*G0_4 + 0.0444444444444443*G0_5;
    A[5] = -0.0111111111111111*G0_2 + 0.0444444444444443*G0_3 + 0.0444444444444443*G0_4 + 0.0888888888888887*G0_5;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class biharmonic_form_0: public ufc::form
{
public:

  /// Constructor
  biharmonic_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "f6f289ef54d420f896cf98fe9a19472065863b2299c62de865b4394b769bc55f9d8d624cdaf1e42d46b093f92de7c34eca013df40d979e78d10344ed00efba64";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return true;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 1:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 2:
      {
        return new biharmonic_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_dofmap_1();
        break;
      }
    case 1:
      {
        return new biharmonic_dofmap_1();
        break;
      }
    case 2:
      {
        return new biharmonic_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new biharmonic_cell_integral_0_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return 0;
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return new biharmonic_interior_facet_integral_0_otherwise();
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class biharmonic_form_1: public ufc::form
{
public:

  /// Constructor
  biharmonic_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~biharmonic_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "cf233358bfd1086ac41c948b15f716ea463484b4d60163a9b9361bea1c1cef625eb4bbdf6de038a538bd46c8445fd3f245d00fb19b4c204c01eb182d6f003369";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 1;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    case 1:
      {
        return new biharmonic_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new biharmonic_dofmap_1();
        break;
      }
    case 1:
      {
        return new biharmonic_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new biharmonic_cell_integral_1_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return 0;
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

// DOLFIN wrappers

// Standard library includes
#include <string>

// DOLFIN includes
#include <dolfin/common/NoDeleter.h>
#include <dolfin/mesh/Restriction.h>
#include <dolfin/fem/FiniteElement.h>
#include <dolfin/fem/DofMap.h>
#include <dolfin/fem/Form.h>
#include <dolfin/function/FunctionSpace.h>
#include <dolfin/function/GenericFunction.h>
#include <dolfin/function/CoefficientAssigner.h>
#include <dolfin/adaptivity/ErrorControl.h>
#include <dolfin/adaptivity/GoalFunctional.h>

namespace Biharmonic
{

class CoefficientSpace_alpha: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_alpha(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_0()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_alpha(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_0()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_alpha(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_0()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_alpha(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_0()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  CoefficientSpace_alpha(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_0()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  CoefficientSpace_alpha(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_0()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_0()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~CoefficientSpace_alpha()
  {
  }

};

class CoefficientSpace_f: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_f(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  CoefficientSpace_f(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  CoefficientSpace_f(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  CoefficientSpace_f(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  CoefficientSpace_f(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~CoefficientSpace_f()
  {
  }

};

class Form_a_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_a_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_a_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_a_FunctionSpace_0(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_a_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  Form_a_FunctionSpace_0(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  Form_a_FunctionSpace_0(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~Form_a_FunctionSpace_0()
  {
  }

};

class Form_a_FunctionSpace_1: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_a_FunctionSpace_1(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_a_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_a_FunctionSpace_1(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_a_FunctionSpace_1(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  Form_a_FunctionSpace_1(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  Form_a_FunctionSpace_1(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~Form_a_FunctionSpace_1()
  {
  }

};

typedef CoefficientSpace_alpha Form_a_FunctionSpace_2;

class Form_a: public dolfin::Form
{
public:

  // Constructor
  Form_a(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0):
    dolfin::Form(2, 1), alpha(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_a(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& alpha):
    dolfin::Form(2, 1), alpha(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->alpha = alpha;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_a(const dolfin::FunctionSpace& V1, const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> alpha):
    dolfin::Form(2, 1), alpha(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);
    _function_spaces[1] = reference_to_no_delete_pointer(V1);

    this->alpha = *alpha;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_a(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(2, 1), alpha(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_a(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& alpha):
    dolfin::Form(2, 1), alpha(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->alpha = alpha;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Constructor
  Form_a(boost::shared_ptr<const dolfin::FunctionSpace> V1, boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> alpha):
    dolfin::Form(2, 1), alpha(*this, 0)
  {
    _function_spaces[0] = V0;
    _function_spaces[1] = V1;

    this->alpha = *alpha;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_0());
  }

  // Destructor
  ~Form_a()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "alpha")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "alpha";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_a_FunctionSpace_0 TestSpace;
  typedef Form_a_FunctionSpace_1 TrialSpace;
  typedef Form_a_FunctionSpace_2 CoefficientSpace_alpha;

  // Coefficients
  dolfin::CoefficientAssigner alpha;
};

class Form_L_FunctionSpace_0: public dolfin::FunctionSpace
{
public:

  //--- Constructors for standard function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_L_FunctionSpace_0(const dolfin::Mesh& mesh):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), mesh)))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_L_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), *mesh)))
  {
    // Do nothing
  }

  //--- Constructors for constrained function space, 2 different versions ---

  // Create standard function space (reference version)
  Form_L_FunctionSpace_0(const dolfin::Mesh& mesh, const dolfin::SubDomain& constrained_domain):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(mesh),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), mesh,
                              dolfin::reference_to_no_delete_pointer(constrained_domain))))
  {
    // Do nothing
  }

  // Create standard function space (shared pointer version)
  Form_L_FunctionSpace_0(boost::shared_ptr<const dolfin::Mesh> mesh, boost::shared_ptr<const dolfin::SubDomain> constrained_domain):
    dolfin::FunctionSpace(mesh,
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()), *mesh, constrained_domain)))
  {
    // Do nothing
  }

  //--- Constructors for restricted function space, 2 different versions ---

  // Create restricted function space (reference version)
  Form_L_FunctionSpace_0(const dolfin::Restriction& restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction.mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()),
                                                                                     reference_to_no_delete_pointer(restriction))))
  {
    // Do nothing
  }

  // Create restricted function space (shared pointer version)
  Form_L_FunctionSpace_0(boost::shared_ptr<const dolfin::Restriction> restriction):
    dolfin::FunctionSpace(dolfin::reference_to_no_delete_pointer(restriction->mesh()),
                          boost::shared_ptr<const dolfin::FiniteElement>(new dolfin::FiniteElement(boost::shared_ptr<ufc::finite_element>(new biharmonic_finite_element_1()))),
                          boost::shared_ptr<const dolfin::DofMap>(new dolfin::DofMap(boost::shared_ptr<ufc::dofmap>(new biharmonic_dofmap_1()),
                                                                                     restriction)))
  {
    // Do nothing
  }

  // Copy constructor
  ~Form_L_FunctionSpace_0()
  {
  }

};

typedef CoefficientSpace_f Form_L_FunctionSpace_1;

class Form_L: public dolfin::Form
{
public:

  // Constructor
  Form_L(const dolfin::FunctionSpace& V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_L(const dolfin::FunctionSpace& V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_L(const dolfin::FunctionSpace& V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = reference_to_no_delete_pointer(V0);

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_L(boost::shared_ptr<const dolfin::FunctionSpace> V0):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_L(boost::shared_ptr<const dolfin::FunctionSpace> V0, const dolfin::GenericFunction& f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Constructor
  Form_L(boost::shared_ptr<const dolfin::FunctionSpace> V0, boost::shared_ptr<const dolfin::GenericFunction> f):
    dolfin::Form(1, 1), f(*this, 0)
  {
    _function_spaces[0] = V0;

    this->f = *f;

    _ufc_form = boost::shared_ptr<const ufc::form>(new biharmonic_form_1());
  }

  // Destructor
  ~Form_L()
  {}

  /// Return the number of the coefficient with this name
  virtual std::size_t coefficient_number(const std::string& name) const
  {
    if (name == "f")
      return 0;

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return 0;
  }

  /// Return the name of the coefficient with this number
  virtual std::string coefficient_name(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      return "f";
    }

    dolfin::dolfin_error("generated code for class Form",
                         "access coefficient data",
                         "Invalid coefficient");
    return "unnamed";
  }

  // Typedefs
  typedef Form_L_FunctionSpace_0 TestSpace;
  typedef Form_L_FunctionSpace_1 CoefficientSpace_f;

  // Coefficients
  dolfin::CoefficientAssigner f;
};

// Class typedefs
typedef Form_a BilinearForm;
typedef Form_a JacobianForm;
typedef Form_L LinearForm;
typedef Form_L ResidualForm;
typedef Form_a::TestSpace FunctionSpace;

}

#endif
