// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// A routing control, which is a simple on/off switch that you can use to route
// traffic to cells. When a routing control state is set to ON, traffic flows to a
// cell. When the state is set to OFF, traffic does not flow.
type RoutingControl struct {

	// The Amazon Resource Name (ARN) of the control panel where the routing control
	// is located.
	ControlPanelArn *string

	// The name of the control panel where the routing control is located. Only ASCII
	// characters are supported for control panel names.
	ControlPanelName *string

	// The Amazon Web Services account ID of the routing control owner.
	Owner *string

	// The Amazon Resource Name (ARN) of the routing control.
	RoutingControlArn *string

	// The name of the routing control.
	RoutingControlName *string

	// The current state of the routing control. When a routing control state is set
	// to ON, traffic flows to a cell. When the state is set to OFF, traffic does not
	// flow.
	RoutingControlState RoutingControlState

	noSmithyDocumentSerde
}

// A routing control state entry.
type UpdateRoutingControlStateEntry struct {

	// The Amazon Resource Name (ARN) for a routing control state entry.
	//
	// This member is required.
	RoutingControlArn *string

	// The routing control state in a set of routing control state entries.
	//
	// This member is required.
	RoutingControlState RoutingControlState

	noSmithyDocumentSerde
}

// There was a validation error on the request.
type ValidationExceptionField struct {

	// Information about the validation exception.
	//
	// This member is required.
	Message *string

	// The field that had the validation exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
