// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Information of a test device. A thing ARN, certificate ARN or device role ARN
// is required.
type DeviceUnderTest struct {

	// Lists device's certificate ARN.
	CertificateArn *string

	// Lists device's role ARN.
	DeviceRoleArn *string

	// Lists device's thing ARN.
	ThingArn *string

	noSmithyDocumentSerde
}

// Show Group Result.
type GroupResult struct {

	// Group result ID.
	GroupId *string

	// Group Result Name.
	GroupName *string

	// Tests under Group Result.
	Tests []TestCaseRun

	noSmithyDocumentSerde
}

// Gets the suite definition configuration.
type SuiteDefinitionConfiguration struct {

	// Gets the device permission ARN. This is a required parameter.
	//
	// This member is required.
	DevicePermissionRoleArn *string

	// Gets the test suite root group. This is a required parameter. For updating or
	// creating the latest qualification suite, if intendedForQualification is set to
	// true, rootGroup can be an empty string. If intendedForQualification is false,
	// rootGroup cannot be an empty string. If rootGroup is empty, and
	// intendedForQualification is set to true, all the qualification tests are
	// included, and the configuration is default.
	//
	// For a qualification suite, the minimum length is 0, and the maximum is 2048.
	// For a non-qualification suite, the minimum length is 1, and the maximum is 2048.
	//
	// This member is required.
	RootGroup *string

	// Gets the suite definition name. This is a required parameter.
	//
	// This member is required.
	SuiteDefinitionName *string

	// Gets the devices configured.
	Devices []DeviceUnderTest

	// Gets the tests intended for qualification in a suite.
	IntendedForQualification *bool

	// Verifies if the test suite is a long duration test.
	IsLongDurationTest *bool

	// Sets the MQTT protocol that is configured in the suite definition.
	Protocol Protocol

	noSmithyDocumentSerde
}

// Information about the suite definition.
type SuiteDefinitionInformation struct {

	// Date (in Unix epoch time) when the test suite was created.
	CreatedAt *time.Time

	// Specifies the devices that are under test for the test suite.
	DefaultDevices []DeviceUnderTest

	// Specifies if the test suite is intended for qualification.
	IntendedForQualification *bool

	// Verifies if the test suite is a long duration test.
	IsLongDurationTest *bool

	// Gets the MQTT protocol that is configured in the suite definition.
	Protocol Protocol

	// Suite definition ID of the test suite.
	SuiteDefinitionId *string

	// Suite name of the test suite.
	SuiteDefinitionName *string

	noSmithyDocumentSerde
}

// Gets suite run configuration.
type SuiteRunConfiguration struct {

	// Sets the primary device for the test suite run. This requires a thing ARN or a
	// certificate ARN.
	//
	// This member is required.
	PrimaryDevice *DeviceUnderTest

	// TRUE if multiple test suites run in parallel.
	ParallelRun *bool

	// Sets test case list.
	SelectedTestList []string

	noSmithyDocumentSerde
}

// Information about the suite run.
//
// Requires permission to access the [SuiteRunInformation] action.
//
// [SuiteRunInformation]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions
type SuiteRunInformation struct {

	// Date (in Unix epoch time) when the suite run was created.
	CreatedAt *time.Time

	// Date (in Unix epoch time) when the suite run ended.
	EndAt *time.Time

	// Number of test cases that failed in the suite run.
	Failed *int32

	// Number of test cases that passed in the suite run.
	Passed *int32

	// Date (in Unix epoch time) when the suite run was started.
	StartedAt *time.Time

	// Status of the suite run.
	Status SuiteRunStatus

	// Suite definition ID of the suite run.
	SuiteDefinitionId *string

	// Suite definition name of the suite run.
	SuiteDefinitionName *string

	// Suite definition version of the suite run.
	SuiteDefinitionVersion *string

	// Suite run ID of the suite run.
	SuiteRunId *string

	noSmithyDocumentSerde
}

// Provides the test case run.
type TestCaseRun struct {

	// Provides test case run end time.
	EndTime *time.Time

	// Provides test case run failure result.
	Failure *string

	// Provides test case run log URL.
	LogUrl *string

	// Provides test case run start time.
	StartTime *time.Time

	// Provides the test case run status. Status is one of the following:
	//
	//   - PASS : Test passed.
	//
	//   - FAIL : Test failed.
	//
	//   - PENDING : Test has not started running but is scheduled.
	//
	//   - RUNNING : Test is running.
	//
	//   - STOPPING : Test is performing cleanup steps. You will see this status only
	//   if you stop a suite run.
	//
	//   - STOPPED Test is stopped. You will see this status only if you stop a suite
	//   run.
	//
	//   - PASS_WITH_WARNINGS : Test passed with warnings.
	//
	//   - ERORR : Test faced an error when running due to an internal issue.
	Status Status

	// Provides the test case run definition ID.
	TestCaseDefinitionId *string

	// Provides the test case run definition name.
	TestCaseDefinitionName *string

	// Provides the test case run ID.
	TestCaseRunId *string

	//  Provides the test scenarios for the test case run.
	TestScenarios []TestCaseScenario

	// Provides test case run warnings.
	Warnings *string

	noSmithyDocumentSerde
}

// Provides test case scenario.
type TestCaseScenario struct {

	// Provides test case scenario failure result.
	Failure *string

	// Provides the test case scenario status. Status is one of the following:
	//
	//   - PASS : Test passed.
	//
	//   - FAIL : Test failed.
	//
	//   - PENDING : Test has not started running but is scheduled.
	//
	//   - RUNNING : Test is running.
	//
	//   - STOPPING : Test is performing cleanup steps. You will see this status only
	//   if you stop a suite run.
	//
	//   - STOPPED Test is stopped. You will see this status only if you stop a suite
	//   run.
	//
	//   - PASS_WITH_WARNINGS : Test passed with warnings.
	//
	//   - ERORR : Test faced an error when running due to an internal issue.
	Status TestCaseScenarioStatus

	// Provides test case scenario system messages if any.
	SystemMessage *string

	// Provides test case scenario ID.
	TestCaseScenarioId *string

	// Provides test case scenario type. Type is one of the following:
	//
	//   - Advanced
	//
	//   - Basic
	TestCaseScenarioType TestCaseScenarioType

	noSmithyDocumentSerde
}

// Show each group result.
type TestResult struct {

	// Show each group of test results.
	Groups []GroupResult

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
