package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VulnerabilityAssessmentBaselineClient is the the Azure SQL Database management API provides a RESTful set of web
// services that interact with Azure SQL Database services to manage your databases. The API enables you to create,
// retrieve, update, and delete databases.
type VulnerabilityAssessmentBaselineClient struct {
	BaseClient
}

// NewVulnerabilityAssessmentBaselineClient creates an instance of the VulnerabilityAssessmentBaselineClient client.
func NewVulnerabilityAssessmentBaselineClient(subscriptionID string) VulnerabilityAssessmentBaselineClient {
	return NewVulnerabilityAssessmentBaselineClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVulnerabilityAssessmentBaselineClientWithBaseURI creates an instance of the VulnerabilityAssessmentBaselineClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewVulnerabilityAssessmentBaselineClientWithBaseURI(baseURI string, subscriptionID string) VulnerabilityAssessmentBaselineClient {
	return VulnerabilityAssessmentBaselineClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets a list of database's sql vulnerability assessment rule baselines.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
func (client VulnerabilityAssessmentBaselineClient) Get(ctx context.Context, resourceGroupName string, serverName string) (result DatabaseSQLVulnerabilityAssessmentBaselineSet, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentBaselineClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, serverName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VulnerabilityAssessmentBaselineClient) GetPreparer(ctx context.Context, resourceGroupName string, serverName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", "default"),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":        APIVersion,
		"systemDatabaseName": autorest.Encode("query", "master"),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VulnerabilityAssessmentBaselineClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VulnerabilityAssessmentBaselineClient) GetResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentBaselineSet, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBySQLVulnerabilityAssessment gets a list of database's sql vulnerability assessment rule baselines.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
func (client VulnerabilityAssessmentBaselineClient) ListBySQLVulnerabilityAssessment(ctx context.Context, resourceGroupName string, serverName string) (result DatabaseSQLVulnerabilityAssessmentBaselineSetListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentBaselineClient.ListBySQLVulnerabilityAssessment")
		defer func() {
			sc := -1
			if result.dsvabslr.Response.Response != nil {
				sc = result.dsvabslr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listBySQLVulnerabilityAssessmentNextResults
	req, err := client.ListBySQLVulnerabilityAssessmentPreparer(ctx, resourceGroupName, serverName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "ListBySQLVulnerabilityAssessment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListBySQLVulnerabilityAssessmentSender(req)
	if err != nil {
		result.dsvabslr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "ListBySQLVulnerabilityAssessment", resp, "Failure sending request")
		return
	}

	result.dsvabslr, err = client.ListBySQLVulnerabilityAssessmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "ListBySQLVulnerabilityAssessment", resp, "Failure responding to request")
		return
	}
	if result.dsvabslr.hasNextLink() && result.dsvabslr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListBySQLVulnerabilityAssessmentPreparer prepares the ListBySQLVulnerabilityAssessment request.
func (client VulnerabilityAssessmentBaselineClient) ListBySQLVulnerabilityAssessmentPreparer(ctx context.Context, resourceGroupName string, serverName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":        APIVersion,
		"systemDatabaseName": autorest.Encode("query", "master"),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListBySQLVulnerabilityAssessmentSender sends the ListBySQLVulnerabilityAssessment request. The method will close the
// http.Response Body if it receives an error.
func (client VulnerabilityAssessmentBaselineClient) ListBySQLVulnerabilityAssessmentSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListBySQLVulnerabilityAssessmentResponder handles the response to the ListBySQLVulnerabilityAssessment request. The method always
// closes the http.Response Body.
func (client VulnerabilityAssessmentBaselineClient) ListBySQLVulnerabilityAssessmentResponder(resp *http.Response) (result DatabaseSQLVulnerabilityAssessmentBaselineSetListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listBySQLVulnerabilityAssessmentNextResults retrieves the next set of results, if any.
func (client VulnerabilityAssessmentBaselineClient) listBySQLVulnerabilityAssessmentNextResults(ctx context.Context, lastResults DatabaseSQLVulnerabilityAssessmentBaselineSetListResult) (result DatabaseSQLVulnerabilityAssessmentBaselineSetListResult, err error) {
	req, err := lastResults.databaseSQLVulnerabilityAssessmentBaselineSetListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "listBySQLVulnerabilityAssessmentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListBySQLVulnerabilityAssessmentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "listBySQLVulnerabilityAssessmentNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListBySQLVulnerabilityAssessmentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentBaselineClient", "listBySQLVulnerabilityAssessmentNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListBySQLVulnerabilityAssessmentComplete enumerates all values, automatically crossing page boundaries as required.
func (client VulnerabilityAssessmentBaselineClient) ListBySQLVulnerabilityAssessmentComplete(ctx context.Context, resourceGroupName string, serverName string) (result DatabaseSQLVulnerabilityAssessmentBaselineSetListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentBaselineClient.ListBySQLVulnerabilityAssessment")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListBySQLVulnerabilityAssessment(ctx, resourceGroupName, serverName)
	return
}
