package storage

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessTier enumerates the values for access tier.
type AccessTier string

const (
	// Cool ...
	Cool AccessTier = "Cool"
	// Hot ...
	Hot AccessTier = "Hot"
)

// PossibleAccessTierValues returns an array of possible values for the AccessTier const type.
func PossibleAccessTierValues() []AccessTier {
	return []AccessTier{Cool, Hot}
}

// AccountStatus enumerates the values for account status.
type AccountStatus string

const (
	// Available ...
	Available AccountStatus = "available"
	// Unavailable ...
	Unavailable AccountStatus = "unavailable"
)

// PossibleAccountStatusValues returns an array of possible values for the AccountStatus const type.
func PossibleAccountStatusValues() []AccountStatus {
	return []AccountStatus{Available, Unavailable}
}

// HTTPProtocol enumerates the values for http protocol.
type HTTPProtocol string

const (
	// HTTPS ...
	HTTPS HTTPProtocol = "https"
	// Httpshttp ...
	Httpshttp HTTPProtocol = "https,http"
)

// PossibleHTTPProtocolValues returns an array of possible values for the HTTPProtocol const type.
func PossibleHTTPProtocolValues() []HTTPProtocol {
	return []HTTPProtocol{HTTPS, Httpshttp}
}

// KeyPermission enumerates the values for key permission.
type KeyPermission string

const (
	// Full ...
	Full KeyPermission = "Full"
	// Read ...
	Read KeyPermission = "Read"
)

// PossibleKeyPermissionValues returns an array of possible values for the KeyPermission const type.
func PossibleKeyPermissionValues() []KeyPermission {
	return []KeyPermission{Full, Read}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// BlobStorage ...
	BlobStorage Kind = "BlobStorage"
	// Storage ...
	Storage Kind = "Storage"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{BlobStorage, Storage}
}

// Permissions enumerates the values for permissions.
type Permissions string

const (
	// A ...
	A Permissions = "a"
	// C ...
	C Permissions = "c"
	// D ...
	D Permissions = "d"
	// L ...
	L Permissions = "l"
	// P ...
	P Permissions = "p"
	// R ...
	R Permissions = "r"
	// U ...
	U Permissions = "u"
	// W ...
	W Permissions = "w"
)

// PossiblePermissionsValues returns an array of possible values for the Permissions const type.
func PossiblePermissionsValues() []Permissions {
	return []Permissions{A, C, D, L, P, R, U, W}
}

// Permissions1 enumerates the values for permissions 1.
type Permissions1 string

const (
	// Permissions1A ...
	Permissions1A Permissions1 = "a"
	// Permissions1C ...
	Permissions1C Permissions1 = "c"
	// Permissions1D ...
	Permissions1D Permissions1 = "d"
	// Permissions1L ...
	Permissions1L Permissions1 = "l"
	// Permissions1P ...
	Permissions1P Permissions1 = "p"
	// Permissions1R ...
	Permissions1R Permissions1 = "r"
	// Permissions1U ...
	Permissions1U Permissions1 = "u"
	// Permissions1W ...
	Permissions1W Permissions1 = "w"
)

// PossiblePermissions1Values returns an array of possible values for the Permissions1 const type.
func PossiblePermissions1Values() []Permissions1 {
	return []Permissions1{Permissions1A, Permissions1C, Permissions1D, Permissions1L, Permissions1P, Permissions1R, Permissions1U, Permissions1W}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Creating ...
	Creating ProvisioningState = "Creating"
	// ResolvingDNS ...
	ResolvingDNS ProvisioningState = "ResolvingDNS"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Creating, ResolvingDNS, Succeeded}
}

// Reason enumerates the values for reason.
type Reason string

const (
	// AccountNameInvalid ...
	AccountNameInvalid Reason = "AccountNameInvalid"
	// AlreadyExists ...
	AlreadyExists Reason = "AlreadyExists"
)

// PossibleReasonValues returns an array of possible values for the Reason const type.
func PossibleReasonValues() []Reason {
	return []Reason{AccountNameInvalid, AlreadyExists}
}

// ResourceTypes enumerates the values for resource types.
type ResourceTypes string

const (
	// ResourceTypesC ...
	ResourceTypesC ResourceTypes = "c"
	// ResourceTypesO ...
	ResourceTypesO ResourceTypes = "o"
	// ResourceTypesS ...
	ResourceTypesS ResourceTypes = "s"
)

// PossibleResourceTypesValues returns an array of possible values for the ResourceTypes const type.
func PossibleResourceTypesValues() []ResourceTypes {
	return []ResourceTypes{ResourceTypesC, ResourceTypesO, ResourceTypesS}
}

// Services enumerates the values for services.
type Services string

const (
	// B ...
	B Services = "b"
	// F ...
	F Services = "f"
	// Q ...
	Q Services = "q"
	// T ...
	T Services = "t"
)

// PossibleServicesValues returns an array of possible values for the Services const type.
func PossibleServicesValues() []Services {
	return []Services{B, F, Q, T}
}

// SignedResource enumerates the values for signed resource.
type SignedResource string

const (
	// SignedResourceB ...
	SignedResourceB SignedResource = "b"
	// SignedResourceC ...
	SignedResourceC SignedResource = "c"
	// SignedResourceF ...
	SignedResourceF SignedResource = "f"
	// SignedResourceS ...
	SignedResourceS SignedResource = "s"
)

// PossibleSignedResourceValues returns an array of possible values for the SignedResource const type.
func PossibleSignedResourceValues() []SignedResource {
	return []SignedResource{SignedResourceB, SignedResourceC, SignedResourceF, SignedResourceS}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// PremiumLRS ...
	PremiumLRS SkuName = "Premium_LRS"
	// StandardGRS ...
	StandardGRS SkuName = "Standard_GRS"
	// StandardLRS ...
	StandardLRS SkuName = "Standard_LRS"
	// StandardRAGRS ...
	StandardRAGRS SkuName = "Standard_RAGRS"
	// StandardZRS ...
	StandardZRS SkuName = "Standard_ZRS"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{PremiumLRS, StandardGRS, StandardLRS, StandardRAGRS, StandardZRS}
}

// SkuTier enumerates the values for sku tier.
type SkuTier string

const (
	// Premium ...
	Premium SkuTier = "Premium"
	// Standard ...
	Standard SkuTier = "Standard"
)

// PossibleSkuTierValues returns an array of possible values for the SkuTier const type.
func PossibleSkuTierValues() []SkuTier {
	return []SkuTier{Premium, Standard}
}

// UsageUnit enumerates the values for usage unit.
type UsageUnit string

const (
	// Bytes ...
	Bytes UsageUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond UsageUnit = "BytesPerSecond"
	// Count ...
	Count UsageUnit = "Count"
	// CountsPerSecond ...
	CountsPerSecond UsageUnit = "CountsPerSecond"
	// Percent ...
	Percent UsageUnit = "Percent"
	// Seconds ...
	Seconds UsageUnit = "Seconds"
)

// PossibleUsageUnitValues returns an array of possible values for the UsageUnit const type.
func PossibleUsageUnitValues() []UsageUnit {
	return []UsageUnit{Bytes, BytesPerSecond, Count, CountsPerSecond, Percent, Seconds}
}
