# gozerbot/utils/log.py
#
#

""" gozerbots logging module. logging is implemented with the use of a 
    loglevel and a loglist of plugins to log for. 
"""

# basic imports

from trace import whichmodule
import logging, logging.handlers, sys, traceback, os, thread

# basic logger
logging.basicConfig(level=logging.INFO, format="[%(asctime)s] (%(name)s) %(message)s")

basiclogger = logging.getLogger('')

# check if we are in GAE

# make sure dirs are there
if not os.path.isdir('logs'):
    os.mkdir('logs')
if not os.path.isdir('logs' + os.sep + 'bot'):
    os.mkdir('logs' + os.sep + 'bot')

# add logging to file
filehandler = logging.handlers.TimedRotatingFileHandler(
              'logs' + os.sep + 'bot' + os.sep + 'gozerbot.log', 'midnight')
formatter = logging.Formatter("[%(asctime)s] (%(name)s) %(message)s")
filehandler.setFormatter(formatter)
basiclogger.addHandler(filehandler)

# the vars
loglevel = 10
logcallbacks = []
loglist = []
logfile = None
enabled = True
debuglog = False

# lock

loglock = thread.allocate_lock()

def exceptionmsg():
    """ create a exception traceback as 1 liner. """
    exctype, excvalue, tb = sys.exc_info()
    trace = traceback.extract_tb(tb)
    result = ""   
    for i in trace:
        fname = i[0]
        linenr = i[1]
        func = i[2]
        result += "%s:%s %s | " % (fname, linenr, func)
    del trace
    return "%s%s: %s" % (result, exctype, excvalue)

def rlog(level, descr, txt):
    """ log an item showing description and txt. call logcallbacks if 
        available
    """
    if not enabled:
        return
    try:
        #loglock.acquire()
        logger = logging.getLogger(descr)

        go = False

        if loglist:

            for item in loglist:

                if item in descr:
                    go = True

        if level >= loglevel or loglist and go:
            if debuglog:
                logger.info("(%s) %s - <%s>" % (descr, txt, whichmodule(2)))
            else:
                logger.info(txt)
                         
            for cb in logcallbacks:

                try:
                    cb(level, descr, txt)
                except:
                    print exceptionmsg()

    except (IOError, OSError):
        pass
        
def disable_logging():
    global enabled
    enabled = False

def enable_logging(level=10, list=[]):
    """ enable logging setting loglevel and/ort loglist """
    global loglevel, loglist, enabled
    logging.basicConfig(level=logging.INFO, format="[%(asctime)s] %(name)s %(message)s")
    loglevel = level
    loglist = list
    enabled = True
