{- This module was generated from data in the Kate syntax
   highlighting file go.xml, version 1.04, by Miquel Sabaté (mikisabate@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Go
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Go"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.go"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Go","normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Go","normal") -> return ()
      ("Go","Commentar 1") -> (popContext) >> pEndLine
      ("Go","Commentar 2") -> return ()
      ("Go","String") -> (popContext) >> pEndLine
      ("Go","Multiline String") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "break case chan const continue default defer else fallthrough for func go goto if import interface map package range return select struct switch type var"
list_types = Set.fromList $ words $ "bool byte complex64 complex128 error float32 float64 int int8 int16 int32 int64 rune string uint uintptr uint8 uint16 uint32 uint64"
list_builtin = Set.fromList $ words $ "append cap close complex copy delete imag len make new panic print println real recover"
list_predeclared = Set.fromList $ words $ "false nil true iota"


parseRules ("Go","normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_predeclared >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_builtin >>= withAttribute FunctionTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Go","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Go","Commentar 2"))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Go","String"))
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ pushContext ("Go","Multiline String"))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Go","normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Go","Commentar 1") =
  (((pLineContinue >>= withAttribute CommentTok))
   <|>
   ((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Go","Commentar 1")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Go","Commentar 2") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Go","Commentar 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Go","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Go","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Go","Multiline String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '`' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Go","Multiline String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("Go","normal") <|> fail ("Unknown context" ++ show x)
