// Copyright (c) 2019 Intel Corporation
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#pragma once

#include "mfx_common.h"
#if defined(MFX_ENABLE_H265_VIDEO_ENCODE) && (MFX_VERSION >= 1031)

#include "hevcehw_base.h"
#include "hevcehw_g12_data.h"

namespace HEVCEHW
{
namespace Gen12
{
class RExt
    : public FeatureBase
{
public:
#define DECL_BLOCK_LIST\
    DECL_BLOCK(SetRecInfo)\
    DECL_BLOCK(SetGUID)\
    DECL_BLOCK(HardcodeCaps)\
    DECL_BLOCK(SetDefaultsCallChain)\
    DECL_BLOCK(CheckShift)
#define DECL_FEATURE_NAME "G12_RExt"
#include "hevcehw_decl_blocks.h"

    RExt(mfxU32 FeatureId)
        : FeatureBase(FeatureId)
    {}

protected:
    virtual void InitInternal(const FeatureBlocks& blocks, TPushII Push) override;
    virtual void Query1NoCaps(const FeatureBlocks& blocks, TPushQ1 Push) override;
    virtual void Query1WithCaps(const FeatureBlocks& blocks, TPushQ1 Push) override;

    mfxStatus SetGuid(mfxVideoParam& par, StorageRW& strg);

    static bool IsRextFourCC(mfxU32 FourCC)
    {
        return !Check<mfxU32
            , MFX_FOURCC_P016
            , MFX_FOURCC_Y216
            , MFX_FOURCC_Y416>(FourCC);
    }

    static const GUID DXVA2_Intel_Encode_HEVC_Main12;
    static const GUID DXVA2_Intel_Encode_HEVC_Main422_12;
    static const GUID DXVA2_Intel_Encode_HEVC_Main444_12;
};

} //Gen12
} //namespace HEVCEHW

#endif
