/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import net.sourceforge.stripes.util.StringUtil;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Log {
    private org.apache.commons.logging.Log realLog;

    public static Log getInstance(Class<?> clazz) {
        return new Log(LogFactory.getLog(clazz));
    }

    public static void cleanup() {
        LogFactory.release((ClassLoader)Thread.currentThread().getContextClassLoader());
    }

    private Log(org.apache.commons.logging.Log realLog) {
        this.realLog = realLog;
    }

    public final void fatal(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isFatalEnabled()) {
            this.realLog.fatal((Object)StringUtil.combineParts(messageParts), throwable);
        }
    }

    public final void error(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isErrorEnabled()) {
            this.realLog.error((Object)StringUtil.combineParts(messageParts), throwable);
        }
    }

    public final void warn(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isWarnEnabled()) {
            this.realLog.warn((Object)StringUtil.combineParts(messageParts), throwable);
        }
    }

    public final void info(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isInfoEnabled()) {
            this.realLog.info((Object)StringUtil.combineParts(messageParts), throwable);
        }
    }

    public final void debug(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isDebugEnabled()) {
            this.realLog.debug((Object)StringUtil.combineParts(messageParts), throwable);
        }
    }

    public final void trace(Throwable throwable, Object ... messageParts) {
        if (this.realLog.isTraceEnabled()) {
            this.realLog.trace((Object)StringUtil.combineParts(messageParts), throwable);
        }
    }

    public final void fatal(Object ... messageParts) {
        if (this.realLog.isFatalEnabled()) {
            this.realLog.fatal((Object)StringUtil.combineParts(messageParts));
        }
    }

    public final void error(Object ... messageParts) {
        if (this.realLog.isErrorEnabled()) {
            this.realLog.error((Object)StringUtil.combineParts(messageParts));
        }
    }

    public final void warn(Object ... messageParts) {
        if (this.realLog.isWarnEnabled()) {
            this.realLog.warn((Object)StringUtil.combineParts(messageParts));
        }
    }

    public final void info(Object ... messageParts) {
        if (this.realLog.isInfoEnabled()) {
            this.realLog.info((Object)StringUtil.combineParts(messageParts));
        }
    }

    public final void debug(Object ... messageParts) {
        if (this.realLog.isDebugEnabled()) {
            this.realLog.debug((Object)StringUtil.combineParts(messageParts));
        }
    }

    public final void trace(Object ... messageParts) {
        if (this.realLog.isTraceEnabled()) {
            this.realLog.trace((Object)StringUtil.combineParts(messageParts));
        }
    }
}

