/***************************************************************************
 *   Copyright (C) 2006-2007 by Julien Lemoine, Simon Viennot              *
 *   lapinot@tuxfamily.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef CALCUL_H
#define CALCUL_H

#include <set>
#include <list>
#include <string>
#include <iostream>
#include <algorithm>
#include <sstream>

using namespace std;

typedef unsigned char plaque;
typedef long compte;	//attention, ne pas mettre unsigned. On a besoin des ngatifs dans les fonctions de canonisation.

class tirage;

class calcul {
  public:
	// DONNEES
	bool est_plaque;
	plaque pl;
	
	bool est_additif;
	list<calcul> sous_calculs;	//liste des "sous_calculs de profondeur 1"
	bool signe;			//signe du calcul dans son calcul-parent (true=positif, false=ngatif)
	compte valeur_calcul;
	int profondeur;
	
	// AFFICHAGE
	static bool niv_sup; 		//variable statique indiquant si l'on est au niveau suprieur
	string affiche_calcul() const;
	
	// FONCTIONS
	
	//fonctions d'initialisation
	calcul();			//l'initialisation par dfaut se fait sur un calcul de type additif
	calcul(const plaque&); 		//initialisation  partir d'une plaque
	
	//l'oprateur == est utilis dans la dfinition de l'oprateur <
	//l'oprateur < est lui ncessaire pour pouvoir trier une liste de calculs avec "sort"
	bool operator==(const calcul& a) const;
	bool operator<(const calcul& a) const;
	
	//manip de signes
	void oppose_sous_calculs();
	
	//oprations entre 2 calculs
	calcul operator+(const calcul&) const;
	calcul operator-(const calcul&) const;
	calcul operator*(const calcul&) const;
	calcul operator/(const calcul&) const;
	calcul reunion(const calcul&, bool type_additif, bool opposition) const;
	
	//fonctions d'analyse des calculs, ncessaires au fonctionnement des fonctions de canonisation
	list<calcul> liste_sous_calculs() const;
	list<compte> liste_valeurs_combinaisons_enfants(bool) const;
	list<compte> liste_valeurs_combinaisons_descendants(bool) const;
	list<compte> liste_sous_comptes() const;
	tirage liste_plaques() const;
	tirage liste_valeurs() const;
	int longueur() const;		//ncessaire pour jeu::afficheBase2()
	
	//fonction globale de canonisation appellant les fonctions en dessous
	bool est_cano() const;
	//fonctions de canonisation
	static bool cano1_actif, cano2_actif, cano3_actif;	//pour activer ou desactiver les canonisations
	bool est_cano_1() const;
	bool est_cano_2() const;
	bool est_cano_3() const;
};

#endif
