package tests::ConfigPluginSpecTest;

use strict;

use tests::ConfigSpecTest;
use base qw/tests::ConfigSelectSpecTest/;

use Lire::Config::TypeSpec;
use Lire::Config::PluginSpec;
use Lire::Config::RecordSpec;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    my $spec = new Lire::Config::ConfigSpec();
    $self->{'o1_props'} = new Lire::Config::RecordSpec( 'name' => 'option_1_properties' );
    $self->{'o1_props'}->add( new Lire::Config::StringSpec( 'name' => 'string1' ) );
    $spec->add( $self->{'o1_props'} );
    $self->{'o2_props'} = new Lire::Config::RecordSpec( 'name' => 'option_2_properties' );
    $self->{'o2_props'}->add( new Lire::Config::StringSpec( 'name' => 'string2' ) );
    $spec->add( $self->{'o2_props'} );

    $self->{'cfg'}{'_lr_config_spec'} = $spec;

    return;
}


sub type {
    return 'Lire::Config::PluginSpec';
}

sub test_new {
    my $self = $_[0];

    $self->SUPER::test_new();

    my $no_props_spec =
      new Lire::Config::RecordSpec( 'name' => $self->{'spec'}->name() . "_no_properties" );
    $self->assert_isa( 'Lire::Config::RecordSpec',
                       $self->{'spec'}{'_no_properties_spec'} );
    $self->assert_deep_equals( $no_props_spec,
                               $self->{'spec'}->{'_no_properties_spec'} );
}

sub test_get_properties_spec {
    my $self = $_[0];

    $self->assert_str_equals( $self->{'spec'}{'_no_properties_spec'},
                              $self->{'spec'}->get_properties_spec( undef ));

    $self->assert_str_equals( $self->{'o1_props'},
                              $self->{'spec'}->get_properties_spec( 'option_1' ) );

    $self->assert_str_equals( $self->{'o2_props'},
                              $self->{'spec'}->get_properties_spec( 'OPTION_2') );

    $self->assert_deep_equals( $self->{'spec'}{'_no_properties_spec'},
                               $self->{'spec'}->get_properties_spec( 'option_3' ) );
    $self->assert_dies( qr/no option 'option_4' in this specification/,
                        sub { $self->{'spec'}->get_properties_spec( 'option_4' ) } );
}

1;

