package tests::functional;

use File::Basename qw/dirname/;
use Cwd qw/realpath/;

use base 'Test::Unit::TestSuite';

sub name { "All Lire's Functional Tests" }

sub include_tests {

    # Files containing test cases all ends in Test.pm
    my $dir =  realpath( dirname(__FILE__) . "/functional" );

    opendir DIR, $dir
      or die "can't opendir $dir: $!";
    my @tests = ();
    foreach my $e ( readdir DIR ) {
        next unless $e =~ /(.*Test)\.pm$/;
        push @tests, "tests::functional::$1";
    }
    closedir DIR;

    @tests;
}

1;
