// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -verify -fopenmp -x c++ -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -fopenmp -x c++ -std=c++11 -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -x c++ -triple x86_64-apple-darwin10 -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -verify -fopenmp -x c++ -std=c++11 -DLAMBDA -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK3
// RUN: %clang_cc1 -verify -fopenmp -x c++ -fblocks -DBLOCKS -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK4

// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -fopenmp-simd -x c++ -std=c++11 -triple x86_64-apple-darwin10 -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -x c++ -triple x86_64-apple-darwin10 -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -std=c++11 -DLAMBDA -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -verify -fopenmp-simd -x c++ -fblocks -DBLOCKS -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// expected-no-diagnostics
#ifndef HEADER
#define HEADER

volatile int g __attribute__((aligned(128))) = 1212;

template <class T>
struct S {
  T f;
  S(T a) : f(a + g) {}
  S() : f(g) {}
  operator T() { return T(); }
  S &operator&(const S &) { return *this; }
  ~S() {}
};

struct SS {
  int a;
  int b : 4;
  int &c;
  SS(int &d) : a(0), b(0), c(d) {
#pragma omp parallel reduction(default, +: a, b, c)
#ifdef LAMBDA
    [&]() {
      ++this->a, --b, (this)->c /= 1;
#pragma omp parallel reduction(&: a, b, c)
      ++(this)->a, --b, this->c /= 1;
    }();
#elif defined(BLOCKS)
    ^{
      ++a;
      --this->b;
      (this)->c /= 1;
#pragma omp parallel reduction(-: a, b, c)
      ++(this)->a, --b, this->c /= 1;
    }();
#else
    ++this->a, --b, c /= 1;
#endif
  }
};

template<typename T>
struct SST {
  T a;
  SST() : a(T()) {
#pragma omp parallel reduction(*: a)
#ifdef LAMBDA
    [&]() {
      [&]() {
        ++this->a;
#pragma omp parallel reduction(&& :a)
        ++(this)->a;
      }();
    }();
#elif defined(BLOCKS)
    ^{
      ^{
        ++a;
#pragma omp parallel reduction(|: a)
        ++(this)->a;
      }();
    }();
#else
    ++(this)->a;
#endif
  }
};


void foo_array_sect(short x[1]) {
#pragma omp parallel reduction(default, + : x[:])
  {}
}

template <typename T>
T tmain() {
  T t;
  S<T> test;
  SST<T> sst;
  T t_var __attribute__((aligned(128))) = T(), t_var1 __attribute__((aligned(128)));
  T vec[] = {1, 2};
  S<T> s_arr[]  = {1, 2};
  S<T> var __attribute__((aligned(128))) (3), var1 __attribute__((aligned(128)));
#pragma omp parallel reduction(+:t_var) reduction(&:var) reduction(&& : var1) reduction(min: t_var1)
  {
    vec[0] = t_var;
    s_arr[0] = var;
  }
  return T();
}

int sivar;
int main() {
  SS ss(sivar);
#ifdef LAMBDA
  [&]() {
#pragma omp parallel reduction(+:g)
  {




    // Reduction list for runtime.

    g = 1;

    [&]() {
      g = 2;
    }();
  }
  }();
  return 0;
#elif defined(BLOCKS)
  ^{
#pragma omp parallel reduction(-:g)
  {

    // Reduction list for runtime.

    g = 1;

    ^{
      g = 2;
    }();
  }
  }();
  return 0;


#else
  S<float> test;
  float t_var = 0, t_var1;
  int vec[] = {1, 2};
  S<float> s_arr[] = {1, 2};
  S<float> var(3), var1;
  float _Complex cf;
#pragma omp parallel reduction(+:t_var) reduction(&:var) reduction(&& : var1) reduction(min: t_var1)
  {
    vec[0] = t_var;
    s_arr[0] = var;
  }
  if (var1)
#pragma omp parallel reduction(+ : t_var) reduction(& : var) reduction(&& : var1) reduction(min : t_var1)
    while (1) {
      vec[0] = t_var;
      s_arr[0] = var;
    }
#pragma omp parallel reduction(+ : cf)
    ;
  return tmain<int>();
#endif
}


// Reduction list for runtime.



// For + reduction operation initial value of private variable is 0.

// For & reduction operation initial value of private variable is ones in all bits.

// For && reduction operation initial value of private variable is 1.0.

// For min reduction operation initial value of private variable is largest repesentable value.

// Skip checks for internal operations.

// ptr RedList[<n>] = {<ReductionVars>[0], ..., <ReductionVars>[<n>-1]};


// res = __kmpc_reduce_nowait(<loc>, <gtid>, <n>, sizeof(RedList), RedList, reduce_func, &<lock>);


// switch(res)

// case 1:
// t_var += t_var_reduction;

// var = var.operator &(var_reduction);

// var1 = var1.operator &&(var1_reduction);

// t_var1 = min(t_var1, t_var1_reduction);

// __kmpc_end_reduce_nowait(<loc>, <gtid>, &<lock>);

// break;

// case 2:
// t_var += t_var_reduction;

// var = var.operator &(var_reduction);

// var1 = var1.operator &&(var1_reduction);

// t_var1 = min(t_var1, t_var1_reduction);

// break;


// void reduce_func(ptr lhs[<n>], ptr rhs[<n>]) {
//  *(Type0*)lhs[0] = ReductionOperation0(*(Type0*)lhs[0], *(Type0*)rhs[0]);
//  ...
//  *(Type<n>-1*)lhs[<n>-1] = ReductionOperation<n>-1(*(Type<n>-1*)lhs[<n>-1],
//  *(Type<n>-1*)rhs[<n>-1]);
// }
// t_var_lhs = (ptr)lhs[0];
// t_var_rhs = (ptr)rhs[0];

// var_lhs = (Sptr)lhs[1];
// var_rhs = (Sptr)rhs[1];

// var1_lhs = (Sptr)lhs[2];
// var1_rhs = (Sptr)rhs[2];

// t_var1_lhs = (ptr)lhs[3];
// t_var1_rhs = (ptr)rhs[3];

// t_var_lhs += t_var_rhs;

// var_lhs = var_lhs.operator &(var_rhs);

// var1_lhs = var1_lhs.operator &&(var1_rhs);

// t_var1_lhs = min(t_var1_lhs, t_var1_rhs);




// For + reduction operation initial value of private variable is 0.

// For & reduction operation initial value of private variable is ones in all bits.

// For && reduction operation initial value of private variable is 1.0.

// For min reduction operation initial value of private variable is largest repesentable value.






// Reduction list for runtime.



// For + reduction operation initial value of private variable is 0.

// For & reduction operation initial value of private variable is ones in all bits.

// For && reduction operation initial value of private variable is 1.0.

// For min reduction operation initial value of private variable is largest repesentable value.

// Skip checks for internal operations.

// ptr RedList[<n>] = {<ReductionVars>[0], ..., <ReductionVars>[<n>-1]};


// res = __kmpc_reduce_nowait(<loc>, <gtid>, <n>, sizeof(RedList), RedList, reduce_func, &<lock>);


// switch(res)

// case 1:
// t_var += t_var_reduction;

// var = var.operator &(var_reduction);

// var1 = var1.operator &&(var1_reduction);

// t_var1 = min(t_var1, t_var1_reduction);

// __kmpc_end_reduce_nowait(<loc>, <gtid>, &<lock>);

// break;

// case 2:
// t_var += t_var_reduction;

// var = var.operator &(var_reduction);

// var1 = var1.operator &&(var1_reduction);

// t_var1 = min(t_var1, t_var1_reduction);

// break;


// void reduce_func(ptr lhs[<n>], ptr rhs[<n>]) {
//  *(Type0*)lhs[0] = ReductionOperation0(*(Type0*)lhs[0], *(Type0*)rhs[0]);
//  ...
//  *(Type<n>-1*)lhs[<n>-1] = ReductionOperation<n>-1(*(Type<n>-1*)lhs[<n>-1],
//  *(Type<n>-1*)rhs[<n>-1]);
// }
// t_var_lhs = (iptr)lhs[0];
// t_var_rhs = (iptr)rhs[0];

// var_lhs = (Sptr)lhs[1];
// var_rhs = (Sptr)rhs[1];

// var1_lhs = (Sptr)lhs[2];
// var1_rhs = (Sptr)rhs[2];

// t_var1_lhs = (iptr)lhs[3];
// t_var1_rhs = (iptr)rhs[3];

// t_var_lhs += t_var_rhs;

// var_lhs = var_lhs.operator &(var_rhs);

// var1_lhs = var1_lhs.operator &&(var1_rhs);

// t_var1_lhs = min(t_var1_lhs, t_var1_rhs);

#endif
// CHECK1-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs
// CHECK1-SAME: (ptr noundef [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2:[0-9]+]], i32 1, ptr @_Z14foo_array_sectPs.omp_outlined, ptr [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[X:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x ptr], align 8
// CHECK1-NEXT:    [[ATOMIC_TEMP:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    [[_TMP13:%.*]] = alloca i16, align 2
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, ptr [[TMP0]], i64 0
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK1-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i16, ptr [[TMP1]], i64 0
// CHECK1-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[ARRAYIDX1]] to i64
// CHECK1-NEXT:    [[TMP3:%.*]] = ptrtoint ptr [[ARRAYIDX]] to i64
// CHECK1-NEXT:    [[TMP4:%.*]] = sub i64 [[TMP2]], [[TMP3]]
// CHECK1-NEXT:    [[TMP5:%.*]] = sdiv exact i64 [[TMP4]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK1-NEXT:    [[TMP6:%.*]] = add nuw i64 [[TMP5]], 1
// CHECK1-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP6]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK1-NEXT:    [[TMP8:%.*]] = call ptr @llvm.stacksave.p0()
// CHECK1-NEXT:    store ptr [[TMP8]], ptr [[SAVED_STACK]], align 8
// CHECK1-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP6]], align 16
// CHECK1-NEXT:    store i64 [[TMP6]], ptr [[__VLA_EXPR0]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr i16, ptr [[VLA]], i64 [[TMP6]]
// CHECK1-NEXT:    [[OMP_ARRAYINIT_ISEMPTY:%.*]] = icmp eq ptr [[VLA]], [[TMP9]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYINIT_ISEMPTY]], label [[OMP_ARRAYINIT_DONE:%.*]], label [[OMP_ARRAYINIT_BODY:%.*]]
// CHECK1:       omp.arrayinit.body:
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[VLA]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYINIT_BODY]] ]
// CHECK1-NEXT:    store i16 0, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP9]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYINIT_DONE]], label [[OMP_ARRAYINIT_BODY]]
// CHECK1:       omp.arrayinit.done:
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = ptrtoint ptr [[TMP10]] to i64
// CHECK1-NEXT:    [[TMP12:%.*]] = ptrtoint ptr [[ARRAYIDX]] to i64
// CHECK1-NEXT:    [[TMP13:%.*]] = sub i64 [[TMP11]], [[TMP12]]
// CHECK1-NEXT:    [[TMP14:%.*]] = sdiv exact i64 [[TMP13]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr i16, ptr [[VLA]], i64 [[TMP14]]
// CHECK1-NEXT:    store ptr [[TMP15]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[VLA]], ptr [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP18:%.*]] = inttoptr i64 [[TMP6]] to ptr
// CHECK1-NEXT:    store ptr [[TMP18]], ptr [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP19]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1:[0-9]+]], i32 [[TMP20]], i32 1, i64 16, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_Z14foo_array_sectPs.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    switch i32 [[TMP21]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK1-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK1-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK1-NEXT:    ]
// CHECK1:       .omp.reduction.case1:
// CHECK1-NEXT:    [[TMP22:%.*]] = getelementptr i16, ptr [[ARRAYIDX]], i64 [[TMP6]]
// CHECK1-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAYIDX]], [[TMP22]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE7:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK1:       omp.arraycpy.body:
// CHECK1-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[VLA]], [[DOTOMP_REDUCTION_CASE1]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST2:%.*]] = phi ptr [ [[ARRAYIDX]], [[DOTOMP_REDUCTION_CASE1]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT5:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK1-NEXT:    [[TMP23:%.*]] = load i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP23]] to i32
// CHECK1-NEXT:    [[TMP24:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], align 2
// CHECK1-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP24]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV3]]
// CHECK1-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV4]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], align 2
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT5]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DONE6:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT5]], [[TMP22]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_DONE6]], label [[OMP_ARRAYCPY_DONE7]], label [[OMP_ARRAYCPY_BODY]]
// CHECK1:       omp.arraycpy.done7:
// CHECK1-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP20]], ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.case2:
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr i16, ptr [[ARRAYIDX]], i64 [[TMP6]]
// CHECK1-NEXT:    [[OMP_ARRAYCPY_ISEMPTY8:%.*]] = icmp eq ptr [[ARRAYIDX]], [[TMP25]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY8]], label [[OMP_ARRAYCPY_DONE21:%.*]], label [[OMP_ARRAYCPY_BODY9:%.*]]
// CHECK1:       omp.arraycpy.body9:
// CHECK1-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST10:%.*]] = phi ptr [ [[VLA]], [[DOTOMP_REDUCTION_CASE2]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT19:%.*]], [[ATOMIC_EXIT:%.*]] ]
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST11:%.*]] = phi ptr [ [[ARRAYIDX]], [[DOTOMP_REDUCTION_CASE2]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT18:%.*]], [[ATOMIC_EXIT]] ]
// CHECK1-NEXT:    [[TMP26:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], align 2
// CHECK1-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP26]] to i32
// CHECK1-NEXT:    [[ATOMIC_LOAD:%.*]] = load atomic i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]] monotonic, align 2
// CHECK1-NEXT:    br label [[ATOMIC_CONT:%.*]]
// CHECK1:       atomic_cont:
// CHECK1-NEXT:    [[TMP27:%.*]] = phi i16 [ [[ATOMIC_LOAD]], [[OMP_ARRAYCPY_BODY9]] ], [ [[TMP32:%.*]], [[ATOMIC_CONT]] ]
// CHECK1-NEXT:    store i16 [[TMP27]], ptr [[_TMP13]], align 2
// CHECK1-NEXT:    [[TMP28:%.*]] = load i16, ptr [[_TMP13]], align 2
// CHECK1-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP28]] to i32
// CHECK1-NEXT:    [[TMP29:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], align 2
// CHECK1-NEXT:    [[CONV15:%.*]] = sext i16 [[TMP29]] to i32
// CHECK1-NEXT:    [[ADD16:%.*]] = add nsw i32 [[CONV14]], [[CONV15]]
// CHECK1-NEXT:    [[CONV17:%.*]] = trunc i32 [[ADD16]] to i16
// CHECK1-NEXT:    store i16 [[CONV17]], ptr [[ATOMIC_TEMP]], align 2
// CHECK1-NEXT:    [[TMP30:%.*]] = load i16, ptr [[ATOMIC_TEMP]], align 2
// CHECK1-NEXT:    [[TMP31:%.*]] = cmpxchg ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]], i16 [[TMP27]], i16 [[TMP30]] monotonic monotonic, align 2
// CHECK1-NEXT:    [[TMP32]] = extractvalue { i16, i1 } [[TMP31]], 0
// CHECK1-NEXT:    [[TMP33:%.*]] = extractvalue { i16, i1 } [[TMP31]], 1
// CHECK1-NEXT:    br i1 [[TMP33]], label [[ATOMIC_EXIT]], label [[ATOMIC_CONT]]
// CHECK1:       atomic_exit:
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT18]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT19]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DONE20:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT18]], [[TMP25]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_DONE20]], label [[OMP_ARRAYCPY_DONE21]], label [[OMP_ARRAYCPY_BODY9]]
// CHECK1:       omp.arraycpy.done21:
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.default:
// CHECK1-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// CHECK1-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP34]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs.omp_outlined.omp.reduction.reduction_func
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[TMP9]] to i64
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr i16, ptr [[TMP7]], i64 [[TMP10]]
// CHECK1-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[TMP7]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK1:       omp.arraycpy.body:
// CHECK1-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP5]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[TMP7]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK1-NEXT:    [[TMP12:%.*]] = load i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK1-NEXT:    [[CONV:%.*]] = sext i16 [[TMP12]] to i32
// CHECK1-NEXT:    [[TMP13:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], align 2
// CHECK1-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP13]] to i32
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV2]]
// CHECK1-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD]] to i16
// CHECK1-NEXT:    store i16 [[CONV3]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP11]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]]
// CHECK1:       omp.arraycpy.done4:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@main
// CHECK1-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK1-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK1-NEXT:    [[T_VAR:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[T_VAR1:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK1-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S], align 4
// CHECK1-NEXT:    [[VAR:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK1-NEXT:    [[VAR1:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK1-NEXT:    [[CF:%.*]] = alloca { float, float }, align 4
// CHECK1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    call void @_ZN2SSC1ERi(ptr noundef nonnull align 8 dereferenceable(16) [[SS]], ptr noundef nonnull align 4 dereferenceable(4) @sivar)
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK1-NEXT:    store float 0.000000e+00, ptr [[T_VAR]], align 4
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const.main.vec, i64 8, i1 false)
// CHECK1-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i64 0, i64 0
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], float noundef 1.000000e+00)
// CHECK1-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYINIT_BEGIN]], i64 1
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], float noundef 2.000000e+00)
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]], float noundef 3.000000e+00)
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR1]])
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 6, ptr @main.omp_outlined, ptr [[VEC]], ptr [[T_VAR]], ptr [[S_ARR]], ptr [[VAR]], ptr [[VAR1]], ptr [[T_VAR1]])
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef float @_ZN1SIfEcvfEv(ptr noundef nonnull align 4 dereferenceable(4) [[VAR1]])
// CHECK1-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[CALL]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[IF_END:%.*]]
// CHECK1:       if.then:
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 6, ptr @main.omp_outlined.1, ptr [[VEC]], ptr [[T_VAR]], ptr [[S_ARR]], ptr [[VAR]], ptr [[VAR1]], ptr [[T_VAR1]])
// CHECK1-NEXT:    br label [[IF_END]]
// CHECK1:       if.end:
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 1, ptr @main.omp_outlined.2, ptr [[CF]])
// CHECK1-NEXT:    [[CALL1:%.*]] = call noundef i32 @_Z5tmainIiET_v()
// CHECK1-NEXT:    store i32 [[CALL1]], ptr [[RETVAL]], align 4
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR1]]) #[[ATTR5:[0-9]+]]
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]]) #[[ATTR5]]
// CHECK1-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[S_ARR]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP0]], [[IF_END]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR5]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE2:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done2:
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR5]]
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    ret i32 [[TMP1]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2SSC2ERi(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SIfEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfEC1Ef
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    call void @_ZN1SIfEC2Ef(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], float noundef [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@main.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR1:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VAR1_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR1_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR2:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[VAR3:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK1-NEXT:    [[VAR14:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK1-NEXT:    [[T_VAR15:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [4 x ptr], align 8
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK1-NEXT:    [[REF_TMP12:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK1-NEXT:    [[ATOMIC_TEMP:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca float, align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VAR1]], ptr [[VAR1_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[T_VAR1]], ptr [[T_VAR1_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[T_VAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[VAR1_ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[T_VAR1_ADDR]], align 8
// CHECK1-NEXT:    store float 0.000000e+00, ptr [[T_VAR2]], align 4
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]])
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]])
// CHECK1-NEXT:    store float 0x47EFFFFFE0000000, ptr [[T_VAR15]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load float, ptr [[T_VAR2]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP6]] to i32
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[TMP0]], i64 0, i64 0
// CHECK1-NEXT:    store i32 [[CONV]], ptr [[ARRAYIDX]], align 4
// CHECK1-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX6]], ptr align 4 [[VAR3]], i64 4, i1 false)
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[T_VAR2]], ptr [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK1-NEXT:    store ptr [[VAR3]], ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 2
// CHECK1-NEXT:    store ptr [[VAR14]], ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 3
// CHECK1-NEXT:    store ptr [[T_VAR15]], ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP11]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP12]], i32 4, i64 32, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @main.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    switch i32 [[TMP13]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK1-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK1-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK1-NEXT:    ]
// CHECK1:       .omp.reduction.case1:
// CHECK1-NEXT:    [[TMP14:%.*]] = load float, ptr [[TMP1]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load float, ptr [[T_VAR2]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = fadd float [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    store float [[ADD]], ptr [[TMP1]], align 4
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN1SIfEanERKS0_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP3]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP3]], ptr align 4 [[CALL]], i64 4, i1 false)
// CHECK1-NEXT:    [[CALL7:%.*]] = call noundef float @_ZN1SIfEcvfEv(ptr noundef nonnull align 4 dereferenceable(4) [[TMP4]])
// CHECK1-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[CALL7]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[LAND_RHS:%.*]], label [[LAND_END:%.*]]
// CHECK1:       land.rhs:
// CHECK1-NEXT:    [[CALL8:%.*]] = call noundef float @_ZN1SIfEcvfEv(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]])
// CHECK1-NEXT:    [[TOBOOL9:%.*]] = fcmp une float [[CALL8]], 0.000000e+00
// CHECK1-NEXT:    br label [[LAND_END]]
// CHECK1:       land.end:
// CHECK1-NEXT:    [[TMP16:%.*]] = phi i1 [ false, [[DOTOMP_REDUCTION_CASE1]] ], [ [[TOBOOL9]], [[LAND_RHS]] ]
// CHECK1-NEXT:    [[CONV10:%.*]] = uitofp i1 [[TMP16]] to float
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP]], float noundef [[CONV10]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP4]], ptr align 4 [[REF_TMP]], i64 4, i1 false)
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP]]) #[[ATTR5]]
// CHECK1-NEXT:    [[TMP17:%.*]] = load float, ptr [[TMP5]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load float, ptr [[T_VAR15]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = fcmp olt float [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP19:%.*]] = load float, ptr [[TMP5]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP20:%.*]] = load float, ptr [[T_VAR15]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi float [ [[TMP19]], [[COND_TRUE]] ], [ [[TMP20]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store float [[COND]], ptr [[TMP5]], align 4
// CHECK1-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP12]], ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.case2:
// CHECK1-NEXT:    [[TMP21:%.*]] = load float, ptr [[T_VAR2]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = atomicrmw fadd ptr [[TMP1]], float [[TMP21]] monotonic, align 4
// CHECK1-NEXT:    call void @__kmpc_critical(ptr @[[GLOB2]], i32 [[TMP12]], ptr @.gomp_critical_user_.atomic_reduction.var)
// CHECK1-NEXT:    [[CALL11:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN1SIfEanERKS0_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP3]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP3]], ptr align 4 [[CALL11]], i64 4, i1 false)
// CHECK1-NEXT:    call void @__kmpc_end_critical(ptr @[[GLOB2]], i32 [[TMP12]], ptr @.gomp_critical_user_.atomic_reduction.var)
// CHECK1-NEXT:    call void @__kmpc_critical(ptr @[[GLOB2]], i32 [[TMP12]], ptr @.gomp_critical_user_.atomic_reduction.var)
// CHECK1-NEXT:    [[CALL13:%.*]] = call noundef float @_ZN1SIfEcvfEv(ptr noundef nonnull align 4 dereferenceable(4) [[TMP4]])
// CHECK1-NEXT:    [[TOBOOL14:%.*]] = fcmp une float [[CALL13]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[TOBOOL14]], label [[LAND_RHS15:%.*]], label [[LAND_END18:%.*]]
// CHECK1:       land.rhs15:
// CHECK1-NEXT:    [[CALL16:%.*]] = call noundef float @_ZN1SIfEcvfEv(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]])
// CHECK1-NEXT:    [[TOBOOL17:%.*]] = fcmp une float [[CALL16]], 0.000000e+00
// CHECK1-NEXT:    br label [[LAND_END18]]
// CHECK1:       land.end18:
// CHECK1-NEXT:    [[TMP23:%.*]] = phi i1 [ false, [[DOTOMP_REDUCTION_CASE2]] ], [ [[TOBOOL17]], [[LAND_RHS15]] ]
// CHECK1-NEXT:    [[CONV19:%.*]] = uitofp i1 [[TMP23]] to float
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP12]], float noundef [[CONV19]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP4]], ptr align 4 [[REF_TMP12]], i64 4, i1 false)
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP12]]) #[[ATTR5]]
// CHECK1-NEXT:    call void @__kmpc_end_critical(ptr @[[GLOB2]], i32 [[TMP12]], ptr @.gomp_critical_user_.atomic_reduction.var)
// CHECK1-NEXT:    [[TMP24:%.*]] = load float, ptr [[T_VAR15]], align 4
// CHECK1-NEXT:    [[ATOMIC_LOAD:%.*]] = load atomic i32, ptr [[TMP5]] monotonic, align 4
// CHECK1-NEXT:    br label [[ATOMIC_CONT:%.*]]
// CHECK1:       atomic_cont:
// CHECK1-NEXT:    [[TMP25:%.*]] = phi i32 [ [[ATOMIC_LOAD]], [[LAND_END18]] ], [ [[TMP33:%.*]], [[COND_END23:%.*]] ]
// CHECK1-NEXT:    [[TMP26:%.*]] = bitcast i32 [[TMP25]] to float
// CHECK1-NEXT:    store float [[TMP26]], ptr [[TMP]], align 4
// CHECK1-NEXT:    [[TMP27:%.*]] = load float, ptr [[TMP]], align 4
// CHECK1-NEXT:    [[TMP28:%.*]] = load float, ptr [[T_VAR15]], align 4
// CHECK1-NEXT:    [[CMP20:%.*]] = fcmp olt float [[TMP27]], [[TMP28]]
// CHECK1-NEXT:    br i1 [[CMP20]], label [[COND_TRUE21:%.*]], label [[COND_FALSE22:%.*]]
// CHECK1:       cond.true21:
// CHECK1-NEXT:    [[TMP29:%.*]] = load float, ptr [[TMP]], align 4
// CHECK1-NEXT:    br label [[COND_END23]]
// CHECK1:       cond.false22:
// CHECK1-NEXT:    [[TMP30:%.*]] = load float, ptr [[T_VAR15]], align 4
// CHECK1-NEXT:    br label [[COND_END23]]
// CHECK1:       cond.end23:
// CHECK1-NEXT:    [[COND24:%.*]] = phi float [ [[TMP29]], [[COND_TRUE21]] ], [ [[TMP30]], [[COND_FALSE22]] ]
// CHECK1-NEXT:    store float [[COND24]], ptr [[ATOMIC_TEMP]], align 4
// CHECK1-NEXT:    [[TMP31:%.*]] = load i32, ptr [[ATOMIC_TEMP]], align 4
// CHECK1-NEXT:    [[TMP32:%.*]] = cmpxchg ptr [[TMP5]], i32 [[TMP25]], i32 [[TMP31]] monotonic monotonic, align 4
// CHECK1-NEXT:    [[TMP33]] = extractvalue { i32, i1 } [[TMP32]], 0
// CHECK1-NEXT:    [[TMP34:%.*]] = extractvalue { i32, i1 } [[TMP32]], 1
// CHECK1-NEXT:    br i1 [[TMP34]], label [[ATOMIC_EXIT:%.*]], label [[ATOMIC_CONT]]
// CHECK1:       atomic_exit:
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.default:
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]]) #[[ATTR5]]
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]]) #[[ATTR5]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@main.omp_outlined.omp.reduction.reduction_func
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP3]], i64 0, i64 3
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP2]], i64 0, i64 3
// CHECK1-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load float, ptr [[TMP7]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load float, ptr [[TMP5]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = fadd float [[TMP20]], [[TMP21]]
// CHECK1-NEXT:    store float [[ADD]], ptr [[TMP7]], align 4
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN1SIfEanERKS0_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP11]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP9]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP11]], ptr align 4 [[CALL]], i64 4, i1 false)
// CHECK1-NEXT:    [[CALL2:%.*]] = call noundef float @_ZN1SIfEcvfEv(ptr noundef nonnull align 4 dereferenceable(4) [[TMP15]])
// CHECK1-NEXT:    [[TOBOOL:%.*]] = fcmp une float [[CALL2]], 0.000000e+00
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[LAND_RHS:%.*]], label [[LAND_END:%.*]]
// CHECK1:       land.rhs:
// CHECK1-NEXT:    [[CALL3:%.*]] = call noundef float @_ZN1SIfEcvfEv(ptr noundef nonnull align 4 dereferenceable(4) [[TMP13]])
// CHECK1-NEXT:    [[TOBOOL4:%.*]] = fcmp une float [[CALL3]], 0.000000e+00
// CHECK1-NEXT:    br label [[LAND_END]]
// CHECK1:       land.end:
// CHECK1-NEXT:    [[TMP22:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ [[TOBOOL4]], [[LAND_RHS]] ]
// CHECK1-NEXT:    [[CONV:%.*]] = uitofp i1 [[TMP22]] to float
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ef(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP]], float noundef [[CONV]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[TMP15]], ptr align 4 [[REF_TMP]], i64 4, i1 false)
// CHECK1-NEXT:    call void @_ZN1SIfED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP]]) #[[ATTR5]]
// CHECK1-NEXT:    [[TMP23:%.*]] = load float, ptr [[TMP19]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = load float, ptr [[TMP17]], align 4
// CHECK1-NEXT:    [[CMP:%.*]] = fcmp olt float [[TMP23]], [[TMP24]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP25:%.*]] = load float, ptr [[TMP19]], align 4
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP26:%.*]] = load float, ptr [[TMP17]], align 4
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi float [ [[TMP25]], [[COND_TRUE]] ], [ [[TMP26]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store float [[COND]], ptr [[TMP19]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfEanERKS0_
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0:%.*]]) #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret ptr [[THIS1]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfEcvfEv
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret float 0.000000e+00
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfED1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SIfED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR5]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@main.omp_outlined.1
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR1:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VAR1_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR1_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR2:%.*]] = alloca float, align 4
// CHECK1-NEXT:    [[VAR3:%.*]] = alloca [[STRUCT_S:%.*]], align 4
// CHECK1-NEXT:    [[VAR14:%.*]] = alloca [[STRUCT_S]], align 4
// CHECK1-NEXT:    [[T_VAR15:%.*]] = alloca float, align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VAR1]], ptr [[VAR1_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[T_VAR1]], ptr [[T_VAR1_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[T_VAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[VAR1_ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[T_VAR1_ADDR]], align 8
// CHECK1-NEXT:    store float 0.000000e+00, ptr [[T_VAR2]], align 4
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]])
// CHECK1-NEXT:    call void @_ZN1SIfEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]])
// CHECK1-NEXT:    store float 0x47EFFFFFE0000000, ptr [[T_VAR15]], align 4
// CHECK1-NEXT:    br label [[WHILE_COND:%.*]]
// CHECK1:       while.cond:
// CHECK1-NEXT:    br label [[WHILE_BODY:%.*]]
// CHECK1:       while.body:
// CHECK1-NEXT:    [[TMP6:%.*]] = load float, ptr [[T_VAR2]], align 4
// CHECK1-NEXT:    [[CONV:%.*]] = fptosi float [[TMP6]] to i32
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[TMP0]], i64 0, i64 0
// CHECK1-NEXT:    store i32 [[CONV]], ptr [[ARRAYIDX]], align 4
// CHECK1-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds [2 x %struct.S], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX6]], ptr align 4 [[VAR3]], i64 4, i1 false)
// CHECK1-NEXT:    br label [[WHILE_COND]], !llvm.loop [[LOOP5:![0-9]+]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@main.omp_outlined.2
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[CF:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[CF_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[CF1:%.*]] = alloca { float, float }, align 4
// CHECK1-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    [[ATOMIC_TEMP:%.*]] = alloca { float, float }, align 4
// CHECK1-NEXT:    [[ATOMIC_TEMP10:%.*]] = alloca { float, float }, align 4
// CHECK1-NEXT:    [[TMP:%.*]] = alloca { float, float }, align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[CF]], ptr [[CF_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[CF_ADDR]], align 8
// CHECK1-NEXT:    [[CF1_REALP:%.*]] = getelementptr inbounds { float, float }, ptr [[CF1]], i32 0, i32 0
// CHECK1-NEXT:    [[CF1_IMAGP:%.*]] = getelementptr inbounds { float, float }, ptr [[CF1]], i32 0, i32 1
// CHECK1-NEXT:    store float 0.000000e+00, ptr [[CF1_REALP]], align 4
// CHECK1-NEXT:    store float 0.000000e+00, ptr [[CF1_IMAGP]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[CF1]], ptr [[TMP1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP3]], i32 1, i64 8, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @main.omp_outlined.2.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    switch i32 [[TMP4]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK1-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK1-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK1-NEXT:    ]
// CHECK1:       .omp.reduction.case1:
// CHECK1-NEXT:    [[DOTREALP:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP0]], i32 0, i32 0
// CHECK1-NEXT:    [[DOTREAL:%.*]] = load float, ptr [[DOTREALP]], align 4
// CHECK1-NEXT:    [[DOTIMAGP:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP0]], i32 0, i32 1
// CHECK1-NEXT:    [[DOTIMAG:%.*]] = load float, ptr [[DOTIMAGP]], align 4
// CHECK1-NEXT:    [[CF1_REALP2:%.*]] = getelementptr inbounds { float, float }, ptr [[CF1]], i32 0, i32 0
// CHECK1-NEXT:    [[CF1_REAL:%.*]] = load float, ptr [[CF1_REALP2]], align 4
// CHECK1-NEXT:    [[CF1_IMAGP3:%.*]] = getelementptr inbounds { float, float }, ptr [[CF1]], i32 0, i32 1
// CHECK1-NEXT:    [[CF1_IMAG:%.*]] = load float, ptr [[CF1_IMAGP3]], align 4
// CHECK1-NEXT:    [[ADD_R:%.*]] = fadd float [[DOTREAL]], [[CF1_REAL]]
// CHECK1-NEXT:    [[ADD_I:%.*]] = fadd float [[DOTIMAG]], [[CF1_IMAG]]
// CHECK1-NEXT:    [[DOTREALP4:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP0]], i32 0, i32 0
// CHECK1-NEXT:    [[DOTIMAGP5:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP0]], i32 0, i32 1
// CHECK1-NEXT:    store float [[ADD_R]], ptr [[DOTREALP4]], align 4
// CHECK1-NEXT:    store float [[ADD_I]], ptr [[DOTIMAGP5]], align 4
// CHECK1-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP3]], ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.case2:
// CHECK1-NEXT:    [[CF1_REALP6:%.*]] = getelementptr inbounds { float, float }, ptr [[CF1]], i32 0, i32 0
// CHECK1-NEXT:    [[CF1_REAL7:%.*]] = load float, ptr [[CF1_REALP6]], align 4
// CHECK1-NEXT:    [[CF1_IMAGP8:%.*]] = getelementptr inbounds { float, float }, ptr [[CF1]], i32 0, i32 1
// CHECK1-NEXT:    [[CF1_IMAG9:%.*]] = load float, ptr [[CF1_IMAGP8]], align 4
// CHECK1-NEXT:    call void @__atomic_load(i64 noundef 8, ptr noundef [[TMP0]], ptr noundef [[ATOMIC_TEMP]], i32 noundef 0)
// CHECK1-NEXT:    br label [[ATOMIC_CONT:%.*]]
// CHECK1:       atomic_cont:
// CHECK1-NEXT:    [[ATOMIC_TEMP_REALP:%.*]] = getelementptr inbounds { float, float }, ptr [[ATOMIC_TEMP]], i32 0, i32 0
// CHECK1-NEXT:    [[ATOMIC_TEMP_REAL:%.*]] = load float, ptr [[ATOMIC_TEMP_REALP]], align 4
// CHECK1-NEXT:    [[ATOMIC_TEMP_IMAGP:%.*]] = getelementptr inbounds { float, float }, ptr [[ATOMIC_TEMP]], i32 0, i32 1
// CHECK1-NEXT:    [[ATOMIC_TEMP_IMAG:%.*]] = load float, ptr [[ATOMIC_TEMP_IMAGP]], align 4
// CHECK1-NEXT:    [[TMP_REALP:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP_IMAGP:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP]], i32 0, i32 1
// CHECK1-NEXT:    store float [[ATOMIC_TEMP_REAL]], ptr [[TMP_REALP]], align 4
// CHECK1-NEXT:    store float [[ATOMIC_TEMP_IMAG]], ptr [[TMP_IMAGP]], align 4
// CHECK1-NEXT:    [[TMP_REALP11:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP_REAL:%.*]] = load float, ptr [[TMP_REALP11]], align 4
// CHECK1-NEXT:    [[TMP_IMAGP12:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP_IMAG:%.*]] = load float, ptr [[TMP_IMAGP12]], align 4
// CHECK1-NEXT:    [[CF1_REALP13:%.*]] = getelementptr inbounds { float, float }, ptr [[CF1]], i32 0, i32 0
// CHECK1-NEXT:    [[CF1_REAL14:%.*]] = load float, ptr [[CF1_REALP13]], align 4
// CHECK1-NEXT:    [[CF1_IMAGP15:%.*]] = getelementptr inbounds { float, float }, ptr [[CF1]], i32 0, i32 1
// CHECK1-NEXT:    [[CF1_IMAG16:%.*]] = load float, ptr [[CF1_IMAGP15]], align 4
// CHECK1-NEXT:    [[ADD_R17:%.*]] = fadd float [[TMP_REAL]], [[CF1_REAL14]]
// CHECK1-NEXT:    [[ADD_I18:%.*]] = fadd float [[TMP_IMAG]], [[CF1_IMAG16]]
// CHECK1-NEXT:    [[ATOMIC_TEMP10_REALP:%.*]] = getelementptr inbounds { float, float }, ptr [[ATOMIC_TEMP10]], i32 0, i32 0
// CHECK1-NEXT:    [[ATOMIC_TEMP10_IMAGP:%.*]] = getelementptr inbounds { float, float }, ptr [[ATOMIC_TEMP10]], i32 0, i32 1
// CHECK1-NEXT:    store float [[ADD_R17]], ptr [[ATOMIC_TEMP10_REALP]], align 4
// CHECK1-NEXT:    store float [[ADD_I18]], ptr [[ATOMIC_TEMP10_IMAGP]], align 4
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef zeroext i1 @__atomic_compare_exchange(i64 noundef 8, ptr noundef [[TMP0]], ptr noundef [[ATOMIC_TEMP]], ptr noundef [[ATOMIC_TEMP10]], i32 noundef 0, i32 noundef 0)
// CHECK1-NEXT:    br i1 [[CALL]], label [[ATOMIC_EXIT:%.*]], label [[ATOMIC_CONT]]
// CHECK1:       atomic_exit:
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.default:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@main.omp_outlined.2.omp.reduction.reduction_func
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[DOTREALP:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP7]], i32 0, i32 0
// CHECK1-NEXT:    [[DOTREAL:%.*]] = load float, ptr [[DOTREALP]], align 4
// CHECK1-NEXT:    [[DOTIMAGP:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP7]], i32 0, i32 1
// CHECK1-NEXT:    [[DOTIMAG:%.*]] = load float, ptr [[DOTIMAGP]], align 4
// CHECK1-NEXT:    [[DOTREALP2:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP5]], i32 0, i32 0
// CHECK1-NEXT:    [[DOTREAL3:%.*]] = load float, ptr [[DOTREALP2]], align 4
// CHECK1-NEXT:    [[DOTIMAGP4:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP5]], i32 0, i32 1
// CHECK1-NEXT:    [[DOTIMAG5:%.*]] = load float, ptr [[DOTIMAGP4]], align 4
// CHECK1-NEXT:    [[ADD_R:%.*]] = fadd float [[DOTREAL]], [[DOTREAL3]]
// CHECK1-NEXT:    [[ADD_I:%.*]] = fadd float [[DOTIMAG]], [[DOTIMAG5]]
// CHECK1-NEXT:    [[DOTREALP6:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP7]], i32 0, i32 0
// CHECK1-NEXT:    [[DOTIMAGP7:%.*]] = getelementptr inbounds { float, float }, ptr [[TMP7]], i32 0, i32 1
// CHECK1-NEXT:    store float [[ADD_R]], ptr [[DOTREALP6]], align 4
// CHECK1-NEXT:    store float [[ADD_I]], ptr [[DOTIMAGP7]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z5tmainIiET_v
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[T:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[TEST:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK1-NEXT:    [[SST:%.*]] = alloca [[STRUCT_SST:%.*]], align 4
// CHECK1-NEXT:    [[T_VAR:%.*]] = alloca i32, align 128
// CHECK1-NEXT:    [[T_VAR1:%.*]] = alloca i32, align 128
// CHECK1-NEXT:    [[VEC:%.*]] = alloca [2 x i32], align 4
// CHECK1-NEXT:    [[S_ARR:%.*]] = alloca [2 x %struct.S.0], align 4
// CHECK1-NEXT:    [[VAR:%.*]] = alloca [[STRUCT_S_0]], align 128
// CHECK1-NEXT:    [[VAR1:%.*]] = alloca [[STRUCT_S_0]], align 128
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]])
// CHECK1-NEXT:    call void @_ZN3SSTIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[SST]])
// CHECK1-NEXT:    store i32 0, ptr [[T_VAR]], align 128
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[VEC]], ptr align 4 @__const._Z5tmainIiET_v.vec, i64 8, i1 false)
// CHECK1-NEXT:    [[ARRAYINIT_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i64 0, i64 0
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_BEGIN]], i32 noundef 1)
// CHECK1-NEXT:    [[ARRAYINIT_ELEMENT:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYINIT_BEGIN]], i64 1
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYINIT_ELEMENT]], i32 noundef 2)
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]], i32 noundef 3)
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR1]])
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 6, ptr @_Z5tmainIiET_v.omp_outlined, ptr [[VEC]], ptr [[T_VAR]], ptr [[S_ARR]], ptr [[VAR]], ptr [[VAR1]], ptr [[T_VAR1]])
// CHECK1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR1]]) #[[ATTR5]]
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR]]) #[[ATTR5]]
// CHECK1-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[S_ARR]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP0]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[STRUCT_S_0]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR5]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done1:
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TEST]]) #[[ATTR5]]
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    ret i32 [[TMP1]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C5:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK1-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 4
// CHECK1-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK1-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], 0
// CHECK1-NEXT:    store i8 [[BF_SET]], ptr [[B]], align 4
// CHECK1-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[C]], align 8
// CHECK1-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK1-NEXT:    [[C6:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C6]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[C5]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[C5]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 4, ptr @_ZN2SSC2ERi.omp_outlined, ptr [[THIS1]], ptr [[TMP2]], ptr [[B4]], ptr [[TMP3]])
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[B4]], align 4
// CHECK1-NEXT:    [[B7:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i8
// CHECK1-NEXT:    [[BF_LOAD8:%.*]] = load i8, ptr [[B7]], align 4
// CHECK1-NEXT:    [[BF_VALUE:%.*]] = and i8 [[TMP5]], 15
// CHECK1-NEXT:    [[BF_CLEAR9:%.*]] = and i8 [[BF_LOAD8]], -16
// CHECK1-NEXT:    [[BF_SET10:%.*]] = or i8 [[BF_CLEAR9]], [[BF_VALUE]]
// CHECK1-NEXT:    store i8 [[BF_SET10]], ptr [[B7]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A2:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C5:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// CHECK1-NEXT:    store ptr [[TMP3]], ptr [[_TMP1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[A2]], align 4
// CHECK1-NEXT:    store ptr [[A2]], ptr [[_TMP3]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[B4]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[C5]], align 4
// CHECK1-NEXT:    store ptr [[C5]], ptr [[_TMP6]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP6]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B4]], align 4
// CHECK1-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP8]], -1
// CHECK1-NEXT:    store i32 [[DEC]], ptr [[B4]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1
// CHECK1-NEXT:    store i32 [[DIV]], ptr [[TMP9]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[A2]], ptr [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK1-NEXT:    store ptr [[B4]], ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 2
// CHECK1-NEXT:    store ptr [[C5]], ptr [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP15]], i32 3, i64 24, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_ZN2SSC2ERi.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    switch i32 [[TMP16]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK1-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK1-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK1-NEXT:    ]
// CHECK1:       .omp.reduction.case1:
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A2]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[TMP4]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[B4]], align 4
// CHECK1-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK1-NEXT:    store i32 [[ADD7]], ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i32, ptr [[C5]], align 4
// CHECK1-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK1-NEXT:    store i32 [[ADD8]], ptr [[TMP5]], align 4
// CHECK1-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP15]], ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.case2:
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[A2]], align 4
// CHECK1-NEXT:    [[TMP24:%.*]] = atomicrmw add ptr [[TMP4]], i32 [[TMP23]] monotonic, align 4
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, ptr [[B4]], align 4
// CHECK1-NEXT:    [[TMP26:%.*]] = atomicrmw add ptr [[TMP2]], i32 [[TMP25]] monotonic, align 4
// CHECK1-NEXT:    [[TMP27:%.*]] = load i32, ptr [[C5]], align 4
// CHECK1-NEXT:    [[TMP28:%.*]] = atomicrmw add ptr [[TMP5]], i32 [[TMP27]] monotonic, align 4
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.default:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined.omp.reduction.reduction_func
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP16]], [[TMP17]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[TMP7]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP11]], align 4
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK1-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK1-NEXT:    store i32 [[ADD2]], ptr [[TMP11]], align 4
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP15]], align 4
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP13]], align 4
// CHECK1-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK1-NEXT:    store i32 [[ADD3]], ptr [[TMP15]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @g, align 128
// CHECK1-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP0]] to float
// CHECK1-NEXT:    store float [[CONV]], ptr [[F]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfEC2Ef
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], float noundef [[A:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca float, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store float [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = load float, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load volatile i32, ptr @g, align 128
// CHECK1-NEXT:    [[CONV:%.*]] = sitofp i32 [[TMP1]] to float
// CHECK1-NEXT:    [[ADD:%.*]] = fadd float [[TMP0]], [[CONV]]
// CHECK1-NEXT:    store float [[ADD]], ptr [[F]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIfED2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIiEC1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN3SSTIiEC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiEC1Ei
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    call void @_ZN1SIiEC2Ei(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]], i32 noundef [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z5tmainIiET_v.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[VEC:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(8) [[S_ARR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR1:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[T_VAR1:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VEC_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[S_ARR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VAR_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[VAR1_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR1_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[T_VAR2:%.*]] = alloca i32, align 128
// CHECK1-NEXT:    [[VAR3:%.*]] = alloca [[STRUCT_S_0:%.*]], align 128
// CHECK1-NEXT:    [[VAR14:%.*]] = alloca [[STRUCT_S_0]], align 128
// CHECK1-NEXT:    [[T_VAR15:%.*]] = alloca i32, align 128
// CHECK1-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [4 x ptr], align 8
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_S_0]], align 4
// CHECK1-NEXT:    [[REF_TMP11:%.*]] = alloca [[STRUCT_S_0]], align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VEC]], ptr [[VEC_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[T_VAR]], ptr [[T_VAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[S_ARR]], ptr [[S_ARR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VAR]], ptr [[VAR_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[VAR1]], ptr [[VAR1_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[T_VAR1]], ptr [[T_VAR1_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[VEC_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[T_VAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[S_ARR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[VAR_ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[VAR1_ADDR]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[T_VAR1_ADDR]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[T_VAR2]], align 128
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]])
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]])
// CHECK1-NEXT:    store i32 2147483647, ptr [[T_VAR15]], align 128
// CHECK1-NEXT:    [[TMP6:%.*]] = load i32, ptr [[T_VAR2]], align 128
// CHECK1-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds [2 x i32], ptr [[TMP0]], i64 0, i64 0
// CHECK1-NEXT:    store i32 [[TMP6]], ptr [[ARRAYIDX]], align 4
// CHECK1-NEXT:    [[ARRAYIDX6:%.*]] = getelementptr inbounds [2 x %struct.S.0], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 4 [[ARRAYIDX6]], ptr align 128 [[VAR3]], i64 4, i1 false)
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[T_VAR2]], ptr [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK1-NEXT:    store ptr [[VAR3]], ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 2
// CHECK1-NEXT:    store ptr [[VAR14]], ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 3
// CHECK1-NEXT:    store ptr [[T_VAR15]], ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = load i32, ptr [[TMP11]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP12]], i32 4, i64 32, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_Z5tmainIiET_v.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    switch i32 [[TMP13]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK1-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK1-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK1-NEXT:    ]
// CHECK1:       .omp.reduction.case1:
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[TMP1]], align 128
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[T_VAR2]], align 128
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP14]], [[TMP15]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[TMP1]], align 128
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN1SIiEanERKS0_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP3]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 128 [[TMP3]], ptr align 4 [[CALL]], i64 4, i1 false)
// CHECK1-NEXT:    [[CALL7:%.*]] = call noundef i32 @_ZN1SIiEcviEv(ptr noundef nonnull align 4 dereferenceable(4) [[TMP4]])
// CHECK1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[CALL7]], 0
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[LAND_RHS:%.*]], label [[LAND_END:%.*]]
// CHECK1:       land.rhs:
// CHECK1-NEXT:    [[CALL8:%.*]] = call noundef i32 @_ZN1SIiEcviEv(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]])
// CHECK1-NEXT:    [[TOBOOL9:%.*]] = icmp ne i32 [[CALL8]], 0
// CHECK1-NEXT:    br label [[LAND_END]]
// CHECK1:       land.end:
// CHECK1-NEXT:    [[TMP16:%.*]] = phi i1 [ false, [[DOTOMP_REDUCTION_CASE1]] ], [ [[TOBOOL9]], [[LAND_RHS]] ]
// CHECK1-NEXT:    [[CONV:%.*]] = zext i1 [[TMP16]] to i32
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP]], i32 noundef [[CONV]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 128 [[TMP4]], ptr align 4 [[REF_TMP]], i64 4, i1 false)
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP]]) #[[ATTR5]]
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP5]], align 128
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[T_VAR15]], align 128
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP17]], [[TMP18]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP5]], align 128
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[T_VAR15]], align 128
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP19]], [[COND_TRUE]] ], [ [[TMP20]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[TMP5]], align 128
// CHECK1-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP12]], ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.case2:
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[T_VAR2]], align 128
// CHECK1-NEXT:    [[TMP22:%.*]] = atomicrmw add ptr [[TMP1]], i32 [[TMP21]] monotonic, align 128
// CHECK1-NEXT:    call void @__kmpc_critical(ptr @[[GLOB2]], i32 [[TMP12]], ptr @.gomp_critical_user_.atomic_reduction.var)
// CHECK1-NEXT:    [[CALL10:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN1SIiEanERKS0_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP3]], ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 128 [[TMP3]], ptr align 4 [[CALL10]], i64 4, i1 false)
// CHECK1-NEXT:    call void @__kmpc_end_critical(ptr @[[GLOB2]], i32 [[TMP12]], ptr @.gomp_critical_user_.atomic_reduction.var)
// CHECK1-NEXT:    call void @__kmpc_critical(ptr @[[GLOB2]], i32 [[TMP12]], ptr @.gomp_critical_user_.atomic_reduction.var)
// CHECK1-NEXT:    [[CALL12:%.*]] = call noundef i32 @_ZN1SIiEcviEv(ptr noundef nonnull align 4 dereferenceable(4) [[TMP4]])
// CHECK1-NEXT:    [[TOBOOL13:%.*]] = icmp ne i32 [[CALL12]], 0
// CHECK1-NEXT:    br i1 [[TOBOOL13]], label [[LAND_RHS14:%.*]], label [[LAND_END17:%.*]]
// CHECK1:       land.rhs14:
// CHECK1-NEXT:    [[CALL15:%.*]] = call noundef i32 @_ZN1SIiEcviEv(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]])
// CHECK1-NEXT:    [[TOBOOL16:%.*]] = icmp ne i32 [[CALL15]], 0
// CHECK1-NEXT:    br label [[LAND_END17]]
// CHECK1:       land.end17:
// CHECK1-NEXT:    [[TMP23:%.*]] = phi i1 [ false, [[DOTOMP_REDUCTION_CASE2]] ], [ [[TOBOOL16]], [[LAND_RHS14]] ]
// CHECK1-NEXT:    [[CONV18:%.*]] = zext i1 [[TMP23]] to i32
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP11]], i32 noundef [[CONV18]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 128 [[TMP4]], ptr align 4 [[REF_TMP11]], i64 4, i1 false)
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP11]]) #[[ATTR5]]
// CHECK1-NEXT:    call void @__kmpc_end_critical(ptr @[[GLOB2]], i32 [[TMP12]], ptr @.gomp_critical_user_.atomic_reduction.var)
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, ptr [[T_VAR15]], align 128
// CHECK1-NEXT:    [[TMP25:%.*]] = atomicrmw min ptr [[TMP5]], i32 [[TMP24]] monotonic, align 128
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.default:
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR14]]) #[[ATTR5]]
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[VAR3]]) #[[ATTR5]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z5tmainIiET_v.omp_outlined.omp.reduction.reduction_func
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[STRUCT_S_0:%.*]], align 4
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP3]], i64 0, i64 3
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = getelementptr inbounds [4 x ptr], ptr [[TMP2]], i64 0, i64 3
// CHECK1-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[TMP18]], align 8
// CHECK1-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP7]], align 128
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP5]], align 128
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[TMP7]], align 128
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN1SIiEanERKS0_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP11]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP9]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 128 [[TMP11]], ptr align 4 [[CALL]], i64 4, i1 false)
// CHECK1-NEXT:    [[CALL2:%.*]] = call noundef i32 @_ZN1SIiEcviEv(ptr noundef nonnull align 4 dereferenceable(4) [[TMP15]])
// CHECK1-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[CALL2]], 0
// CHECK1-NEXT:    br i1 [[TOBOOL]], label [[LAND_RHS:%.*]], label [[LAND_END:%.*]]
// CHECK1:       land.rhs:
// CHECK1-NEXT:    [[CALL3:%.*]] = call noundef i32 @_ZN1SIiEcviEv(ptr noundef nonnull align 4 dereferenceable(4) [[TMP13]])
// CHECK1-NEXT:    [[TOBOOL4:%.*]] = icmp ne i32 [[CALL3]], 0
// CHECK1-NEXT:    br label [[LAND_END]]
// CHECK1:       land.end:
// CHECK1-NEXT:    [[TMP22:%.*]] = phi i1 [ false, [[ENTRY:%.*]] ], [ [[TOBOOL4]], [[LAND_RHS]] ]
// CHECK1-NEXT:    [[CONV:%.*]] = zext i1 [[TMP22]] to i32
// CHECK1-NEXT:    call void @_ZN1SIiEC1Ei(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP]], i32 noundef [[CONV]])
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 128 [[TMP15]], ptr align 4 [[REF_TMP]], i64 4, i1 false)
// CHECK1-NEXT:    call void @_ZN1SIiED1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[REF_TMP]]) #[[ATTR5]]
// CHECK1-NEXT:    [[TMP23:%.*]] = load i32, ptr [[TMP19]], align 128
// CHECK1-NEXT:    [[TMP24:%.*]] = load i32, ptr [[TMP17]], align 128
// CHECK1-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP23]], [[TMP24]]
// CHECK1-NEXT:    br i1 [[CMP]], label [[COND_TRUE:%.*]], label [[COND_FALSE:%.*]]
// CHECK1:       cond.true:
// CHECK1-NEXT:    [[TMP25:%.*]] = load i32, ptr [[TMP19]], align 128
// CHECK1-NEXT:    br label [[COND_END:%.*]]
// CHECK1:       cond.false:
// CHECK1-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP17]], align 128
// CHECK1-NEXT:    br label [[COND_END]]
// CHECK1:       cond.end:
// CHECK1-NEXT:    [[COND:%.*]] = phi i32 [ [[TMP25]], [[COND_TRUE]] ], [ [[TMP26]], [[COND_FALSE]] ]
// CHECK1-NEXT:    store i32 [[COND]], ptr [[TMP19]], align 128
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiEanERKS0_
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0:%.*]]) #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret ptr [[THIS1]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiEcviEv
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret i32 0
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiED1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN1SIiED2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR5]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = load volatile i32, ptr @g, align 128
// CHECK1-NEXT:    store i32 [[TMP0]], ptr [[F]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIiEC2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK1-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SST]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 2, ptr @_ZN3SSTIiEC2Ev.omp_outlined, ptr [[THIS1]], ptr [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIiEC2Ev.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]]) #[[ATTR1]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A1:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    [[ATOMIC_TEMP:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[_TMP3:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    store i32 1, ptr [[A1]], align 4
// CHECK1-NEXT:    store ptr [[A1]], ptr [[_TMP2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[A1]], ptr [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP7]], i32 1, i64 8, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_ZN3SSTIiEC2Ev.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    switch i32 [[TMP8]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK1-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK1-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK1-NEXT:    ]
// CHECK1:       .omp.reduction.case1:
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[A1]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP9]], [[TMP10]]
// CHECK1-NEXT:    store i32 [[MUL]], ptr [[TMP2]], align 4
// CHECK1-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP7]], ptr @.gomp_critical_user_.reduction.var)
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.case2:
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[A1]], align 4
// CHECK1-NEXT:    [[ATOMIC_LOAD:%.*]] = load atomic i32, ptr [[TMP2]] monotonic, align 4
// CHECK1-NEXT:    br label [[ATOMIC_CONT:%.*]]
// CHECK1:       atomic_cont:
// CHECK1-NEXT:    [[TMP12:%.*]] = phi i32 [ [[ATOMIC_LOAD]], [[DOTOMP_REDUCTION_CASE2]] ], [ [[TMP17:%.*]], [[ATOMIC_CONT]] ]
// CHECK1-NEXT:    store i32 [[TMP12]], ptr [[_TMP3]], align 4
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[_TMP3]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[A1]], align 4
// CHECK1-NEXT:    [[MUL4:%.*]] = mul nsw i32 [[TMP13]], [[TMP14]]
// CHECK1-NEXT:    store i32 [[MUL4]], ptr [[ATOMIC_TEMP]], align 4
// CHECK1-NEXT:    [[TMP15:%.*]] = load i32, ptr [[ATOMIC_TEMP]], align 4
// CHECK1-NEXT:    [[TMP16:%.*]] = cmpxchg ptr [[TMP2]], i32 [[TMP12]], i32 [[TMP15]] monotonic monotonic, align 4
// CHECK1-NEXT:    [[TMP17]] = extractvalue { i32, i1 } [[TMP16]], 0
// CHECK1-NEXT:    [[TMP18:%.*]] = extractvalue { i32, i1 } [[TMP16]], 1
// CHECK1-NEXT:    br i1 [[TMP18]], label [[ATOMIC_EXIT:%.*]], label [[ATOMIC_CONT]]
// CHECK1:       atomic_exit:
// CHECK1-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK1:       .omp.reduction.default:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIiEC2Ev.omp_outlined.omp.reduction.reduction_func
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK1-NEXT:    [[MUL:%.*]] = mul nsw i32 [[TMP8]], [[TMP9]]
// CHECK1-NEXT:    store i32 [[MUL]], ptr [[TMP7]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiEC2Ei
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], i32 noundef [[A:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i32 [[A]], ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[F:%.*]] = getelementptr inbounds [[STRUCT_S_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A_ADDR]], align 4
// CHECK1-NEXT:    [[TMP1:%.*]] = load volatile i32, ptr @g, align 128
// CHECK1-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP0]], [[TMP1]]
// CHECK1-NEXT:    store i32 [[ADD]], ptr [[F]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN1SIiED2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs
// CHECK3-SAME: (ptr noundef [[X:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2:[0-9]+]], i32 1, ptr @_Z14foo_array_sectPs.omp_outlined, ptr [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs.omp_outlined
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[X:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x ptr], align 8
// CHECK3-NEXT:    [[ATOMIC_TEMP:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    [[_TMP13:%.*]] = alloca i16, align 2
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK3-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, ptr [[TMP0]], i64 0
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK3-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i16, ptr [[TMP1]], i64 0
// CHECK3-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[ARRAYIDX1]] to i64
// CHECK3-NEXT:    [[TMP3:%.*]] = ptrtoint ptr [[ARRAYIDX]] to i64
// CHECK3-NEXT:    [[TMP4:%.*]] = sub i64 [[TMP2]], [[TMP3]]
// CHECK3-NEXT:    [[TMP5:%.*]] = sdiv exact i64 [[TMP4]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK3-NEXT:    [[TMP6:%.*]] = add nuw i64 [[TMP5]], 1
// CHECK3-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP6]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK3-NEXT:    [[TMP8:%.*]] = call ptr @llvm.stacksave.p0()
// CHECK3-NEXT:    store ptr [[TMP8]], ptr [[SAVED_STACK]], align 8
// CHECK3-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP6]], align 16
// CHECK3-NEXT:    store i64 [[TMP6]], ptr [[__VLA_EXPR0]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr i16, ptr [[VLA]], i64 [[TMP6]]
// CHECK3-NEXT:    [[OMP_ARRAYINIT_ISEMPTY:%.*]] = icmp eq ptr [[VLA]], [[TMP9]]
// CHECK3-NEXT:    br i1 [[OMP_ARRAYINIT_ISEMPTY]], label [[OMP_ARRAYINIT_DONE:%.*]], label [[OMP_ARRAYINIT_BODY:%.*]]
// CHECK3:       omp.arrayinit.body:
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[VLA]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYINIT_BODY]] ]
// CHECK3-NEXT:    store i16 0, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP9]]
// CHECK3-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYINIT_DONE]], label [[OMP_ARRAYINIT_BODY]]
// CHECK3:       omp.arrayinit.done:
// CHECK3-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK3-NEXT:    [[TMP11:%.*]] = ptrtoint ptr [[TMP10]] to i64
// CHECK3-NEXT:    [[TMP12:%.*]] = ptrtoint ptr [[ARRAYIDX]] to i64
// CHECK3-NEXT:    [[TMP13:%.*]] = sub i64 [[TMP11]], [[TMP12]]
// CHECK3-NEXT:    [[TMP14:%.*]] = sdiv exact i64 [[TMP13]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr i16, ptr [[VLA]], i64 [[TMP14]]
// CHECK3-NEXT:    store ptr [[TMP15]], ptr [[TMP]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK3-NEXT:    store ptr [[VLA]], ptr [[TMP16]], align 8
// CHECK3-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK3-NEXT:    [[TMP18:%.*]] = inttoptr i64 [[TMP6]] to ptr
// CHECK3-NEXT:    store ptr [[TMP18]], ptr [[TMP17]], align 8
// CHECK3-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP19]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1:[0-9]+]], i32 [[TMP20]], i32 1, i64 16, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_Z14foo_array_sectPs.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK3-NEXT:    switch i32 [[TMP21]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK3-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK3-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK3-NEXT:    ]
// CHECK3:       .omp.reduction.case1:
// CHECK3-NEXT:    [[TMP22:%.*]] = getelementptr i16, ptr [[ARRAYIDX]], i64 [[TMP6]]
// CHECK3-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAYIDX]], [[TMP22]]
// CHECK3-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE7:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK3:       omp.arraycpy.body:
// CHECK3-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[VLA]], [[DOTOMP_REDUCTION_CASE1]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST2:%.*]] = phi ptr [ [[ARRAYIDX]], [[DOTOMP_REDUCTION_CASE1]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT5:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK3-NEXT:    [[TMP23:%.*]] = load i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP23]] to i32
// CHECK3-NEXT:    [[TMP24:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], align 2
// CHECK3-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP24]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV3]]
// CHECK3-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV4]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], align 2
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT5]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], i32 1
// CHECK3-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DONE6:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT5]], [[TMP22]]
// CHECK3-NEXT:    br i1 [[OMP_ARRAYCPY_DONE6]], label [[OMP_ARRAYCPY_DONE7]], label [[OMP_ARRAYCPY_BODY]]
// CHECK3:       omp.arraycpy.done7:
// CHECK3-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP20]], ptr @.gomp_critical_user_.reduction.var)
// CHECK3-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK3:       .omp.reduction.case2:
// CHECK3-NEXT:    [[TMP25:%.*]] = getelementptr i16, ptr [[ARRAYIDX]], i64 [[TMP6]]
// CHECK3-NEXT:    [[OMP_ARRAYCPY_ISEMPTY8:%.*]] = icmp eq ptr [[ARRAYIDX]], [[TMP25]]
// CHECK3-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY8]], label [[OMP_ARRAYCPY_DONE21:%.*]], label [[OMP_ARRAYCPY_BODY9:%.*]]
// CHECK3:       omp.arraycpy.body9:
// CHECK3-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST10:%.*]] = phi ptr [ [[VLA]], [[DOTOMP_REDUCTION_CASE2]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT19:%.*]], [[ATOMIC_EXIT:%.*]] ]
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST11:%.*]] = phi ptr [ [[ARRAYIDX]], [[DOTOMP_REDUCTION_CASE2]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT18:%.*]], [[ATOMIC_EXIT]] ]
// CHECK3-NEXT:    [[TMP26:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], align 2
// CHECK3-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP26]] to i32
// CHECK3-NEXT:    [[ATOMIC_LOAD:%.*]] = load atomic i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]] monotonic, align 2
// CHECK3-NEXT:    br label [[ATOMIC_CONT:%.*]]
// CHECK3:       atomic_cont:
// CHECK3-NEXT:    [[TMP27:%.*]] = phi i16 [ [[ATOMIC_LOAD]], [[OMP_ARRAYCPY_BODY9]] ], [ [[TMP32:%.*]], [[ATOMIC_CONT]] ]
// CHECK3-NEXT:    store i16 [[TMP27]], ptr [[_TMP13]], align 2
// CHECK3-NEXT:    [[TMP28:%.*]] = load i16, ptr [[_TMP13]], align 2
// CHECK3-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP28]] to i32
// CHECK3-NEXT:    [[TMP29:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], align 2
// CHECK3-NEXT:    [[CONV15:%.*]] = sext i16 [[TMP29]] to i32
// CHECK3-NEXT:    [[ADD16:%.*]] = add nsw i32 [[CONV14]], [[CONV15]]
// CHECK3-NEXT:    [[CONV17:%.*]] = trunc i32 [[ADD16]] to i16
// CHECK3-NEXT:    store i16 [[CONV17]], ptr [[ATOMIC_TEMP]], align 2
// CHECK3-NEXT:    [[TMP30:%.*]] = load i16, ptr [[ATOMIC_TEMP]], align 2
// CHECK3-NEXT:    [[TMP31:%.*]] = cmpxchg ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]], i16 [[TMP27]], i16 [[TMP30]] monotonic monotonic, align 2
// CHECK3-NEXT:    [[TMP32]] = extractvalue { i16, i1 } [[TMP31]], 0
// CHECK3-NEXT:    [[TMP33:%.*]] = extractvalue { i16, i1 } [[TMP31]], 1
// CHECK3-NEXT:    br i1 [[TMP33]], label [[ATOMIC_EXIT]], label [[ATOMIC_CONT]]
// CHECK3:       atomic_exit:
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT18]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]], i32 1
// CHECK3-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT19]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], i32 1
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DONE20:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT18]], [[TMP25]]
// CHECK3-NEXT:    br i1 [[OMP_ARRAYCPY_DONE20]], label [[OMP_ARRAYCPY_DONE21]], label [[OMP_ARRAYCPY_BODY9]]
// CHECK3:       omp.arraycpy.done21:
// CHECK3-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK3:       .omp.reduction.default:
// CHECK3-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// CHECK3-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP34]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs.omp_outlined.omp.reduction.reduction_func
// CHECK3-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK3-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK3-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[TMP9]] to i64
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr i16, ptr [[TMP7]], i64 [[TMP10]]
// CHECK3-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[TMP7]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK3:       omp.arraycpy.body:
// CHECK3-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP5]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[TMP7]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK3-NEXT:    [[TMP12:%.*]] = load i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK3-NEXT:    [[CONV:%.*]] = sext i16 [[TMP12]] to i32
// CHECK3-NEXT:    [[TMP13:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], align 2
// CHECK3-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP13]] to i32
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV2]]
// CHECK3-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD]] to i16
// CHECK3-NEXT:    store i16 [[CONV3]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK3-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK3-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP11]]
// CHECK3-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]]
// CHECK3:       omp.arraycpy.done4:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@main
// CHECK3-SAME: () #[[ATTR6:[0-9]+]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 1
// CHECK3-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK3-NEXT:    call void @_ZN2SSC1ERi(ptr noundef nonnull align 8 dereferenceable(16) [[SS]], ptr noundef nonnull align 4 dereferenceable(4) @sivar)
// CHECK3-NEXT:    call void @"_ZZ4mainENK3$_0clEv"(ptr noundef nonnull align 1 dereferenceable(1) [[REF_TMP]])
// CHECK3-NEXT:    ret i32 0
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK3-NEXT:    call void @_ZN2SSC2ERi(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK3-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR0]] align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C5:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK3-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK3-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK3-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 4
// CHECK3-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK3-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], 0
// CHECK3-NEXT:    store i8 [[BF_SET]], ptr [[B]], align 4
// CHECK3-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[C]], align 8
// CHECK3-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0
// CHECK3-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK3-NEXT:    [[C6:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C6]], align 8
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[C5]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[C5]], align 8
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 4, ptr @_ZN2SSC2ERi.omp_outlined, ptr [[THIS1]], ptr [[TMP2]], ptr [[B4]], ptr [[TMP3]])
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[B4]], align 4
// CHECK3-NEXT:    [[B7:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i8
// CHECK3-NEXT:    [[BF_LOAD8:%.*]] = load i8, ptr [[B7]], align 4
// CHECK3-NEXT:    [[BF_VALUE:%.*]] = and i8 [[TMP5]], 15
// CHECK3-NEXT:    [[BF_CLEAR9:%.*]] = and i8 [[BF_LOAD8]], -16
// CHECK3-NEXT:    [[BF_SET10:%.*]] = or i8 [[BF_CLEAR9]], [[BF_VALUE]]
// CHECK3-NEXT:    store i8 [[BF_SET10]], ptr [[B7]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[A2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C5:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK3-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// CHECK3-NEXT:    store ptr [[TMP3]], ptr [[_TMP1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK3-NEXT:    store i32 0, ptr [[A2]], align 4
// CHECK3-NEXT:    store ptr [[A2]], ptr [[_TMP3]], align 8
// CHECK3-NEXT:    store i32 0, ptr [[B4]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK3-NEXT:    store i32 0, ptr [[C5]], align 4
// CHECK3-NEXT:    store ptr [[C5]], ptr [[_TMP6]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK3-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 8
// CHECK3-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 2
// CHECK3-NEXT:    store ptr [[B4]], ptr [[TMP9]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK3-NEXT:    store ptr [[TMP11]], ptr [[TMP10]], align 8
// CHECK3-NEXT:    call void @_ZZN2SSC1ERiENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK3-NEXT:    store ptr [[A2]], ptr [[TMP12]], align 8
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK3-NEXT:    store ptr [[B4]], ptr [[TMP13]], align 8
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 2
// CHECK3-NEXT:    store ptr [[C5]], ptr [[TMP14]], align 8
// CHECK3-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP16]], i32 3, i64 24, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_ZN2SSC2ERi.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK3-NEXT:    switch i32 [[TMP17]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK3-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK3-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK3-NEXT:    ]
// CHECK3:       .omp.reduction.case1:
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, ptr [[A2]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK3-NEXT:    store i32 [[ADD]], ptr [[TMP4]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[B4]], align 4
// CHECK3-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK3-NEXT:    store i32 [[ADD7]], ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, ptr [[C5]], align 4
// CHECK3-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP22]], [[TMP23]]
// CHECK3-NEXT:    store i32 [[ADD8]], ptr [[TMP5]], align 4
// CHECK3-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP16]], ptr @.gomp_critical_user_.reduction.var)
// CHECK3-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK3:       .omp.reduction.case2:
// CHECK3-NEXT:    [[TMP24:%.*]] = load i32, ptr [[A2]], align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = atomicrmw add ptr [[TMP4]], i32 [[TMP24]] monotonic, align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = load i32, ptr [[B4]], align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = atomicrmw add ptr [[TMP2]], i32 [[TMP26]] monotonic, align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = load i32, ptr [[C5]], align 4
// CHECK3-NEXT:    [[TMP29:%.*]] = atomicrmw add ptr [[TMP5]], i32 [[TMP28]] monotonic, align 4
// CHECK3-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK3:       .omp.reduction.default:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv
// CHECK3-SAME: (ptr noundef nonnull align 8 dereferenceable(32) [[THIS:%.*]]) #[[ATTR0]] align 2 {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK3-NEXT:    store i32 [[INC]], ptr [[TMP3]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4
// CHECK3-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP7]], -1
// CHECK3-NEXT:    store i32 [[DEC]], ptr [[TMP6]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1
// CHECK3-NEXT:    store i32 [[DIV]], ptr [[TMP9]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 1
// CHECK3-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 2
// CHECK3-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[TMP13]], align 8
// CHECK3-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 3
// CHECK3-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK3-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 4, ptr @_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined, ptr [[TMP1]], ptr [[TMP12]], ptr [[TMP14]], ptr [[TMP16]])
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined.omp.reduction.reduction_func
// CHECK3-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK3-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK3-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK3-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK3-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK3-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK3-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP16]], [[TMP17]]
// CHECK3-NEXT:    store i32 [[ADD]], ptr [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK3-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK3-NEXT:    store i32 [[ADD2]], ptr [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP13]], align 4
// CHECK3-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK3-NEXT:    store i32 [[ADD3]], ptr [[TMP15]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined
// CHECK3-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR1]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[A2:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[C5:%.*]] = alloca i32, align 4
// CHECK3-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK3-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK3-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK3-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK3-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// CHECK3-NEXT:    store ptr [[TMP3]], ptr [[_TMP1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK3-NEXT:    store i32 -1, ptr [[A2]], align 4
// CHECK3-NEXT:    store ptr [[A2]], ptr [[_TMP3]], align 8
// CHECK3-NEXT:    store i32 -1, ptr [[B4]], align 4
// CHECK3-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK3-NEXT:    store i32 -1, ptr [[C5]], align 4
// CHECK3-NEXT:    store ptr [[C5]], ptr [[_TMP6]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK3-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4
// CHECK3-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK3-NEXT:    store i32 [[INC]], ptr [[TMP6]], align 4
// CHECK3-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B4]], align 4
// CHECK3-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP8]], -1
// CHECK3-NEXT:    store i32 [[DEC]], ptr [[B4]], align 4
// CHECK3-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK3-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1
// CHECK3-NEXT:    store i32 [[DIV]], ptr [[TMP9]], align 4
// CHECK3-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK3-NEXT:    store ptr [[A2]], ptr [[TMP11]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK3-NEXT:    store ptr [[B4]], ptr [[TMP12]], align 8
// CHECK3-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 2
// CHECK3-NEXT:    store ptr [[C5]], ptr [[TMP13]], align 8
// CHECK3-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK3-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 4
// CHECK3-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP15]], i32 3, i64 24, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK3-NEXT:    switch i32 [[TMP16]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK3-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK3-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK3-NEXT:    ]
// CHECK3:       .omp.reduction.case1:
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A2]], align 4
// CHECK3-NEXT:    [[AND:%.*]] = and i32 [[TMP17]], [[TMP18]]
// CHECK3-NEXT:    store i32 [[AND]], ptr [[TMP4]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[B4]], align 4
// CHECK3-NEXT:    [[AND7:%.*]] = and i32 [[TMP19]], [[TMP20]]
// CHECK3-NEXT:    store i32 [[AND7]], ptr [[TMP2]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK3-NEXT:    [[TMP22:%.*]] = load i32, ptr [[C5]], align 4
// CHECK3-NEXT:    [[AND8:%.*]] = and i32 [[TMP21]], [[TMP22]]
// CHECK3-NEXT:    store i32 [[AND8]], ptr [[TMP5]], align 4
// CHECK3-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP15]], ptr @.gomp_critical_user_.reduction.var)
// CHECK3-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK3:       .omp.reduction.case2:
// CHECK3-NEXT:    [[TMP23:%.*]] = load i32, ptr [[A2]], align 4
// CHECK3-NEXT:    [[TMP24:%.*]] = atomicrmw and ptr [[TMP4]], i32 [[TMP23]] monotonic, align 4
// CHECK3-NEXT:    [[TMP25:%.*]] = load i32, ptr [[B4]], align 4
// CHECK3-NEXT:    [[TMP26:%.*]] = atomicrmw and ptr [[TMP2]], i32 [[TMP25]] monotonic, align 4
// CHECK3-NEXT:    [[TMP27:%.*]] = load i32, ptr [[C5]], align 4
// CHECK3-NEXT:    [[TMP28:%.*]] = atomicrmw and ptr [[TMP5]], i32 [[TMP27]] monotonic, align 4
// CHECK3-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK3:       .omp.reduction.default:
// CHECK3-NEXT:    ret void
//
//
// CHECK3-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined.omp.reduction.reduction_func
// CHECK3-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3]] {
// CHECK3-NEXT:  entry:
// CHECK3-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK3-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK3-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK3-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK3-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK3-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK3-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK3-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK3-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK3-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK3-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK3-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK3-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK3-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK3-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK3-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK3-NEXT:    [[AND:%.*]] = and i32 [[TMP16]], [[TMP17]]
// CHECK3-NEXT:    store i32 [[AND]], ptr [[TMP7]], align 4
// CHECK3-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK3-NEXT:    [[AND2:%.*]] = and i32 [[TMP18]], [[TMP19]]
// CHECK3-NEXT:    store i32 [[AND2]], ptr [[TMP11]], align 4
// CHECK3-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP15]], align 4
// CHECK3-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP13]], align 4
// CHECK3-NEXT:    [[AND3:%.*]] = and i32 [[TMP20]], [[TMP21]]
// CHECK3-NEXT:    store i32 [[AND3]], ptr [[TMP15]], align 4
// CHECK3-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs
// CHECK4-SAME: (ptr noundef [[X:%.*]]) #[[ATTR1:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2:[0-9]+]], i32 1, ptr @_Z14foo_array_sectPs.omp_outlined, ptr [[TMP0]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[X:%.*]]) #[[ATTR2:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[X_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[SAVED_STACK:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[__VLA_EXPR0:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [2 x ptr], align 8
// CHECK4-NEXT:    [[ATOMIC_TEMP:%.*]] = alloca i16, align 2
// CHECK4-NEXT:    [[_TMP13:%.*]] = alloca i16, align 2
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[X]], ptr [[X_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK4-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i16, ptr [[TMP0]], i64 0
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK4-NEXT:    [[ARRAYIDX1:%.*]] = getelementptr inbounds i16, ptr [[TMP1]], i64 0
// CHECK4-NEXT:    [[TMP2:%.*]] = ptrtoint ptr [[ARRAYIDX1]] to i64
// CHECK4-NEXT:    [[TMP3:%.*]] = ptrtoint ptr [[ARRAYIDX]] to i64
// CHECK4-NEXT:    [[TMP4:%.*]] = sub i64 [[TMP2]], [[TMP3]]
// CHECK4-NEXT:    [[TMP5:%.*]] = sdiv exact i64 [[TMP4]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK4-NEXT:    [[TMP6:%.*]] = add nuw i64 [[TMP5]], 1
// CHECK4-NEXT:    [[TMP7:%.*]] = mul nuw i64 [[TMP6]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK4-NEXT:    [[TMP8:%.*]] = call ptr @llvm.stacksave.p0()
// CHECK4-NEXT:    store ptr [[TMP8]], ptr [[SAVED_STACK]], align 8
// CHECK4-NEXT:    [[VLA:%.*]] = alloca i16, i64 [[TMP6]], align 16
// CHECK4-NEXT:    store i64 [[TMP6]], ptr [[__VLA_EXPR0]], align 8
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr i16, ptr [[VLA]], i64 [[TMP6]]
// CHECK4-NEXT:    [[OMP_ARRAYINIT_ISEMPTY:%.*]] = icmp eq ptr [[VLA]], [[TMP9]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYINIT_ISEMPTY]], label [[OMP_ARRAYINIT_DONE:%.*]], label [[OMP_ARRAYINIT_BODY:%.*]]
// CHECK4:       omp.arrayinit.body:
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[VLA]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYINIT_BODY]] ]
// CHECK4-NEXT:    store i16 0, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP9]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYINIT_DONE]], label [[OMP_ARRAYINIT_BODY]]
// CHECK4:       omp.arrayinit.done:
// CHECK4-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[X_ADDR]], align 8
// CHECK4-NEXT:    [[TMP11:%.*]] = ptrtoint ptr [[TMP10]] to i64
// CHECK4-NEXT:    [[TMP12:%.*]] = ptrtoint ptr [[ARRAYIDX]] to i64
// CHECK4-NEXT:    [[TMP13:%.*]] = sub i64 [[TMP11]], [[TMP12]]
// CHECK4-NEXT:    [[TMP14:%.*]] = sdiv exact i64 [[TMP13]], ptrtoint (ptr getelementptr (i16, ptr null, i32 1) to i64)
// CHECK4-NEXT:    [[TMP15:%.*]] = getelementptr i16, ptr [[VLA]], i64 [[TMP14]]
// CHECK4-NEXT:    store ptr [[TMP15]], ptr [[TMP]], align 8
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK4-NEXT:    store ptr [[VLA]], ptr [[TMP16]], align 8
// CHECK4-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP18:%.*]] = inttoptr i64 [[TMP6]] to ptr
// CHECK4-NEXT:    store ptr [[TMP18]], ptr [[TMP17]], align 8
// CHECK4-NEXT:    [[TMP19:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP19]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1:[0-9]+]], i32 [[TMP20]], i32 1, i64 16, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_Z14foo_array_sectPs.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK4-NEXT:    switch i32 [[TMP21]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK4-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK4-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK4-NEXT:    ]
// CHECK4:       .omp.reduction.case1:
// CHECK4-NEXT:    [[TMP22:%.*]] = getelementptr i16, ptr [[ARRAYIDX]], i64 [[TMP6]]
// CHECK4-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAYIDX]], [[TMP22]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE7:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK4:       omp.arraycpy.body:
// CHECK4-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[VLA]], [[DOTOMP_REDUCTION_CASE1]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST2:%.*]] = phi ptr [ [[ARRAYIDX]], [[DOTOMP_REDUCTION_CASE1]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT5:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK4-NEXT:    [[TMP23:%.*]] = load i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], align 2
// CHECK4-NEXT:    [[CONV:%.*]] = sext i16 [[TMP23]] to i32
// CHECK4-NEXT:    [[TMP24:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], align 2
// CHECK4-NEXT:    [[CONV3:%.*]] = sext i16 [[TMP24]] to i32
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV3]]
// CHECK4-NEXT:    [[CONV4:%.*]] = trunc i32 [[ADD]] to i16
// CHECK4-NEXT:    store i16 [[CONV4]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], align 2
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT5]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST2]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DONE6:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT5]], [[TMP22]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_DONE6]], label [[OMP_ARRAYCPY_DONE7]], label [[OMP_ARRAYCPY_BODY]]
// CHECK4:       omp.arraycpy.done7:
// CHECK4-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP20]], ptr @.gomp_critical_user_.reduction.var)
// CHECK4-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK4:       .omp.reduction.case2:
// CHECK4-NEXT:    [[TMP25:%.*]] = getelementptr i16, ptr [[ARRAYIDX]], i64 [[TMP6]]
// CHECK4-NEXT:    [[OMP_ARRAYCPY_ISEMPTY8:%.*]] = icmp eq ptr [[ARRAYIDX]], [[TMP25]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY8]], label [[OMP_ARRAYCPY_DONE21:%.*]], label [[OMP_ARRAYCPY_BODY9:%.*]]
// CHECK4:       omp.arraycpy.body9:
// CHECK4-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST10:%.*]] = phi ptr [ [[VLA]], [[DOTOMP_REDUCTION_CASE2]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT19:%.*]], [[ATOMIC_EXIT:%.*]] ]
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST11:%.*]] = phi ptr [ [[ARRAYIDX]], [[DOTOMP_REDUCTION_CASE2]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT18:%.*]], [[ATOMIC_EXIT]] ]
// CHECK4-NEXT:    [[TMP26:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], align 2
// CHECK4-NEXT:    [[CONV12:%.*]] = sext i16 [[TMP26]] to i32
// CHECK4-NEXT:    [[ATOMIC_LOAD:%.*]] = load atomic i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]] monotonic, align 2
// CHECK4-NEXT:    br label [[ATOMIC_CONT:%.*]]
// CHECK4:       atomic_cont:
// CHECK4-NEXT:    [[TMP27:%.*]] = phi i16 [ [[ATOMIC_LOAD]], [[OMP_ARRAYCPY_BODY9]] ], [ [[TMP32:%.*]], [[ATOMIC_CONT]] ]
// CHECK4-NEXT:    store i16 [[TMP27]], ptr [[_TMP13]], align 2
// CHECK4-NEXT:    [[TMP28:%.*]] = load i16, ptr [[_TMP13]], align 2
// CHECK4-NEXT:    [[CONV14:%.*]] = sext i16 [[TMP28]] to i32
// CHECK4-NEXT:    [[TMP29:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], align 2
// CHECK4-NEXT:    [[CONV15:%.*]] = sext i16 [[TMP29]] to i32
// CHECK4-NEXT:    [[ADD16:%.*]] = add nsw i32 [[CONV14]], [[CONV15]]
// CHECK4-NEXT:    [[CONV17:%.*]] = trunc i32 [[ADD16]] to i16
// CHECK4-NEXT:    store i16 [[CONV17]], ptr [[ATOMIC_TEMP]], align 2
// CHECK4-NEXT:    [[TMP30:%.*]] = load i16, ptr [[ATOMIC_TEMP]], align 2
// CHECK4-NEXT:    [[TMP31:%.*]] = cmpxchg ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]], i16 [[TMP27]], i16 [[TMP30]] monotonic monotonic, align 2
// CHECK4-NEXT:    [[TMP32]] = extractvalue { i16, i1 } [[TMP31]], 0
// CHECK4-NEXT:    [[TMP33:%.*]] = extractvalue { i16, i1 } [[TMP31]], 1
// CHECK4-NEXT:    br i1 [[TMP33]], label [[ATOMIC_EXIT]], label [[ATOMIC_CONT]]
// CHECK4:       atomic_exit:
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT18]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST11]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT19]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST10]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DONE20:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT18]], [[TMP25]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_DONE20]], label [[OMP_ARRAYCPY_DONE21]], label [[OMP_ARRAYCPY_BODY9]]
// CHECK4:       omp.arraycpy.done21:
// CHECK4-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK4:       .omp.reduction.default:
// CHECK4-NEXT:    [[TMP34:%.*]] = load ptr, ptr [[SAVED_STACK]], align 8
// CHECK4-NEXT:    call void @llvm.stackrestore.p0(ptr [[TMP34]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z14foo_array_sectPs.omp_outlined.omp.reduction.reduction_func
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR4:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = ptrtoint ptr [[TMP9]] to i64
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr i16, ptr [[TMP7]], i64 [[TMP10]]
// CHECK4-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[TMP7]], [[TMP11]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK4:       omp.arraycpy.body:
// CHECK4-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP5]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[TMP7]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK4-NEXT:    [[TMP12:%.*]] = load i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK4-NEXT:    [[CONV:%.*]] = sext i16 [[TMP12]] to i32
// CHECK4-NEXT:    [[TMP13:%.*]] = load i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], align 2
// CHECK4-NEXT:    [[CONV2:%.*]] = sext i16 [[TMP13]] to i32
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[CONV]], [[CONV2]]
// CHECK4-NEXT:    [[CONV3:%.*]] = trunc i32 [[ADD]] to i16
// CHECK4-NEXT:    store i16 [[CONV3]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], align 2
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr i16, ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP11]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]]
// CHECK4:       omp.arraycpy.done4:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@main
// CHECK4-SAME: () #[[ATTR7:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK4-NEXT:    call void @_ZN2SSC1ERi(ptr noundef nonnull align 8 dereferenceable(16) [[SS]], ptr noundef nonnull align 4 dereferenceable(4) @sivar)
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr getelementptr inbounds ([[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], ptr @__block_literal_global, i32 0, i32 3), align 8
// CHECK4-NEXT:    call void [[TMP0]](ptr noundef @__block_literal_global)
// CHECK4-NEXT:    ret i32 0
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK4-NEXT:    call void @_ZN2SSC2ERi(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@__main_block_invoke
// CHECK4-SAME: (ptr noundef [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR8:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[BLOCK_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[BLOCK_ADDR]], align 8
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 1, ptr @__main_block_invoke.omp_outlined, ptr @g)
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@__main_block_invoke.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[G:%.*]]) #[[ATTR2]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[G_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[G1:%.*]] = alloca i32, align 128
// CHECK4-NEXT:    [[BLOCK:%.*]] = alloca <{ ptr, i32, i32, ptr, ptr, [96 x i8], i32 }>, align 128
// CHECK4-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[G]], ptr [[G_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[G_ADDR]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[G1]], align 128
// CHECK4-NEXT:    store i32 1, ptr [[G1]], align 128
// CHECK4-NEXT:    [[BLOCK_ISA:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, [96 x i8], i32 }>, ptr [[BLOCK]], i32 0, i32 0
// CHECK4-NEXT:    store ptr @_NSConcreteStackBlock, ptr [[BLOCK_ISA]], align 128
// CHECK4-NEXT:    [[BLOCK_FLAGS:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, [96 x i8], i32 }>, ptr [[BLOCK]], i32 0, i32 1
// CHECK4-NEXT:    store i32 1073741824, ptr [[BLOCK_FLAGS]], align 8
// CHECK4-NEXT:    [[BLOCK_RESERVED:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, [96 x i8], i32 }>, ptr [[BLOCK]], i32 0, i32 2
// CHECK4-NEXT:    store i32 0, ptr [[BLOCK_RESERVED]], align 4
// CHECK4-NEXT:    [[BLOCK_INVOKE:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, [96 x i8], i32 }>, ptr [[BLOCK]], i32 0, i32 3
// CHECK4-NEXT:    store ptr @g_block_invoke, ptr [[BLOCK_INVOKE]], align 16
// CHECK4-NEXT:    [[BLOCK_DESCRIPTOR:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, [96 x i8], i32 }>, ptr [[BLOCK]], i32 0, i32 4
// CHECK4-NEXT:    store ptr @__block_descriptor_tmp.1, ptr [[BLOCK_DESCRIPTOR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, [96 x i8], i32 }>, ptr [[BLOCK]], i32 0, i32 6
// CHECK4-NEXT:    [[TMP1:%.*]] = load volatile i32, ptr [[G1]], align 128
// CHECK4-NEXT:    store volatile i32 [[TMP1]], ptr [[BLOCK_CAPTURED]], align 128
// CHECK4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], ptr [[BLOCK]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK4-NEXT:    call void [[TMP3]](ptr noundef [[BLOCK]])
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK4-NEXT:    store ptr [[G1]], ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP7:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP6]], i32 1, i64 8, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @__main_block_invoke.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK4-NEXT:    switch i32 [[TMP7]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK4-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK4-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK4-NEXT:    ]
// CHECK4:       .omp.reduction.case1:
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP0]], align 128
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, ptr [[G1]], align 128
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP8]], [[TMP9]]
// CHECK4-NEXT:    store i32 [[ADD]], ptr [[TMP0]], align 128
// CHECK4-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP6]], ptr @.gomp_critical_user_.reduction.var)
// CHECK4-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK4:       .omp.reduction.case2:
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[G1]], align 128
// CHECK4-NEXT:    [[TMP11:%.*]] = atomicrmw add ptr [[TMP0]], i32 [[TMP10]] monotonic, align 128
// CHECK4-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK4:       .omp.reduction.default:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@g_block_invoke
// CHECK4-SAME: (ptr noundef [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR8]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[BLOCK_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[BLOCK_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, [96 x i8], i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 6
// CHECK4-NEXT:    store i32 2, ptr [[BLOCK_CAPTURE_ADDR]], align 128
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@__main_block_invoke.omp_outlined.omp.reduction.reduction_func
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 128
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, ptr [[TMP5]], align 128
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP8]], [[TMP9]]
// CHECK4-NEXT:    store i32 [[ADD]], ptr [[TMP7]], align 128
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[C5:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK4-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 4
// CHECK4-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK4-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], 0
// CHECK4-NEXT:    store i8 [[BF_SET]], ptr [[B]], align 4
// CHECK4-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[C]], align 8
// CHECK4-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK4-NEXT:    [[C6:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C6]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[C5]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[C5]], align 8
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 4, ptr @_ZN2SSC2ERi.omp_outlined, ptr [[THIS1]], ptr [[TMP2]], ptr [[B4]], ptr [[TMP3]])
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, ptr [[B4]], align 4
// CHECK4-NEXT:    [[B7:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP5:%.*]] = trunc i32 [[TMP4]] to i8
// CHECK4-NEXT:    [[BF_LOAD8:%.*]] = load i8, ptr [[B7]], align 4
// CHECK4-NEXT:    [[BF_VALUE:%.*]] = and i8 [[TMP5]], 15
// CHECK4-NEXT:    [[BF_CLEAR9:%.*]] = and i8 [[BF_LOAD8]], -16
// CHECK4-NEXT:    [[BF_SET10:%.*]] = or i8 [[BF_CLEAR9]], [[BF_VALUE]]
// CHECK4-NEXT:    store i8 [[BF_SET10]], ptr [[B7]], align 4
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A2:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[C5:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[BLOCK:%.*]] = alloca <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, align 8
// CHECK4-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// CHECK4-NEXT:    store ptr [[TMP3]], ptr [[_TMP1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[A2]], align 4
// CHECK4-NEXT:    store ptr [[A2]], ptr [[_TMP3]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[B4]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[C5]], align 4
// CHECK4-NEXT:    store ptr [[C5]], ptr [[_TMP6]], align 8
// CHECK4-NEXT:    [[BLOCK_ISA:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 0
// CHECK4-NEXT:    store ptr @_NSConcreteStackBlock, ptr [[BLOCK_ISA]], align 8
// CHECK4-NEXT:    [[BLOCK_FLAGS:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 1
// CHECK4-NEXT:    store i32 1073741824, ptr [[BLOCK_FLAGS]], align 8
// CHECK4-NEXT:    [[BLOCK_RESERVED:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 2
// CHECK4-NEXT:    store i32 0, ptr [[BLOCK_RESERVED]], align 4
// CHECK4-NEXT:    [[BLOCK_INVOKE:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 3
// CHECK4-NEXT:    store ptr @g_block_invoke_2, ptr [[BLOCK_INVOKE]], align 8
// CHECK4-NEXT:    [[BLOCK_DESCRIPTOR:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 4
// CHECK4-NEXT:    store ptr @__block_descriptor_tmp.2, ptr [[BLOCK_DESCRIPTOR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED_THIS_ADDR:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 5
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[BLOCK_CAPTURED_THIS_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 6
// CHECK4-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK4-NEXT:    store ptr [[TMP6]], ptr [[BLOCK_CAPTURED]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED7:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 8
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, ptr [[B4]], align 4
// CHECK4-NEXT:    store i32 [[TMP7]], ptr [[BLOCK_CAPTURED7]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED8:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[BLOCK]], i32 0, i32 7
// CHECK4-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK4-NEXT:    store ptr [[TMP8]], ptr [[BLOCK_CAPTURED8]], align 8
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [[STRUCT___BLOCK_LITERAL_GENERIC:%.*]], ptr [[BLOCK]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK4-NEXT:    call void [[TMP10]](ptr noundef [[BLOCK]])
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK4-NEXT:    store ptr [[A2]], ptr [[TMP11]], align 8
// CHECK4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK4-NEXT:    store ptr [[B4]], ptr [[TMP12]], align 8
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 2
// CHECK4-NEXT:    store ptr [[C5]], ptr [[TMP13]], align 8
// CHECK4-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP15]], i32 3, i64 24, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @_ZN2SSC2ERi.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK4-NEXT:    switch i32 [[TMP16]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK4-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK4-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK4-NEXT:    ]
// CHECK4:       .omp.reduction.case1:
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A2]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP17]], [[TMP18]]
// CHECK4-NEXT:    store i32 [[ADD]], ptr [[TMP4]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[B4]], align 4
// CHECK4-NEXT:    [[ADD9:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK4-NEXT:    store i32 [[ADD9]], ptr [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, ptr [[C5]], align 4
// CHECK4-NEXT:    [[ADD10:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK4-NEXT:    store i32 [[ADD10]], ptr [[TMP5]], align 4
// CHECK4-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP15]], ptr @.gomp_critical_user_.reduction.var)
// CHECK4-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK4:       .omp.reduction.case2:
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32, ptr [[A2]], align 4
// CHECK4-NEXT:    [[TMP24:%.*]] = atomicrmw add ptr [[TMP4]], i32 [[TMP23]] monotonic, align 4
// CHECK4-NEXT:    [[TMP25:%.*]] = load i32, ptr [[B4]], align 4
// CHECK4-NEXT:    [[TMP26:%.*]] = atomicrmw add ptr [[TMP2]], i32 [[TMP25]] monotonic, align 4
// CHECK4-NEXT:    [[TMP27:%.*]] = load i32, ptr [[C5]], align 4
// CHECK4-NEXT:    [[TMP28:%.*]] = atomicrmw add ptr [[TMP5]], i32 [[TMP27]] monotonic, align 4
// CHECK4-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK4:       .omp.reduction.default:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@g_block_invoke_2
// CHECK4-SAME: (ptr noundef [[DOTBLOCK_DESCRIPTOR:%.*]]) #[[ATTR8]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTBLOCK_DESCRIPTOR_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[BLOCK_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[DOTBLOCK_DESCRIPTOR_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBLOCK_DESCRIPTOR]], ptr [[BLOCK_ADDR]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURED_THIS:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 5
// CHECK4-NEXT:    [[THIS:%.*]] = load ptr, ptr [[BLOCK_CAPTURED_THIS]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 6
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[BLOCK_CAPTURE_ADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK4-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP1]], 1
// CHECK4-NEXT:    store i32 [[INC]], ptr [[TMP0]], align 4
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR1:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load i32, ptr [[BLOCK_CAPTURE_ADDR1]], align 8
// CHECK4-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP2]], -1
// CHECK4-NEXT:    store i32 [[DEC]], ptr [[BLOCK_CAPTURE_ADDR1]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR2:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 7
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[BLOCK_CAPTURE_ADDR2]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP4]], 1
// CHECK4-NEXT:    store i32 [[DIV]], ptr [[TMP3]], align 4
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR3:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 6
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[BLOCK_CAPTURE_ADDR3]], align 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR4:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 8
// CHECK4-NEXT:    [[BLOCK_CAPTURE_ADDR5:%.*]] = getelementptr inbounds <{ ptr, i32, i32, ptr, ptr, ptr, ptr, ptr, i32 }>, ptr [[DOTBLOCK_DESCRIPTOR]], i32 0, i32 7
// CHECK4-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[BLOCK_CAPTURE_ADDR5]], align 8
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB2]], i32 4, ptr @g_block_invoke_2.omp_outlined, ptr [[THIS]], ptr [[TMP5]], ptr [[BLOCK_CAPTURE_ADDR4]], ptr [[TMP6]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@g_block_invoke_2.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[A:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[B:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[C:%.*]]) #[[ATTR2]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A2:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[C5:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[_TMP6:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTOMP_REDUCTION_RED_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[B]], ptr [[B_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[C]], ptr [[C_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[A_ADDR]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[B_ADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[C_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[TMP]], align 8
// CHECK4-NEXT:    store ptr [[TMP3]], ptr [[_TMP1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[A2]], align 4
// CHECK4-NEXT:    store ptr [[A2]], ptr [[_TMP3]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[B4]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[C5]], align 4
// CHECK4-NEXT:    store ptr [[C5]], ptr [[_TMP6]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4
// CHECK4-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP7]], 1
// CHECK4-NEXT:    store i32 [[INC]], ptr [[TMP6]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[B4]], align 4
// CHECK4-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP8]], -1
// CHECK4-NEXT:    store i32 [[DEC]], ptr [[B4]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP6]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1
// CHECK4-NEXT:    store i32 [[DIV]], ptr [[TMP9]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 0
// CHECK4-NEXT:    store ptr [[A2]], ptr [[TMP11]], align 8
// CHECK4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 1
// CHECK4-NEXT:    store ptr [[B4]], ptr [[TMP12]], align 8
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_REDUCTION_RED_LIST]], i64 0, i64 2
// CHECK4-NEXT:    store ptr [[C5]], ptr [[TMP13]], align 8
// CHECK4-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP15:%.*]] = load i32, ptr [[TMP14]], align 4
// CHECK4-NEXT:    [[TMP16:%.*]] = call i32 @__kmpc_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP15]], i32 3, i64 24, ptr [[DOTOMP_REDUCTION_RED_LIST]], ptr @g_block_invoke_2.omp_outlined.omp.reduction.reduction_func, ptr @.gomp_critical_user_.reduction.var)
// CHECK4-NEXT:    switch i32 [[TMP16]], label [[DOTOMP_REDUCTION_DEFAULT:%.*]] [
// CHECK4-NEXT:      i32 1, label [[DOTOMP_REDUCTION_CASE1:%.*]]
// CHECK4-NEXT:      i32 2, label [[DOTOMP_REDUCTION_CASE2:%.*]]
// CHECK4-NEXT:    ]
// CHECK4:       .omp.reduction.case1:
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP4]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[A2]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP17]], [[TMP18]]
// CHECK4-NEXT:    store i32 [[ADD]], ptr [[TMP4]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[B4]], align 4
// CHECK4-NEXT:    [[ADD7:%.*]] = add nsw i32 [[TMP19]], [[TMP20]]
// CHECK4-NEXT:    store i32 [[ADD7]], ptr [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = load i32, ptr [[C5]], align 4
// CHECK4-NEXT:    [[ADD8:%.*]] = add nsw i32 [[TMP21]], [[TMP22]]
// CHECK4-NEXT:    store i32 [[ADD8]], ptr [[TMP5]], align 4
// CHECK4-NEXT:    call void @__kmpc_end_reduce_nowait(ptr @[[GLOB1]], i32 [[TMP15]], ptr @.gomp_critical_user_.reduction.var)
// CHECK4-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK4:       .omp.reduction.case2:
// CHECK4-NEXT:    [[TMP23:%.*]] = load i32, ptr [[A2]], align 4
// CHECK4-NEXT:    [[TMP24:%.*]] = atomicrmw add ptr [[TMP4]], i32 [[TMP23]] monotonic, align 4
// CHECK4-NEXT:    [[TMP25:%.*]] = load i32, ptr [[B4]], align 4
// CHECK4-NEXT:    [[TMP26:%.*]] = atomicrmw add ptr [[TMP2]], i32 [[TMP25]] monotonic, align 4
// CHECK4-NEXT:    [[TMP27:%.*]] = load i32, ptr [[C5]], align 4
// CHECK4-NEXT:    [[TMP28:%.*]] = atomicrmw add ptr [[TMP5]], i32 [[TMP27]] monotonic, align 4
// CHECK4-NEXT:    br label [[DOTOMP_REDUCTION_DEFAULT]]
// CHECK4:       .omp.reduction.default:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@g_block_invoke_2.omp_outlined.omp.reduction.reduction_func
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP16]], [[TMP17]]
// CHECK4-NEXT:    store i32 [[ADD]], ptr [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP11]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK4-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK4-NEXT:    store i32 [[ADD2]], ptr [[TMP11]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP15]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP13]], align 4
// CHECK4-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK4-NEXT:    store i32 [[ADD3]], ptr [[TMP15]], align 4
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined.omp.reduction.reduction_func
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR4]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP11:%.*]] = load ptr, ptr [[TMP10]], align 8
// CHECK4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK4-NEXT:    [[TMP16:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP5]], align 4
// CHECK4-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP16]], [[TMP17]]
// CHECK4-NEXT:    store i32 [[ADD]], ptr [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP11]], align 4
// CHECK4-NEXT:    [[TMP19:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK4-NEXT:    [[ADD2:%.*]] = add nsw i32 [[TMP18]], [[TMP19]]
// CHECK4-NEXT:    store i32 [[ADD2]], ptr [[TMP11]], align 4
// CHECK4-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP15]], align 4
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP13]], align 4
// CHECK4-NEXT:    [[ADD3:%.*]] = add nsw i32 [[TMP20]], [[TMP21]]
// CHECK4-NEXT:    store i32 [[ADD3]], ptr [[TMP15]], align 4
// CHECK4-NEXT:    ret void
//
