/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Array;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.GeneralArray;
import gnu.lists.Sequence;
import java.util.Collection;
import java.util.Iterator;

public abstract class SimpleVector
extends AbstractSequence
implements Sequence,
Array {
    public int size;

    public final int size() {
        return this.size;
    }

    public void setSize(int size) {
        int oldSize = this.size;
        this.size = size;
        if (size < oldSize) {
            this.clearBuffer(size, oldSize - size);
        } else {
            int oldLength = this.getBufferLength();
            if (size > oldLength) {
                int newLength = oldLength < 16 ? 16 : 2 * oldLength;
                this.setBufferLength(size > newLength ? size : newLength);
            }
        }
    }

    public abstract int getBufferLength();

    public abstract void setBufferLength(int var1);

    protected boolean isAfterPos(int ipos) {
        return (ipos & 1) != 0;
    }

    protected int nextIndex(int ipos) {
        return ipos == -1 ? this.size : ipos >>> 1;
    }

    public int createPos(int index, boolean isAfter) {
        return index << 1 | (isAfter ? 1 : 0);
    }

    public int nextPos(int ipos) {
        if (ipos == -1) {
            return 0;
        }
        int index = ipos >>> 1;
        if (index == this.size) {
            return 0;
        }
        return (index << 1) + 3;
    }

    protected abstract Object getBuffer();

    public Object get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getBuffer(index);
    }

    public Object getPosNext(int ipos) {
        int index = ipos >>> 1;
        return index >= this.size ? Sequence.eofValue : this.getBuffer(index);
    }

    public int intAtBuffer(int index) {
        return Convert.toInt(this.getBuffer(index));
    }

    public int intAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.intAtBuffer(index);
    }

    public long longAt(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longAtBuffer(index);
    }

    public long longAtBuffer(int index) {
        return Convert.toLong(this.getBuffer(index));
    }

    public Object getRowMajor(int i) {
        return this.get(i);
    }

    protected abstract Object getBuffer(int var1);

    public Object set(int index, Object value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object old = this.getBuffer(index);
        this.setBuffer(index, value);
        return old;
    }

    protected abstract Object setBuffer(int var1, Object var2);

    public void fill(Object value) {
        int i = this.size;
        while (--i >= 0) {
            this.setBuffer(i, value);
        }
    }

    public void fillPosRange(int fromPos, int toPos, Object value) {
        int j;
        int n = j = toPos == -1 ? this.size : toPos >>> 1;
        for (int i = fromPos == -1 ? this.size : fromPos >>> 1; i < j; ++i) {
            this.setBuffer(i, value);
        }
    }

    public void fill(int fromIndex, int toIndex, Object value) {
        if (fromIndex < 0 || toIndex > this.size) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            this.setBuffer(i, value);
        }
    }

    public void shift(int srcStart, int dstStart, int count) {
        Object data = this.getBuffer();
        System.arraycopy(data, srcStart, data, dstStart, count);
    }

    public boolean add(Object o) {
        this.add(this.size, o);
        return true;
    }

    protected int addPos(int ipos, Object value) {
        int index = ipos >>> 1;
        this.add(index, value);
        return (index << 1) + 3;
    }

    public void add(int index, Object o) {
        int newSize;
        this.size = newSize = this.size + 1;
        int length = this.getBufferLength();
        if (newSize > length) {
            this.setBufferLength(length < 16 ? 16 : 2 * length);
        }
        this.size = newSize;
        if (this.size != index) {
            this.shift(index, index + 1, this.size - index);
        }
        this.set(index, o);
    }

    public boolean addAll(int index, Collection c) {
        boolean changed = false;
        int count = c.size();
        this.setSize(this.size + count);
        this.shift(index, index + count, this.size - count - index);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.set(index++, it.next());
            changed = true;
        }
        return changed;
    }

    protected abstract void clearBuffer(int var1, int var2);

    protected void removePosRange(int ipos0, int ipos1) {
        if ((ipos0 >>>= 1) >= (ipos1 >>>= 1)) {
            return;
        }
        if (ipos1 > this.size) {
            ipos1 = this.size;
        }
        this.shift(ipos1, ipos0, this.size - ipos1);
        int count = ipos1 - ipos0;
        this.size -= count;
        this.clearBuffer(this.size, count);
    }

    public void removePos(int ipos, int count) {
        int ipos1;
        int ipos0;
        int index = ipos >>> 1;
        if (index > this.size) {
            index = this.size;
        }
        if (count >= 0) {
            ipos0 = index;
            ipos1 = index + count;
        } else {
            ipos0 = index + count;
            ipos1 = index;
            count = -count;
        }
        if (ipos0 < 0 || ipos1 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.shift(ipos1, ipos0, this.size - ipos1);
        this.size -= count;
        this.clearBuffer(this.size, count);
    }

    public Object remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object result = this.get(index);
        this.shift(index + 1, index, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return result;
    }

    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.shift(index + 1, index, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean changed = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            Object value = this.get(i);
            if (c.contains(value)) {
                changed = true;
                continue;
            }
            if (changed) {
                this.set(j, value);
            }
            ++j;
        }
        this.setSize(j);
        return changed;
    }

    public boolean retainAll(Collection c) {
        boolean changed = false;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            Object value = this.get(i);
            if (!c.contains(value)) {
                changed = true;
                continue;
            }
            if (changed) {
                this.set(j, value);
            }
            ++j;
        }
        this.setSize(j);
        return changed;
    }

    public void clear() {
        this.setSize(0);
    }

    public String getTag() {
        return null;
    }

    protected static int compareToInt(SimpleVector v1, SimpleVector v2) {
        int n1 = v1.size;
        int n2 = v2.size;
        int n = n1 > n2 ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            int i1 = v1.intAtBuffer(i);
            int i2 = v2.intAtBuffer(i);
            if (11 == i2) continue;
            return i1 > i2 ? 1 : -1;
        }
        return n1 - n2;
    }

    protected static int compareToLong(SimpleVector v1, SimpleVector v2) {
        int n1 = v1.size;
        int n2 = v2.size;
        int n = n1 > n2 ? n2 : n1;
        for (int i = 0; i < n; ++i) {
            long i2;
            long i1 = v1.longAtBuffer(i);
            if (i1 == (i2 = v2.longAtBuffer(i))) continue;
            return i1 > i2 ? 1 : -1;
        }
        return n1 - n2;
    }

    public void consume(int start, int length, Consumer out) {
        this.consumePosRange(start << 1, start + length << 1, out);
    }

    public boolean consumeNext(int ipos, Consumer out) {
        int index = ipos >>> 1;
        if (index >= this.size) {
            return false;
        }
        out.writeObject(this.getBuffer(index));
        return true;
    }

    public void consumePosRange(int iposStart, int iposEnd, Consumer out) {
        if (out.ignoring()) {
            return;
        }
        int i = iposStart >>> 1;
        int end = iposEnd >>> 1;
        if (end > this.size) {
            end = this.size;
        }
        while (i < end) {
            out.writeObject(this.getBuffer(i));
            ++i;
        }
    }

    public int getNextKind(int ipos) {
        return this.hasNext(ipos) ? this.getElementKind() : 0;
    }

    public int getElementKind() {
        return 32;
    }

    public Array transpose(int[] lowBounds, int[] dimensions, int offset0, int[] factors) {
        GeneralArray array = new GeneralArray();
        array.strides = factors;
        array.dimensions = dimensions;
        array.lowBounds = lowBounds;
        array.offset = offset0;
        array.base = this;
        array.simple = false;
        return array;
    }
}

