------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2011-2017, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

pragma Ada_05;
with Ada.Text_IO;           use Ada.Text_IO;
with GNATCOLL.Email.Utils;  use GNATCOLL.Email, GNATCOLL.Email.Utils;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;

procedure Encode_Test is
   Test_String   : constant String (1 .. 1000) := (others => '#');
   U_Test_String : Unbounded_String            := Null_Unbounded_String;
   Decoded_String : Charset_String_List.List;
   Result : Unbounded_String;
begin
   Encode (Str     => Test_String,
           Charset => Charset_ISO_8859_1,
           Where   => Text,
           Result  => U_Test_String);

   --  Test that the encoded string is split on several lines

   declare
      Encoded : constant String := To_String (U_Test_String);
   begin
      --  Note: The default line limit is 76 characters for the encoded
      --  line, i.e. 75 characters from input, and the soft line break as
      --  the 76th character.

      if Encoded (76 .. 77) /= "=" & ASCII.LF then
         Put_Line ("Missing soft line-break in encoded string");
         Put_Line (Encoded);
      end if;
   end;

   Quoted_Printable_Decode
      (Str    => To_String (U_Test_String),
       Result => Result,
       Where  => Text);

   if Result /= Test_String then
      Put_Line ("Failed encoding/decoding:");
      Put_Line ("-  " & Test_String);
      Put_Line ("+  " & To_String (Result));
   end if;
end Encode_Test;
